/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.convert;

import gnu.gcj.convert.UnicodeToBytes;
import gnu.java.nio.charset.EncodingHelper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class CharsetToBytesAdaptor
extends UnicodeToBytes {
    private final CharsetEncoder encoder;
    private ByteBuffer outBuf;
    private boolean closedEncoder;
    private boolean hasBytes;
    private boolean finished;

    public CharsetToBytesAdaptor(Charset cs) {
        this(cs.newEncoder());
    }

    public CharsetToBytesAdaptor(CharsetEncoder enc) {
        this.encoder = enc;
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public String getName() {
        return EncodingHelper.getOldCanonical(this.encoder.charset().name());
    }

    public int write(char[] inbuffer, int inpos, int inlength) {
        CharBuffer b = CharBuffer.wrap(inbuffer, inpos, inlength);
        this.write(b);
        return b.position() - inpos;
    }

    public int write(String str, int inpos, int inlength, char work) {
        CharBuffer b = CharBuffer.wrap(str, inpos, inlength);
        this.write(b);
        return b.position() - inpos;
    }

    private void write(CharBuffer inBuf) {
        if (this.outBuf == null || !this.outBuf.hasArray() || this.outBuf.array() != this.buf) {
            this.outBuf = ByteBuffer.wrap(this.buf);
        }
        this.outBuf.position(this.count);
        CoderResult result = this.encoder.encode(inBuf, this.outBuf, this.closedEncoder);
        boolean bl = this.hasBytes = result == CoderResult.OVERFLOW;
        if (this.closedEncoder) {
            result = this.encoder.flush(this.outBuf);
            if (result == CoderResult.UNDERFLOW) {
                this.finished = true;
            } else {
                this.hasBytes = true;
            }
        }
        this.count = this.outBuf.position();
    }

    public boolean havePendingBytes() {
        return this.hasBytes;
    }

    public void setFinished() {
        this.closedEncoder = true;
    }

    public void done() {
    }
}

