/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.value;

import gnu.classpath.jdwp.VMIdManager;
import gnu.classpath.jdwp.exception.InvalidClassException;
import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.exception.InvalidTagException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.value.BooleanValue;
import gnu.classpath.jdwp.value.ByteValue;
import gnu.classpath.jdwp.value.CharValue;
import gnu.classpath.jdwp.value.DoubleValue;
import gnu.classpath.jdwp.value.FloatValue;
import gnu.classpath.jdwp.value.IntValue;
import gnu.classpath.jdwp.value.LongValue;
import gnu.classpath.jdwp.value.ObjectValue;
import gnu.classpath.jdwp.value.ShortValue;
import gnu.classpath.jdwp.value.StringValue;
import gnu.classpath.jdwp.value.Value;
import gnu.classpath.jdwp.value.VoidValue;
import java.nio.ByteBuffer;

public class ValueFactory {
    public static Value createFromTagged(ByteBuffer bb) throws JdwpInternalErrorException, InvalidObjectException, InvalidTagException {
        return ValueFactory.create(bb, bb.get());
    }

    public static Value createFromUntagged(ByteBuffer bb, Class type) throws JdwpInternalErrorException, InvalidObjectException, InvalidClassException {
        byte tag = ValueFactory.getTagForClass(type);
        try {
            return ValueFactory.create(bb, tag);
        }
        catch (InvalidTagException ite) {
            throw new InvalidClassException(ite);
        }
    }

    private static Value create(ByteBuffer bb, byte tag) throws JdwpInternalErrorException, InvalidObjectException, InvalidTagException {
        Value val = null;
        switch (tag) {
            case 66: {
                val = new ByteValue(bb.get());
                break;
            }
            case 90: {
                val = new BooleanValue(bb.get() != 0);
                break;
            }
            case 67: {
                val = new CharValue(bb.getChar());
                break;
            }
            case 83: {
                val = new ShortValue(bb.getShort());
                break;
            }
            case 73: {
                val = new IntValue(bb.getInt());
                break;
            }
            case 70: {
                val = new FloatValue(bb.getFloat());
                break;
            }
            case 74: {
                val = new LongValue(bb.getLong());
                break;
            }
            case 68: {
                val = new DoubleValue(bb.getDouble());
                break;
            }
            case 86: {
                val = new VoidValue();
                break;
            }
            case 76: 
            case 91: 
            case 99: 
            case 103: 
            case 108: 
            case 116: {
                ObjectId oid = VMIdManager.getDefault().readObjectId(bb);
                val = new ObjectValue(oid.getObject());
                break;
            }
            case 115: {
                val = new StringValue(JdwpString.readString(bb));
                break;
            }
            default: {
                throw new InvalidTagException(tag);
            }
        }
        return val;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte getTagForClass(Class klass) throws JdwpInternalErrorException {
        if (!klass.isPrimitive()) return (byte)76;
        if (klass == Byte.TYPE) {
            return (byte)66;
        }
        if (klass == Boolean.TYPE) {
            return (byte)90;
        }
        if (klass == Character.TYPE) {
            return (byte)67;
        }
        if (klass == Short.TYPE) {
            return (byte)83;
        }
        if (klass == Integer.TYPE) {
            return (byte)73;
        }
        if (klass == Float.TYPE) {
            return (byte)70;
        }
        if (klass == Long.TYPE) {
            return (byte)74;
        }
        if (klass == Double.TYPE) {
            return (byte)68;
        }
        if (klass != Void.TYPE) throw new JdwpInternalErrorException("Invalid primitive class");
        return (byte)86;
    }

    public static Value createFromObject(Object value, Class type) {
        Value val = null;
        if (type.isPrimitive()) {
            if (type == Byte.TYPE) {
                val = new ByteValue((Byte)value);
            } else if (type == Boolean.TYPE) {
                val = new BooleanValue((Boolean)value);
            } else if (type == Character.TYPE) {
                val = new CharValue(((Character)value).charValue());
            } else if (type == Short.TYPE) {
                val = new ShortValue((Short)value);
            } else if (type == Integer.TYPE) {
                val = new IntValue((Integer)value);
            } else if (type == Float.TYPE) {
                val = new FloatValue(((Float)value).floatValue());
            } else if (type == Long.TYPE) {
                val = new LongValue((Long)value);
            } else if (type == Double.TYPE) {
                val = new DoubleValue((Double)value);
            } else if (type == Void.TYPE) {
                val = new VoidValue();
            }
        } else {
            val = type.isAssignableFrom(String.class) ? new StringValue((String)value) : new ObjectValue(value);
        }
        return val;
    }
}

