/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class CompositeView
extends View {
    View[] children = new View[0];
    Rectangle insideAllocation;
    Insets insets = new Insets(0, 0, 0, 0);

    public CompositeView(Element element) {
        super(element);
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        View[] viewArray = new View[n];
        for (int i = 0; i < n; ++i) {
            View view;
            Element element2 = element.getElement(i);
            viewArray[i] = view = viewFactory.create(element2);
        }
        this.replace(0, this.getViewCount(), viewArray);
    }

    public void setParent(View view) {
        super.setParent(view);
        if (view != null && (this.children == null || this.children.length == 0)) {
            this.loadChildren(this.getViewFactory());
        }
    }

    public int getViewCount() {
        return this.children.length;
    }

    public View getView(int n) {
        return this.children[n];
    }

    public void replace(int n, int n2, View[] viewArray) {
        int n3;
        for (n3 = 0; n3 < viewArray.length; ++n3) {
            if (viewArray[n3] != null) continue;
            throw new NullPointerException("Added views must not be null");
        }
        n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.children[i].setParent(null);
        }
        View[] viewArray2 = new View[this.children.length - n2 + viewArray.length];
        System.arraycopy(this.children, 0, viewArray2, 0, n);
        System.arraycopy(viewArray, 0, viewArray2, n, viewArray.length);
        System.arraycopy(this.children, n + n2, viewArray2, n + viewArray.length, this.children.length - (n + n2));
        this.children = viewArray2;
        for (int i = 0; i < viewArray.length; ++i) {
            viewArray[i].setParent(this);
        }
    }

    public Shape getChildAllocation(int n, Shape shape) {
        Rectangle rectangle = this.getInsideAllocation(shape);
        this.childAllocation(n, rectangle);
        return rectangle;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        boolean bl = bias == Position.Bias.Backward;
        int n2 = bl ? Math.max(0, n - 1) : n;
        Shape shape2 = null;
        if (!bl || n2 >= this.getStartOffset()) {
            int n3 = this.getViewIndexAtPosition(n2);
            if (n3 != -1 && n3 < this.getViewCount()) {
                Shape shape3;
                View view = this.getView(n3);
                if (view != null && n2 >= view.getStartOffset() && n2 < view.getEndOffset() && (shape3 = this.getChildAllocation(n3, shape)) != null && (shape2 = view.modelToView(n, shape3, bias)) == null && view.getEndOffset() == n && ++n3 < this.getViewCount()) {
                    view = this.getView(n3);
                    shape3 = this.getChildAllocation(n3, shape);
                    shape2 = view.modelToView(n, shape3, bias);
                }
            } else {
                throw new BadLocationException("Position " + n + " is not represented by view.", n);
            }
        }
        return shape2;
    }

    private Shape createDefaultLocation(Shape shape, Position.Bias bias) {
        Rectangle rectangle = shape.getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 1, rectangle.height);
        if (bias == Position.Bias.Forward) {
            rectangle2.x = rectangle.x + rectangle.width;
        }
        return rectangle2;
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        return super.modelToView(n, bias, n2, bias2, shape);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (f >= 0.0f && f2 >= 0.0f) {
            Rectangle rectangle = this.getInsideAllocation(shape);
            View view = this.getViewAtPoint((int)f, (int)f2, rectangle);
            return view.viewToModel(f, f2, rectangle, biasArray);
        }
        return 0;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3 = -1;
        switch (n2) {
            case 3: 
            case 7: {
                n3 = this.getNextEastWestVisualPositionFrom(n, bias, shape, n2, biasArray);
                break;
            }
            case 1: 
            case 5: {
                n3 = this.getNextNorthSouthVisualPositionFrom(n, bias, shape, n2, biasArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for direction.");
            }
        }
        return n3;
    }

    public int getViewIndex(int n, Position.Bias bias) {
        if (bias == Position.Bias.Backward && n != 0) {
            --n;
        }
        int n2 = -1;
        if (n >= this.getStartOffset() && n < this.getEndOffset()) {
            n2 = this.getViewIndexAtPosition(n);
        }
        return n2;
    }

    protected abstract boolean isBefore(int var1, int var2, Rectangle var3);

    protected abstract boolean isAfter(int var1, int var2, Rectangle var3);

    protected abstract View getViewAtPoint(int var1, int var2, Rectangle var3);

    protected abstract void childAllocation(int var1, Rectangle var2);

    protected View getViewAtPosition(int n, Rectangle rectangle) {
        View view = null;
        int n2 = this.getViewIndexAtPosition(n);
        if (n2 >= 0 && n2 < this.getViewCount() && rectangle != null) {
            view = this.getView(n2);
            this.childAllocation(n2, rectangle);
        }
        return view;
    }

    protected int getViewIndexAtPosition(int n) {
        Element element = this.getElement();
        return element.getElementIndex(n);
    }

    protected Rectangle getInsideAllocation(Shape shape) {
        Rectangle rectangle;
        Rectangle rectangle2;
        if (shape == null) {
            return null;
        }
        Rectangle rectangle3 = shape.getBounds();
        CompositeView compositeView = this;
        synchronized (compositeView) {
            block4: {
                try {
                    rectangle2 = this.insideAllocation;
                    if (rectangle2 != null) break block4;
                    this.insideAllocation = rectangle2 = new Rectangle();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            rectangle = null;
        }
        rectangle2.x = rectangle3.x + this.insets.left;
        rectangle2.y = rectangle3.y + this.insets.top;
        rectangle2.width = rectangle3.width - this.insets.left - this.insets.right;
        rectangle2.height = rectangle3.height - this.insets.top - this.insets.bottom;
        rectangle = rectangle2;
        return rectangle;
    }

    protected void setParagraphInsets(AttributeSet attributeSet) {
        Float f = (Float)attributeSet.getAttribute(StyleConstants.LeftIndent);
        short s = 0;
        if (f != null) {
            s = f.shortValue();
        }
        Float f2 = (Float)attributeSet.getAttribute(StyleConstants.RightIndent);
        short s2 = 0;
        if (f2 != null) {
            s2 = f2.shortValue();
        }
        Float f3 = (Float)attributeSet.getAttribute(StyleConstants.SpaceAbove);
        short s3 = 0;
        if (f3 != null) {
            s3 = f3.shortValue();
        }
        Float f4 = (Float)attributeSet.getAttribute(StyleConstants.SpaceBelow);
        short s4 = 0;
        if (f4 != null) {
            s4 = f4.shortValue();
        }
        this.setInsets(s3, s, s4, s2);
    }

    protected void setInsets(short s, short s2, short s3, short s4) {
        this.insets.top = s;
        this.insets.left = s2;
        this.insets.bottom = s3;
        this.insets.right = s4;
    }

    protected short getLeftInset() {
        return (short)this.insets.left;
    }

    protected short getRightInset() {
        return (short)this.insets.right;
    }

    protected short getTopInset() {
        return (short)this.insets.top;
    }

    protected short getBottomInset() {
        return (short)this.insets.bottom;
    }

    protected int getNextNorthSouthVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3 = this.getViewIndex(n, bias);
        View view = null;
        if (n3 == -1) {
            return n;
        }
        switch (n2) {
            case 1: {
                if (n3 <= 0) {
                    return n;
                }
                view = this.getView(n3 - 1);
                break;
            }
            case 5: {
                if (n3 >= this.getViewCount() - 1) {
                    return n;
                }
                view = this.getView(n3 + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
    }

    protected int getNextEastWestVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        View view = null;
        switch (n2) {
            case 3: {
                int n3 = this.getViewIndex(n + 1, bias);
                if (n3 == -1) {
                    return n;
                }
                view = this.getView(n3);
                break;
            }
            case 7: {
                int n4 = this.getViewIndex(n - 1, bias);
                if (n4 == -1) {
                    return n;
                }
                view = this.getView(n4);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        return false;
    }
}

