/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.MenuItemUI;

public class JMenuItem
extends AbstractButton
implements Accessible,
MenuElement {
    private static final long serialVersionUID = -1681004643499461044L;
    private KeyStroke accelerator;

    public JMenuItem() {
        this.init(null, null);
    }

    public JMenuItem(Icon icon) {
        this.init(null, icon);
    }

    public JMenuItem(String string) {
        this(string, null);
    }

    public JMenuItem(Action action) {
        super.setAction(action);
        this.init(null, null);
        if (action != null) {
            String string;
            Integer n;
            KeyStroke keyStroke;
            String string2 = (String)action.getValue("Name");
            if (string2 != null) {
                this.setName(string2);
            }
            if ((keyStroke = (KeyStroke)action.getValue("AcceleratorKey")) != null) {
                this.setAccelerator(keyStroke);
            }
            if ((n = (Integer)action.getValue("MnemonicKey")) != null) {
                this.setMnemonic(n);
            }
            if ((string = (String)action.getValue("ActionCommandKey")) != null) {
                this.setActionCommand(string);
            }
        }
    }

    public JMenuItem(String string, Icon icon) {
        this.init(string, icon);
    }

    public JMenuItem(String string, int n) {
        this(string, null);
        this.setMnemonic(n);
    }

    protected void init(String string, Icon icon) {
        super.init(string, icon);
        this.setModel(new DefaultButtonModel());
        this.focusPainted = false;
        this.horizontalAlignment = 10;
        this.horizontalTextPosition = 11;
    }

    public void setUI(MenuItemUI menuItemUI) {
        super.setUI(menuItemUI);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "MenuItemUI";
    }

    public boolean isArmed() {
        return this.getModel().isArmed();
    }

    public void setArmed(boolean bl) {
        this.getModel().setArmed(bl);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        KeyStroke keyStroke2 = this.accelerator;
        this.accelerator = keyStroke;
        this.firePropertyChange("accelerator", keyStroke2, keyStroke);
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        if (!(this instanceof JMenu) && action != null) {
            this.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
            if (this.accelerator != null) {
                super.registerKeyboardAction(action, this.accelerator, 2);
            }
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(this){
            private /* synthetic */ JMenuItem this$0;
            {
                this.this$0 = jMenuItem;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Action action = (Action)propertyChangeEvent.getSource();
                this.this$0.configurePropertiesFromAction(action);
            }
        };
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        boolean bl;
        boolean bl2 = bl = (mouseEvent.getModifiersEx() & 0x400) != 0;
        if (bl) {
            this.processMenuDragMouseEvent(this.createMenuDragMouseEvent(mouseEvent, menuElementArray, menuSelectionManager));
        }
        switch (mouseEvent.getID()) {
            case 500: {
                break;
            }
            case 504: {
                if (!this.isRolloverEnabled()) break;
                this.model.setRollover(true);
                break;
            }
            case 505: {
                if (this.isRolloverEnabled()) {
                    this.model.setRollover(false);
                }
                if (menuElementArray[menuElementArray.length - 1] instanceof JPopupMenu || bl) break;
                this.setArmed(false);
                break;
            }
            case 501: {
                if ((mouseEvent.getModifiersEx() & 0x400) == 0) break;
                this.model.setArmed(true);
                this.model.setPressed(true);
                break;
            }
            case 502: {
                break;
            }
            case 503: {
                break;
            }
        }
    }

    private MenuDragMouseEvent createMenuDragMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        return new MenuDragMouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), menuElementArray, menuSelectionManager);
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        MenuKeyEvent menuKeyEvent = new MenuKeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), menuElementArray, menuSelectionManager);
        this.processMenuKeyEvent(menuKeyEvent);
        if (menuKeyEvent.isConsumed()) {
            keyEvent.consume();
        }
    }

    public void processMenuDragMouseEvent(MenuDragMouseEvent menuDragMouseEvent) {
        switch (menuDragMouseEvent.getID()) {
            case 504: {
                this.fireMenuDragMouseEntered(menuDragMouseEvent);
                break;
            }
            case 505: {
                this.fireMenuDragMouseExited(menuDragMouseEvent);
                break;
            }
            case 506: {
                this.fireMenuDragMouseDragged(menuDragMouseEvent);
                break;
            }
            case 502: {
                this.fireMenuDragMouseReleased(menuDragMouseEvent);
            }
        }
    }

    public void processMenuKeyEvent(MenuKeyEvent menuKeyEvent) {
        switch (menuKeyEvent.getID()) {
            case 401: {
                this.fireMenuKeyPressed(menuKeyEvent);
                break;
            }
            case 402: {
                this.fireMenuKeyReleased(menuKeyEvent);
                break;
            }
            case 400: {
                this.fireMenuKeyTyped(menuKeyEvent);
                break;
            }
        }
    }

    protected void fireMenuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuDragMouseListener)eventListenerArray[i]).menuDragMouseEntered(menuDragMouseEvent);
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void fireMenuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuDragMouseListener)eventListenerArray[i]).menuDragMouseExited(menuDragMouseEvent);
        }
    }

    protected void fireMenuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuDragMouseListener)eventListenerArray[i]).menuDragMouseDragged(menuDragMouseEvent);
        }
    }

    protected void fireMenuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuDragMouseListener)eventListenerArray[i]).menuDragMouseReleased(menuDragMouseEvent);
        }
    }

    protected void fireMenuKeyPressed(MenuKeyEvent menuKeyEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuKeyListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuKeyListener)eventListenerArray[i]).menuKeyPressed(menuKeyEvent);
        }
    }

    protected void fireMenuKeyReleased(MenuKeyEvent menuKeyEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuKeyListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuKeyListener)eventListenerArray[i]).menuKeyTyped(menuKeyEvent);
        }
    }

    protected void fireMenuKeyTyped(MenuKeyEvent menuKeyEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuKeyListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuKeyListener)eventListenerArray[i]).menuKeyTyped(menuKeyEvent);
        }
    }

    public void menuSelectionChanged(boolean bl) {
        Container container = this.getParent();
        if (bl) {
            this.model.setArmed(true);
            if (container != null && container instanceof JPopupMenu) {
                ((JPopupMenu)container).setSelected(this);
            }
        } else {
            this.model.setArmed(false);
            if (container != null && container instanceof JPopupMenu) {
                ((JPopupMenu)container).getSelectionModel().clearSelection();
            }
        }
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[0];
    }

    public Component getComponent() {
        return this;
    }

    public void addMenuDragMouseListener(MenuDragMouseListener menuDragMouseListener) {
        this.listenerList.add(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"), menuDragMouseListener);
    }

    public void removeMenuDragMouseListener(MenuDragMouseListener menuDragMouseListener) {
        this.listenerList.remove(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"), menuDragMouseListener);
    }

    public MenuDragMouseListener[] getMenuDragMouseListeners() {
        return (MenuDragMouseListener[])this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"));
    }

    public void addMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.add(JMenuItem.class$("javax.swing.event.MenuKeyListener"), menuKeyListener);
    }

    public void removeMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.remove(JMenuItem.class$("javax.swing.event.MenuKeyListener"), menuKeyListener);
    }

    public MenuKeyListener[] getMenuKeyListeners() {
        return (MenuKeyListener[])this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuKeyListener"));
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleJMenuItem accessibleJMenuItem = new AccessibleJMenuItem(this);
            this.addChangeListener(accessibleJMenuItem);
            this.accessibleContext = accessibleJMenuItem;
        }
        return this.accessibleContext;
    }

    protected class AccessibleJMenuItem
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener {
        private /* synthetic */ JMenuItem this$0;
        private static final long serialVersionUID = 6748924232082076534L;
        private boolean armed;
        private boolean focusOwner;
        private boolean pressed;
        private boolean selected;

        AccessibleJMenuItem(JMenuItem jMenuItem) {
            this.this$0 = jMenuItem;
            super(jMenuItem);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
            ButtonModel buttonModel = this.this$0.getModel();
            if (buttonModel.isArmed()) {
                if (!this.armed) {
                    this.armed = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.ARMED, null);
                }
            } else if (this.armed) {
                this.armed = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.ARMED);
            }
            if (buttonModel.isPressed()) {
                if (!this.pressed) {
                    this.pressed = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.PRESSED, null);
                }
            } else if (this.pressed) {
                this.pressed = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.PRESSED);
            }
            if (buttonModel.isSelected()) {
                if (!this.selected) {
                    this.selected = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
                }
            } else if (this.selected) {
                this.selected = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            }
            if (this.this$0.isFocusOwner()) {
                if (!this.focusOwner) {
                    this.focusOwner = true;
                    this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            } else if (this.focusOwner) {
                this.focusOwner = false;
                this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }
    }
}

