/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Method;
import javax.management.IntrospectionException;
import javax.management.MBeanFeatureInfo;

public class MBeanAttributeInfo
extends MBeanFeatureInfo
implements Cloneable {
    private String attributeType;
    private boolean isWrite;
    private boolean isRead;
    private boolean is;

    public MBeanAttributeInfo(String string, String string2, Method method, Method method2) throws IntrospectionException {
        super(string, string2);
        if (method == null && method2 == null) {
            throw new IntrospectionException("Both the getter and setter methods can not be null.");
        }
        if (method == null) {
            this.attributeType = method2.getParameterTypes()[0].getName();
            this.isRead = false;
            this.is = false;
        } else {
            this.attributeType = method.getReturnType().getName();
            this.isRead = true;
            this.is = method.getName().startsWith("is");
        }
        if (method2 != null) {
            this.isWrite = true;
        }
    }

    public MBeanAttributeInfo(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        super(string, string3);
        if (!bl && !bl2) {
            throw new IllegalArgumentException("The attribute can not be both unreadable and unwritable.");
        }
        this.attributeType = string2;
        this.isRead = bl;
        this.isWrite = bl2;
        this.is = bl3;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("clone() called on non-cloneable object.");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MBeanAttributeInfo)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MBeanAttributeInfo mBeanAttributeInfo = (MBeanAttributeInfo)object;
        return this.attributeType.equals(mBeanAttributeInfo.getType()) && this.isRead == mBeanAttributeInfo.isReadable() && this.isWrite == mBeanAttributeInfo.isWritable() && this.is == mBeanAttributeInfo.isIs();
    }

    public String getType() {
        return this.attributeType;
    }

    public int hashCode() {
        return super.hashCode() + this.attributeType.hashCode() + Boolean.valueOf(this.isRead).hashCode() + 2 * Boolean.valueOf(this.isWrite).hashCode() + 4 * Boolean.valueOf(this.is).hashCode();
    }

    public boolean isIs() {
        return this.is;
    }

    public boolean isReadable() {
        return this.isRead;
    }

    public boolean isWritable() {
        return this.isWrite;
    }

    public String toString() {
        if (this.string == null) {
            super.toString();
            this.string = this.string.substring(0, this.string.length() - 1) + ",type=" + this.attributeType + ",isReadable=" + (this.isRead ? "yes" : "no") + ",isWritable=" + (this.isWrite ? "yes" : "no") + ",isIs=" + (this.is ? "yes" : "no") + "]";
        }
        return this.string;
    }
}

