/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;

public abstract class Line2D
implements Shape,
Cloneable {
    protected Line2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public void setLine(Point2D point2D, Point2D point2D2) {
        this.setLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setLine(Line2D line2D) {
        this.setLine(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public static int relativeCCW(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d == d3 && d2 == d4 || d == d5 && d2 == d6) {
            return 0;
        }
        double d7 = (d4 -= d2) / (d3 -= d);
        double d8 = (d6 -= d2) / (d5 -= d);
        if (d7 == d8 || d3 == 0.0 && d5 == 0.0) {
            if (d4 > 0.0) {
                if (d6 < 0.0) {
                    return -1;
                }
                if (d6 > d4) {
                    return 1;
                }
                return 0;
            }
            if (d6 > 0.0) {
                return -1;
            }
            if (d6 < d4) {
                return 1;
            }
            return 0;
        }
        if (d3 >= 0.0 && d7 >= 0.0) {
            if (d5 >= 0.0) {
                if (d7 > d8) {
                    return 1;
                }
                return -1;
            }
            if (d7 < d8) {
                return 1;
            }
            return -1;
        }
        if (d4 > 0.0) {
            if (d5 < 0.0) {
                if (d7 > d8) {
                    return 1;
                }
                return -1;
            }
            if (d7 < d8) {
                return 1;
            }
            return -1;
        }
        if (d7 >= 0.0) {
            if (d5 >= 0.0) {
                if (d7 < d8) {
                    return 1;
                }
                return -1;
            }
            if (d7 > d8) {
                return 1;
            }
            return -1;
        }
        if (d5 < 0.0) {
            if (d7 < d8) {
                return 1;
            }
            return -1;
        }
        if (d7 > d8) {
            return 1;
        }
        return -1;
    }

    public int relativeCCW(double d, double d2) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2);
    }

    public int relativeCCW(Point2D point2D) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    private static double area2(double d, double d2, double d3, double d4, double d5, double d6) {
        return (d3 - d) * (d6 - d2) - (d5 - d) * (d4 - d2);
    }

    private static boolean between(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d != d3) {
            return d <= d5 && d5 <= d3 || d >= d5 && d5 >= d3;
        }
        return d2 <= d6 && d6 <= d4 || d2 >= d6 && d6 >= d4;
    }

    public static boolean linesIntersect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = Line2D.area2(d, d2, d3, d4, d5, d6);
        if (d9 == 0.0) {
            if (Line2D.between(d, d2, d3, d4, d5, d6)) {
                return true;
            }
            if (Line2D.area2(d, d2, d3, d4, d7, d8) == 0.0) {
                return Line2D.between(d5, d6, d7, d8, d, d2) || Line2D.between(d5, d6, d7, d8, d3, d4);
            }
            return false;
        }
        double d10 = Line2D.area2(d, d2, d3, d4, d7, d8);
        if (d10 == 0.0) {
            return Line2D.between(d, d2, d3, d4, d7, d8);
        }
        double d11 = Line2D.area2(d5, d6, d7, d8, d, d2);
        if (d11 == 0.0) {
            if (Line2D.between(d5, d6, d7, d8, d, d2)) {
                return true;
            }
            if (Line2D.area2(d5, d6, d7, d8, d3, d4) == 0.0) {
                return Line2D.between(d, d2, d3, d4, d5, d6) || Line2D.between(d, d2, d3, d4, d7, d8);
            }
            return false;
        }
        double d12 = Line2D.area2(d5, d6, d7, d8, d3, d4);
        if (d12 == 0.0) {
            return Line2D.between(d5, d6, d7, d8, d3, d4);
        }
        return d9 > 0.0 ^ d10 > 0.0 && d11 > 0.0 ^ d12 > 0.0;
    }

    public boolean intersectsLine(double d, double d2, double d3, double d4) {
        return Line2D.linesIntersect(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2, d3, d4);
    }

    public boolean intersectsLine(Line2D line2D) {
        return Line2D.linesIntersect(this.getX1(), this.getY1(), this.getX2(), this.getY2(), line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public static double ptSegDistSq(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = d - d3;
        double d10 = d2 - d4;
        double d11 = d9 * d9 + d10 * d10;
        if (d11 == 0.0) {
            d8 = d;
            d7 = d4;
        } else {
            double d12 = ((d5 - d) * (d3 - d) + (d6 - d2) * (d4 - d2)) / d11;
            if (d12 < 0.0) {
                d8 = d;
                d7 = d2;
            } else if (d12 > 1.0) {
                d8 = d3;
                d7 = d4;
            } else {
                d8 = d + d12 * (d3 - d);
                d7 = d2 + d12 * (d4 - d2);
            }
        }
        double d13 = d8 - d5;
        double d14 = d7 - d6;
        return d13 * d13 + d14 * d14;
    }

    public static double ptSegDist(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.sqrt(Line2D.ptSegDistSq(d, d2, d3, d4, d5, d6));
    }

    public double ptSegDistSq(double d, double d2) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2);
    }

    public double ptSegDistSq(Point2D point2D) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public double ptSegDist(double d, double d2) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2);
    }

    public double ptSegDist(Point2D point2D) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public static double ptLineDistSq(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = d - d3;
        double d10 = d2 - d4;
        double d11 = d9 * d9 + d10 * d10;
        if (d11 == 0.0) {
            d8 = d;
            d7 = d4;
        } else {
            double d12 = ((d5 - d) * (d3 - d) + (d6 - d2) * (d4 - d2)) / d11;
            d8 = d + d12 * (d3 - d);
            d7 = d2 + d12 * (d4 - d2);
        }
        double d13 = d8 - d5;
        double d14 = d7 - d6;
        return d13 * d13 + d14 * d14;
    }

    public static double ptLineDist(double d, double d2, double d3, double d4, double d5, double d6) {
        return Math.sqrt(Line2D.ptLineDistSq(d, d2, d3, d4, d5, d6));
    }

    public double ptLineDistSq(double d, double d2) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2);
    }

    public double ptLineDistSq(Point2D point2D) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public double ptLineDist(double d, double d2) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2);
    }

    public double ptLineDist(Point2D point2D) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), point2D.getX(), point2D.getY());
    }

    public boolean contains(double d, double d2) {
        return false;
    }

    public boolean contains(Point2D point2D) {
        return false;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        double d5 = this.getX1();
        double d6 = this.getY1();
        double d7 = this.getX2();
        double d8 = this.getY2();
        if (d5 >= d && d5 <= d + d3 && d6 >= d2 && d6 <= d2 + d4) {
            return true;
        }
        if (d7 >= d && d7 <= d + d3 && d8 >= d2 && d8 <= d2 + d4) {
            return true;
        }
        double d9 = d + d3;
        double d10 = d2 + d4;
        return Line2D.linesIntersect(d5, d6, d7, d8, d, d2, d, d10) || Line2D.linesIntersect(d5, d6, d7, d8, d, d10, d9, d10) || Line2D.linesIntersect(d5, d6, d7, d8, d9, d10, d9, d2) || Line2D.linesIntersect(d5, d6, d7, d8, d9, d2, d, d2);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return false;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new PathIterator(this, affineTransform){
            private /* synthetic */ Line2D this$0;
            private /* synthetic */ AffineTransform val$at;
            private int current;
            {
                this.this$0 = line2D;
                this.finit$(affineTransform);
            }

            private /* synthetic */ void finit$(AffineTransform affineTransform) {
                this.val$at = affineTransform;
                this.current = 0;
            }

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.current > 1;
            }

            public void next() {
                ++this.current;
            }

            public int currentSegment(float[] fArray) {
                int n;
                switch (this.current) {
                    case 0: {
                        fArray[0] = (float)this.this$0.getX1();
                        fArray[1] = (float)this.this$0.getY1();
                        n = 0;
                        break;
                    }
                    case 1: {
                        fArray[0] = (float)this.this$0.getX2();
                        fArray[1] = (float)this.this$0.getY2();
                        n = 1;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("line iterator out of bounds");
                    }
                }
                if (this.val$at != null) {
                    this.val$at.transform(fArray, 0, fArray, 0, 1);
                }
                return n;
            }

            public int currentSegment(double[] dArray) {
                int n;
                switch (this.current) {
                    case 0: {
                        dArray[0] = this.this$0.getX1();
                        dArray[1] = this.this$0.getY1();
                        n = 0;
                        break;
                    }
                    case 1: {
                        dArray[0] = this.this$0.getX2();
                        dArray[1] = this.this$0.getY2();
                        n = 1;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("line iterator out of bounds");
                    }
                }
                if (this.val$at != null) {
                    this.val$at.transform(dArray, 0, dArray, 0, 1);
                }
                return n;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    public static class Float
    extends Line2D {
        public float x1;
        public float y1;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4) {
            this.x1 = f;
            this.y1 = f2;
            this.x2 = f3;
            this.y2 = f4;
        }

        public Float(Point2D point2D, Point2D point2D2) {
            this.x1 = (float)point2D.getX();
            this.y1 = (float)point2D.getY();
            this.x2 = (float)point2D2.getX();
            this.y2 = (float)point2D2.getY();
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setLine(double d, double d2, double d3, double d4) {
            this.x1 = (float)d;
            this.y1 = (float)d2;
            this.x2 = (float)d3;
            this.y2 = (float)d4;
        }

        public void setLine(float f, float f2, float f3, float f4) {
            this.x1 = f;
            this.y1 = f2;
            this.x2 = f3;
            this.y2 = f4;
        }

        public Rectangle2D getBounds2D() {
            float f = Math.min(this.x1, this.x2);
            float f2 = Math.min(this.y1, this.y2);
            float f3 = Math.abs(this.x1 - this.x2);
            float f4 = Math.abs(this.y1 - this.y2);
            return new Rectangle2D.Float(f, f2, f3, f4);
        }
    }

    public static class Double
    extends Line2D {
        public double x1;
        public double y1;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.y1 = d2;
            this.x2 = d3;
            this.y2 = d4;
        }

        public Double(Point2D point2D, Point2D point2D2) {
            this.x1 = point2D.getX();
            this.y1 = point2D.getY();
            this.x2 = point2D2.getX();
            this.y2 = point2D2.getY();
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setLine(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.y1 = d2;
            this.x2 = d3;
            this.y2 = d4;
        }

        public Rectangle2D getBounds2D() {
            double d = Math.min(this.x1, this.x2);
            double d2 = Math.min(this.y1, this.y2);
            double d3 = Math.abs(this.x1 - this.x2);
            double d4 = Math.abs(this.y1 - this.y2);
            return new Rectangle2D.Double(d, d2, d3, d4);
        }
    }
}

