/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRLE8
extends BMPDecoder {
    private static final byte ESCAPE = 0;
    private static final byte EOL = 0;
    private static final byte EOB = 1;
    private static final byte DELTA = 2;

    public DecodeRLE8(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        super(bMPFileHeader, bMPInfoHeader);
    }

    public BufferedImage decode(ImageInputStream imageInputStream) throws IOException, BMPException {
        IndexColorModel indexColorModel = this.readPalette(imageInputStream);
        this.skipToImage(imageInputStream);
        Dimension dimension = this.infoHeader.getSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth();
        byte[] byArray = this.uncompress(n2, n, imageInputStream);
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(0, n2, n, new int[]{255});
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n2 * n, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferByte, null);
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] uncompress(int var1_1, int var2_2, ImageInputStream var3_3) throws BMPException, IOException {
        var4_4 = new byte[2];
        var5_5 = new byte[var1_1 * var2_2];
        var6_6 = false;
        var8_7 = 0;
        var7_8 = 0;
        try {
            block7: while (true) {
                if (var8_7 + var7_8 * var1_1 >= var1_1 * var2_2) {
                    return var5_5;
                }
                if (var3_3.read(var4_4) != 2) {
                    throw new IOException("Error reading compressed data.");
                }
                if (var4_4[0] == 0) {
                    switch (var4_4[1]) {
                        case 1: {
                            return var5_5;
                        }
                        case 0: {
                            var8_7 = 0;
                            ++var7_8;
                            continue block7;
                        }
                        case 2: {
                            if (var3_3.read(var4_4) != 2) {
                                throw new IOException("Error reading compressed data.");
                            }
                            var9_9 = var4_4[0] & 255;
                            var10_11 = var4_4[1] & 255;
                            var8_7 += var9_9;
                            var7_8 += var10_11;
                            continue block7;
                        }
                    }
                    var12_13 = var11_12 = var4_4[1] & 255;
                    var11_12 += var11_12 & 1;
                    var13_14 = new byte[var11_12];
                    if (var3_3.read(var13_14) != var11_12) {
                        throw new IOException("Error reading compressed data.");
                    }
                    System.arraycopy(var13_14, 0, var5_5, var8_7 + var1_1 * (var2_2 - var7_8 - 1), var12_13);
                    var8_7 += var12_13;
                    continue;
                }
                var9_9 = var4_4[0] & 255;
                var10_11 = 0;
                while (true) {
                    if (var10_11 < var9_9) ** break;
                    continue block7;
                    var5_5[(var2_2 - var7_8 - 1) * var1_1 + var8_7++] = var4_4[1];
                    ++var10_11;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException var9_10) {
            throw new BMPException("Invalid RLE data.");
        }
    }
}

