/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRGB8
extends BMPDecoder {
    public DecodeRGB8(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        super(bMPFileHeader, bMPInfoHeader);
    }

    public BufferedImage decode(ImageInputStream imageInputStream) throws IOException, BMPException {
        Object object;
        IndexColorModel indexColorModel = this.readPalette(imageInputStream);
        this.skipToImage(imageInputStream);
        Dimension dimension = this.infoHeader.getSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth();
        int n3 = (n2 & 3) != 0 ? n2 + 4 - (n2 & 3) : n2;
        byte[] byArray = new byte[n2 * n];
        for (int i = n - 1; i >= 0; --i) {
            object = new byte[n3];
            if (imageInputStream.read((byte[])object) != n3) {
                throw new IOException("Couldn't read image data.");
            }
            for (int j = 0; j < n2; ++j) {
                byArray[j + i * n2] = object[j];
            }
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(0, n2, n, new int[]{255});
        object = new DataBufferByte(byArray, n2 * n, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, (DataBuffer)object, null);
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }
}

