/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl;

import gnu.javax.crypto.sasl.SaslEncodingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.logging.Logger;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;

public class SaslInputStream
extends InputStream {
    private static final Logger log = Logger.getLogger(SaslInputStream.class$("gnu.javax.crypto.sasl.SaslInputStream").getName());
    private SaslClient client;
    private SaslServer server;
    private int maxRawSendSize;
    private InputStream source;
    private byte[] internalBuf;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SaslInputStream(SaslClient saslClient, InputStream inputStream) throws IOException {
        this.client = saslClient;
        String string = (String)saslClient.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        this.maxRawSendSize = Integer.parseInt(string);
        this.server = null;
        this.source = inputStream;
    }

    public SaslInputStream(SaslServer saslServer, InputStream inputStream) throws IOException {
        this.server = saslServer;
        String string = (String)saslServer.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        this.maxRawSendSize = Integer.parseInt(string);
        this.client = null;
        this.source = inputStream;
    }

    public int available() throws IOException {
        if (this.internalBuf == null) {
            return 0;
        }
        return this.internalBuf.length;
    }

    public void close() throws IOException {
        this.source.close();
    }

    public int read() throws IOException {
        int n = -1;
        if (this.internalBuf != null && this.internalBuf.length > 0) {
            n = this.internalBuf[0] & 0xFF;
            if (this.internalBuf.length == 1) {
                this.internalBuf = new byte[0];
            } else {
                byte[] byArray = new byte[this.internalBuf.length - 1];
                System.arraycopy(this.internalBuf, 1, byArray, 0, byArray.length);
                this.internalBuf = byArray;
            }
        } else {
            byte[] byArray = new byte[1];
            int n2 = this.read(byArray);
            n = n2 > 0 ? byArray[0] & 0xFF : -1;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off=" + n + ", len=" + n2 + ", b.length=" + byArray.length);
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (this.internalBuf == null || this.internalBuf.length < 1) {
            try {
                this.internalBuf = this.readSaslBuffer();
                if (this.internalBuf == null) {
                    return -1;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                return -1;
            }
        }
        if (n2 <= this.internalBuf.length) {
            n3 = n2;
            System.arraycopy(this.internalBuf, 0, byArray, n, n2);
            if (n2 == this.internalBuf.length) {
                this.internalBuf = null;
            } else {
                byte[] byArray2 = new byte[this.internalBuf.length - n2];
                System.arraycopy(this.internalBuf, n2, byArray2, 0, byArray2.length);
                this.internalBuf = byArray2;
            }
        } else {
            byte[] byArray3;
            n3 = this.internalBuf.length;
            System.arraycopy(this.internalBuf, 0, byArray, n, n3);
            this.internalBuf = null;
            n += n3;
            n2 -= n3;
            while (n2 > 0 && this.source.available() > 3 && (byArray3 = this.readSaslBuffer()) != null) {
                int n4 = byArray3.length;
                int n5 = n4 <= n2 ? 0 : n4 - n2;
                int n6 = n4 - n5;
                System.arraycopy(byArray3, 0, byArray, n, n6);
                if (n5 > 0) {
                    this.internalBuf = new byte[n5];
                    System.arraycopy(byArray3, n6, this.internalBuf, 0, n5);
                }
                n += n6;
                n3 += n6;
                n2 -= n6;
            }
        }
        return n3;
    }

    private byte[] readSaslBuffer() throws IOException {
        byte[] byArray = new byte[4];
        int n = this.source.read(byArray);
        if (n == -1) {
            return null;
        }
        if (n != 4) {
            throw new IOException("Was expecting 4 but found " + n);
        }
        int n2 = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        if (n2 > this.maxRawSendSize || n2 < 0) {
            throw new SaslEncodingException("SASL buffer (security layer) too long");
        }
        byArray = new byte[n2];
        n = this.source.read(byArray);
        if (n != n2) {
            throw new IOException("Was expecting " + n2 + " but found " + n);
        }
        byArray = this.client != null ? this.client.unwrap(byArray, 0, n) : this.server.unwrap(byArray, 0, n);
        return byArray;
    }
}

