/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl;

import gnu.javax.crypto.sasl.IllegalMechanismStateException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public abstract class ClientMechanism
implements SaslClient {
    protected String mechanism;
    protected String authorizationID;
    protected String protocol;
    protected String serverName;
    protected Map properties;
    protected CallbackHandler handler;
    protected byte[] channelBinding;
    protected boolean complete;
    protected int state;

    private /* synthetic */ void finit$() {
        this.complete = false;
        this.state = -1;
    }

    protected ClientMechanism(String string) {
        this.finit$();
        this.mechanism = string;
        this.state = -1;
    }

    protected abstract void initMechanism() throws SaslException;

    protected abstract void resetMechanism() throws SaslException;

    public abstract byte[] evaluateChallenge(byte[] var1) throws SaslException;

    public abstract boolean hasInitialResponse();

    public boolean isComplete() {
        return this.complete;
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalMechanismStateException();
        }
        return this.engineUnwrap(byArray, n, n2);
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (!this.isComplete()) {
            throw new IllegalMechanismStateException();
        }
        return this.engineWrap(byArray, n, n2);
    }

    public String getMechanismName() {
        return this.mechanism;
    }

    public Object getNegotiatedProperty(String string) {
        if (!this.isComplete()) {
            throw new IllegalStateException();
        }
        if (Sasl.QOP.equals(string)) {
            return this.getNegotiatedQOP();
        }
        if (Sasl.STRENGTH.equals(string)) {
            return this.getNegotiatedStrength();
        }
        if (Sasl.SERVER_AUTH.equals(string)) {
            return this.getNegotiatedServerAuth();
        }
        if (Sasl.MAX_BUFFER.equals(string)) {
            return this.getNegotiatedMaxBuffer();
        }
        if (Sasl.RAW_SEND_SIZE.equals(string)) {
            return this.getNegotiatedRawSendSize();
        }
        if (Sasl.POLICY_NOPLAINTEXT.equals(string)) {
            return this.getNegotiatedPolicyNoPlainText();
        }
        if (Sasl.POLICY_NOACTIVE.equals(string)) {
            return this.getNegotiatedPolicyNoActive();
        }
        if (Sasl.POLICY_NODICTIONARY.equals(string)) {
            return this.getNegotiatedPolicyNoDictionary();
        }
        if (Sasl.POLICY_NOANONYMOUS.equals(string)) {
            return this.getNegotiatedPolicyNoAnonymous();
        }
        if (Sasl.POLICY_FORWARD_SECRECY.equals(string)) {
            return this.getNegotiatedPolicyForwardSecrecy();
        }
        if (Sasl.POLICY_PASS_CREDENTIALS.equals(string)) {
            return this.getNegotiatedPolicyPassCredentials();
        }
        if (Sasl.REUSE.equals(string)) {
            return this.getReuse();
        }
        return null;
    }

    public void dispose() throws SaslException {
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    protected String getNegotiatedQOP() {
        return "auth";
    }

    protected String getNegotiatedStrength() {
        return "low";
    }

    protected String getNegotiatedServerAuth() {
        return "false";
    }

    protected String getNegotiatedMaxBuffer() {
        return null;
    }

    protected String getNegotiatedRawSendSize() {
        return String.valueOf(0x7FFFFFFB);
    }

    protected String getNegotiatedPolicyNoPlainText() {
        return null;
    }

    protected String getNegotiatedPolicyNoActive() {
        return null;
    }

    protected String getNegotiatedPolicyNoDictionary() {
        return null;
    }

    protected String getNegotiatedPolicyNoAnonymous() {
        return null;
    }

    protected String getNegotiatedPolicyForwardSecrecy() {
        return null;
    }

    protected String getNegotiatedPolicyPassCredentials() {
        return null;
    }

    protected String getReuse() {
        return "false";
    }

    protected byte[] engineUnwrap(byte[] byArray, int n, int n2) throws SaslException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    protected byte[] engineWrap(byte[] byArray, int n, int n2) throws SaslException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public void init(Map map) throws SaslException {
        if (this.state != -1) {
            throw new IllegalMechanismStateException("init()");
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        } else {
            this.properties.clear();
        }
        if (map != null) {
            this.authorizationID = (String)map.get("gnu.crypto.sasl.authorisation.ID");
            this.protocol = (String)map.get("gnu.crypto.sasl.protocol");
            this.serverName = (String)map.get("gnu.crypto.sasl.server.name");
            this.handler = (CallbackHandler)map.get("gnu.crypto.sasl.callback.handler");
            this.channelBinding = (byte[])map.get("gnu.crypto.sasl.channel.binding");
            this.properties.putAll(map);
        } else {
            this.handler = null;
        }
        if (this.authorizationID == null) {
            this.authorizationID = "";
        }
        if (this.protocol == null) {
            this.protocol = "";
        }
        if (this.serverName == null) {
            this.serverName = "";
        }
        if (this.channelBinding == null) {
            this.channelBinding = new byte[0];
        }
        this.initMechanism();
        this.complete = false;
        this.state = 0;
    }

    public void reset() throws SaslException {
        this.resetMechanism();
        this.properties.clear();
        this.serverName = null;
        this.protocol = null;
        this.authorizationID = null;
        this.channelBinding = null;
        this.complete = false;
        this.state = -1;
    }
}

