/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.Properties;
import gnu.java.security.util.PRNG;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSA {
    private static final BigInteger ZERO = BigInteger.ZERO;
    private static final BigInteger ONE = BigInteger.ONE;
    private static final PRNG prng = PRNG.getInstance();

    private RSA() {
    }

    public static final BigInteger sign(PrivateKey privateKey, BigInteger bigInteger) {
        try {
            return RSA.RSADP((RSAPrivateKey)privateKey, bigInteger);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("message representative out of range");
        }
    }

    public static final BigInteger verify(PublicKey publicKey, BigInteger bigInteger) {
        try {
            return RSA.RSAEP((RSAPublicKey)publicKey, bigInteger);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("signature representative out of range");
        }
    }

    public static final BigInteger encrypt(PublicKey publicKey, BigInteger bigInteger) {
        try {
            return RSA.RSAEP((RSAPublicKey)publicKey, bigInteger);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("message representative out of range");
        }
    }

    public static final BigInteger decrypt(PrivateKey privateKey, BigInteger bigInteger) {
        try {
            return RSA.RSADP((RSAPrivateKey)privateKey, bigInteger);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("ciphertext representative out of range");
        }
    }

    public static final byte[] I2OSP(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length < n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
            byArray = byArray2;
        } else if (byArray.length > n) {
            int n2 = byArray.length - n;
            for (int i = 0; i < n2; ++i) {
                if (byArray[i] == 0) continue;
                throw new IllegalArgumentException("integer too large");
            }
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, n2, byArray3, 0, n);
            byArray = byArray3;
        }
        return byArray;
    }

    private static final BigInteger RSAEP(RSAPublicKey rSAPublicKey, BigInteger bigInteger) {
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        if (bigInteger.compareTo(ZERO) < 0 || bigInteger.compareTo(bigInteger2.subtract(ONE)) > 0) {
            throw new IllegalArgumentException();
        }
        BigInteger bigInteger3 = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger4 = bigInteger.modPow(bigInteger3, bigInteger2);
        return bigInteger4;
    }

    private static final BigInteger RSADP(RSAPrivateKey rSAPrivateKey, BigInteger bigInteger) {
        BigInteger bigInteger2;
        BigInteger bigInteger3 = rSAPrivateKey.getModulus();
        if (bigInteger.compareTo(ZERO) < 0 || bigInteger.compareTo(bigInteger3.subtract(ONE)) > 0) {
            throw new IllegalArgumentException();
        }
        if (!(rSAPrivateKey instanceof RSAPrivateCrtKey)) {
            BigInteger bigInteger4 = rSAPrivateKey.getPrivateExponent();
            bigInteger2 = bigInteger.modPow(bigInteger4, bigInteger3);
        } else {
            BigInteger bigInteger5;
            boolean bl = Properties.doRSABlinding();
            BigInteger bigInteger6 = null;
            BigInteger bigInteger7 = null;
            if (bl) {
                bigInteger6 = RSA.newR(bigInteger3);
                bigInteger7 = ((RSAPrivateCrtKey)rSAPrivateKey).getPublicExponent();
                bigInteger = bigInteger5 = bigInteger6.modPow(bigInteger7, bigInteger3).multiply(bigInteger).mod(bigInteger3);
            }
            bigInteger5 = ((RSAPrivateCrtKey)rSAPrivateKey).getPrimeP();
            BigInteger bigInteger8 = ((RSAPrivateCrtKey)rSAPrivateKey).getPrimeQ();
            BigInteger bigInteger9 = ((RSAPrivateCrtKey)rSAPrivateKey).getPrimeExponentP();
            BigInteger bigInteger10 = ((RSAPrivateCrtKey)rSAPrivateKey).getPrimeExponentQ();
            BigInteger bigInteger11 = ((RSAPrivateCrtKey)rSAPrivateKey).getCrtCoefficient();
            BigInteger bigInteger12 = bigInteger.modPow(bigInteger9, bigInteger5);
            BigInteger bigInteger13 = bigInteger.modPow(bigInteger10, bigInteger8);
            BigInteger bigInteger14 = bigInteger12.subtract(bigInteger13).multiply(bigInteger11).mod(bigInteger5);
            bigInteger2 = bigInteger13.add(bigInteger8.multiply(bigInteger14));
            if (bl) {
                bigInteger2 = bigInteger2.multiply(bigInteger6.modInverse(bigInteger3)).mod(bigInteger3);
            }
        }
        return bigInteger2;
    }

    private static final BigInteger newR(BigInteger bigInteger) {
        int n;
        int n2 = (bigInteger.bitLength() + 7) / 8;
        int n3 = n2 / 2;
        byte[] byArray = new byte[1];
        do {
            prng.nextBytes(byArray);
        } while ((n = byArray[0] & 0xFF) < n3 || n > n2);
        byte[] byArray2 = new byte[n];
        prng.nextBytes(byArray2);
        return new BigInteger(1, byArray2);
    }
}

