/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.protocol.http.HTTPConnection;
import java.io.IOException;
import java.io.InputStream;

class LimitedLengthInputStream
extends InputStream {
    private long remainingLen;
    private boolean restrictLen;
    private HTTPConnection connection;
    private boolean eof;
    private InputStream in;
    private boolean doClose;

    private void handleClose() throws IOException {
        this.eof = true;
        if (this.doClose) {
            this.in.close();
        } else {
            this.connection.release();
        }
        this.in = null;
        this.connection = null;
    }

    LimitedLengthInputStream(InputStream inputStream, long l, boolean bl, HTTPConnection hTTPConnection, boolean bl2) throws IOException {
        this.in = inputStream;
        this.remainingLen = l;
        this.restrictLen = bl;
        this.connection = hTTPConnection;
        this.doClose = bl2;
        if (bl) {
            if (l < 0L) {
                throw new IllegalArgumentException();
            }
            if (l == 0L) {
                this.handleClose();
            }
        }
    }

    public synchronized int read() throws IOException {
        int n;
        if (this.eof) {
            return -1;
        }
        if (this.restrictLen) {
            n = this.in.read();
            if (-1 != n) {
                --this.remainingLen;
            }
            if (0L == this.remainingLen) {
                this.handleClose();
            }
        } else {
            n = this.in.read();
            if (n == -1) {
                this.handleClose();
            }
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.eof) {
            return -1;
        }
        if (this.restrictLen && (long)n2 > this.remainingLen) {
            n2 = (int)this.remainingLen;
        }
        if (-1 == (n3 = this.in.read(byArray, n, n2))) {
            this.handleClose();
        }
        if (this.restrictLen && n3 > 0) {
            this.remainingLen -= (long)n3;
            if (0L == this.remainingLen) {
                this.handleClose();
            }
        }
        return n3;
    }

    public synchronized long skip(long l) throws IOException {
        if (this.eof) {
            return 0L;
        }
        if (this.restrictLen && l > this.remainingLen) {
            l = this.remainingLen;
        }
        long l2 = this.in.skip(l);
        if (this.restrictLen) {
            this.remainingLen -= l2;
            if (0L == this.remainingLen) {
                this.handleClose();
            }
        }
        return l2;
    }

    public synchronized int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        int n = this.in.available();
        if (this.restrictLen && (long)n > this.remainingLen) {
            n = (int)this.remainingLen;
        }
        return n;
    }

    public synchronized void close() throws IOException {
        if (this.eof) {
            return;
        }
        this.doClose = true;
        this.handleClose();
    }
}

