/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractElementHandler;
import gnu.java.beans.decoder.ArrayContext;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.ElementHandler;
import gnu.java.beans.decoder.GrowableArrayContext;
import java.beans.ExceptionListener;
import java.util.HashMap;
import org.xml.sax.Attributes;

class ArrayHandler
extends AbstractElementHandler {
    private static HashMap typeMap = new HashMap();

    ArrayHandler(ElementHandler elementHandler) {
        super(elementHandler, true);
    }

    protected Context startElement(Attributes attributes, ExceptionListener exceptionListener) throws AssemblyException, AssemblyException {
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("class");
        if (string2 != null) {
            try {
                Class clazz = typeMap.containsKey(string2) ? (Class)typeMap.get(string2) : this.instantiateClass(string2);
                String string3 = attributes.getValue("length");
                if (string3 != null) {
                    return new ArrayContext(string, clazz, Integer.parseInt(string3));
                }
                return new GrowableArrayContext(string, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssemblyException(classNotFoundException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AssemblyException(numberFormatException);
            }
        }
        throw new AssemblyException(new IllegalArgumentException("Missing 'class' attribute in <array> tag."));
    }

    static {
        typeMap.put("byte", Byte.TYPE);
        typeMap.put("short", Short.TYPE);
        typeMap.put("int", Integer.TYPE);
        typeMap.put("long", Long.TYPE);
        typeMap.put("float", Float.TYPE);
        typeMap.put("double", Double.TYPE);
        typeMap.put("boolean", Boolean.TYPE);
        typeMap.put("char", Character.TYPE);
    }
}

