/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.CairoSurfaceGraphics;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;

public class ComponentGraphicsCopy
extends CairoSurfaceGraphics {
    private GtkComponentPeer component;
    private GtkImage gtkimage;
    private int width;
    private int height;

    native void getPixbuf(GtkComponentPeer var1, GtkImage var2);

    native void copyPixbuf(GtkComponentPeer var1, GtkImage var2, int var3, int var4, int var5, int var6);

    public ComponentGraphicsCopy(int n, int n2, GtkComponentPeer gtkComponentPeer) {
        super(new CairoSurface(n, n2));
        this.component = gtkComponentPeer;
        this.width = n;
        this.height = n2;
        this.gtkimage = this.surface.getGtkImage();
        this.getPixbuf(gtkComponentPeer, this.gtkimage);
    }

    public void draw(Shape shape) {
        super.draw(shape);
        Rectangle rectangle = shape.getBounds();
        this.copyPixbuf(this.component, this.gtkimage, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fill(Shape shape) {
        super.fill(shape);
        Rectangle rectangle = shape.getBounds();
        this.copyPixbuf(this.component, this.gtkimage, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        super.drawRenderedImage(renderedImage, affineTransform);
        this.copyPixbuf(this.component, this.gtkimage, 0, 0, this.width, this.height);
    }

    protected boolean drawImage(Image image, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        boolean bl = super.drawImage(image, affineTransform, color, imageObserver);
        this.copyPixbuf(this.component, this.gtkimage, 0, 0, this.width, this.height);
        return bl;
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        super.drawGlyphVector(glyphVector, f, f2);
        Rectangle rectangle = glyphVector.getPixelBounds(this.getFontRenderContext(), f, f2);
        this.copyPixbuf(this.component, this.gtkimage, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

