/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.gtk.BufferedImageGraphics;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.FreetypeGlyphVector;
import gnu.java.awt.peer.gtk.GdkFontPeer;
import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.ImagingOpException;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;

public abstract class CairoGraphics2D
extends Graphics2D {
    long nativePointer;
    Paint paint;
    Stroke stroke;
    Color fg;
    Color bg;
    Shape clip;
    AffineTransform transform;
    Font font;
    Composite comp;
    private RenderingHints hints;
    private boolean shiftDrawCalls;
    private boolean firstClip;
    private Shape originalClip;
    private static BasicStroke draw3DRectStroke;
    static ColorModel rgb32;
    static ColorModel argb32;

    private /* synthetic */ void finit$() {
        this.shiftDrawCalls = false;
        this.firstClip = true;
    }

    public CairoGraphics2D() {
        this.finit$();
    }

    public void setup(long l) {
        this.nativePointer = this.init(l);
        this.setRenderingHints(new RenderingHints(this.getDefaultHints()));
        this.font = new Font("SansSerif", 0, 12);
        this.setColor(Color.black);
        this.setBackground(Color.white);
        this.setPaint(Color.black);
        this.setStroke(new BasicStroke());
        this.setTransform(new AffineTransform());
    }

    public void copy(CairoGraphics2D cairoGraphics2D, long l) {
        this.nativePointer = this.init(l);
        this.paint = cairoGraphics2D.paint;
        this.stroke = cairoGraphics2D.stroke;
        this.setRenderingHints(cairoGraphics2D.hints);
        Color color = cairoGraphics2D.fg.getAlpha() != -1 ? new Color(cairoGraphics2D.fg.getRed(), cairoGraphics2D.fg.getGreen(), cairoGraphics2D.fg.getBlue(), cairoGraphics2D.fg.getAlpha()) : new Color(cairoGraphics2D.fg.getRGB());
        if (cairoGraphics2D.bg != null) {
            this.bg = cairoGraphics2D.bg.getAlpha() != -1 ? new Color(cairoGraphics2D.bg.getRed(), cairoGraphics2D.bg.getGreen(), cairoGraphics2D.bg.getBlue(), cairoGraphics2D.bg.getAlpha()) : new Color(cairoGraphics2D.bg.getRGB());
        }
        this.clip = cairoGraphics2D.getClip();
        this.transform = cairoGraphics2D.transform == null ? null : new AffineTransform(cairoGraphics2D.transform);
        this.font = cairoGraphics2D.font;
        this.setColor(color);
        this.setBackground(this.bg);
        this.setPaint(this.paint);
        this.setStroke(this.stroke);
        this.setTransformImpl(this.transform);
        this.setClip(this.clip);
    }

    public void finalize() {
        this.dispose();
    }

    public void dispose() {
        this.disposeNative(this.nativePointer);
        this.nativePointer = 0L;
    }

    private native long init(long var1);

    public abstract Graphics create();

    public abstract GraphicsConfiguration getDeviceConfiguration();

    protected abstract void copyAreaImpl(int var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract Rectangle2D getRealBounds();

    public native void disposeNative(long var1);

    private native void drawPixels(long var1, int[] var3, int var4, int var5, int var6, double[] var7, double var8);

    private native void setGradient(long var1, double var3, double var5, double var7, double var9, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, boolean var19);

    private native void setTexturePixels(long var1, int[] var3, int var4, int var5, int var6);

    private native void cairoSetMatrix(long var1, double[] var3);

    private native void cairoScale(long var1, double var3, double var5);

    private native void cairoSetOperator(long var1, int var3);

    private native void cairoSetRGBAColor(long var1, double var3, double var5, double var7, double var9);

    private native void cairoSetFillRule(long var1, int var3);

    private native void cairoSetLine(long var1, double var3, int var5, int var6, double var7);

    private native void cairoSetDash(long var1, double[] var3, int var4, double var5);

    native void cairoDrawGlyphVector(long var1, GdkFontPeer var3, float var4, float var5, int var6, int[] var7, float[] var8);

    private native void cairoRelCurveTo(long var1, double var3, double var5, double var7, double var9, double var11, double var13);

    private native void cairoRectangle(long var1, double var3, double var5, double var7, double var9);

    private native void cairoArc(long var1, double var3, double var5, double var7, double var9, double var11);

    private native void cairoSave(long var1);

    private native void cairoRestore(long var1);

    private native void cairoNewPath(long var1);

    private native void cairoClosePath(long var1);

    private native void cairoMoveTo(long var1, double var3, double var5);

    private native void cairoRelMoveTo(long var1, double var3, double var5);

    private native void cairoLineTo(long var1, double var3, double var5);

    private native void cairoRelLineTo(long var1, double var3, double var5);

    private native void cairoCurveTo(long var1, double var3, double var5, double var7, double var9, double var11, double var13);

    private native void cairoStroke(long var1);

    private native void cairoFill(long var1, double var3);

    private native void cairoClip(long var1);

    private native void cairoPreserveClip(long var1);

    private native void cairoResetClip(long var1);

    private native void cairoSurfaceSetFilter(long var1, int var3);

    private native void cairoDrawLine(long var1, double var3, double var5, double var7, double var9);

    private native void cairoDrawRect(long var1, double var3, double var5, double var7, double var9);

    private native void cairoFillRect(long var1, double var3, double var5, double var7, double var9);

    public void setTransform(AffineTransform affineTransform) {
        this.updateClip(this.transform);
        this.setTransformImpl(affineTransform);
        try {
            this.updateClip(this.transform.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        if (this.clip != null) {
            this.setClip(this.clip);
        }
    }

    private void setTransformImpl(AffineTransform affineTransform) {
        this.transform = affineTransform;
        if (this.transform != null) {
            double[] dArray = new double[6];
            this.transform.getMatrix(dArray);
            this.cairoSetMatrix(this.nativePointer, dArray);
        }
    }

    public void transform(AffineTransform affineTransform) {
        if (this.transform == null) {
            this.transform = new AffineTransform(affineTransform);
        } else {
            this.transform.concatenate(affineTransform);
        }
        if (this.clip != null) {
            try {
                AffineTransform affineTransform2 = affineTransform.createInverse();
                this.updateClip(affineTransform2);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        this.setTransformImpl(this.transform);
    }

    public void rotate(double d) {
        this.transform(AffineTransform.getRotateInstance(d));
    }

    public void rotate(double d, double d2, double d3) {
        this.transform(AffineTransform.getRotateInstance(d, d2, d3));
    }

    public void scale(double d, double d2) {
        this.transform(AffineTransform.getScaleInstance(d, d2));
    }

    public void translate(double d, double d2) {
        if (this.transform != null) {
            this.transform.translate(d, d2);
        } else {
            this.transform = AffineTransform.getTranslateInstance(d, d2);
        }
        if (this.clip != null) {
            if (this.clip instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)this.clip;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth(), rectangle2D.getHeight());
            } else {
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(-d, -d2);
                this.updateClip(affineTransform);
            }
        }
        this.setTransformImpl(this.transform);
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    public void shear(double d, double d2) {
        this.transform(AffineTransform.getShearInstance(d, d2));
    }

    public void clip(Shape shape) {
        if (shape == null) {
            this.setClip(null);
            return;
        }
        if (this.clip == null) {
            this.clip = this.getRealBounds();
        }
        if (this.clip instanceof Rectangle2D && shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)this.clip;
            Rectangle2D rectangle2D2 = (Rectangle2D)shape;
            Rectangle2D.intersect(rectangle2D, rectangle2D2, rectangle2D);
            this.setClip(rectangle2D);
        } else {
            Area area = this.clip instanceof Area ? (Area)this.clip : new Area(this.clip);
            Area area2 = shape instanceof Area ? (Area)shape : new Area(shape);
            area.intersect(area2);
            this.clip = area;
            this.setClip(this.clip);
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public void setPaint(Paint paint) {
        if (this.paint == null) {
            return;
        }
        this.paint = paint;
        if (this.paint instanceof Color) {
            this.setColor((Color)this.paint);
        } else if (this.paint instanceof TexturePaint) {
            TexturePaint texturePaint = (TexturePaint)this.paint;
            BufferedImage bufferedImage = texturePaint.getImage();
            int n = (int)texturePaint.getAnchorRect().getWidth();
            int n2 = (int)texturePaint.getAnchorRect().getHeight();
            double d = (double)n / (double)bufferedImage.getWidth();
            double d2 = (double)n2 / (double)bufferedImage.getHeight();
            AffineTransform affineTransform = new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, this.getRenderingHints());
            BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
            int[] nArray = bufferedImage2.getRGB(0, 0, n, n2, null, 0, n);
            this.setTexturePixels(this.nativePointer, nArray, n, n2, n);
        } else if (this.paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)this.paint;
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            Color color = gradientPaint.getColor1();
            Color color2 = gradientPaint.getColor2();
            this.setGradient(this.nativePointer, point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), color2.getRed(), color2.getGreen(), color2.getBlue(), color2.getAlpha(), gradientPaint.isCyclic());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        if (this.stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this.stroke;
            this.cairoSetLine(this.nativePointer, basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit());
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                double[] dArray = new double[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    dArray[i] = fArray[i];
                }
                this.cairoSetDash(this.nativePointer, dArray, dArray.length, basicStroke.getDashPhase());
            } else {
                this.cairoSetDash(this.nativePointer, new double[0], 0, 0.0);
            }
        }
    }

    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    public void setXORMode(Color color) {
    }

    public void setColor(Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        this.fg = color;
        this.paint = color;
        this.updateColor();
    }

    void updateColor() {
        if (this.fg == null) {
            this.fg = Color.BLACK;
        }
        this.cairoSetRGBAColor(this.nativePointer, (double)this.fg.getRed() / 255.0, (double)this.fg.getGreen() / 255.0, (double)this.fg.getBlue() / 255.0, (double)this.fg.getAlpha() / 255.0);
    }

    public Color getColor() {
        return this.fg;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        if (this.clip == null) {
            this.setClip(new Rectangle(n, n2, n3, n4));
        } else if (this.clip instanceof Rectangle) {
            CairoGraphics2D.computeIntersection(n, n2, n3, n4, (Rectangle)this.clip);
            this.setClip(this.clip);
        } else {
            this.clip(new Rectangle(n, n2, n3, n4));
        }
    }

    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        if (this.clip instanceof Rectangle2D) {
            return this.clip.getBounds2D();
        }
        GeneralPath generalPath = new GeneralPath();
        PathIterator pathIterator = this.clip.getPathIterator(null);
        generalPath.append(pathIterator, false);
        return generalPath;
    }

    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.clip.getBounds();
    }

    protected Rectangle2D getClipInDevSpace() {
        Rectangle2D rectangle2D = this.clip.getBounds2D();
        if (this.transform == null) {
            return rectangle2D;
        }
        Point2D point2D = this.transform.transform(new Point2D.Double(rectangle2D.getX(), rectangle2D.getY()), null);
        Point2D point2D2 = this.transform.deltaTransform(new Point2D.Double(rectangle2D.getWidth(), rectangle2D.getHeight()), null);
        return new Rectangle2D.Double(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setClip(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            return;
        }
        this.setClip(new Rectangle2D.Double(n, n2, n3, n4));
    }

    public void setClip(Shape shape) {
        if (this.firstClip) {
            this.originalClip = shape;
            this.firstClip = false;
        }
        this.clip = shape;
        this.cairoResetClip(this.nativePointer);
        if (this.clip != null) {
            this.cairoNewPath(this.nativePointer);
            if (this.clip instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)this.clip;
                this.cairoRectangle(this.nativePointer, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            } else {
                this.walkPath(this.clip.getPathIterator(null), false);
            }
            this.cairoClip(this.nativePointer);
        }
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = Color.WHITE;
        }
        this.bg = color;
    }

    public Color getBackground() {
        return this.bg;
    }

    public Composite getComposite() {
        if (this.comp == null) {
            return AlphaComposite.SrcOver;
        }
        return this.comp;
    }

    public void setComposite(Composite composite) {
        this.comp = composite;
        if (!(composite instanceof AlphaComposite)) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new AWTPermission("readDisplayPixels"));
            }
            throw new UnsupportedOperationException();
        }
        AlphaComposite alphaComposite = (AlphaComposite)composite;
        this.cairoSetOperator(this.nativePointer, alphaComposite.getRule());
    }

    public void draw(Shape shape) {
        if (this.stroke != null && !(this.stroke instanceof BasicStroke) || this.comp instanceof AlphaComposite && (double)((AlphaComposite)this.comp).getAlpha() != 1.0) {
            this.fill(this.stroke.createStrokedShape(shape));
            return;
        }
        this.createPath(shape);
        this.cairoStroke(this.nativePointer);
    }

    public void fill(Shape shape) {
        this.createPath(shape);
        double d = 1.0;
        if (this.comp instanceof AlphaComposite) {
            d = ((AlphaComposite)this.comp).getAlpha();
        }
        this.cairoFill(this.nativePointer, d);
    }

    private void createPath(Shape shape) {
        this.cairoNewPath(this.nativePointer);
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.cairoRectangle(this.nativePointer, this.shifted(rectangle2D.getX(), this.shiftDrawCalls), this.shifted(rectangle2D.getY(), this.shiftDrawCalls), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            double d = Math.min(ellipse2D.getHeight(), ellipse2D.getWidth()) / 2.0;
            double d2 = 1.0;
            double d3 = 1.0;
            if (ellipse2D.getHeight() != ellipse2D.getWidth()) {
                this.cairoSave(this.nativePointer);
                if (ellipse2D.getHeight() < ellipse2D.getWidth()) {
                    d2 = ellipse2D.getWidth() / (d * 2.0);
                } else {
                    d3 = ellipse2D.getHeight() / (d * 2.0);
                }
                if (d2 != 1.0 || d3 != 1.0) {
                    this.cairoScale(this.nativePointer, d2, d3);
                }
            }
            this.cairoArc(this.nativePointer, this.shifted(ellipse2D.getCenterX() / d2, this.shiftDrawCalls), this.shifted(ellipse2D.getCenterY() / d3, this.shiftDrawCalls), d, 0.0, Math.PI * 2);
            if (d2 != 1.0 || d3 != 1.0) {
                this.cairoRestore(this.nativePointer);
            }
        } else {
            this.walkPath(shape.getPathIterator(null), this.shiftDrawCalls);
        }
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        if (this.bg != null) {
            this.cairoSetRGBAColor(this.nativePointer, (double)this.bg.getRed() / 255.0, (double)this.bg.getGreen() / 255.0, (double)this.bg.getBlue() / 255.0, 1.0);
        }
        this.fillRect(n, n2, n3, n4);
        this.updateColor();
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Stroke stroke = this.stroke;
        this.setStroke(draw3DRectStroke);
        super.draw3DRect(n, n2, n3, n4, bl);
        this.setStroke(stroke);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (n == n3 && n2 == n4) {
            this.cairoFillRect(this.nativePointer, n, n2, 1.0, 1.0);
        } else {
            this.cairoDrawLine(this.nativePointer, (double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, (double)n4 + 0.5);
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.cairoDrawRect(this.nativePointer, this.shifted(n, this.shiftDrawCalls), this.shifted(n2, this.shiftDrawCalls), n3, n4);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.cairoFillRect(this.nativePointer, n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fill(new Polygon(nArray, nArray2, n));
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n));
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawArc(n, n2, n3, n4, 0, 360);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillArc(n, n2, n3, n4, 0, 360);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        Point2D point2D = this.transform.transform(new Point2D.Double(n, n2), null);
        Point2D point2D2 = this.transform.transform(new Point2D.Double(n + n3, n2 + n4), null);
        Point2D point2D3 = this.transform.transform(new Point2D.Double(n + n5, n2 + n6), null);
        int n7 = (int)point2D.getX();
        int n8 = (int)point2D.getY();
        int n9 = (int)(point2D2.getX() - point2D.getX());
        int n10 = (int)(point2D2.getY() - point2D.getY());
        int n11 = (int)(point2D3.getX() - point2D.getX());
        int n12 = (int)(point2D3.getY() - point2D.getY());
        Rectangle2D rectangle2D = this.getRealBounds();
        if (n9 < 0 || n10 < 0) {
            return;
        }
        if ((double)(n7 + n11) > rectangle2D.getWidth() || (double)(n8 + n12) > rectangle2D.getHeight()) {
            return;
        }
        if ((double)(n7 + n11 + n9) < rectangle2D.getX() || (double)(n8 + n12 + n10) < rectangle2D.getY()) {
            return;
        }
        if ((double)(n7 + n11) < rectangle2D.getX()) {
            n9 = n7 + n11 + n9;
            n7 = (int)rectangle2D.getX() - n11;
        }
        if ((double)(n8 + n12) < rectangle2D.getY()) {
            n10 = n8 + n12 + n10;
            n8 = (int)rectangle2D.getY() - n12;
        }
        if ((double)(n7 + n11 + n9) >= rectangle2D.getWidth()) {
            n9 = (int)rectangle2D.getWidth() - n11 - n7;
        }
        if ((double)(n8 + n12 + n10) >= rectangle2D.getHeight()) {
            n10 = (int)rectangle2D.getHeight() - n12 - n8;
        }
        this.copyAreaImpl(n7, n8, n9, n10, n11, n12);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.hints.put(key, object);
        if (key.equals(RenderingHints.KEY_INTERPOLATION) || key.equals(RenderingHints.KEY_ALPHA_INTERPOLATION)) {
            if (object.equals("Nearest Neighbor image interpolation mode")) {
                this.cairoSurfaceSetFilter(this.nativePointer, 0);
            } else if (object.equals("Bilinear image interpolation mode")) {
                this.cairoSurfaceSetFilter(this.nativePointer, 1);
            } else if (object.equals("Fastest alpha blending methods")) {
                this.cairoSurfaceSetFilter(this.nativePointer, 2);
            } else if (object.equals("Highest quality alpha blending methods")) {
                this.cairoSurfaceSetFilter(this.nativePointer, 3);
            } else if (object.equals("Default alpha blending methods")) {
                this.cairoSurfaceSetFilter(this.nativePointer, 4);
            }
        }
        this.shiftDrawCalls = this.hints.containsValue("Normalize strokes for consistent rendering") || this.hints.containsValue("Default stroke normalization");
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public void setRenderingHints(Map map) {
        this.hints = new RenderingHints(this.getDefaultHints());
        this.hints.add(new RenderingHints(map));
        if (map.containsKey(RenderingHints.KEY_INTERPOLATION)) {
            if (map.containsValue("Nearest Neighbor image interpolation mode")) {
                this.cairoSurfaceSetFilter(this.nativePointer, 0);
            } else if (map.containsValue("Bilinear image interpolation mode")) {
                this.cairoSurfaceSetFilter(this.nativePointer, 1);
            }
        }
        if (map.containsKey(RenderingHints.KEY_ALPHA_INTERPOLATION)) {
            if (map.containsValue("Fastest alpha blending methods")) {
                this.cairoSurfaceSetFilter(this.nativePointer, 2);
            } else if (map.containsValue("Highest quality alpha blending methods")) {
                this.cairoSurfaceSetFilter(this.nativePointer, 3);
            } else if (map.containsValue("Default alpha blending methods")) {
                this.cairoSurfaceSetFilter(this.nativePointer, 4);
            }
        }
        this.shiftDrawCalls = map.containsValue("Normalize strokes for consistent rendering") || map.containsValue("Default stroke normalization");
    }

    public void addRenderingHints(Map map) {
        this.hints.add(new RenderingHints(map));
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    protected boolean drawImage(Image image, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        Object object;
        Object object2;
        AffineTransform affineTransform2;
        if (image == null) {
            return false;
        }
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        try {
            affineTransform2 = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new ImagingOpException("Unable to invert transform " + affineTransform.toString());
        }
        if (!(image instanceof BufferedImage)) {
            object2 = image.getSource();
            if (object2 == null) {
                return false;
            }
            image = Toolkit.getDefaultToolkit().createImage((ImageProducer)object2);
        }
        object2 = (BufferedImage)image;
        double[] dArray = new double[6];
        int n = ((BufferedImage)object2).getWidth();
        int n2 = ((BufferedImage)object2).getHeight();
        DataBuffer dataBuffer = BufferedImageGraphics.bufferedImages.get(object2) != null ? (DataBuffer)BufferedImageGraphics.bufferedImages.get(object2) : ((BufferedImage)object2).getRaster().getDataBuffer();
        affineTransform2.getMatrix(dArray);
        double d = 1.0;
        if (this.comp instanceof AlphaComposite) {
            d = ((AlphaComposite)this.comp).getAlpha();
        }
        if (dataBuffer instanceof CairoSurface) {
            ((CairoSurface)dataBuffer).drawSurface(this.nativePointer, dArray, d);
            this.updateColor();
            return true;
        }
        if (color != null) {
            object = this.paint;
            AffineTransform affineTransform3 = this.transform;
            this.setPaint(color);
            this.setTransform(affineTransform2);
            this.fillRect(0, 0, n, n2);
            this.setTransform(affineTransform3);
            this.setPaint((Paint)object);
        }
        object = ((BufferedImage)object2).getRGB(0, 0, n, n2, null, 0, n);
        this.drawPixels(this.nativePointer, (int[])object, n, n2, n, dArray, d);
        this.updateColor();
        return true;
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.drawRaster(renderedImage.getColorModel(), renderedImage.getData(), affineTransform, null);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createRendering(new RenderContext(affineTransform)), affineTransform);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.drawImage(image, affineTransform, null, imageObserver);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImageOp != null) {
            bufferedImage2 = bufferedImageOp.filter(bufferedImage, null);
        }
        this.drawImage((Image)bufferedImage2, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2), null, null);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2), null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        double d = (double)n3 / (double)image.getWidth(imageObserver);
        double d2 = (double)n4 / (double)image.getHeight(imageObserver);
        if (d == 0.0 || d2 == 0.0) {
            return true;
        }
        return this.drawImage(image, new AffineTransform(d, 0.0, 0.0, d2, (double)n, (double)n2), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9;
        int n10;
        int n11;
        int n12;
        if (image == null) {
            return false;
        }
        int n13 = n7 - n5;
        int n14 = n8 - n6;
        int n15 = n3 - n;
        int n16 = n4 - n2;
        if (n15 == 0 || n16 == 0 || n13 == 0 || n14 == 0) {
            return true;
        }
        double d = (double)n15 / (double)n13;
        double d2 = (double)n16 / (double)n14;
        Shape shape = this.getClip();
        if (n < n3) {
            n12 = n;
            n11 = n3 - n;
        } else {
            n12 = n3;
            n11 = n - n3;
        }
        if (n2 < n4) {
            n10 = n2;
            n9 = n4 - n2;
        } else {
            n10 = n4;
            n9 = n2 - n4;
        }
        this.clipRect(n12, n10, n11, n9);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate((double)n - (double)n5 * d, (double)n2 - (double)n6 * d2);
        affineTransform.scale(d, d2);
        boolean bl = this.drawImage(image, affineTransform, color, imageObserver);
        this.setClip(shape);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public void drawString(String string, float f, float f2) {
        if (string == null || string.length() == 0) {
            return;
        }
        new TextLayout(string, this.getFont(), this.getFontRenderContext()).draw(this, f, f2);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        double d = 1.0;
        if (glyphVector.getNumGlyphs() <= 0) {
            return;
        }
        if (this.comp instanceof AlphaComposite) {
            d = ((AlphaComposite)this.comp).getAlpha();
        }
        if (glyphVector instanceof FreetypeGlyphVector && d == 1.0) {
            int n = glyphVector.getNumGlyphs();
            int[] nArray = glyphVector.getGlyphCodes(0, n, null);
            float[] fArray = glyphVector.getGlyphPositions(0, n, null);
            this.setFont(glyphVector.getFont());
            Font font = this.font;
            synchronized (font) {
                try {
                    this.cairoDrawGlyphVector(this.nativePointer, (GdkFontPeer)this.getFont().getPeer(), f, f2, n, nArray, fArray);
                }
                finally {
                    Object var10_9 = null;
                }
            }
        } else {
            this.translate(f, f2);
            this.fill(glyphVector.getOutline());
            this.translate(-f, -f2);
        }
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        GlyphVector glyphVector = this.getFont().createGlyphVector(this.getFontRenderContext(), attributedCharacterIterator);
        this.drawGlyphVector(glyphVector, f, f2);
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, true, true);
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.font = font.getPeer() instanceof GdkFontPeer ? font : ((ClasspathToolkit)Toolkit.getDefaultToolkit()).getFont(font.getName(), font.getAttributes());
    }

    public Font getFont() {
        if (this.font == null) {
            return new Font("SansSerif", 0, 12);
        }
        return this.font;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            Shape shape2 = this.stroke.createStrokedShape(shape);
            return shape2.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return shape.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont().toString() + ",color=" + this.fg.toString() + "]";
    }

    private boolean drawRaster(ColorModel colorModel, Raster raster, AffineTransform affineTransform, Color color) {
        int n;
        if (raster == null) {
            return false;
        }
        SampleModel sampleModel = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (dataBuffer == null || sampleModel == null) {
            return false;
        }
        if (colorModel == null) {
            colorModel = ColorModel.getRGBdefault();
        }
        double[] dArray = new double[6];
        if (affineTransform != null) {
            affineTransform.getMatrix(dArray);
        } else {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
            dArray[3] = 1.0;
            dArray[4] = 0.0;
            dArray[5] = 0.0;
        }
        int[] nArray = CairoGraphics2D.findSimpleIntegerArray(colorModel, raster);
        if (nArray == null) {
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                nArray = raster.getPixels(0, 0, raster.getWidth(), raster.getHeight(), nArray);
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = colorModel.getRGB(nArray[n]);
                }
            } else {
                nArray = new int[raster.getWidth() * raster.getHeight()];
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = colorModel.getRGB(dataBuffer.getElem(n));
                }
            }
        }
        if (colorModel.hasAlpha()) {
            if (color != null && colorModel.hasAlpha()) {
                for (n = 0; n < nArray.length; ++n) {
                    if (colorModel.getAlpha(nArray[n]) != 0) continue;
                    nArray[n] = color.getRGB();
                }
            }
        } else {
            n = 0;
            while (n < nArray.length) {
                int n2 = n++;
                nArray[n2] = nArray[n2] | 0xFF000000;
            }
        }
        double d = 1.0;
        if (this.comp instanceof AlphaComposite) {
            d = ((AlphaComposite)this.comp).getAlpha();
        }
        this.drawPixels(this.nativePointer, nArray, raster.getWidth(), raster.getHeight(), raster.getWidth(), dArray, d);
        this.updateColor();
        return true;
    }

    private double shifted(double d, boolean bl) {
        if (bl) {
            return Math.floor(d) + 0.5;
        }
        return d;
    }

    private void walkPath(PathIterator pathIterator, boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[6];
        this.cairoSetFillRule(this.nativePointer, pathIterator.getWindingRule());
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    d = this.shifted(dArray[0], bl);
                    d2 = this.shifted(dArray[1], bl);
                    this.cairoMoveTo(this.nativePointer, d, d2);
                    break;
                }
                case 1: {
                    d = this.shifted(dArray[0], bl);
                    d2 = this.shifted(dArray[1], bl);
                    this.cairoLineTo(this.nativePointer, d, d2);
                    break;
                }
                case 2: {
                    double d3 = d + 0.6666666666666666 * (this.shifted(dArray[0], bl) - d);
                    double d4 = d2 + 0.6666666666666666 * (this.shifted(dArray[1], bl) - d2);
                    double d5 = d3 + 0.3333333333333333 * (this.shifted(dArray[2], bl) - d);
                    double d6 = d4 + 0.3333333333333333 * (this.shifted(dArray[3], bl) - d2);
                    d = this.shifted(dArray[2], bl);
                    d2 = this.shifted(dArray[3], bl);
                    this.cairoCurveTo(this.nativePointer, d3, d4, d5, d6, d, d2);
                    break;
                }
                case 3: {
                    d = this.shifted(dArray[4], bl);
                    d2 = this.shifted(dArray[5], bl);
                    this.cairoCurveTo(this.nativePointer, this.shifted(dArray[0], bl), this.shifted(dArray[1], bl), this.shifted(dArray[2], bl), this.shifted(dArray[3], bl), d, d2);
                    break;
                }
                case 4: {
                    this.cairoClosePath(this.nativePointer);
                }
            }
            pathIterator.next();
        }
    }

    private Map getDefaultHints() {
        HashMap hashMap = new HashMap();
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, "Default antialiasing text mode");
        hashMap.put(RenderingHints.KEY_STROKE_CONTROL, "Default stroke normalization");
        hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, "Integer text metrics mode");
        hashMap.put(RenderingHints.KEY_ANTIALIASING, "Nonantialiased rendering mode");
        hashMap.put(RenderingHints.KEY_RENDERING, "Default rendering methods");
        return hashMap;
    }

    public static int[] findSimpleIntegerArray(ColorModel colorModel, Raster raster) {
        if (colorModel == null || raster == null) {
            return null;
        }
        if (!colorModel.getColorSpace().isCS_sRGB()) {
            return null;
        }
        if (!(colorModel instanceof DirectColorModel)) {
            return null;
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000 || directColorModel.getGreenMask() != 65280 || directColorModel.getBlueMask() != 255) {
            return null;
        }
        if (!(raster instanceof WritableRaster)) {
            return null;
        }
        if (raster.getSampleModel().getDataType() != 3) {
            return null;
        }
        if (!(raster.getDataBuffer() instanceof DataBufferInt)) {
            return null;
        }
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        if (dataBufferInt.getNumBanks() != 1) {
            return null;
        }
        return dataBufferInt.getData();
    }

    private void updateClip(AffineTransform affineTransform) {
        if (this.clip == null) {
            return;
        }
        if (!(this.clip instanceof GeneralPath)) {
            this.clip = new GeneralPath(this.clip);
        }
        GeneralPath generalPath = (GeneralPath)this.clip;
        generalPath.transform(affineTransform);
    }

    private static Rectangle computeIntersection(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int n10 = n > n6 ? n : n6;
        int n11 = n2 > n7 ? n2 : n7;
        int n12 = n + n3 < n6 + n8 ? n + n3 - n10 : n6 + n8 - n10;
        int n13 = n5 = n2 + n4 < n7 + n9 ? n2 + n4 - n11 : n7 + n9 - n11;
        if (n12 >= 0 && n5 >= 0) {
            rectangle.setBounds(n10, n11, n12, n5);
        } else {
            rectangle.setBounds(0, 0, 0, 0);
        }
        return rectangle;
    }

    static {
        System.loadLibrary("gtkpeer");
        draw3DRectStroke = new BasicStroke();
        rgb32 = new DirectColorModel(32, 0xFF0000, 65280, 255);
        argb32 = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    }
}

