/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.tools.getopt.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class KeyPasswdCmd
extends Command {
    private static final Logger log = Logger.getLogger(KeyPasswdCmd.class$("gnu.classpath.tools.keytool.KeyPasswdCmd").getName());
    protected String _alias;
    protected String _password;
    protected String _newPassword;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private char[] newPasswordChars;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void setAlias(String string) {
        this._alias = string;
    }

    public void setKeypass(String string) {
        this._password = string;
    }

    public void setNew(String string) {
        this._newPassword = string;
    }

    public void setStoretype(String string) {
        this._ksType = string;
    }

    public void setKeystore(String string) {
        this._ksURL = string;
    }

    public void setStorepass(String string) {
        this._ksPassword = string;
    }

    public void setProvider(String string) {
        this._providerClassName = string;
    }

    void setup() throws Exception {
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordNoPrompt(this._password);
        if (Configuration.DEBUG) {
            log.fine("-keypasswd handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -new=" + this._newPassword);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws KeyStoreException, NoSuchAlgorithmException, IOException, UnsupportedCallbackException, UnrecoverableKeyException, CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        Key key = this.getAliasPrivateKey();
        Certificate[] certificateArray = this.store.getCertificateChain(this.alias);
        this.setNewKeyPassword(this._newPassword);
        this.store.setKeyEntry(this.alias, key, this.newPasswordChars, certificateArray);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser classpathToolParser = new ClasspathToolParser("keypasswd", true);
        classpathToolParser.setHeader(Messages.getString("KeyPasswdCmd.23"));
        classpathToolParser.setFooter(Messages.getString("KeyPasswdCmd.22"));
        OptionGroup optionGroup = new OptionGroup(Messages.getString("KeyPasswdCmd.21"));
        optionGroup.add(new Option(this, "alias", Messages.getString("KeyPasswdCmd.20"), Messages.getString("KeyPasswdCmd.19")){
            private /* synthetic */ KeyPasswdCmd this$0;
            {
                this.this$0 = keyPasswdCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._alias = string;
            }
        });
        optionGroup.add(new Option(this, "keypass", Messages.getString("KeyPasswdCmd.18"), Messages.getString("KeyPasswdCmd.9")){
            private /* synthetic */ KeyPasswdCmd this$0;
            {
                this.this$0 = keyPasswdCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._password = string;
            }
        });
        optionGroup.add(new Option(this, "new", Messages.getString("KeyPasswdCmd.16"), Messages.getString("KeyPasswdCmd.9")){
            private /* synthetic */ KeyPasswdCmd this$0;
            {
                this.this$0 = keyPasswdCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._newPassword = string;
            }
        });
        optionGroup.add(new Option(this, "storetype", Messages.getString("KeyPasswdCmd.14"), Messages.getString("KeyPasswdCmd.13")){
            private /* synthetic */ KeyPasswdCmd this$0;
            {
                this.this$0 = keyPasswdCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksType = string;
            }
        });
        optionGroup.add(new Option(this, "keystore", Messages.getString("KeyPasswdCmd.12"), Messages.getString("KeyPasswdCmd.11")){
            private /* synthetic */ KeyPasswdCmd this$0;
            {
                this.this$0 = keyPasswdCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksURL = string;
            }
        });
        optionGroup.add(new Option(this, "storepass", Messages.getString("KeyPasswdCmd.10"), Messages.getString("KeyPasswdCmd.9")){
            private /* synthetic */ KeyPasswdCmd this$0;
            {
                this.this$0 = keyPasswdCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._ksPassword = string;
            }
        });
        optionGroup.add(new Option(this, "provider", Messages.getString("KeyPasswdCmd.8"), Messages.getString("KeyPasswdCmd.7")){
            private /* synthetic */ KeyPasswdCmd this$0;
            {
                this.this$0 = keyPasswdCmd;
                super(string, string2, string3);
            }

            public void parsed(String string) throws OptionException {
                this.this$0._providerClassName = string;
            }
        });
        optionGroup.add(new Option(this, "v", Messages.getString("KeyPasswdCmd.6")){
            private /* synthetic */ KeyPasswdCmd this$0;
            {
                this.this$0 = keyPasswdCmd;
                super(string, string2);
            }

            public void parsed(String string) throws OptionException {
                this.this$0.verbose = true;
            }
        });
        classpathToolParser.add(optionGroup);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", classpathToolParser);
        }
        return classpathToolParser;
    }

    private void setNewKeyPassword(String string) throws IOException, UnsupportedCallbackException {
        if (string != null) {
            this.newPasswordChars = string.toCharArray();
        } else {
            boolean bl = false;
            Callback[] callbackArray = new Callback[1];
            Callback[] callbackArray2 = new Callback[1];
            for (int i = 0; i < 3; ++i) {
                if (!this.prompt4NewPassword(this.getCallbackHandler(), callbackArray, callbackArray2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new SecurityException(Messages.getString("StorePasswdCmd.19"));
            }
        }
    }

    private boolean prompt4NewPassword(CallbackHandler callbackHandler, Callback[] callbackArray, Callback[] callbackArray2) throws IOException, UnsupportedCallbackException {
        String string = Messages.getFormattedString("KeyPasswdCmd.24", this.alias);
        PasswordCallback passwordCallback = new PasswordCallback(string, false);
        callbackArray[0] = passwordCallback;
        callbackHandler.handle(callbackArray);
        char[] cArray = passwordCallback.getPassword();
        passwordCallback.clearPassword();
        String string2 = SystemProperties.getProperty((String)"line.separator");
        if (cArray == null || cArray.length < 6) {
            String string3 = Messages.getString("StorePasswdCmd.21") + string2;
            callbackArray2[0] = new TextOutputCallback(2, string3);
            callbackHandler.handle(callbackArray2);
            return false;
        }
        if (Arrays.equals(this.keyPasswordChars, cArray)) {
            String string4 = Messages.getString("StorePasswdCmd.22") + string2;
            callbackArray2[0] = new TextOutputCallback(2, string4);
            callbackHandler.handle(callbackArray2);
            return false;
        }
        string = Messages.getFormattedString("KeyPasswdCmd.28", this.alias);
        passwordCallback = new PasswordCallback(string, false);
        callbackArray[0] = passwordCallback;
        callbackHandler.handle(callbackArray);
        char[] cArray2 = passwordCallback.getPassword();
        passwordCallback.clearPassword();
        if (!Arrays.equals(cArray, cArray2)) {
            String string5 = Messages.getString("StorePasswdCmd.24") + string2;
            callbackArray2[0] = new TextOutputCallback(2, string5);
            callbackHandler.handle(callbackArray2);
            return false;
        }
        this.newPasswordChars = cArray2;
        return true;
    }

    KeyPasswdCmd() {
    }
}

