<?php
// (c) Copyright 2002-2009 by authors of the Tiki Wiki/CMS/Groupware Project
// 
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
// $Id: /cvsroot/tikiwiki/tiki/tiki-admin_categories.php,v 1.51.2.3 2008-03-19 17:01:02 luciash Exp $
require_once ('tiki-setup.php');
include_once ('lib/categories/categlib.php');
include_once ('lib/filegals/filegallib.php');
include_once ('lib/polls/polllib.php');
include_once ('lib/tree/categ_admin_tree.php');
include_once ('lib/directory/dirlib.php');
include_once ('lib/trackers/trackerlib.php');
include_once ('lib/commentslib.php');
if (!isset($polllib)) {
	$polllib = new PollLib;
}
if (!isset($commentslib)) {
	$commentslib = new Comments($dbTiki);
}
if ($prefs['feature_categories'] != 'y') {
	$smarty->assign('msg', tra("This feature is disabled") . ": feature_categories");
	$smarty->display("error.tpl");
	die;
}
if ($tiki_p_admin_categories != 'y') {
	$smarty->assign('errortype', 401);
	$smarty->assign('msg', tra("You do not have permission to use this feature"));
	$smarty->display("error.tpl");
	die;
}
// Check for parent category or set to 0 if not present
if (!isset($_REQUEST["parentId"])) {
	$_REQUEST["parentId"] = 0;
}
$smarty->assign('parentId', $_REQUEST["parentId"]);
if (isset($_REQUEST["addpage"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize a page
	// $categlib->categorize_page($_REQUEST["pageName"],$_REQUEST["parentId"]);
	// add multiple pages at once
	foreach($_REQUEST['pageName'] as $value) {
		$categlib->categorize_page($value, $_REQUEST["parentId"]);
		$category = $categlib->get_category($_REQUEST["parentId"]);
		$categorizedObject = $categlib->get_categorized_object('wiki page', $value);
		// Notify the users watching this category.
		$values = array(
			"categoryId" => $_REQUEST["parentId"],
			"categoryName" => $category['name'],
			"categoryPath" => $categlib->get_category_path_string_with_root($_REQUEST["parentId"]) ,
			"description" => $category['description'],
			"parentId" => $category['parentId'],
			"parentName" => $categlib->get_category_name($category['parentId']) ,
			"action" => "object entered category",
			"objectName" => $categorizedObject['name'],
			"objectType" => $categorizedObject['type'],
			"objectUrl" => $categorizedObject['href']
		);
		$categlib->notify($values);
	}
}
if (isset($_REQUEST["addpoll"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize a poll
	$categlib->categorize_poll($_REQUEST["pollId"], $_REQUEST["parentId"]);
	$categorizedObject = $categlib->get_categorized_object('poll', $_REQUEST["pollId"]);
}
if (isset($_REQUEST["addfaq"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize a faq
	$categlib->categorize_faq($_REQUEST["faqId"], $_REQUEST["parentId"]);
	$categorizedObject = $categlib->get_categorized_object('faq', $_REQUEST["faqId"]);
}
if (isset($_REQUEST["addtracker"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize a tracker
	$categlib->categorize_tracker($_REQUEST["trackerId"], $_REQUEST["parentId"]);
	$categorizedObject = $categlib->get_categorized_object('tracker', $_REQUEST["trackerId"]);
}
if (isset($_REQUEST["addquiz"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize a quiz
	$categlib->categorize_quiz($_REQUEST["quizId"], $_REQUEST["parentId"]);
	$categorizedObject = $categlib->get_categorized_object('quiz', $_REQUEST["quizId"]);
}
if (isset($_REQUEST["addforum"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize a forum
	$categlib->categorize_forum($_REQUEST["forumId"], $_REQUEST["parentId"]);
	$categorizedObject = $categlib->get_categorized_object('forum', $_REQUEST["forumId"]);
}
if (isset($_REQUEST["addgallery"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize an image gallery
	$categlib->categorize_gallery($_REQUEST["galleryId"], $_REQUEST["parentId"]);
	$categorizedObject = $categlib->get_categorized_object('image gallery', $_REQUEST["galleryId"]);
}
if (isset($_REQUEST["addfilegallery"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize a file gallery
	$categlib->categorize_file_gallery($_REQUEST["file_galleryId"], $_REQUEST["parentId"]);
	$categorizedObject = $categlib->get_categorized_object('file gallery', $_REQUEST["file_galleryId"]);
}
if (isset($_REQUEST["addarticle"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize an article
	$categlib->categorize_article($_REQUEST["articleId"], $_REQUEST["parentId"]);
	$categorizedObject = $categlib->get_categorized_object('article', $_REQUEST["articleId"]);
}
if (isset($_REQUEST["addblog"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize a blog
	$categlib->categorize_blog($_REQUEST["blogId"], $_REQUEST["parentId"]);
	$categorizedObject = $categlib->get_categorized_object('blog', $_REQUEST["blogId"]);
}
if (isset($_REQUEST["adddirectory"]) && $_REQUEST["parentId"] != 0) {
	check_ticket('admin-categories');
	// Here we categorize a directory category
	$categlib->categorize_directory($_REQUEST["directoryId"], $_REQUEST["parentId"]);
	$categorizedObject = $categlib->get_categorized_object('directory', $_REQUEST["directoryId"]);
}
if (isset($categorizedObject) && !isset($_REQUEST["addpage"])) {
	$category = $categlib->get_category($_REQUEST["parentId"]);
	// Notify the users watching this category.
	$values = array(
		"categoryId" => $_REQUEST["parentId"],
		"categoryName" => $category['name'],
		"categoryPath" => $categlib->get_category_path_string_with_root($_REQUEST["parentId"]) ,
		"description" => $category['description'],
		"parentId" => $category['parentId'],
		"parentName" => $categlib->get_category_name($category['parentId']) ,
		"action" => "object entered category",
		"objectName" => $categorizedObject['name'],
		"objectType" => $categorizedObject['type'],
		"objectUrl" => $categorizedObject['href']
	);
	$categlib->notify($values);
}
if (isset($_REQUEST["categId"])) {
	$info = $categlib->get_category($_REQUEST["categId"]);
} else {
	$_REQUEST["categId"] = 0;
	$info["name"] = '';
	$info["description"] = '';
}
if (isset($_REQUEST["removeObject"])) {
	$area = 'delcategobject';
	if ($prefs['feature_ticketlib2'] != 'y' or (isset($_POST['daconfirm']) and isset($_SESSION["ticket_$area"]))) {
		key_check($area);
		$category = $categlib->get_category($_REQUEST["parentId"]);
		$categorizedObject = $categlib->get_categorized_object_via_category_object_id($_REQUEST["removeObject"]);
		$categlib->remove_object_from_category($_REQUEST["removeObject"], $_REQUEST["parentId"]);
		// Notify the users watching this category.
		$values = array(
			"categoryId" => $_REQUEST["parentId"],
			"categoryName" => $category['name'],
			"categoryPath" => $categlib->get_category_path_string_with_root($_REQUEST["parentId"]) ,
			"description" => $category['description'],
			"parentId" => $category['parentId'],
			"parentName" => $categlib->get_category_name($category['parentId']) ,
			"action" => "object leaved category",
			"objectName" => $categorizedObject['name'],
			"objectType" => $categorizedObject['type'],
			"objectUrl" => $categorizedObject['href']
		);
		$categlib->notify($values);
	} else {
		key_get($area);
	}
}
if (isset($_REQUEST["removeCat"]) && ($info = $categlib->get_category($_REQUEST['removeCat']))) {
	$area = "delcateg";
	if ($prefs['feature_ticketlib2'] != 'y' or (isset($_POST['daconfirm']) and isset($_SESSION["ticket_$area"]))) {
		key_check($area);
		$categlib->remove_category($_REQUEST["removeCat"]);
	} else {
		$confirmation = tra('Click here to delete the category:') . ' ' . $info['name'];
		key_get($area, $confirmation);
	}
}
if (isset($_REQUEST["save"]) && isset($_REQUEST["name"]) && strlen($_REQUEST["name"]) > 0) {
	check_ticket('admin-categories');
	// Save
	if ($_REQUEST["categId"]) {
		if ($_REQUEST['parentId'] == $_REQUEST['categId']) {
			$smarty->assign('msg', tra("Category can`t be parent of itself"));
			$smarty->display("error.tpl");
			die;
		}
		$categlib->update_category($_REQUEST["categId"], $_REQUEST["name"], $_REQUEST["description"], $_REQUEST["parentId"]);
	} else if ($categlib->exist_child_category($_REQUEST['parentId'], $_REQUEST['name'])) {
		$errors[] = tra('You can not create a category with a name already existing at this level');
	} else {
		$newcategId = $categlib->add_category($_REQUEST["parentId"], $_REQUEST["name"], $_REQUEST["description"]);
	}
	$info["name"] = '';
	$info["description"] = '';
	$_REQUEST["categId"] = 0;
}
if (isset($_REQUEST['import']) && isset($_FILES['csvlist']['tmp_name'])) {
	check_ticket('admin-categories');
	$fhandle = fopen($_FILES['csvlist']['tmp_name'], 'r');
	if (!$fhandle) {
		$smarty->assign('msg', tra("The file is not a CSV file or has not a correct syntax"));
		$smarty->display("error.tpl");
		die;
	}
	$fields = fgetcsv($fhandle, 1000);
	if (!$fields[0]) {
		$smarty->assign('msg', tra('The file is not a CSV file or has not a correct syntax'));
		$smarty->display('error.tpl');
		die;
	}
	if ($fields[0] != 'category' || $fields[1] != 'description' || $fields[2] != 'parent') {
		$smarty->assign('msg', tra('The file does not have the required header:') . ' category, description, parent');
		$smarty->display('error.tpl');
		die;
	}
	while (!feof($fhandle)) {
		$data = fgetcsv($fhandle, 1000);
		if (!empty($data)) {
			$temp_max = count($fields);
			if ($temp_max > 1 && strtolower($data[2]) != 'top' && !empty($data[2])) {
				$parentId = $categlib->get_category_id($data[2]);
				if (empty($parentId)) {
					$smarty->assign('msg', tra('Incorrect param') . ' ' . $data[2]);
					$smarty->display('error.tpl');
					die;
				}
			} else {
				$parentId = 0;
			}
			if (!$categlib->exist_child_category($parentId, $data[0])) {
				$newcategId = $categlib->add_category($parentId, $data[0], $data[1]);
				if (empty($newcategId)) {
					$smarty->assign('msg', tra('Incorrect param') . ' ' . $data[0]);
					$smarty->display('error.tpl');
					die;
				}
			}
		}
	}
}
$smarty->assign('categId', $_REQUEST["categId"]);
$smarty->assign('name', $info["name"]);
$smarty->assign('description', $info["description"]);
// If the parent category is not zero get the category path
if ($_REQUEST["parentId"]) {
	$path = $categlib->get_category_path($_REQUEST["parentId"]);
	$p_info = $categlib->get_category($_REQUEST["parentId"]);
	$father = $p_info["parentId"];
	$categ_name = $p_info['name'];
} else {
	$path = "";
	$father = 0;
	$categ_name = tra('Top');
}
$smarty->assign('path', $path);
$smarty->assign('father', $father);
$smarty->assign('categ_name', $categ_name);
// ---------------------------------------------------
function array_csort($marray, $column) {
	if (is_array($marray)) {
		$sortarr = array();
		foreach($marray as $key => $row) {
			$sortarr[$key] = $row[$column];
		}
		array_multisort($sortarr, $marray);
		return $marray;
	} else {
		return array();
	}
}
$catree = $categlib->list_all_categories(0, -1, 'name_asc', '', '', 0);
//$catree = array_csort($catree['data'],'categpath'); not needed as array is already sorted when returned from categlib
if (is_array($path)) {
	foreach($catree['data'] as $key => $c) {
		foreach($path as $p) {
			if ($p['categId'] == $c['categId']) {
				$catree['data'][$key]['incat'] = 'y';
				break;
			}
		}
	}
}
$smarty->assign('catree', $catree['data']);
// ---------------------------------------------------
if (!isset($_REQUEST["sort_mode"])) {
	$sort_mode = 'name_asc';
} else {
	$sort_mode = $_REQUEST["sort_mode"];
}
if (!isset($_REQUEST["offset"])) {
	$offset = 0;
} else {
	$offset = $_REQUEST["offset"];
}
$smarty->assign_by_ref('offset', $offset);
if (isset($_REQUEST["find"])) {
	$find = $_REQUEST["find"];
} else {
	$find = '';
}
$smarty->assign('find', $find);
if (isset($_REQUEST["find_objects"])) {
	$find_objects = $_REQUEST["find_objects"];
} else {
	$find_objects = '';
}
$smarty->assign('find_objects', $find_objects);
$smarty->assign_by_ref('sort_mode', $sort_mode);
$smarty->assign_by_ref('find', $find);
$objects = $categlib->list_category_objects($_REQUEST["parentId"], $offset, $maxRecords, $sort_mode, '', $find, false);
$smarty->assign_by_ref('objects', $objects["data"]);
$smarty->assign_by_ref('cant_pages', $objects["cant"]);
$galleries = $tikilib->list_galleries(0, -1, 'name_desc', 'admin', $find_objects);
$smarty->assign_by_ref('galleries', $galleries["data"]);
$file_galleries = $filegallib->list_file_galleries(0, -1, 'name_desc', 'admin', $find_objects, $prefs['fgal_root_id']);
$smarty->assign_by_ref('file_galleries', $file_galleries["data"]);
$forums = $commentslib->list_forums(0, -1, 'name_asc', $find_objects);
$smarty->assign_by_ref('forums', $forums["data"]);
$polls = $polllib->list_polls(0, -1, 'title_asc', $find_objects);
$smarty->assign_by_ref('polls', $polls["data"]);
$blogs = $tikilib->list_blogs(0, -1, 'title_asc', $find_objects);
$smarty->assign_by_ref('blogs', $blogs["data"]);
$pages = $tikilib->list_pageNames(0, -1, 'pageName_asc', $find_objects);
$smarty->assign_by_ref('pages', $pages["data"]);
$faqs = $tikilib->list_faqs(0, -1, 'title_asc', $find_objects);
$smarty->assign_by_ref('faqs', $faqs["data"]);
$quizzes = $tikilib->list_quizzes(0, -1, 'name_asc', $find_objects);
$smarty->assign_by_ref('quizzes', $quizzes["data"]);
$trackers = $trklib->list_trackers(0, -1, 'name_asc', $find_objects);
$smarty->assign_by_ref('trackers', $trackers["data"]);
$articles = $tikilib->list_articles(0, -1, 'title_asc', $find_objects, '', '', $user, '', '', 'n');
$smarty->assign_by_ref('articles', $articles["data"]);
$directories = $dirlib->dir_list_all_categories(0, -1, 'name_asc', $find_objects);
$smarty->assign_by_ref('directories', $directories["data"]);
ask_ticket('admin-categories');
if (!empty($errors)) $smarty->assign_by_ref('errors', $errors);
// disallow robots to index page:
$smarty->assign('metatag_robots', 'NOINDEX, NOFOLLOW');
// Display the template
$smarty->assign('mid', 'tiki-admin_categories.tpl');
$smarty->display("tiki.tpl");
