/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.color.RotatedTexturePaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.PdfPatternObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.Matrix;

public class PatternColorSpace
extends GenericColorSpace {
    private boolean isRotated = false;
    PdfObjectReader currentPdfFile = null;
    private BufferedImage img;
    private int XStep;
    private int YStep;
    private boolean isPrinting = false;
    private static final boolean debug = false;
    private boolean colorsReversed;
    static int count = 0;

    public PatternColorSpace(boolean bl, PdfObjectReader pdfObjectReader) {
        this.value = 1146450818;
        this.isPrinting = bl;
        this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
        this.currentPdfFile = pdfObjectReader;
    }

    public void setColor(String[] stringArray, int n) {
        PdfPatternObject pdfPatternObject = (PdfPatternObject)this.patterns.get(stringArray[0]);
        byte[] byArray = this.currentPdfFile.readStream(pdfPatternObject, true, true, true, false, false);
        int n2 = pdfPatternObject.getInt(1755231159);
        Object object = null;
        float[] fArray = pdfPatternObject.getFloatArray(1145198201);
        if (fArray != null) {
            if (n2 == 1) {
                float[][] fArrayArray = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {0.0f, 0.0f, 1.0f}};
                object = fArrayArray;
            } else {
                float[][] fArrayArray = new float[][]{{fArray[0], fArray[1], 0.0f}, {fArray[2], fArray[3], 0.0f}, {fArray[4], fArray[5], 1.0f}};
                this.colorsReversed = fArrayArray[2][0] < 0.0f;
                object = Matrix.multiply(fArrayArray, this.CTM);
            }
        }
        if (n2 == 1) {
            this.currentColor = this.setupTiling(pdfPatternObject, (float[][])object, byArray);
        } else if (n2 == 2 && PdfStreamDecoder.useShading) {
            this.currentColor = this.setupShading(pdfPatternObject, (float[][])object);
        } else if (PdfStreamDecoder.useShading) {
            // empty if block
        }
    }

    private PdfPaint setupTiling(PdfObject pdfObject, float[][] fArray, byte[] byArray) {
        int n;
        boolean bl = false;
        if (fArray != null) {
            this.isRotated = fArray[1][0] != 0.0f && fArray[0][1] != 0.0f && fArray[0][0] != 0.0f && fArray[1][1] != 0.0f;
            bl = fArray[1][1] < 0.0f | fArray[0][1] < 0.0f;
            if (bl && fArray[0][1] > 0.0f && fArray[1][0] > 0.0f) {
                bl = false;
            }
        }
        int n2 = pdfObject.getInt(1434615449);
        this.XStep = (int)pdfObject.getFloatNumber(591672680);
        this.YStep = (int)pdfObject.getFloatNumber(591672681);
        if (fArray != null) {
            if (fArray[1][1] < 0.0f) {
                fArray[2][1] = this.YStep;
            }
            if ((double)fArray[1][0] != 0.0) {
                fArray[2][1] = -fArray[1][0];
            }
        }
        PdfObject pdfObject2 = pdfObject.getDictionary(2004251818);
        float f = 0.0f;
        float f2 = 0.0f;
        PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder();
        pdfStreamDecoder.setStreamType(1);
        ObjectStore objectStore = new ObjectStore();
        pdfStreamDecoder.setStore(objectStore);
        DynamicVectorRenderer dynamicVectorRenderer = new DynamicVectorRenderer(0, false, 20, objectStore);
        dynamicVectorRenderer.setOptimisedRotation(false);
        try {
            pdfStreamDecoder.init(false, true, 7, 0, new PdfPageData(), 0, dynamicVectorRenderer, this.currentPdfFile);
            if (pdfObject2 != null) {
                pdfStreamDecoder.readResources(pdfObject2, true);
            }
            pdfStreamDecoder.setDefaultColors(this.gs.getStrokeColor(), this.gs.getNonstrokeColor());
            GraphicsState graphicsState = new GraphicsState(0, 0);
            if (fArray != null) {
                graphicsState.CTM = fArray;
            }
            pdfStreamDecoder.decodePageContent(null, 0, 0, graphicsState, byArray);
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        pdfStreamDecoder = null;
        if (this.XStep < 0) {
            this.XStep = -this.XStep;
        }
        if (this.YStep < 0) {
            this.YStep = -this.YStep;
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl2 = false;
        if (fArray != null) {
            f3 = fArray[0][0];
            if (f3 == 0.0f) {
                f3 = fArray[0][1];
            }
            if (f3 < 0.0f) {
                f3 = -f3;
            }
            if ((f4 = fArray[1][1]) == 0.0f) {
                f4 = fArray[1][0];
            }
            if (f4 < 0.0f) {
                f4 = -f4;
            }
        }
        AffineTransform affineTransform = null;
        if (fArray != null) {
            f = fArray[0][0];
            if (f == 0.0f) {
                f = fArray[0][1];
            }
            if (f < 0.0f) {
                f = -f;
            }
            if ((f2 = fArray[1][1]) == 0.0f) {
                f2 = fArray[1][0];
            }
            if (f2 < 0.0f) {
                f2 = -f2;
            }
            f *= (float)this.XStep;
            f2 *= (float)this.YStep;
            n = this.XStep;
            int n3 = this.YStep;
            if (bl) {
                int n4 = (int)((float)this.XStep / f);
                int n5 = (int)((float)this.YStep / f2);
                if (n4 > 0 && n5 > 0) {
                    n = (int)((float)(n4 + 1) * f);
                    n3 = (int)((float)(n5 + 1) * f2);
                    this.XStep = n;
                    this.YStep = n3;
                }
            }
            if (bl2) {
                this.img = new BufferedImage((int)(f3 + 0.5f), (int)(f4 + 0.5f), 2);
                affineTransform = AffineTransform.getScaleInstance((float)this.XStep / f3, (float)this.YStep / f4);
            } else {
                this.img = new BufferedImage(n, n3, 2);
            }
            Graphics2D graphics2D = this.img.createGraphics();
            AffineTransform affineTransform2 = graphics2D.getTransform();
            graphics2D.setClip(new Rectangle(0, 0, this.img.getWidth(), this.img.getHeight()));
            int n6 = 0;
            Rectangle rectangle = dynamicVectorRenderer.getOccupiedArea().getBounds();
            int n7 = rectangle.x;
            if (n7 < 0) {
                n6 = (int)((float)(-n7) * fArray[0][0]);
            }
            if (!this.isRotated) {
                for (float f5 = 0.0f; f5 < (float)this.YStep; f5 += f2) {
                    for (float f6 = (float)n6; f6 < (float)this.XStep; f6 += f) {
                        if (bl) {
                            graphics2D.translate(f6, -f5);
                        } else {
                            graphics2D.translate(f6, f5);
                        }
                        dynamicVectorRenderer.paint(graphics2D, null, affineTransform, null, false, false);
                        graphics2D.setTransform(affineTransform2);
                    }
                }
            }
        } else {
            n = this.XStep;
            int n8 = this.YStep;
            if (bl2) {
                this.img = new BufferedImage((int)(f3 + 0.5f), (int)(f4 + 0.5f), 2);
                affineTransform = AffineTransform.getScaleInstance((float)this.XStep / f3, (float)this.YStep / f4);
            } else {
                this.img = new BufferedImage(n, n8, 2);
            }
            Graphics2D graphics2D = this.img.createGraphics();
            dynamicVectorRenderer.paint(graphics2D, null, null, null, false, false);
            if (bl && this.img.getHeight() > 1) {
                AffineTransform affineTransform3 = new AffineTransform();
                affineTransform3.translate(0.0, this.img.getHeight());
                affineTransform3.scale(1.0, -1.0);
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform3, ColorSpaces.hints);
                this.img = affineTransformOp.filter(this.img, null);
            }
        }
        objectStore.flush();
        if (this.img != null) {
            PdfPaint pdfPaint = new PdfTexturePaint(this.img, new Rectangle(0, 0, this.img.getWidth(), this.img.getHeight()));
            if (this.isRotated) {
                pdfPaint = new RotatedTexturePaint(dynamicVectorRenderer, fArray, this.XStep, this.YStep, f, f2, affineTransform);
            }
            return pdfPaint;
        }
        return null;
    }

    private PdfPaint setupShading(PdfObject pdfObject, float[][] fArray) {
        PdfObject pdfObject2 = pdfObject.getDictionary(878474856);
        PdfObject pdfObject3 = pdfObject2.getDictionary(2087749783);
        GenericColorSpace genericColorSpace = ColorspaceFactory.getColorSpaceInstance(false, this.currentPdfFile, pdfObject3);
        if (pdfObject2 == null) {
            return null;
        }
        return ShadingFactory.createShading(pdfObject2, this.isPrinting, this.pageHeight, genericColorSpace, this.currentPdfFile, fArray, this.pageHeight, this.colorsReversed);
    }
}

