/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.PdfDecoder;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class GenericColorSpace
implements Cloneable,
Serializable {
    protected String intent = null;
    protected float[] rawValues;
    protected Map patterns;
    float[][] CTM;
    protected int size = 0;
    protected float c = -1.0f;
    protected float y = -1.0f;
    protected float m = -1.0f;
    protected float k = -1.0f;
    protected float[] W;
    protected float[] G;
    protected float[] Ma;
    protected float[] B;
    protected float[] R;
    protected static ColorSpace rgbCS;
    public static final String cb = "<color ";
    public static final String ce = "</color>";
    protected int value = 1785221209;
    private static ColorConvertOp CSToRGB;
    protected ColorSpace cs;
    protected PdfPaint currentColor = new PdfColor(0, 0, 0);
    protected static ColorModel rgbModel;
    private static ICC_Profile ICCProfile;
    protected boolean failed = false;
    protected int alternative = -1;
    protected byte[] IndexedColorMap = null;
    public String pantoneName = null;
    protected int componentCount = 3;
    protected GraphicsState gs;
    protected int pageHeight;

    private static void initCMYKColorspace() throws PdfException {
        try {
            Object object;
            if (ICCProfile == null) {
                rgbModel = new ComponentColorModel(rgbCS, new int[]{8, 8, 8}, false, false, 1, 0);
            } else {
                int n = rgbCS.getNumComponents();
                object = new int[n];
                for (int i = 0; i < n; ++i) {
                    object[i] = 8;
                }
                rgbModel = new ComponentColorModel(rgbCS, (int[])object, false, false, 1, 0);
            }
            ICC_Profile iCC_Profile = ICC_Profile.getInstance(GenericColorSpace.class.getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm"));
            object = new ICC_ColorSpace(iCC_Profile);
            CSToRGB = new ColorConvertOp((ColorSpace)object, rgbCS, ColorSpaces.hints);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception.getMessage() + " initialising color components");
            throw new PdfException("[PDF] Unable to create CMYK colorspace. Check cmyk.icm in jar file");
        }
    }

    public boolean isInvalid() {
        return this.failed;
    }

    public int getIndexSize() {
        return this.size;
    }

    public PdfPaint getColor() {
        return this.currentColor;
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    public GenericColorSpace() {
        this.cs = rgbCS;
    }

    protected void setAlternateColorSpace(int n) {
        this.alternative = n;
    }

    public final Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return object;
    }

    protected final BufferedImage nonRGBJPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) {
        ImageInputStream imageInputStream;
        ImageReader imageReader;
        ByteArrayInputStream byteArrayInputStream;
        BufferedImage bufferedImage;
        block27: {
            boolean bl = false;
            bufferedImage = null;
            byteArrayInputStream = null;
            imageReader = null;
            imageInputStream = null;
            try {
                Object object;
                block26: {
                    Object object2;
                    if (CSToRGB == null) {
                        GenericColorSpace.initCMYKColorspace();
                    }
                    CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    int n5 = this.getJPEGTransform(byArray);
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
                    while (iterator.hasNext() && !(imageReader = (object2 = iterator.next())).canReadRaster()) {
                    }
                    ImageIO.setUseCache(false);
                    imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                    imageReader.setInput(imageInputStream, true);
                    object2 = imageReader.readRaster(0, null);
                    if (fArray != null) {
                        if (fArray.length == 6 && fArray[0] == 1.0f && fArray[1] == 0.0f && fArray[2] == 1.0f && fArray[3] == 0.0f && fArray[4] == 1.0f && fArray[5] == 0.0f || fArray.length > 2 && fArray[0] == 1.0f && fArray[1] == 0.0f) {
                            object = ((Raster)object2).getDataBuffer();
                            int n6 = ((DataBuffer)object).getSize();
                            for (int i = 0; i < n6; ++i) {
                                ((DataBuffer)object).setElem(i, 255 - ((DataBuffer)object).getElem(i));
                            }
                        } else if (fArray.length == 6 && fArray[0] == 0.0f && fArray[1] == 1.0f && fArray[2] == 0.0f && fArray[3] == 1.0f && fArray[4] == 0.0f && fArray[5] == 1.0f || fArray == null || fArray.length > 0) {
                            // empty if block
                        }
                    }
                    if (this.cs.getNumComponents() == 4) {
                        bl = true;
                        try {
                            if (n5 == 2) {
                                object = System.getProperty("org.jpedal.useICC");
                                if (object != null) {
                                    bufferedImage = ColorSpaceConvertor.iccConvertCMYKImageToRGB(((DataBufferByte)((Raster)object2).getDataBuffer()).getData(), n, n2, (String)object);
                                } else {
                                    object2 = this.cleanupRaster((Raster)object2, 0, n3, n4, 4);
                                    n = ((Raster)object2).getWidth();
                                    n2 = ((Raster)object2).getHeight();
                                    bufferedImage = ColorSpaceConvertor.algorithmicConvertCMYKImageToRGB(((Raster)object2).getDataBuffer(), n, n2, false);
                                }
                                break block26;
                            }
                            object2 = this.cleanupRaster((Raster)object2, 0, n3, n4, 4);
                            n = ((Raster)object2).getWidth();
                            n2 = ((Raster)object2).getHeight();
                            object = rgbModel.createCompatibleWritableRaster(n, n2);
                            CSToRGB.filter((Raster)object2, (WritableRaster)object);
                            bufferedImage = new BufferedImage(n, n2, 1);
                            bufferedImage.setData((Raster)object);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (n5 != 0) {
                        bufferedImage = imageReader.read(0);
                        bufferedImage = this.cleanupImage(bufferedImage, n3, n4);
                        bl = true;
                    }
                }
                if (!bl) {
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
                    Raster raster = jPEGImageDecoder.decodeAsRaster();
                    int n7 = jPEGImageDecoder.getJPEGDecodeParam().getEncodedColorID();
                    if (n7 == 4) {
                        raster = this.cleanupRaster(raster, 0, n3, n4, 4);
                        int n8 = raster.getWidth();
                        int n9 = raster.getHeight();
                        object = rgbModel.createCompatibleWritableRaster(n8, n9);
                        CSToRGB.filter(raster, (WritableRaster)object);
                        bufferedImage = new BufferedImage(n8, n9, 1);
                        bufferedImage.setData((Raster)object);
                    } else {
                        LogWriter.writeLog("COLOR_ID_YCbCrA image");
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
                        bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                        bufferedImage = this.cleanupImage(bufferedImage, n3, n4);
                        bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                    }
                }
            }
            catch (Exception exception) {
                bufferedImage = null;
                exception.printStackTrace();
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
            }
            catch (Error error) {
                if (imageReader != null) {
                    imageReader.dispose();
                }
                if (imageInputStream == null) break block27;
                try {
                    imageInputStream.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        try {
            byteArrayInputStream.close();
            imageReader.dispose();
            imageInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Problem closing  " + exception);
        }
        return bufferedImage;
    }

    private BufferedImage cleanupImage(BufferedImage bufferedImage, int n, int n2) {
        return bufferedImage;
    }

    protected Raster cleanupRaster(Raster raster, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        byte[] byArray = null;
        int[] nArray = null;
        if (n == 1) {
            nArray = ((DataBufferInt)raster.getDataBuffer()).getData();
        } else {
            n10 = raster.getNumBands();
            if (n10 == n4) {
                byArray = ((DataBufferByte)raster.getDataBuffer()).getData();
            } else if (n10 == 1) {
                byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                n9 = byArray2.length;
                n8 = n9 * n4;
                n7 = 0;
                n6 = 0;
                byArray = new byte[n8];
                do {
                    for (n5 = 0; n5 < n4; ++n5) {
                        byArray[n7] = byArray2[n6];
                        ++n7;
                    }
                } while (++n6 < n9);
            }
        }
        n10 = raster.getWidth();
        int n11 = raster.getHeight();
        n9 = 1;
        n8 = n10;
        if (n2 > 0 && n3 > 0) {
            int n12;
            n6 = n3 << 2;
            n5 = n2 << 2;
            for (n7 = n11; n8 > n5 && n7 > n6; n8 >>= 1, n7 >>= 1) {
                n9 <<= 1;
            }
            int n13 = n10 / n2;
            if (n13 < 1) {
                n13 = 1;
            }
            if ((n12 = n11 / n3) < 1) {
                n12 = 1;
            }
            if ((n9 = n13) > n12) {
                n9 = n12;
            }
            if (n9 > 1) {
                n8 = n10 / n9;
                n7 = n11 / n9;
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                int n19 = n10;
                try {
                    int n20;
                    byte[] byArray3 = new byte[n8 * n7 * n4];
                    if (n == 0) {
                        n19 = n10 * n4;
                    }
                    for (n15 = 0; n15 < n7; ++n15) {
                        for (n14 = 0; n14 < n8; ++n14) {
                            int n21 = n9;
                            n20 = n9;
                            int n22 = n10 - n14;
                            int n23 = n11 - n15;
                            if (n21 > n22) {
                                n21 = n22;
                            }
                            if (n20 > n23) {
                                n20 = n23;
                            }
                            for (n18 = 0; n18 < n4; ++n18) {
                                int n24 = 0;
                                int n25 = 0;
                                for (n17 = 0; n17 < n20; ++n17) {
                                    for (n16 = 0; n16 < n21; ++n16) {
                                        n24 = n == 0 ? (n24 += byArray[(n17 + n15 * n9) * n19 + (n14 * n9 * n4 + n16 * n4 + n18)] & 0xFF) : (n24 += nArray[(n17 + n15 * n9) * n19 + n14 * n9 + n16] >> 8 * (2 - n18) & 0xFF);
                                        ++n25;
                                    }
                                }
                                if (n25 <= 0) continue;
                                byArray3[n18 + n14 * n4 + n8 * n15 * n4] = (byte)(n24 / n25);
                            }
                        }
                    }
                    int[] nArray2 = new int[n4];
                    for (n20 = 0; n20 < n4; ++n20) {
                        nArray2[n20] = n20;
                    }
                    raster = Raster.createInterleavedRaster(new DataBufferByte(byArray3, byArray3.length), n8, n7, n8 * n4, n4, nArray2, null);
                }
                catch (Exception exception) {
                    if (n == 0) {
                        System.err.println("xx=" + n16 + " yy=" + n17 + " jj=" + n18 + " ptr=" + (n17 + n15 * n9) * n19 + (n14 * n9 + n16 * n4 + n18) + "/" + byArray.length);
                        System.err.println((n17 + n15 * n9) * n19 + " " + (n14 * n9 + n16 * n4 + n18));
                        System.err.println("w=" + n10 + " h=" + n11 + " sampling=" + n9 + " x=" + n14 + " y=" + n15);
                        System.err.println("data size=" + byArray.length + " comp=" + n4);
                    }
                    exception.printStackTrace();
                    System.exit(1);
                }
            }
        }
        return raster;
    }

    protected final int getJPEGTransform(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length - 2;
        block0: while (n2 < n3) {
            int n4 = byArray[n2 + 1] & 0xFF;
            n2 += 2;
            if (n4 == 1 || 208 <= n4 && n4 <= 218) continue;
            if (n4 == 218) {
                n2 = n2 + ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
                while (true) {
                    if (n2 < n3 && ((byArray[n2] & 0xFF) != 255 || byArray[n2 + 1] == 0)) {
                        ++n2;
                        continue;
                    }
                    int n5 = byArray[n2 + 1] & 0xFF;
                    if (208 > n5 || n5 > 215) continue block0;
                    n2 += 2;
                }
            }
            if (n4 == 238 && byArray[n2 + 2] == 65 && byArray[n2 + 3] == 100 && byArray[n2 + 4] == 111 && byArray[n2 + 5] == 98 && byArray[n2 + 6] == 101) {
                n = byArray[n2 + 13] & 0xFF;
                break;
            }
            n2 = n2 + ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
        }
        return n;
    }

    public void setIndex(byte[] byArray, int n) {
        this.IndexedColorMap = byArray;
        this.size = n;
    }

    public void setIndex(String string, String string2, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        this.size = n;
        if (string.startsWith("(\\")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "(\\)");
            while (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.parseInt(stringTokenizer.nextToken(), 8);
                String string3 = Integer.toHexString(n2);
                if (string3.length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string3);
            }
        } else if (!string.startsWith("(")) {
            if (string.startsWith("<")) {
                string = string.substring(1, string.length() - 1).trim();
            }
            stringBuffer = new StringBuffer(string);
        }
        int n3 = 1;
        if (string2.indexOf("RGB") != -1 | string2.indexOf("ICC") != -1) {
            n3 = 3;
        } else if (string2.indexOf("CMYK") != -1) {
            n3 = 4;
        }
        this.IndexedColorMap = new byte[(n + 1) * n3];
        stringBuffer = Strip.stripAllSpaces(stringBuffer);
        for (n2 = 0; n2 < n + 1; ++n2) {
            for (int i = 0; i < n3; ++i) {
                int n4 = n2 * n3 * 2 + i * 2;
                int n5 = Integer.parseInt(stringBuffer.substring(n4, n4 + 2), 16);
                this.IndexedColorMap[n2 * n3 + i] = (byte)n5;
            }
        }
    }

    protected int getIndexedColorComponent(int n) {
        int n2 = 255;
        if (this.IndexedColorMap != null && (n2 = this.IndexedColorMap[n]) < 0) {
            n2 = 256 + n2;
        }
        return n2;
    }

    public byte[] getIndexedMap() {
        return this.IndexedColorMap;
    }

    public void setColor(String[] stringArray, int n) {
    }

    public void setColor(float[] fArray, int n) {
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4) {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (PdfDecoder.use13jPEGConversion) {
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                jPEGImageDecoder = null;
            } else {
                ImageIO.setUseCache(false);
                bufferedImage = ImageIO.read(byteArrayInputStream);
            }
            if (bufferedImage != null) {
                if (this.value != 1568372915) {
                    bufferedImage = this.cleanupImage(bufferedImage, n3, n4);
                }
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Problem reading JPEG: " + exception);
            exception.printStackTrace();
        }
        if (byteArrayInputStream != null) {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bufferedImage;
    }

    public BufferedImage JPEG2000ToRGBImage(byte[] byArray, int n, int n2) throws PdfException {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("JPEG2000").next();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            try {
                imageReader.setInput(imageInputStream, true);
                bufferedImage = imageReader.read(0);
                imageReader.dispose();
                imageInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            bufferedImage = this.cleanupImage(bufferedImage, n, n2);
            bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Problem reading JPEG 2000: " + exception);
            throw new PdfException("Exception with JPEG2000 image - please ensure imageio.jar (from JAI library) on classpath");
        }
        catch (Error error) {
            bufferedImage = null;
            error.printStackTrace();
            LogWriter.writeLog("Problem reading JPEG 2000: " + error);
            throw new PdfException("Error with JPEG2000 image - please ensure imageio.jar (from JAI library) on classpath");
        }
        return bufferedImage;
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        int[] nArray = new int[]{0, 1, 2};
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public BufferedImage BufferedImageToRGBImage(BufferedImage bufferedImage) {
        return bufferedImage;
    }

    public int getID() {
        return this.value;
    }

    public final void setCIEValues(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) {
        this.cs = ColorSpace.getInstance(1001);
        this.G = fArray5;
        this.Ma = fArray4;
        this.W = fArray;
        this.B = fArray2;
        this.R = fArray3;
    }

    protected final byte[] convert4Index(byte[] byArray) {
        return this.convertIndex(byArray, 4);
    }

    protected final byte[] convertIndex(byte[] byArray, int n) {
        try {
            int n2 = byArray.length / n;
            int n3 = 1;
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
            int[] nArray = new int[]{0, 1, 2, 3};
            int[] nArray2 = new int[]{0, 1, 2};
            int[] nArray3 = n == 4 ? nArray : nArray2;
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, n2 * n, n, nArray3, null);
            if (CSToRGB == null) {
                GenericColorSpace.initCMYKColorspace();
            }
            CSToRGB = new ColorConvertOp(this.cs, rgbCS, ColorSpaces.hints);
            WritableRaster writableRaster2 = rgbModel.createCompatibleWritableRaster(n2, n3);
            CSToRGB.filter(writableRaster, writableRaster2);
            int n4 = n2 * n3 * 3;
            byArray = new byte[n4];
            DataBuffer dataBuffer = writableRaster2.getDataBuffer();
            for (int i = 0; i < n4; ++i) {
                byArray[i] = (byte)dataBuffer.getElem(i);
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception  " + exception + " converting colorspace");
        }
        return byArray;
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        return byArray;
    }

    public String getXMLColorToken() {
        String string = "";
        if (this.c == -1.0f) {
            if (this.currentColor instanceof Color) {
                Color color = (Color)((Object)this.currentColor);
                float f = (float)(255 - color.getRed()) / 255.0f;
                float f2 = (float)(255 - color.getGreen()) / 255.0f;
                float f3 = (float)(255 - color.getBlue()) / 255.0f;
                float f4 = f;
                if (f4 < f2) {
                    f4 = f2;
                }
                if (f4 < f3) {
                    f4 = f3;
                }
                string = this.pantoneName == null ? "<color C='" + f + "' M='" + f2 + "' Y='" + f3 + "' K='" + f4 + "' >" : "<color C='" + f + "' M='" + f2 + "' Y='" + f3 + "' K='" + f4 + "' pantoneName='" + this.pantoneName + "' >";
            } else {
                string = "<color type='shading'>";
            }
        } else {
            string = this.pantoneName == null ? "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' >" : "<color C='" + this.c + "' M='" + this.m + "' Y='" + this.y + "' K='" + this.k + "' pantoneName='" + this.pantoneName + "' >";
        }
        return string;
    }

    public void setPattern(Map map, int n, float[][] fArray) {
        this.patterns = map;
        this.pageHeight = n;
        this.CTM = fArray;
    }

    public void setColor(PdfPaint pdfPaint) {
        this.currentColor = pdfPaint;
    }

    public int getColorComponentCount() {
        return this.componentCount;
    }

    public void setGS(GraphicsState graphicsState) {
        this.gs = graphicsState;
    }

    public void setIntent(String string) {
        this.intent = string;
    }

    public float[] getRawValues() {
        return this.rawValues;
    }

    static {
        CSToRGB = null;
        rgbModel = null;
        ICCProfile = null;
        if (ICCProfile != null) {
            System.out.println("setup " + ICCProfile);
            rgbCS = new ICC_ColorSpace(ICCProfile);
        } else {
            rgbCS = ColorSpace.getInstance(1000);
        }
    }
}

