/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestBase;

public class TestIndex
extends TestBase {
    Connection conn;
    Statement stat;
    Random random = new Random();

    private void reconnect() throws Exception {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
        this.conn = this.getConnection("index");
        this.stat = this.conn.createStatement();
    }

    public void test() throws Exception {
        this.random.setSeed(100L);
        this.deleteDb("index");
        this.testWideIndex(100);
        this.testWideIndex(300);
        this.testWideIndex(700);
        this.testWideIndex(1200);
        this.testWideIndex(2400);
        this.testLike();
        this.reconnect();
        this.testConstraint();
        this.testLargeIndex();
        this.testMultiColumnIndex();
        this.testHashIndex(true, false);
        this.testHashIndex(false, false);
        this.testHashIndex(true, true);
        this.testHashIndex(false, true);
        this.testMultiColumnHashIndex();
        this.conn.close();
    }

    String getRandomString(int len) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            buff.append((char)(97 + this.random.nextInt(26)));
        }
        return buff.toString();
    }

    void testWideIndex(int length) throws Exception {
        String name;
        int id;
        this.reconnect();
        this.stat.execute("CREATE TABLE TEST(ID INT, NAME VARCHAR)");
        this.stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
        for (int i = 0; i < 100; ++i) {
            this.stat.execute("INSERT INTO TEST VALUES(" + i + ", SPACE(" + length + ") || " + i + " )");
        }
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY NAME");
        while (rs.next()) {
            id = rs.getInt("ID");
            name = rs.getString("NAME");
            this.check("" + id, name.trim());
        }
        if (!this.config.memory) {
            this.reconnect();
            rs = this.stat.executeQuery("SELECT * FROM TEST ORDER BY NAME");
            while (rs.next()) {
                id = rs.getInt("ID");
                name = rs.getString("NAME");
                this.check("" + id, name.trim());
            }
        }
        this.stat.execute("DROP TABLE TEST");
    }

    void testLike() throws Exception {
        this.reconnect();
        this.stat.execute("CREATE TABLE ABC(ID INT, NAME VARCHAR)");
        this.stat.execute("INSERT INTO ABC VALUES(1, 'Hello')");
        PreparedStatement prep = this.conn.prepareStatement("SELECT * FROM ABC WHERE NAME LIKE CAST(? AS VARCHAR)");
        prep.setString(1, "Hi%");
        prep.execute();
        this.stat.execute("DROP TABLE ABC");
    }

    void testConstraint() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.stat.execute("CREATE TABLE PARENT(ID INT PRIMARY KEY)");
        this.stat.execute("CREATE TABLE CHILD(ID INT PRIMARY KEY, PID INT, FOREIGN KEY(PID) REFERENCES PARENT(ID))");
        this.reconnect();
        this.stat.execute("DROP TABLE PARENT");
        this.stat.execute("DROP TABLE CHILD");
    }

    void testLargeIndex() throws Exception {
        this.random.setSeed(10L);
        for (int i = 1; i < 100; i += this.getSize(1000, 2)) {
            this.stat.execute("DROP TABLE IF EXISTS TEST");
            this.stat.execute("CREATE TABLE TEST(NAME VARCHAR(" + i + "))");
            this.stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
            PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?)");
            for (int j = 0; j < this.getSize(2, 5); ++j) {
                prep.setString(1, this.getRandomString(i));
                prep.execute();
            }
            if (!this.config.memory) {
                this.conn.close();
                this.conn = this.getConnection("index");
                this.stat = this.conn.createStatement();
            }
            ResultSet rs = this.stat.executeQuery("SELECT COUNT(*) FROM TEST WHERE NAME > 'mdd'");
            rs.next();
            int count = rs.getInt(1);
            this.trace(i + " count=" + count);
        }
        this.stat.execute("DROP TABLE IF EXISTS TEST");
    }

    void testHashIndex(boolean primaryKey, boolean hash) throws Exception {
        int a;
        if (this.config.memory) {
            return;
        }
        this.reconnect();
        this.stat.execute("DROP TABLE IF EXISTS TEST");
        if (primaryKey) {
            this.stat.execute("CREATE TABLE TEST(A INT PRIMARY KEY " + (hash ? "HASH" : "") + ", B INT)");
        } else {
            this.stat.execute("CREATE TABLE TEST(A INT, B INT)");
            this.stat.execute("CREATE UNIQUE " + (hash ? "HASH" : "") + " INDEX ON TEST(A)");
        }
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int len = this.getSize(5, 1000);
        for (a = 0; a < len; ++a) {
            prep.setInt(1, a);
            prep.setInt(2, a);
            prep.execute();
            this.check(1L, this.getValue(this.stat, "SELECT COUNT(*) FROM TEST WHERE A=" + a));
            this.check(0L, this.getValue(this.stat, "SELECT COUNT(*) FROM TEST WHERE A=-1-" + a));
        }
        this.reconnect();
        prep = this.conn.prepareStatement("DELETE FROM TEST WHERE A=?");
        for (a = 0; a < len; ++a) {
            if (this.getValue(this.stat, "SELECT COUNT(*) FROM TEST WHERE A=" + a) != 1) {
                this.check(1L, this.getValue(this.stat, "SELECT COUNT(*) FROM TEST WHERE A=" + a));
            }
            prep.setInt(1, a);
            this.check(1L, prep.executeUpdate());
        }
        this.check(0L, this.getValue(this.stat, "SELECT COUNT(*) FROM TEST"));
    }

    void testMultiColumnIndex() throws Exception {
        int a;
        this.stat.execute("DROP TABLE IF EXISTS TEST");
        this.stat.execute("CREATE TABLE TEST(A INT, B INT)");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int len = this.getSize(3, 260);
        for (a = 0; a < len; ++a) {
            prep.setInt(1, a);
            prep.setInt(2, a);
            prep.execute();
        }
        this.stat.execute("INSERT INTO TEST SELECT A, B FROM TEST");
        this.stat.execute("CREATE INDEX ON TEST(A, B)");
        prep = this.conn.prepareStatement("DELETE FROM TEST WHERE A=?");
        for (a = 0; a < len; ++a) {
            this.log(this.stat, "SELECT * FROM TEST");
            this.check(2L, this.getValue(this.stat, "SELECT COUNT(*) FROM TEST WHERE A=" + (len - a - 1)));
            this.check((len - a) * 2, this.getValue(this.stat, "SELECT COUNT(*) FROM TEST"));
            prep.setInt(1, len - a - 1);
            prep.execute();
        }
        this.check(0L, this.getValue(this.stat, "SELECT COUNT(*) FROM TEST"));
    }

    void testMultiColumnHashIndex() throws Exception {
        int b;
        int a;
        if (this.config.memory) {
            return;
        }
        this.stat.execute("DROP TABLE IF EXISTS TEST");
        this.stat.execute("CREATE TABLE TEST(A INT, B INT, DATA VARCHAR(255))");
        this.stat.execute("CREATE UNIQUE HASH INDEX IDXAB ON TEST(A, B)");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, ?, ?)");
        int len = this.getSize(2, 14);
        for (a = 0; a < len; ++a) {
            for (b = 0; b < len; b += 2) {
                prep.setInt(1, a);
                prep.setInt(2, b);
                prep.setString(3, "i(" + a + "," + b + ")");
                prep.execute();
            }
        }
        this.reconnect();
        prep = this.conn.prepareStatement("UPDATE TEST SET DATA=DATA||? WHERE A=? AND B=?");
        for (a = 0; a < len; ++a) {
            for (b = 0; b < len; b += 2) {
                prep.setString(1, "u(" + a + "," + b + ")");
                prep.setInt(2, a);
                prep.setInt(3, b);
                prep.execute();
            }
        }
        this.reconnect();
        ResultSet rs = this.stat.executeQuery("SELECT * FROM TEST WHERE DATA <> 'i('||a||','||b||')u('||a||','||b||')'");
        this.checkFalse(rs.next());
        this.check(len * (len / 2), this.getValue(this.stat, "SELECT COUNT(*) FROM TEST"));
        this.stat.execute("DROP TABLE TEST");
    }

    int getValue(Statement stat, String sql) throws Exception {
        ResultSet rs = stat.executeQuery(sql);
        rs.next();
        return rs.getInt(1);
    }

    void log(Statement stat, String sql) throws Exception {
        this.trace(sql);
        ResultSet rs = stat.executeQuery(sql);
        int cols = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            for (int i = 0; i < cols; ++i) {
                this.trace("[" + i + "]=" + rs.getString(i + 1));
            }
        }
        this.trace("---done---");
    }
}

