/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.Message;
import org.h2.result.ResultInterface;
import org.h2.util.ObjectArray;
import org.h2.util.TypeConverter;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    private CommandInterface command;
    private ObjectArray batchParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        try {
            ResultInterface result;
            int id = this.getNextId(4);
            if (this.info()) {
                this.infoCodeAssign("ResultSet", 4, id);
                this.infoCodeCall("executeQuery");
            }
            this.checkClosed();
            this.closeOld();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                try {
                    this.setExecutingStatement(this.command);
                    boolean scrollable = this.resultSetType != 1003;
                    result = this.command.executeQuery(this.maxRows, scrollable);
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            this.resultSet = new JdbcResultSet(this.session, this.conn, this, result, id);
            return this.resultSet;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            this.infoCodeCall("executeUpdate");
            this.checkClosed();
            return this.executeUpdateInternal();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal() throws SQLException {
        this.closeOld();
        SessionInterface sessionInterface = this.session;
        synchronized (sessionInterface) {
            try {
                this.setExecutingStatement(this.command);
                this.updateCount = this.command.executeUpdate();
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        return this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        try {
            boolean returnsResultSet;
            int id = this.getNextId(4);
            if (this.info()) {
                this.infoCodeCall("execute");
            }
            this.checkClosed();
            this.closeOld();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                try {
                    this.setExecutingStatement(this.command);
                    if (this.command.isQuery()) {
                        returnsResultSet = true;
                        boolean scrollable = this.resultSetType != 1003;
                        ResultInterface result = this.command.executeQuery(this.maxRows, scrollable);
                        this.resultSet = new JdbcResultSet(this.session, this.conn, this, result, id);
                    } else {
                        returnsResultSet = false;
                        this.updateCount = this.command.executeUpdate();
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            return returnsResultSet;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            this.infoCodeCall("clearParameters");
            this.checkClosed();
            ObjectArray parameters = this.command.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                ParameterInterface param = (ParameterInterface)parameters.get(i);
                param.setValue(null);
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.infoCodeCall("executeQuery", sql);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void addBatch(String sql) throws SQLException {
        try {
            this.infoCodeCall("addBatch", sql);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            this.infoCodeCall("executeUpdate", sql);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql) throws SQLException {
        try {
            this.infoCodeCall("execute", sql);
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setNull(" + parameterIndex + ", " + sqlType + ");");
            }
            this.setParameter(parameterIndex, ValueNull.INSTANCE);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setInt(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueInt.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setString(" + parameterIndex + ", " + this.quote(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueString.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setBigDecimal(" + parameterIndex + ", " + this.quoteBigDecimal(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueDecimal.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setDate(" + parameterIndex + ", " + this.quoteDate(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueDate.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setTime(" + parameterIndex + ", " + this.quoteTime(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueTime.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setTimestamp(" + parameterIndex + ", " + this.quoteTimestamp(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueTimestamp.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setObject(" + parameterIndex + ", x);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, DataType.convertToValue(this.session, x));
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setObject(" + parameterIndex + ", x, " + targetSqlType + ");");
            }
            int type = DataType.convertSQLTypeToValueType(targetSqlType);
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                Value v = DataType.convertToValue(this.session, x);
                this.setParameter(parameterIndex, v.convertTo(type));
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setObject(" + parameterIndex + ", x, " + targetSqlType + ", " + scale + ");");
            }
            this.setObject(parameterIndex, x, targetSqlType);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setBoolean(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueBoolean.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setByte(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueByte.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setShort(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueShort.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setLong(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueLong.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setFloat(" + parameterIndex + ", " + x + "f);");
            }
            this.setParameter(parameterIndex, ValueFloat.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setDouble(" + parameterIndex + ", " + x + ");");
            }
            this.setParameter(parameterIndex, ValueDouble.get(x));
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setRef(" + parameterIndex + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar calendar) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setDate(" + parameterIndex + ", " + this.quoteDate(x) + ", calendar);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, TypeConverter.convertDateToUniversal(x, calendar));
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar calendar) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setTime(" + parameterIndex + ", " + this.quoteTime(x) + ", calendar);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, TypeConverter.convertTimeToUniversal(x, calendar));
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar calendar) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setTimestamp(" + parameterIndex + ", " + this.quoteTimestamp(x) + ", calendar);");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, TypeConverter.convertTimestampToUniversal(x, calendar));
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setUnicodeStream(" + parameterIndex + ", x, " + length + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setNull(" + parameterIndex + ", " + sqlType + ", " + this.quote(typeName) + ");");
            }
            this.setNull(parameterIndex, sqlType);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setBlob(" + parameterIndex + ", x);");
            }
            Value v = x == null ? ValueNull.INSTANCE : this.session.createBlob(x.getBinaryStream(), -1);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setClob(" + parameterIndex + ", x);");
            }
            Value v = x == null ? ValueNull.INSTANCE : this.session.createClob(x.getCharacterStream(), -1);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setArray(" + parameterIndex + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setBytes(" + parameterIndex + ", " + this.quoteBytes(x) + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : ValueBytes.get(x);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setBinaryStream(" + parameterIndex + ", x, " + length + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : this.session.createBlob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setAsciiStream(" + parameterIndex + ", x, " + length + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : this.session.createClob(TypeConverter.getAsciiReader(x), length);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setCharacterStream(" + parameterIndex + ", x, " + length + ");");
            }
            Value v = x == null ? ValueNull.INSTANCE : this.session.createClob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setURL(" + parameterIndex + ", x);");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.infoCodeCall("getMetaData");
            this.checkClosed();
            return null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void clearBatch() throws SQLException {
        try {
            this.infoCodeCall("clearBatch");
            this.checkClosed();
            this.batchParameters = null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int[] executeBatch() throws SQLException {
        try {
            this.infoCodeCall("executeBatch");
            this.checkClosed();
            if (this.batchParameters == null) {
                this.batchParameters = new ObjectArray();
            }
            ObjectArray parameters = this.command.getParameters();
            int[] result = new int[this.batchParameters.size()];
            boolean error = false;
            for (int i = 0; i < this.batchParameters.size(); ++i) {
                Value[] set = (Value[])this.batchParameters.get(i);
                for (int j = 0; j < set.length; ++j) {
                    Value value = set[j];
                    ParameterInterface param = (ParameterInterface)parameters.get(j);
                    param.setValue(value);
                }
                try {
                    result[i] = this.executeUpdateInternal();
                    continue;
                }
                catch (SQLException e) {
                    this.logAndConvert(e);
                    result[i] = -3;
                    error = true;
                }
            }
            this.batchParameters = null;
            if (error) {
                throw new BatchUpdateException(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void addBatch() throws SQLException {
        try {
            this.infoCodeCall("addBatch");
            this.checkClosed();
            ObjectArray parameters = this.command.getParameters();
            Value[] set = new Value[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                Value value;
                ParameterInterface param = (ParameterInterface)parameters.get(i);
                set[i] = value = param.getValue(null);
            }
            if (this.batchParameters == null) {
                this.batchParameters = new ObjectArray();
            }
            this.batchParameters.add(set);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("executeUpdate(" + this.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("executeUpdate(" + this.quote(sql) + ", " + this.quoteIntArray(columnIndexes) + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("executeUpdate(" + this.quote(sql) + ", " + this.quoteArray(columnNames) + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("execute(" + this.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("execute(" + this.quote(sql) + ", " + this.quoteIntArray(columnIndexes) + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("execute(" + this.quote(sql) + ", " + this.quoteArray(columnNames) + ");");
            }
            throw Message.getUnsupportedException();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            this.infoCodeCall("getParameterMetaData");
            throw Message.getUnsupportedException();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    JdbcPreparedStatement(SessionInterface session, JdbcConnection conn, String sql, int resultSetType, int id) throws SQLException {
        super(session, conn, resultSetType, id);
        this.setTrace(session.getTrace(), 3, id);
        this.command = conn.prepareCommand(sql);
    }

    private void setParameter(int parameterIndex, Value value) throws SQLException {
        this.checkClosed();
        ObjectArray parameters = this.command.getParameters();
        if (--parameterIndex < 0 || parameterIndex >= parameters.size()) {
            throw Message.getInvalidValueException("" + (parameterIndex + 1), "parameterIndex");
        }
        ParameterInterface param = (ParameterInterface)parameters.get(parameterIndex);
        param.setValue(value);
    }
}

