/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.h2.command.CommandInterface;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Constants;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionRemote;
import org.h2.jdbc.JdbcCallableStatement;
import org.h2.jdbc.JdbcDatabaseMetaData;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcSavepoint;
import org.h2.jdbc.JdbcStatement;
import org.h2.jdbcx.JdbcConnectionListener;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;

public class JdbcConnection
extends TraceObject
implements Connection {
    private String url;
    private String user;
    private int transactionIsolationLevel = 2;
    private int holdability = 1;
    private SessionInterface session;
    private CommandInterface commit;
    private CommandInterface rollback;
    private CommandInterface setAutoCommitTrue;
    private CommandInterface setAutoCommitFalse;
    private CommandInterface getAutoCommit;
    private CommandInterface getReadOnly;
    private Exception openStackTrace;
    private int savepointId;
    private Trace trace;
    private JdbcConnectionListener listener;
    private boolean isInternal;
    private String catalog;
    private Statement executingStatement;

    public Statement createStatement() throws SQLException {
        try {
            int id = this.getNextId(8);
            if (this.info()) {
                this.infoCodeAssign("Statement", 8, id);
                this.infoCodeCall("createStatement");
            }
            this.checkClosed();
            return new JdbcStatement(this.session, this, 1003, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            int id = this.getNextId(8);
            if (this.info()) {
                this.infoCodeAssign("Statement", 8, id);
                this.infoCode("createStatement(" + resultSetType + ", " + resultSetConcurrency + ");");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            return new JdbcStatement(this.session, this, resultSetType, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            int id = this.getNextId(8);
            if (this.info()) {
                this.infoCodeAssign("Statement", 8, id);
                this.infoCode("createStatement(" + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ");");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            this.checkHoldability(resultSetHoldability);
            return new JdbcStatement(this.session, this, resultSetType, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            int id = this.getNextId(3);
            if (this.info()) {
                this.infoCodeAssign("PreparedStatement", 3, id);
                this.infoCodeCall("prepareStatement", sql);
            }
            this.checkClosed();
            sql = this.translateSQL(sql);
            return new JdbcPreparedStatement(this.session, this, sql, 1003, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            int id = this.getNextId(2);
            if (this.info()) {
                this.infoCodeAssign("DatabaseMetaData", 2, id);
                this.infoCodeCall("getMetaData");
            }
            this.checkClosed();
            return new JdbcDatabaseMetaData(this, this.trace, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setJdbcConnectionListener(JdbcConnectionListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        JdbcConnection jdbcConnection = this;
        synchronized (jdbcConnection) {
            if (this.listener == null) {
                this.closeConnection();
            } else {
                this.listener.closed(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws SQLException {
        block16: {
            try {
                this.infoCodeCall("close");
                if (this.executingStatement != null) {
                    this.executingStatement.cancel();
                }
                if (this.session == null || this.session.isClosed()) break block16;
                try {
                    this.rollbackInternal();
                    if (this.commit != null) {
                        this.commit.close();
                        this.commit = null;
                    }
                    if (this.rollback != null) {
                        this.rollback.close();
                        this.rollback = null;
                    }
                    if (this.setAutoCommitTrue != null) {
                        this.setAutoCommitTrue.close();
                        this.setAutoCommitTrue = null;
                    }
                    if (this.setAutoCommitFalse != null) {
                        this.setAutoCommitFalse.close();
                        this.setAutoCommitFalse = null;
                    }
                    if (this.getAutoCommit != null) {
                        this.getAutoCommit.close();
                        this.getAutoCommit = null;
                    }
                    if (this.getReadOnly != null) {
                        this.getReadOnly.close();
                        this.getReadOnly = null;
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    try {
                        this.session.close();
                    }
                    finally {
                        this.session = null;
                    }
                    throw throwable;
                }
                try {
                    this.session.close();
                }
                finally {
                    this.session = null;
                }
            }
            catch (Throwable e) {
                throw this.logAndConvert(e);
            }
        }
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setAutoCommit(" + autoCommit + ");");
            }
            this.checkClosed();
            if (autoCommit) {
                if (this.setAutoCommitTrue == null) {
                    this.setAutoCommitTrue = this.prepareCommand("SET AUTOCOMMIT TRUE");
                }
                this.setAutoCommitTrue.executeUpdate();
            } else {
                if (this.setAutoCommitFalse == null) {
                    this.setAutoCommitFalse = this.prepareCommand("SET AUTOCOMMIT FALSE");
                }
                this.setAutoCommitFalse.executeUpdate();
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            this.infoCodeCall("getAutoCommit");
            this.checkClosed();
            if (this.getAutoCommit == null) {
                this.getAutoCommit = this.prepareCommand("CALL AUTOCOMMIT()");
            }
            ResultInterface result = this.getAutoCommit.executeQuery(0, false);
            result.next();
            boolean autocommit = result.currentRow()[0].getBoolean();
            result.close();
            return autocommit;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public synchronized void commit() throws SQLException {
        try {
            this.infoCodeCall("commit");
            this.checkClosed();
            if (this.commit == null) {
                this.commit = this.prepareCommand("COMMIT");
            }
            this.commit.executeUpdate();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public synchronized void rollback() throws SQLException {
        try {
            this.infoCodeCall("rollback");
            this.checkClosed();
            this.rollbackInternal();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isClosed() throws SQLException {
        try {
            this.infoCodeCall("isClosed");
            return this.session == null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            this.infoCodeCall("nativeSQL", sql);
            this.checkClosed();
            return this.translateSQL(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("setReadOnly(" + readOnly + ");");
            }
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.infoCodeCall("isReadOnly");
            this.checkClosed();
            if (this.getReadOnly == null) {
                this.getReadOnly = this.prepareCommand("CALL READONLY()");
            }
            ResultInterface result = this.getReadOnly.executeQuery(0, false);
            result.next();
            boolean readOnly = result.currentRow()[0].getBoolean();
            return readOnly;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            this.infoCodeCall("setCatalog", catalog);
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public String getCatalog() throws SQLException {
        try {
            this.infoCodeCall("getCatalog");
            this.checkClosed();
            if (this.catalog == null) {
                CommandInterface cat = this.prepareCommand("CALL DATABASE()");
                ResultInterface result = cat.executeQuery(0, false);
                result.next();
                this.catalog = result.currentRow()[0].getString();
                cat.close();
            }
            return this.catalog;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        try {
            this.infoCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void clearWarnings() throws SQLException {
        try {
            this.infoCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            int id = this.getNextId(3);
            if (this.info()) {
                this.infoCodeAssign("PreparedStatement", 3, id);
                this.infoCode("prepareStatement(" + this.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ");");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            sql = this.translateSQL(sql);
            return new JdbcPreparedStatement(this.session, this, sql, resultSetType, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.infoCodeCall("setTransactionIsolation", level);
            this.checkClosed();
            if (level != 2 && level != 8) {
                throw Message.getInvalidValueException("" + level, "level");
            }
            this.commit();
            this.transactionIsolationLevel = level;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            this.infoCodeCall("getTransactionIsolation");
            this.checkClosed();
            return this.transactionIsolationLevel;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        try {
            this.infoCodeCall("setHoldability", holdability);
            this.checkClosed();
            this.checkHoldability(holdability);
            this.holdability = holdability;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int getHoldability() throws SQLException {
        try {
            this.infoCodeCall("getHoldability");
            this.checkClosed();
            return this.holdability;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Map getTypeMap() throws SQLException {
        try {
            this.infoCodeCall("getTypeMap");
            this.checkClosed();
            return null;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        try {
            this.infoCode("setTypeMap(" + this.quoteMap(map) + ");");
            if (map != null && map.size() > 0) {
                throw Message.getUnsupportedException();
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    private String quoteMap(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "new Map()";
        }
        StringBuffer buff = new StringBuffer("new Map() /* ");
        try {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                buff.append(key);
                buff.append(':');
                Class clazz = (Class)map.get(key);
                buff.append(clazz.getName());
            }
        }
        catch (Exception e) {
            buff.append(e.toString() + ": " + map.toString());
        }
        buff.append("*/");
        return buff.toString();
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            int id = this.getNextId(0);
            if (this.info()) {
                this.infoCodeAssign("CallableStatement", 0, id);
                this.infoCodeCall("prepareCall", sql);
            }
            this.checkClosed();
            sql = this.translateSQL(sql);
            return new JdbcCallableStatement(this.session, this, sql, 1003, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            int id = this.getNextId(0);
            if (this.info()) {
                this.infoCodeAssign("CallableStatement", 0, id);
                this.infoCode("prepareCall(" + this.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ");");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            sql = this.translateSQL(sql);
            return new JdbcCallableStatement(this.session, this, sql, resultSetType, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            int id = this.getNextId(0);
            if (this.info()) {
                this.infoCodeAssign("CallableStatement", 0, id);
                this.infoCode("prepareCall(" + this.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ");");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            this.checkHoldability(resultSetHoldability);
            sql = this.translateSQL(sql);
            return new JdbcCallableStatement(this.session, this, sql, resultSetType, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        try {
            int id = this.getNextId(6);
            if (this.info()) {
                this.infoCodeAssign("Savepoint", 6, id);
                this.infoCodeCall("setSavepoint");
            }
            this.checkClosed();
            CommandInterface set = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(null, this.savepointId));
            set.executeUpdate();
            JdbcSavepoint savepoint = new JdbcSavepoint(this, this.savepointId, null, this.trace, id);
            ++this.savepointId;
            return savepoint;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            int id = this.getNextId(6);
            if (this.info()) {
                this.infoCodeAssign("Savepoint", 6, id);
                this.infoCodeCall("setSavepoint", name);
            }
            this.checkClosed();
            CommandInterface set = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(name, 0));
            set.executeUpdate();
            JdbcSavepoint savepoint = new JdbcSavepoint(this, 0, name, this.trace, id);
            return savepoint;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.infoCode("rollback(savepoint);");
            this.checkClosed();
            this.convertSavepoint(savepoint).rollback();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.infoCode("releaseSavepoint(savepoint);");
            this.checkClosed();
            this.convertSavepoint(savepoint).release();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    private JdbcSavepoint convertSavepoint(Savepoint savepoint) throws SQLException {
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw Message.getSQLException(90063);
        }
        return (JdbcSavepoint)savepoint;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            int id = this.getNextId(3);
            if (this.info()) {
                this.infoCodeAssign("PreparedStatement", 3, id);
                this.infoCode("prepareStatement(" + this.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ");");
            }
            this.checkClosed();
            this.checkTypeAndConcurrency(resultSetType, resultSetConcurrency);
            this.checkHoldability(resultSetHoldability);
            sql = this.translateSQL(sql);
            return new JdbcPreparedStatement(this.session, this, sql, resultSetType, id);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("prepareStatement(" + this.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            return this.prepareStatement(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("prepareStatement(" + this.quote(sql) + ", " + this.quoteIntArray(columnIndexes) + ");");
            }
            return this.prepareStatement(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.info()) {
                this.infoCode("prepareStatement(" + this.quote(sql) + ", " + this.quoteArray(columnNames) + ");");
            }
            return this.prepareStatement(sql);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public JdbcConnection(String url, Properties info) throws SQLException {
        try {
            this.checkJavaVersion();
            ConnectionInfo ci = new ConnectionInfo(url, info);
            if (ci.isRemote()) {
                this.session = new SessionRemote().createSession(ci);
            } else {
                SessionInterface si = (SessionInterface)Class.forName("org.h2.engine.Session").newInstance();
                this.session = si.createSession(ci);
            }
            this.trace = this.session.getTrace();
            int id = this.getNextId(1);
            this.setTrace(this.trace, 1, id);
            if (this.info()) {
                this.infoCodeAssign("Connection", 1, id);
                this.trace.infoCode("DriverManager.getConnection(" + this.quote(url) + ", \"<user>\", \"<password>\");");
            }
            this.url = ci.getURL();
            this.user = ci.getUserName();
            this.openStackTrace = new Exception("Stack Trace");
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public JdbcConnection(SessionInterface session, String user) throws SQLException {
        this.isInternal = true;
        this.session = session;
        this.trace = session.getTrace();
        int id = this.getNextId(1);
        this.setTrace(this.trace, 1, id);
        this.user = user;
        this.url = "jdbc:default:connection";
    }

    private void checkJavaVersion() throws SQLException {
        try {
            Class.forName("java.sql.Savepoint");
        }
        catch (Throwable e) {
            throw Message.getSQLException(90092);
        }
    }

    CommandInterface prepareCommand(String sql) throws SQLException {
        return this.session.prepareCommand(sql);
    }

    String translateSQL(String sql) throws SQLException {
        if (sql == null || sql.indexOf(123) < 0) {
            return sql;
        }
        int len = sql.length();
        char[] chars = null;
        int level = 0;
        block8: for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            switch (c) {
                case '\'': {
                    int j = sql.indexOf(39, i + 1);
                    if (j < 0) {
                        throw Message.getSyntaxError(sql, i);
                    }
                    i = j;
                    continue block8;
                }
                case '\"': {
                    int j = sql.indexOf(34, i + 1);
                    if (j < 0) {
                        throw Message.getSyntaxError(sql, i);
                    }
                    i = j;
                    continue block8;
                }
                case '/': {
                    int j;
                    this.checkRunOver(i + 1, len, sql);
                    if (sql.charAt(i + 1) == '*') {
                        j = sql.indexOf("*/", i + 2);
                        if (j < 0) {
                            throw Message.getSyntaxError(sql, i);
                        }
                        i = j + 1;
                        continue block8;
                    }
                    if (sql.charAt(i + 1) != '/') continue block8;
                    i += 2;
                    while (i < len && (c = sql.charAt(i)) != '\r' && c != '\n') {
                        ++i;
                    }
                    continue block8;
                }
                case '-': {
                    this.checkRunOver(i + 1, len, sql);
                    if (sql.charAt(i + 1) != '-') continue block8;
                    i += 2;
                    while (i < len && (c = sql.charAt(i)) != '\r' && c != '\n') {
                        ++i;
                    }
                    continue block8;
                }
                case '{': {
                    ++level;
                    if (chars == null) {
                        chars = sql.toCharArray();
                    }
                    chars[i] = 32;
                    while (Character.isSpaceChar(chars[i])) {
                        this.checkRunOver(++i, len, sql);
                    }
                    int start = i;
                    if (chars[i] >= '0' && chars[i] <= '9') {
                        chars[i - 1] = 123;
                        while (chars[i] != '}') {
                            this.checkRunOver(++i, len, sql);
                        }
                        --level;
                        continue block8;
                    }
                    if (chars[i] == '?') {
                        chars[i++] = 32;
                        this.checkRunOver(i, len, sql);
                        while (Character.isSpaceChar(chars[i])) {
                            this.checkRunOver(++i, len, sql);
                        }
                        if (sql.charAt(i) != '=') {
                            throw Message.getSyntaxError(sql, i, "=");
                        }
                        chars[i++] = 32;
                        this.checkRunOver(i, len, sql);
                        while (Character.isSpaceChar(chars[i])) {
                            this.checkRunOver(++i, len, sql);
                        }
                    }
                    while (!Character.isSpaceChar(chars[i])) {
                        this.checkRunOver(++i, len, sql);
                    }
                    int repl = 0;
                    if (this.found(sql, start, "fn")) {
                        repl = 2;
                    } else {
                        if (this.found(sql, start, "escape") || this.found(sql, start, "call")) continue block8;
                        if (this.found(sql, start, "oj")) {
                            repl = 2;
                        } else if (this.found(sql, start, "ts")) {
                            repl = 2;
                        } else if (this.found(sql, start, "t")) {
                            repl = 1;
                        } else if (this.found(sql, start, "d")) {
                            repl = 1;
                        } else if (this.found(sql, start, "params")) {
                            repl = 1;
                        }
                    }
                    i = start;
                    while (repl > 0) {
                        chars[i] = 32;
                        ++i;
                        --repl;
                    }
                    continue block8;
                }
                case '}': {
                    if (--level < 0) {
                        throw Message.getSyntaxError(sql, i);
                    }
                    chars[i] = 32;
                }
            }
        }
        if (level != 0) {
            throw Message.getSyntaxError(sql, sql.length() - 1);
        }
        if (chars != null) {
            sql = new String(chars);
        }
        return sql;
    }

    private void checkRunOver(int i, int len, String sql) throws SQLException {
        if (i >= len) {
            throw Message.getSyntaxError(sql, i);
        }
    }

    private boolean found(String sql, int start, String other) {
        return sql.regionMatches(true, start, other, 0, other.length());
    }

    private void checkTypeAndConcurrency(int resultSetType, int resultSetConcurrency) throws SQLException {
    }

    private void checkHoldability(int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw Message.getInvalidValueException("" + resultSetHoldability, "resultSetHoldability");
        }
    }

    void checkClosed() throws SQLException {
        if (this.session == null) {
            throw Message.getSQLException(90008);
        }
    }

    String getURL() throws SQLException {
        this.checkClosed();
        return this.url;
    }

    String getUser() throws SQLException {
        this.checkClosed();
        return this.user;
    }

    public void finalize() {
        if (!Constants.RUN_FINALIZERS) {
            return;
        }
        if (this.isInternal) {
            return;
        }
        if (this.session != null) {
            this.trace.error("Connection not closed", this.openStackTrace);
            try {
                this.close();
            }
            catch (SQLException e) {
                this.trace.debug("finalize", e);
            }
        }
    }

    private void rollbackInternal() throws SQLException {
        if (this.rollback == null) {
            this.rollback = this.prepareCommand("ROLLBACK");
        }
        this.rollback.executeUpdate();
    }

    public int getPowerOffCount() {
        return this.session == null ? 0 : this.session.getPowerOffCount();
    }

    public void setPowerOffCount(int count) throws SQLException {
        if (this.session != null) {
            this.session.setPowerOffCount(count);
        }
    }

    public void setExecutingStatement(Statement stat) {
        this.executingStatement = stat;
    }
}

