/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;

public class HoodTopLevel
implements ActionListener {
    private AllCDS cds;
    private List list;
    private Hashtable listHt;
    private Panel reload;
    private TextField textfield;
    private HoodXmlThread xmlThread;
    private Button reloadButton = new Button("Reload");
    private Button beforeEvalButton = new Button("Display Before Evaluation");
    private Button afterEvalButton = new Button("Display After Evaluation");
    private Button staticButton = new Button("Display Statically");
    private Button textButton = new Button("Dump To File");
    int nodeCount;
    Label nodeCountLabel = new Label("");
    boolean first = true;

    private void setGBC(int n, int n2, int n3, int n4, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
    }

    public HoodTopLevel(String string, Container container, Image image) {
        this.cds = new AllCDS(this);
        container.setBackground(Hood.bg);
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.setGBC(0, 0, 1, 1, gridBagConstraints);
        this.reload = new Panel();
        this.reload.add("Center", this.reloadButton);
        container.add((Component)this.reload, gridBagConstraints);
        this.setGBC(1, 0, 1, 1, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.textfield = new TextField(string);
        container.add((Component)this.textfield, gridBagConstraints);
        this.setGBC(2, 0, 1, 1, gridBagConstraints);
        container.add(new CornerIcon(image));
        this.list = new List(10, true);
        this.setGBC(0, 1, 2, 6, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        container.add((Component)this.list, gridBagConstraints);
        this.setGBC(2, 1, 1, 1, gridBagConstraints);
        container.add((Component)this.beforeEvalButton, gridBagConstraints);
        this.setGBC(2, 2, 1, 1, gridBagConstraints);
        container.add((Component)this.afterEvalButton, gridBagConstraints);
        this.setGBC(2, 3, 1, 1, gridBagConstraints);
        container.add((Component)this.staticButton, gridBagConstraints);
        this.setGBC(2, 4, 1, 1, gridBagConstraints);
        container.add((Component)this.textButton, gridBagConstraints);
        this.setGBC(2, 5, 1, 1, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        container.add((Component)new Label(""), gridBagConstraints);
        this.setGBC(2, 6, 1, 1, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        container.add((Component)this.nodeCountLabel, gridBagConstraints);
        this.reloadButton.addActionListener(this);
        this.beforeEvalButton.addActionListener(this);
        this.afterEvalButton.addActionListener(this);
        this.staticButton.addActionListener(this);
        this.textButton.addActionListener(this);
        this.doReload();
        Message.message("about to return..");
    }

    public void finishedLoading(boolean bl) {
        this.displayNodeCount();
        this.reloadButton.setEnabled(true);
        if (!bl) {
            this.list.addItem("** failed to load xml file **");
        } else if (this.list.getRows() > 0) {
            this.beforeEvalButton.setEnabled(true);
            this.afterEvalButton.setEnabled(true);
            this.staticButton.setEnabled(true);
            this.textButton.setEnabled(true);
        }
    }

    private void doReload() {
        this.reloadButton.setEnabled(false);
        this.beforeEvalButton.setEnabled(false);
        this.afterEvalButton.setEnabled(false);
        this.staticButton.setEnabled(false);
        this.textButton.setEnabled(false);
        this.list.removeAll();
        this.resetNodeCount();
        this.xmlThread = new HoodXmlThread(this.textfield.getText(), this, this.cds);
        this.xmlThread.start();
    }

    public void newNode() {
        ++this.nodeCount;
        if (this.nodeCount % 1000 == 0) {
            this.displayNodeCount();
        }
    }

    public void newRootSet(String string) {
        this.list.addItem(string);
        this.list.select(0);
    }

    private void resetNodeCount() {
        this.nodeCount = 0;
        this.displayNodeCount();
    }

    private void displayNodeCount() {
        this.nodeCountLabel.setText("Loaded " + this.nodeCount + " events");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == this.reloadButton) {
            this.doReload();
        } else {
            int n = 0;
            String[] stringArray = this.list.getSelectedItems();
            for (int i = 0; i < stringArray.length; ++i) {
                CDS cDS = this.cds.getContents(stringArray[i]);
                if (button == this.beforeEvalButton) {
                    n = 0;
                    new HoodViewer(stringArray[i], cDS, n);
                }
                if (button == this.afterEvalButton) {
                    n = 1;
                    new HoodViewer(stringArray[i], cDS, n);
                }
                if (button == this.staticButton) {
                    n = 2;
                    new HoodViewer(stringArray[i], cDS, n);
                }
                if (button != this.textButton) continue;
                Message.message("Hello!");
                Pretty pretty = cDS.render(null, 0, false);
                PrettyDisplayText prettyDisplayText = new PrettyDisplayText();
                pretty.best(80, prettyDisplayText);
                Message.message("PP:" + prettyDisplayText.toString());
            }
        }
        Message.message("B:" + button.getLabel());
    }
}

