<?php
	/**
	 * BusyTime Module
	*/
	
	require_once("mapi/class.recurrence.php");
	require_once("class.appointmentlistmodule.php");
	
	class BusyTimeListModule extends AppointmentListModule
	{
		/**
		 * @var array the properties sent back to the client - a minimal set of data
		 */
		var $minproperties;
		/**
		 * Constructor
		 * @param int $id unique id.
		 * @param array $data list of all actions.
		 */
		function BusyTimeListModule($id, $data)
		{
			parent::AppointmentListModule($id, $data, array());
			$this->minproperties = $GLOBALS["properties"]->getBusyTimeProperties();
		}
		
		/**
		 * Process calendar items to prepare them for being sent back to the client
		 * @param array $calendaritems array of appointments retrieved from the mapi tablwe
 		 * @param object $store message store
		 * @param object $calendar folder
		 * @param date $start startdate of the interval
		 * @param date $end enddate of the interval
		 * @return array $items processed items
		 */
		function processItems($calendaritems, $store, $entryid, $start, $end)
		{
			$items = Array();
			foreach($calendaritems as $calendaritem)
			{
				$item = null;
				if (isset($calendaritem[$this->properties["recurring"]]) && $calendaritem[$this->properties["recurring"]]) {
					$recurrence = new Recurrence($store, $calendaritem);
					$recuritems = $recurrence->getItems($start, $end);
					
					foreach($recuritems as $recuritem)
					{
						$item = Conversion::mapMAPI2XML($this->minproperties, $recuritem);
						
						// only add it in response if its not removed by above function
						if(!empty($item)) {
							array_push($items, $item['props']);
						}
					}
				} else {
					$item = Conversion::mapMAPI2XML($this->minproperties, $calendaritem);

					

					// only add it in response if its not removed by above function
					if(!empty($item)) {
						array_push($items,$item['props']);
					}
				}
			}

			return $items;
		}
	}
?>
