DROP TABLE IF EXISTS report_schedule;
CREATE TABLE report_schedule (
        id serial NOT NULL,
        user_report_data_id integer NOT NULL,
        state_id integer DEFAULT 10 NOT NULL,
        status_id integer DEFAULT 10 NOT NULL,
        priority_id integer NOT NULL,
        name varchar(250),
        description varchar(250),
        last_run_date timestamp,
        last_run_processing_time integer,
        average_processing_time integer,
        total_processing_time bigint,
        total_runs integer,
        start_date timestamp,
        end_date timestamp,
        custom_frequency_id varchar(250),
        custom_frequency_data varchar(250),
        minute varchar(250),
        hour varchar(250),
        day_of_month varchar(250),
        month varchar(250),
        day_of_week varchar(250),
        home_email_cc smallint DEFAULT 0,
        other_email varchar(250),
        created_date integer,
        created_by integer,
        updated_date integer,
        updated_by integer,
        deleted_date integer,
        deleted_by integer,
        deleted smallint DEFAULT 0 NOT NULL
) ENGINE=InnoDB;
CREATE UNIQUE INDEX report_schedule_id ON report_schedule(id);
CREATE UNIQUE INDEX report_schedule_user_report_data_id ON report_schedule(user_report_data_id);

