/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.demux.vob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.IncompatibleSourceException;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.Positionable;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import net.sourceforge.jffmpeg.GPLLicense;
import net.sourceforge.jffmpeg.demux.vob.AudioTrack;
import net.sourceforge.jffmpeg.demux.vob.DataBuffer;
import net.sourceforge.jffmpeg.demux.vob.PullSourceInputStream;
import net.sourceforge.jffmpeg.demux.vob.VideoTrack;

public class VobDemux
implements Demultiplexer,
Positionable,
GPLLicense {
    private long timeStamp = 0L;
    public static final int SYNC_CHANNEL = 128;
    public static final long MAX_AUDIO_BUFFER = 4200L;
    public static final long MIN_AUDIO_BUFFER = 100L;
    public static final boolean debugLipSync = false;
    public static final boolean showAllFrames = false;
    private long totalFileSize = 0L;
    private long rateEstimateBase = 0L;
    private long rateEstimateTime = 0L;
    private InputStream in;
    private DataBuffer[] streams = new DataBuffer[512];
    public static final int PACK_START_CODE = 442;
    public static final int SYSTEM_HEADER_START_CODE = 443;
    public static final int SEQUENCE_END_CODE = 439;
    public static final int PACKET_START_CODE_MASK = -256;
    public static final int PACKET_START_CODE_PREFIX = 256;
    public static final int ISO_11172_END_CODE = 441;
    public static final int PROGRAM_STREAM_MAP = 444;
    public static final int PRIVATE_STREAM_1 = 445;
    public static final int PADDING_STREAM = 446;
    public static final int PRIVATE_STREAM_2 = 447;
    public static final int CODEC_TYPE_VIDEO = 0;
    public static final int CODEC_TYPE_AUDIO = 1;
    public static final int CODEC_ID_MPEG1VIDEO = 0;
    public static final int CODEC_ID_MP2 = 1;
    public static final int CODEC_ID_AC3 = 2;
    public static final int CODEC_ID_PCM_S16BE = 3;
    Time estimatedDuration = new Time(1000L);
    private PullSourceStream dataSource;
    private Seekable seekSource;
    public static final long ESTIMATED_BYTE_RATE = 540000L;
    private long startTime = 0L;

    public VobDemux() {
    }

    public VobDemux(InputStream inputStream) {
        this.in = inputStream;
    }

    private int findStartCode() throws IOException {
        int n = 255;
        while (((n = (n << 8 | this.in.read()) & 0xFFFFFFFF) & 0xFFFFFF00) != 256) {
        }
        return n;
    }

    private long getPts(int n) throws IOException {
        if (n < 0) {
            n = this.in.read();
        }
        long l = ((long)n >> 1 & 7L) << 30;
        long l2 = this.in.read() << 8 | this.in.read();
        l |= l2 >> 1 << 15;
        l2 = this.in.read() << 8 | this.in.read();
        return l |= l2 >> 1;
    }

    protected synchronized void parse(int n) throws IOException {
        int n2;
        block13: do {
            n2 = this.findStartCode();
            switch (n2) {
                case 442: {
                    int n3 = this.in.read();
                    int n4 = this.in.read();
                    int n5 = this.in.read();
                    int n6 = this.in.read();
                    int n7 = this.in.read();
                    this.timeStamp = (n3 & 8) << 27 | (n3 & 3) << 28 | n4 << 20 | (n5 & 0xF8) << 12 | (n5 & 3) << 13 | n6 << 5 | (n7 & 0xFE) >> 3;
                    this.timeStamp *= 300L;
                    this.timeStamp /= 26900L;
                    break;
                }
                case 443: {
                    break;
                }
                case 446: 
                case 447: {
                    int n8 = this.in.read() << 8 | this.in.read();
                    this.in.skip(n8);
                    break;
                }
                default: {
                    DataBuffer dataBuffer;
                    int n9;
                    if (!(n2 >= 448 && n2 <= 479 || n2 >= 480 && n2 <= 495 || n2 == 445)) continue block13;
                    long l = 0L;
                    long l2 = 0L;
                    int n7 = this.in.read() << 8 | this.in.read();
                    do {
                        n9 = this.in.read();
                        --n7;
                    } while (n9 == 255);
                    if ((n9 & 0xC0) == 64) {
                        this.in.read();
                        n9 = this.in.read();
                        n7 -= 2;
                    }
                    switch (n9 & 0xF0) {
                        case 32: {
                            l = this.getPts(n9);
                            n7 -= 4;
                            break;
                        }
                        case 48: {
                            l = this.getPts(n9);
                            l2 = this.getPts(-1);
                            n7 -= 9;
                            break;
                        }
                        default: {
                            if ((n9 & 0xC0) != 128) break;
                            int n10 = this.in.read();
                            int n11 = this.in.read();
                            if (n11 > (n7 -= 2)) continue block13;
                            switch (n10 & 0xC0) {
                                case 128: {
                                    l = this.getPts(-1);
                                    n11 -= 5;
                                    n7 -= 5;
                                    break;
                                }
                                case 192: {
                                    l = this.getPts(-1);
                                    l2 = this.getPts(-1);
                                    n11 -= 10;
                                    n7 -= 10;
                                }
                            }
                            n7 -= n11;
                            this.in.skip(n11);
                        }
                    }
                    if (n2 == 445) {
                        n2 = this.in.read();
                        --n7;
                        if (n2 >= 128 && n2 <= 191) {
                            this.in.skip(3L);
                            n7 -= 3;
                        }
                    }
                    if ((dataBuffer = this.streams[n2]) == null && (dataBuffer = this.allocateStream(n2)) == null) {
                        this.in.skip(n7);
                        break;
                    }
                    dataBuffer.readData(this.timeStamp, this.in, n7);
                }
            }
        } while (n != n2);
    }

    private DataBuffer allocateStream(int n) {
        DataBuffer dataBuffer;
        if (n >= 480 && n <= 495) {
            dataBuffer = new VideoTrack(this, n);
        } else if (n >= 448 && n <= 479) {
            dataBuffer = new VideoTrack(this, n);
        } else if (n >= 128 && n <= 159) {
            dataBuffer = new AudioTrack(this, n);
        } else if (n >= 160 && n <= 191) {
            dataBuffer = new AudioTrack(this, n);
        } else {
            return null;
        }
        this.streams[n] = dataBuffer;
        return dataBuffer;
    }

    protected synchronized void readVideo(int n, Buffer buffer) throws IOException {
        DataBuffer dataBuffer;
        do {
            if ((dataBuffer = this.streams[n]) != null && dataBuffer.getCurrentSize() != 0) continue;
            this.parse(128);
            dataBuffer = null;
        } while (dataBuffer == null);
        byte[] byArray = dataBuffer.getBuffer();
        byte[] byArray2 = (byte[])buffer.getData();
        buffer.setData((Object)byArray);
        buffer.setLength(dataBuffer.getCurrentSize());
        if (byArray2 != null) {
            dataBuffer.resetBuffer(byArray2);
        } else {
            dataBuffer.resetBuffer(new byte[byArray.length]);
        }
    }

    protected synchronized void readAudio(int n, Buffer buffer) throws IOException {
        DataBuffer dataBuffer;
        do {
            if ((dataBuffer = this.streams[n]) != null && dataBuffer.getCurrentSize() != 0) continue;
            this.parse(128);
        } while (dataBuffer == null);
        byte[] byArray = dataBuffer.getBuffer();
        byte[] byArray2 = (byte[])buffer.getData();
        buffer.setData((Object)byArray);
        buffer.setLength(dataBuffer.getCurrentSize());
        if (byArray2 != null) {
            dataBuffer.resetBuffer(byArray2);
        } else {
            dataBuffer.resetBuffer(new byte[byArray.length]);
        }
    }

    public void close() {
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return this.estimatedDuration;
    }

    public Time getMediaTime() {
        System.out.println("getMediaTime");
        return new Time(5000000L);
    }

    public String getName() {
        return "VOB demux";
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return new ContentDescriptor[]{new FileTypeDescriptor("video.vob")};
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        int n = 0;
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            ++n;
        }
        Track[] trackArray = new Track[n];
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            trackArray[--n] = (Track)this.streams[i];
        }
        return trackArray;
    }

    public boolean isPositionable() {
        return true;
    }

    public boolean isRandomAccess() {
        return true;
    }

    public void open() throws ResourceUnavailableException {
    }

    public void reset() {
    }

    public Time setPosition(Time time, int n) {
        for (int i = 0; i < this.streams.length; ++i) {
            if (this.streams[i] == null) continue;
            DataBuffer dataBuffer = this.streams[i];
            dataBuffer.drop();
        }
        try {
            this.seekSource.seek(time.getNanoseconds() * 540000L / 1000000000L);
            this.timeStamp = 0L;
            this.start();
            System.out.println("Aim for position " + time.getNanoseconds() / 1000000L + " actual " + this.timeStamp);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.startTime = 0L;
        return time;
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        if (dataSource instanceof PullDataSource) {
            PullSourceStream pullSourceStream;
            this.dataSource = pullSourceStream = ((PullDataSource)dataSource).getStreams()[0];
            if (pullSourceStream instanceof Seekable) {
                this.seekSource = (Seekable)pullSourceStream;
                this.estimatedDuration = new Time(1000L);
                try {
                    URL uRL;
                    MediaLocator mediaLocator = dataSource.getLocator();
                    if (mediaLocator != null && (uRL = mediaLocator.getURL()) != null) {
                        File file = new File(uRL.getFile());
                        this.totalFileSize = file.length();
                        this.estimatedDuration = new Time(this.totalFileSize * 1000000000L / 540000L);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.in = new PullSourceInputStream(pullSourceStream);
            return;
        }
        throw new IncompatibleSourceException();
    }

    public synchronized void start() throws IOException {
        this.parse(128);
        this.startTime = System.currentTimeMillis() - this.timeStamp - 4200L;
        this.parse(128);
        this.parse(128);
        this.parse(128);
        this.parse(128);
        this.parse(128);
        this.parse(128);
        this.parse(128);
        this.parse(128);
        this.parse(128);
        this.parse(128);
        this.parse(128);
    }

    public void stop() {
    }

    public final void setAudioTimeStamp(long l) {
        long l2 = System.currentTimeMillis() - this.startTime;
        if (l2 + 4200L < l) {
            this.startTime -= l - l2 - 4200L;
        }
        if (l2 >= l && l > 4200L) {
            this.startTime -= l - l2 - 4200L;
            return;
        }
        if (l2 + 100L > l && l > 4200L) {
            this.startTime -= l - l2 - 4200L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isVideoSlow(long l) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        long l2 = System.currentTimeMillis() - this.startTime;
        if (l < 1000L && l2 - l > 5000L) {
            this.startTime = System.currentTimeMillis();
            return false;
        }
        if (l <= l2) {
            return true;
        }
        if (l > l2 + 400L) {
            VobDemux vobDemux = this;
            synchronized (vobDemux) {
                try {
                    if (l - l2 - 15L < 200L) {
                        this.wait(l - l2 - 15L);
                    } else {
                        this.wait(100L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

