/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Store;

public class FifoMemoryStore
extends MemoryStore {
    private static final Logger LOG = Logger.getLogger(FifoMemoryStore.class.getName());

    public FifoMemoryStore(Ehcache cache, Store diskStore) {
        super(cache, diskStore);
        this.map = new LinkedHashMap();
    }

    protected final void doPut(Element element) throws CacheException {
        if (this.isFull()) {
            this.removeFirstElement();
        }
    }

    Element getFirstElement() {
        if (this.map.size() == 0) {
            return null;
        }
        Element element = null;
        Set keySet = this.map.keySet();
        Iterator itr = keySet.iterator();
        if (itr.hasNext()) {
            Serializable key = (Serializable)itr.next();
            element = (Element)this.map.get(key);
        }
        return element;
    }

    private void removeFirstElement() throws CacheException {
        Element element = this.getFirstElement();
        if (element.isExpired()) {
            this.remove(element.getObjectKey());
            this.notifyExpiry(element);
            return;
        }
        this.remove(element.getObjectKey());
        this.evict(element);
    }
}

