# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.40
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.
# This file is compatible with both classic and new-style classes.

from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_ogr', [dirname(__file__)])
        except ImportError:
            import _ogr
            return _ogr
        if fp is not None:
            try:
                _mod = imp.load_module('_ogr', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _ogr = swig_import_helper()
    del swig_import_helper
else:
    import _ogr
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


wkb25DBit = _ogr.wkb25DBit
wkb25Bit = _ogr.wkb25Bit
wkbUnknown = _ogr.wkbUnknown
wkbPoint = _ogr.wkbPoint
wkbLineString = _ogr.wkbLineString
wkbPolygon = _ogr.wkbPolygon
wkbMultiPoint = _ogr.wkbMultiPoint
wkbMultiLineString = _ogr.wkbMultiLineString
wkbMultiPolygon = _ogr.wkbMultiPolygon
wkbGeometryCollection = _ogr.wkbGeometryCollection
wkbNone = _ogr.wkbNone
wkbLinearRing = _ogr.wkbLinearRing
wkbPoint25D = _ogr.wkbPoint25D
wkbLineString25D = _ogr.wkbLineString25D
wkbPolygon25D = _ogr.wkbPolygon25D
wkbMultiPoint25D = _ogr.wkbMultiPoint25D
wkbMultiLineString25D = _ogr.wkbMultiLineString25D
wkbMultiPolygon25D = _ogr.wkbMultiPolygon25D
wkbGeometryCollection25D = _ogr.wkbGeometryCollection25D
OFTInteger = _ogr.OFTInteger
OFTIntegerList = _ogr.OFTIntegerList
OFTReal = _ogr.OFTReal
OFTRealList = _ogr.OFTRealList
OFTString = _ogr.OFTString
OFTStringList = _ogr.OFTStringList
OFTWideString = _ogr.OFTWideString
OFTWideStringList = _ogr.OFTWideStringList
OFTBinary = _ogr.OFTBinary
OFTDate = _ogr.OFTDate
OFTTime = _ogr.OFTTime
OFTDateTime = _ogr.OFTDateTime
OJUndefined = _ogr.OJUndefined
OJLeft = _ogr.OJLeft
OJRight = _ogr.OJRight
wkbXDR = _ogr.wkbXDR
wkbNDR = _ogr.wkbNDR
NullFID = _ogr.NullFID
OLCRandomRead = _ogr.OLCRandomRead
OLCSequentialWrite = _ogr.OLCSequentialWrite
OLCRandomWrite = _ogr.OLCRandomWrite
OLCFastSpatialFilter = _ogr.OLCFastSpatialFilter
OLCFastFeatureCount = _ogr.OLCFastFeatureCount
OLCFastGetExtent = _ogr.OLCFastGetExtent
OLCCreateField = _ogr.OLCCreateField
OLCTransactions = _ogr.OLCTransactions
OLCDeleteFeature = _ogr.OLCDeleteFeature
OLCFastSetNextByIndex = _ogr.OLCFastSetNextByIndex
OLCStringsAsUTF8 = _ogr.OLCStringsAsUTF8
OLCIgnoreFields = _ogr.OLCIgnoreFields
ODsCCreateLayer = _ogr.ODsCCreateLayer
ODsCDeleteLayer = _ogr.ODsCDeleteLayer
ODrCCreateDataSource = _ogr.ODrCCreateDataSource
ODrCDeleteDataSource = _ogr.ODrCDeleteDataSource

def GetUseExceptions(*args):
  """GetUseExceptions() -> int"""
  return _ogr.GetUseExceptions(*args)

def UseExceptions(*args):
  """UseExceptions()"""
  return _ogr.UseExceptions(*args)

def DontUseExceptions(*args):
  """DontUseExceptions()"""
  return _ogr.DontUseExceptions(*args)
import osr
class Driver(_object):
    """Proxy of C++ OGRDriverShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Driver, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Driver, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["name"] = _ogr.Driver_name_get
    if _newclass:name = _swig_property(_ogr.Driver_name_get)
    def CreateDataSource(self, *args, **kwargs):
        """
        CreateDataSource(self, char utf8_path, char options = None) -> DataSource

        OGRDataSourceH
        OGR_Dr_CreateDataSource(OGRSFDriverH hDriver, const char *pszName,
        char **papszOptions)

        This function attempts to create a new data source based on the passed
        driver.

        The papszOptions argument can be used to control driver specific
        creation options. These options are normally documented in the format
        specific documentation.

        It is important to call OGR_DS_Destroy() when the datasource is no
        longer used to ensure that all data has been properly flushed to disk.

        This function is the same as the C++ method
        OGRSFDriver::CreateDataSource().

        Parameters:
        -----------

        hDriver:  handle to the driver on which data source creation is based.

        pszName:  the name for the new data source.

        papszOptions:  a StringList of name=value options. Options are driver
        specific, and driver information can be found at the following
        url:http://www.gdal.org/ogr/ogr_formats.html

        NULL is returned on failure, or a new OGRDataSource handle on success.

        """
        return _ogr.Driver_CreateDataSource(self, *args, **kwargs)

    def CopyDataSource(self, *args, **kwargs):
        """
        CopyDataSource(self, DataSource copy_ds, char utf8_path, char options = None) -> DataSource

        OGRDataSourceH
        OGR_Dr_CopyDataSource(OGRSFDriverH hDriver, OGRDataSourceH hSrcDS,
        const char *pszNewName, char **papszOptions)

        This function creates a new datasource by copying all the layers from
        the source datasource.

        It is important to call OGR_DS_Destroy() when the datasource is no
        longer used to ensure that all data has been properly flushed to disk.

        This function is the same as the C++ method
        OGRSFDriver::CopyDataSource().

        Parameters:
        -----------

        hDriver:  handle to the driver on which data source creation is based.

        hSrcDS:  source datasource

        pszNewName:  the name for the new data source.

        papszOptions:  a StringList of name=value options. Options are driver
        specific, and driver information can be found at the following
        url:http://www.gdal.org/ogr/ogr_formats.html

        NULL is returned on failure, or a new OGRDataSource handle on success.

        """
        return _ogr.Driver_CopyDataSource(self, *args, **kwargs)

    def Open(self, *args, **kwargs):
        """
        Open(self, char utf8_path, int update = 0) -> DataSource

        OGRDataSourceH OGR_Dr_Open(OGRSFDriverH
        hDriver, const char *pszName, int bUpdate)

        Attempt to open file with this driver.

        This function is the same as the C++ method OGRSFDriver::Open().

        Parameters:
        -----------

        hDriver:  handle to the driver that is used to open file.

        pszName:  the name of the file, or data source to try and open.

        bUpdate:  TRUE if update access is required, otherwise FALSE (the
        default).

        NULL on error or if the pass name is not supported by this driver,
        otherwise an handle to an OGRDataSource. This OGRDataSource should be
        closed by deleting the object when it is no longer needed. 
        """
        return _ogr.Driver_Open(self, *args, **kwargs)

    def DeleteDataSource(self, *args):
        """
        DeleteDataSource(self, char utf8_path) -> int

        OGRErr
        OGR_Dr_DeleteDataSource(OGRSFDriverH hDriver, const char
        *pszDataSource)

        Delete a datasource.

        Delete (from the disk, in the database, ...) the named datasource.
        Normally it would be safest if the datasource was not open at the
        time.

        Whether this is a supported operation on this driver case be tested
        using TestCapability() on ODrCDeleteDataSource.

        This method is the same as the C++ method
        OGRSFDriver::DeleteDataSource().

        Parameters:
        -----------

        hDriver:  handle to the driver on which data source deletion is based.

        pszDataSource:  the name of the datasource to delete.

        OGRERR_NONE on success, and OGRERR_UNSUPPORTED_OPERATION if this is
        not supported by this driver. 
        """
        return _ogr.Driver_DeleteDataSource(self, *args)

    def TestCapability(self, *args):
        """
        TestCapability(self, char cap) -> bool

        int
        OGR_Dr_TestCapability(OGRSFDriverH hDriver, const char *pszCap)

        Test if capability is available.

        One of the following data source capability names can be passed into
        this function, and a TRUE or FALSE value will be returned indicating
        whether or not the capability is available for this object.

        ODrCCreateDataSource: True if this driver can support creating data
        sources.

        ODrCDeleteDataSource: True if this driver supports deleting data
        sources.

        The #define macro forms of the capability names should be used in
        preference to the strings themselves to avoid mispelling.

        This function is the same as the C++ method
        OGRSFDriver::TestCapability().

        Parameters:
        -----------

        hDriver:  handle to the driver to test the capability against.

        pszCap:  the capability to test.

        TRUE if capability available otherwise FALSE. 
        """
        return _ogr.Driver_TestCapability(self, *args)

    def GetName(self, *args):
        """
        GetName(self) -> char

        const char*
        OGR_Dr_GetName(OGRSFDriverH hDriver)

        Fetch name of driver (file format). This name should be relatively
        short (10-40 characters), and should reflect the underlying file
        format. For instance "ESRI Shapefile".

        This function is the same as the C++ method OGRSFDriver::GetName().

        Parameters:
        -----------

        hDriver:  handle to the the driver to get the name from.

        driver name. This is an internal string and should not be modified or
        freed. 
        """
        return _ogr.Driver_GetName(self, *args)

    def Register(self, *args):
        """Register(self)"""
        return _ogr.Driver_Register(self, *args)

    def Deregister(self, *args):
        """Deregister(self)"""
        return _ogr.Driver_Deregister(self, *args)

Driver_swigregister = _ogr.Driver_swigregister
Driver_swigregister(Driver)

class DataSource(_object):
    """Proxy of C++ OGRDataSourceShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DataSource, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DataSource, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_getmethods__["name"] = _ogr.DataSource_name_get
    if _newclass:name = _swig_property(_ogr.DataSource_name_get)
    __swig_destroy__ = _ogr.delete_DataSource
    __del__ = lambda self : None;
    def GetRefCount(self, *args):
        """
        GetRefCount(self) -> int

        int
        OGR_DS_GetRefCount(OGRDataSourceH hDataSource) 
        """
        return _ogr.DataSource_GetRefCount(self, *args)

    def GetSummaryRefCount(self, *args):
        """
        GetSummaryRefCount(self) -> int

        int
        OGR_DS_GetSummaryRefCount(OGRDataSourceH hDataSource) 
        """
        return _ogr.DataSource_GetSummaryRefCount(self, *args)

    def GetLayerCount(self, *args):
        """
        GetLayerCount(self) -> int

        int
        OGR_DS_GetLayerCount(OGRDataSourceH hDS)

        Get the number of layers in this data source.

        This function is the same as the C++ method
        OGRDataSource::GetLayerCount().

        Parameters:
        -----------

        hDS:  handle to the data source from which to get the number of
        layers.

        layer count. 
        """
        return _ogr.DataSource_GetLayerCount(self, *args)

    def GetDriver(self, *args):
        """
        GetDriver(self) -> Driver

        OGRSFDriverH
        OGR_DS_GetDriver(OGRDataSourceH hDS)

        Returns the driver that the dataset was opened with.

        This method is the same as the C++ method OGRDataSource::GetDriver()

        Parameters:
        -----------

        hDS:  handle to the datasource

        NULL if driver info is not available, or pointer to a driver owned by
        the OGRSFDriverManager. 
        """
        return _ogr.DataSource_GetDriver(self, *args)

    def GetName(self, *args):
        """
        GetName(self) -> char

        const char*
        OGR_DS_GetName(OGRDataSourceH hDS)

        Returns the name of the data source.

        This string should be sufficient to open the data source if passed to
        the same OGRSFDriver that this data source was opened with, but it
        need not be exactly the same string that was used to open the data
        source. Normally this is a filename.

        This function is the same as the C++ method OGRDataSource::GetName().

        Parameters:
        -----------

        hDS:  handle to the data source to get the name from.

        pointer to an internal name string which should not be modified or
        freed by the caller. 
        """
        return _ogr.DataSource_GetName(self, *args)

    def DeleteLayer(self, *args):
        """
        DeleteLayer(self, int index) -> OGRErr

        OGRErr
        OGR_DS_DeleteLayer(OGRDataSourceH hDS, int iLayer)

        Delete the indicated layer from the datasource.

        If this method is supported the ODsCDeleteLayer capability will test
        TRUE on the OGRDataSource.

        This method is the same as the C++ method
        OGRDataSource::DeleteLayer().

        Parameters:
        -----------

        hDS:  handle to the datasource

        iLayer:  the index of the layer to delete.

        OGRERR_NONE on success, or OGRERR_UNSUPPORTED_OPERATION if deleting
        layers is not supported for this datasource. 
        """
        return _ogr.DataSource_DeleteLayer(self, *args)

    def CreateLayer(self, *args, **kwargs):
        """
        CreateLayer(self, char name, SpatialReference srs = None, OGRwkbGeometryType geom_type = wkbUnknown, 
            char options = None) -> Layer

        OGRLayerH
        OGR_DS_CreateLayer(OGRDataSourceH hDS, const char *pszName,
        OGRSpatialReferenceH hSpatialRef, OGRwkbGeometryType eType, char
        **papszOptions)

        This function attempts to create a new layer on the data source with
        the indicated name, coordinate system, geometry type.

        The papszOptions argument can be used to control driver specific
        creation options. These options are normally documented in the format
        specific documentation.

        This function is the same as the C++ method
        OGRDataSource::CreateLayer().

        Parameters:
        -----------

        hDS:  The dataset handle.

        pszName:  the name for the new layer. This should ideally not match
        any existing layer on the datasource.

        hSpatialRef:  handle to the coordinate system to use for the new
        layer, or NULL if no coordinate system is available.

        eType:  the geometry type for the layer. Use wkbUnknown if there are
        no constraints on the types geometry to be written.

        papszOptions:  a StringList of name=value options. Options are driver
        specific, and driver information can be found at the following
        url:http://www.gdal.org/ogr/ogr_formats.html

        NULL is returned on failure, or a new OGRLayer handle on success.
        Example: 
        """
        return _ogr.DataSource_CreateLayer(self, *args, **kwargs)

    def CopyLayer(self, *args, **kwargs):
        """
        CopyLayer(self, Layer src_layer, char new_name, char options = None) -> Layer

        OGRLayerH
        OGR_DS_CopyLayer(OGRDataSourceH hDS, OGRLayerH hSrcLayer, const char
        *pszNewName, char **papszOptions)

        Duplicate an existing layer.

        This function creates a new layer, duplicate the field definitions of
        the source layer and then duplicate each features of the source layer.
        The papszOptions argument can be used to control driver specific
        creation options. These options are normally documented in the format
        specific documentation. The source layer may come from another
        dataset.

        This function is the same as the C++ method OGRDataSource::CopyLayer

        Parameters:
        -----------

        hDS:  handle to the data source where to create the new layer

        hSrcLayer:  handle to the source layer.

        pszNewName:  the name of the layer to create.

        papszOptions:  a StringList of name=value options. Options are driver
        specific.

        an handle to the layer, or NULL if an error occurs. 
        """
        return _ogr.DataSource_CopyLayer(self, *args, **kwargs)

    def GetLayerByIndex(self, *args):
        """GetLayerByIndex(self, int index = 0) -> Layer"""
        return _ogr.DataSource_GetLayerByIndex(self, *args)

    def GetLayerByName(self, *args):
        """
        GetLayerByName(self, char layer_name) -> Layer

        OGRLayerH
        OGR_DS_GetLayerByName(OGRDataSourceH hDS, const char *pszName)

        Fetch a layer by name.

        The returned layer remains owned by the OGRDataSource and should not
        be deleted by the application.

        This function is the same as the C++ method
        OGRDataSource::GetLayerByName().

        Parameters:
        -----------

        hDS:  handle to the data source from which to get the layer.

        pszLayerName:  Layer the layer name of the layer to fetch.

        an handle to the layer, or NULL if the layer is not found or an error
        occurs. 
        """
        return _ogr.DataSource_GetLayerByName(self, *args)

    def TestCapability(self, *args):
        """
        TestCapability(self, char cap) -> bool

        int
        OGR_DS_TestCapability(OGRDataSourceH hDS, const char *pszCap)

        Test if capability is available.

        One of the following data source capability names can be passed into
        this function, and a TRUE or FALSE value will be returned indicating
        whether or not the capability is available for this object.

        ODsCCreateLayer: True if this datasource can create new layers.

        The #define macro forms of the capability names should be used in
        preference to the strings themselves to avoid mispelling.

        This function is the same as the C++ method
        OGRDataSource::TestCapability().

        Parameters:
        -----------

        hDS:  handle to the data source against which to test the capability.

        pszCapability:  the capability to test.

        TRUE if capability available otherwise FALSE. 
        """
        return _ogr.DataSource_TestCapability(self, *args)

    def ExecuteSQL(self, *args, **kwargs):
        """
        ExecuteSQL(self, char statement, Geometry spatialFilter = None, char dialect = "") -> Layer

        OGRLayerH
        OGR_DS_ExecuteSQL(OGRDataSourceH hDS, const char *pszStatement,
        OGRGeometryH hSpatialFilter, const char *pszDialect)

        Execute an SQL statement against the data store.

        The result of an SQL query is either NULL for statements that are in
        error, or that have no results set, or an OGRLayer handle representing
        a results set from the query. Note that this OGRLayer is in addition
        to the layers in the data store and must be destroyed with
        OGR_DS_ReleaseResultsSet() before the data source is closed
        (destroyed).

        For more information on the SQL dialect supported internally by OGR
        review theOGR SQL document. Some drivers (ie. Oracle and PostGIS) pass
        the SQL directly through to the underlying RDBMS.

        This function is the same as the C++ method
        OGRDataSource::ExecuteSQL();

        Parameters:
        -----------

        hDS:  handle to the data source on which the SQL query is executed.

        pszSQLCommand:  the SQL statement to execute.

        hSpatialFilter:  handle to a geometry which represents a spatial
        filter.

        pszDialect:  allows control of the statement dialect. By default it is
        assumed to be "generic" SQL, whatever that is.

        an handle to a OGRLayer containing the results of the query.
        Deallocate with OGR_DS_ReleaseResultsSet(). 
        """
        return _ogr.DataSource_ExecuteSQL(self, *args, **kwargs)

    def ReleaseResultSet(self, *args):
        """
        ReleaseResultSet(self, Layer layer)

        void
        OGR_DS_ReleaseResultSet(OGRDataSourceH hDS, OGRLayerH hLayer)

        Release results of OGR_DS_ExecuteSQL().

        This function should only be used to deallocate OGRLayers resulting
        from an OGR_DS_ExecuteSQL() call on the same OGRDataSource. Failure to
        deallocate a results set before destroying the OGRDataSource may cause
        errors.

        This function is the same as the C++ method
        OGRDataSource::ReleaseResultsSet().

        Parameters:
        -----------

        hDS:  an handle to the data source on which was executed an SQL query.

        hLayer:  handle to the result of a previous OGR_DS_ExecuteSQL() call.

        """
        return _ogr.DataSource_ReleaseResultSet(self, *args)

    def Destroy(self):
      "Once called, self has effectively been destroyed.  Do not access. For backwards compatiblity only"
      _ogr.delete_DataSource( self )
      self.thisown = 0

    def Release(self):
      "Once called, self has effectively been destroyed.  Do not access. For backwards compatiblity only"
      _ogr.delete_DataSource( self )
      self.thisown = 0

    def Reference(self):
      "For backwards compatibility only."
      return self.Reference()

    def Dereference(self):
      "For backwards compatibility only."
      self.Dereference()

    def __len__(self):
        """Returns the number of layers on the datasource"""
        return self.GetLayerCount()

    def __getitem__(self, value):
        """Support dictionary, list, and slice -like access to the datasource.
    ] would return the first layer on the datasource.
    aname'] would return the layer named "aname".
    :4] would return a list of the first four layers."""
        import types
        if isinstance(value, slice):
            output = []
            for i in xrange(value.start,value.stop,value.step):
                try:
                    output.append(self.GetLayer(i))
                except OGRError: #we're done because we're off the end
                    return output
            return output
        if isinstance(value, int):
            if value > len(self)-1:
                raise IndexError
            return self.GetLayer(value)
        elif isinstance(value, str):
            return self.GetLayer(value)
        else:
            raise TypeError('Input %s is not of String or Int type' % type(value))

    def GetLayer(self,iLayer=0):
        """Return the layer given an index or a name"""
        import types
        if isinstance(iLayer, str):
            return self.GetLayerByName(str(iLayer))
        elif isinstance(iLayer, int):
            return self.GetLayerByIndex(iLayer)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(iLayer))

    def DeleteLayer(self, value):
        """Deletes the layer given an index or layer name"""
        import types
        if isinstance(value, str):
            for i in range(self.GetLayerCount()):
                name = self.GetLayer(i).GetName()
                if name == value:
                    return _ogr.DataSource_DeleteLayer(self, i)
            raise ValueError("Layer %s not found to delete" % value)
        elif isinstance(value, int):
            return _ogr.DataSource_DeleteLayer(self, value)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(iLayer))

DataSource_swigregister = _ogr.DataSource_swigregister
DataSource_swigregister(DataSource)

class Layer(_object):
    """Proxy of C++ OGRLayerShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Layer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Layer, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    def GetRefCount(self, *args):
        """
        GetRefCount(self) -> int

        int OGR_L_GetRefCount(OGRLayerH
        hLayer) 
        """
        return _ogr.Layer_GetRefCount(self, *args)

    def SetSpatialFilter(self, *args):
        """
        SetSpatialFilter(self, Geometry filter)

        void
        OGR_L_SetSpatialFilter(OGRLayerH hLayer, OGRGeometryH hGeom)

        Set a new spatial filter.

        This function set the geometry to be used as a spatial filter when
        fetching features via the OGR_L_GetNextFeature() function. Only
        features that geometrically intersect the filter geometry will be
        returned.

        Currently this test is may be inaccurately implemented, but it is
        guaranteed that all features who's envelope (as returned by
        OGR_G_GetEnvelope()) overlaps the envelope of the spatial filter will
        be returned. This can result in more shapes being returned that should
        strictly be the case.

        This function makes an internal copy of the passed geometry. The
        passed geometry remains the responsibility of the caller, and may be
        safely destroyed.

        For the time being the passed filter geometry should be in the same
        SRS as the layer (as returned by OGR_L_GetSpatialRef()). In the future
        this may be generalized.

        This function is the same as the C++ method
        OGRLayer::SetSpatialFilter.

        Parameters:
        -----------

        hLayer:  handle to the layer on which to set the spatial filter.

        hGeom:  handle to the geometry to use as a filtering region. NULL may
        be passed indicating that the current spatial filter should be
        cleared, but no new one instituted. 
        """
        return _ogr.Layer_SetSpatialFilter(self, *args)

    def SetSpatialFilterRect(self, *args):
        """
        SetSpatialFilterRect(self, double minx, double miny, double maxx, double maxy)

        void
        OGR_L_SetSpatialFilterRect(OGRLayerH hLayer, double dfMinX, double
        dfMinY, double dfMaxX, double dfMaxY)

        Set a new rectangular spatial filter.

        This method set rectangle to be used as a spatial filter when fetching
        features via the OGR_L_GetNextFeature() method. Only features that
        geometrically intersect the given rectangle will be returned.

        The x/y values should be in the same coordinate system as the layer as
        a whole (as returned by OGRLayer::GetSpatialRef()). Internally this
        method is normally implemented as creating a 5 vertex closed
        rectangular polygon and passing it to OGRLayer::SetSpatialFilter(). It
        exists as a convenience.

        The only way to clear a spatial filter set with this method is to call
        OGRLayer::SetSpatialFilter(NULL).

        This method is the same as the C++ method
        OGRLayer::SetSpatialFilterRect().

        Parameters:
        -----------

        hLayer:  handle to the layer on which to set the spatial filter.

        dfMinX:  the minimum X coordinate for the rectangular region.

        dfMinY:  the minimum Y coordinate for the rectangular region.

        dfMaxX:  the maximum X coordinate for the rectangular region.

        dfMaxY:  the maximum Y coordinate for the rectangular region. 
        """
        return _ogr.Layer_SetSpatialFilterRect(self, *args)

    def GetSpatialFilter(self, *args):
        """
        GetSpatialFilter(self) -> Geometry

        OGRGeometryH
        OGR_L_GetSpatialFilter(OGRLayerH hLayer)

        This function returns the current spatial filter for this layer.

        The returned pointer is to an internally owned object, and should not
        be altered or deleted by the caller.

        This function is the same as the C++ method
        OGRLayer::GetSpatialFilter().

        Parameters:
        -----------

        hLayer:  handle to the layer to get the spatial filter from.

        an handle to the spatial filter geometry. 
        """
        return _ogr.Layer_GetSpatialFilter(self, *args)

    def SetAttributeFilter(self, *args):
        """
        SetAttributeFilter(self, char filter_string) -> OGRErr

        OGRErr
        OGR_L_SetAttributeFilter(OGRLayerH hLayer, const char *pszQuery)

        Set a new attribute query.

        This function sets the attribute query string to be used when fetching
        features via the OGR_L_GetNextFeature() function. Only features for
        which the query evaluates as true will be returned.

        The query string should be in the format of an SQL WHERE clause. For
        instance "population > 1000000 and population < 5000000" where
        population is an attribute in the layer. The query format is a
        restricted form of SQL WHERE clause as defined
        "eq_format=restricted_where" about half way through this document:

        http://ogdi.sourceforge.net/prop/6.2.CapabilitiesMetadata.html

        Note that installing a query string will generally result in resetting
        the current reading position (ala OGR_L_ResetReading()).

        This function is the same as the C++ method
        OGRLayer::SetAttributeFilter().

        Parameters:
        -----------

        hLayer:  handle to the layer on which attribute query will be
        executed.

        pszQuery:  query in restricted SQL WHERE format, or NULL to clear the
        current query.

        OGRERR_NONE if successfully installed, or an error code if the query
        expression is in error, or some other failure occurs. 
        """
        return _ogr.Layer_SetAttributeFilter(self, *args)

    def ResetReading(self, *args):
        """
        ResetReading(self)

        void
        OGR_L_ResetReading(OGRLayerH hLayer)

        Reset feature reading to start on the first feature.

        This affects GetNextFeature().

        This function is the same as the C++ method OGRLayer::ResetReading().

        Parameters:
        -----------

        hLayer:  handle to the layer on which features are read. 
        """
        return _ogr.Layer_ResetReading(self, *args)

    def GetName(self, *args):
        """GetName(self) -> char"""
        return _ogr.Layer_GetName(self, *args)

    def GetGeomType(self, *args):
        """GetGeomType(self) -> OGRwkbGeometryType"""
        return _ogr.Layer_GetGeomType(self, *args)

    def GetGeometryColumn(self, *args):
        """
        GetGeometryColumn(self) -> char

        const char*
        OGR_L_GetGeometryColumn(OGRLayerH hLayer)

        This method returns the name of the underlying database column being
        used as the geometry column, or "" if not supported.

        This method is the same as the C++ method
        OGRLayer::GetGeometryColumn()

        Parameters:
        -----------

        hLayer:  handle to the layer

        geometry column name. 
        """
        return _ogr.Layer_GetGeometryColumn(self, *args)

    def GetFIDColumn(self, *args):
        """
        GetFIDColumn(self) -> char

        const char*
        OGR_L_GetFIDColumn(OGRLayerH hLayer)

        This method returns the name of the underlying database column being
        used as the FID column, or "" if not supported.

        This method is the same as the C++ method OGRLayer::GetFIDColumn()

        Parameters:
        -----------

        hLayer:  handle to the layer

        fid column name. 
        """
        return _ogr.Layer_GetFIDColumn(self, *args)

    def GetFeature(self, *args):
        """
        GetFeature(self, long fid) -> Feature

        OGRFeatureH
        OGR_L_GetFeature(OGRLayerH hLayer, long nFeatureId)

        Fetch a feature by its identifier.

        This function will attempt to read the identified feature. The nFID
        value cannot be OGRNullFID. Success or failure of this operation is
        unaffected by the spatial or attribute filters.

        If this function returns a non-NULL feature, it is guaranteed that its
        feature id ( OGR_F_GetFID()) will be the same as nFID.

        Use OGR_L_TestCapability(OLCRandomRead) to establish if this layer
        supports efficient random access reading via OGR_L_GetFeature();
        however, the call should always work if the feature exists as a
        fallback implementation just scans all the features in the layer
        looking for the desired feature.

        Sequential reads are generally considered interrupted by a
        OGR_L_GetFeature() call.

        The returned feature should be free with OGR_F_Destroy().

        This function is the same as the C++ method OGRLayer::GetFeature( ).

        Parameters:
        -----------

        hLayer:  handle to the layer that owned the feature.

        nFeatureId:  the feature id of the feature to read.

        an handle to a feature now owned by the caller, or NULL on failure. 
        """
        return _ogr.Layer_GetFeature(self, *args)

    def GetNextFeature(self, *args):
        """
        GetNextFeature(self) -> Feature

        OGRFeatureH
        OGR_L_GetNextFeature(OGRLayerH hLayer)

        Fetch the next available feature from this layer.

        The returned feature becomes the responsiblity of the caller to delete
        with OGR_F_Destroy(). It is critical that all features associated with
        an OGRLayer (more specifically an OGRFeatureDefn) be deleted before
        that layer/datasource is deleted.

        Only features matching the current spatial filter (set with
        SetSpatialFilter()) will be returned.

        This function implements sequential access to the features of a layer.
        The OGR_L_ResetReading() function can be used to start at the
        beginning again. Random reading, writing and spatial filtering will be
        added to the OGRLayer in the future.

        This function is the same as the C++ method
        OGRLayer::GetNextFeature().

        Parameters:
        -----------

        hLayer:  handle to the layer from which feature are read.

        an handle to a feature, or NULL if no more features are available. 
        """
        return _ogr.Layer_GetNextFeature(self, *args)

    def SetNextByIndex(self, *args):
        """
        SetNextByIndex(self, long new_index) -> OGRErr

        OGRErr
        OGR_L_SetNextByIndex(OGRLayerH hLayer, long nIndex)

        Move read cursor to the nIndex'th feature in the current resultset.

        This method allows positioning of a layer such that the
        GetNextFeature() call will read the requested feature, where nIndex is
        an absolute index into the current result set. So, setting it to 3
        would mean the next feature read with GetNextFeature() would have been
        the 4th feature to have been read if sequential reading took place
        from the beginning of the layer, including accounting for spatial and
        attribute filters.

        Only in rare circumstances is SetNextByIndex() efficiently
        implemented. In all other cases the default implementation which calls
        ResetReading() and then calls GetNextFeature() nIndex times is used.
        To determine if fast seeking is available on the current layer use the
        TestCapability() method with a value of OLCFastSetNextByIndex.

        This method is the same as the C++ method OGRLayer::SetNextByIndex()

        Parameters:
        -----------

        hLayer:  handle to the layer

        nIndex:  the index indicating how many steps into the result set to
        seek.

        OGRERR_NONE on success or an error code. 
        """
        return _ogr.Layer_SetNextByIndex(self, *args)

    def SetFeature(self, *args):
        """
        SetFeature(self, Feature feature) -> OGRErr

        OGRErr OGR_L_SetFeature(OGRLayerH
        hLayer, OGRFeatureH hFeat)

        Rewrite an existing feature.

        This function will write a feature to the layer, based on the feature
        id within the OGRFeature.

        Use OGR_L_TestCapability(OLCRandomWrite) to establish if this layer
        supports random access writing via OGR_L_SetFeature().

        This function is the same as the C++ method OGRLayer::SetFeature().

        Parameters:
        -----------

        hLayer:  handle to the layer to write the feature.

        hFeat:  the feature to write.

        OGRERR_NONE if the operation works, otherwise an appropriate error
        code. 
        """
        return _ogr.Layer_SetFeature(self, *args)

    def CreateFeature(self, *args):
        """
        CreateFeature(self, Feature feature) -> OGRErr

        OGRErr
        OGR_L_CreateFeature(OGRLayerH hLayer, OGRFeatureH hFeat)

        Create and write a new feature within a layer.

        The passed feature is written to the layer as a new feature, rather
        than overwriting an existing one. If the feature has a feature id
        other than OGRNullFID, then the native implementation may use that as
        the feature id of the new feature, but not necessarily. Upon
        successful return the passed feature will have been updated with the
        new feature id.

        This function is the same as the C++ method OGRLayer::CreateFeature().

        Parameters:
        -----------

        hLayer:  handle to the layer to write the feature to.

        hFeat:  the handle of the feature to write to disk.

        OGRERR_NONE on success. 
        """
        return _ogr.Layer_CreateFeature(self, *args)

    def DeleteFeature(self, *args):
        """
        DeleteFeature(self, long fid) -> OGRErr

        OGRErr
        OGR_L_DeleteFeature(OGRLayerH hDS, long nFID)

        Delete feature from layer.

        The feature with the indicated feature id is deleted from the layer if
        supported by the driver. Most drivers do not support feature deletion,
        and will return OGRERR_UNSUPPORTED_OPERATION. The
        OGR_L_TestCapability() function may be called with OLCDeleteFeature to
        check if the driver supports feature deletion.

        This method is the same as the C++ method OGRLayer::DeleteFeature().

        Parameters:
        -----------

        hLayer:  handle to the layer

        nFID:  the feature id to be deleted from the layer

        OGRERR_NONE on success. 
        """
        return _ogr.Layer_DeleteFeature(self, *args)

    def SyncToDisk(self, *args):
        """
        SyncToDisk(self) -> OGRErr

        OGRErr OGR_L_SyncToDisk(OGRLayerH
        hDS)

        Flush pending changes to disk.

        This call is intended to force the layer to flush any pending writes
        to disk, and leave the disk file in a consistent state. It would not
        normally have any effect on read-only datasources.

        Some layers do not implement this method, and will still return
        OGRERR_NONE. The default implementation just returns OGRERR_NONE. An
        error is only returned if an error occurs while attempting to flush to
        disk.

        In any event, you should always close any opened datasource with
        OGR_DS_Destroy() that will ensure all data is correctly flushed.

        This method is the same as the C++ method OGRLayer::SyncToDisk()

        Parameters:
        -----------

        hLayer:  handle to the layer

        OGRERR_NONE if no error occurs (even if nothing is done) or an error
        code. 
        """
        return _ogr.Layer_SyncToDisk(self, *args)

    def GetLayerDefn(self, *args):
        """
        GetLayerDefn(self) -> FeatureDefn

        OGRFeatureDefnH
        OGR_L_GetLayerDefn(OGRLayerH hLayer)

        Fetch the schema information for this layer.

        The returned handle to the OGRFeatureDefn is owned by the OGRLayer,
        and should not be modified or freed by the application. It
        encapsulates the attribute schema of the features of the layer.

        This function is the same as the C++ method OGRLayer::GetLayerDefn().

        Parameters:
        -----------

        hLayer:  handle to the layer to get the schema information.

        an handle to the feature definition. 
        """
        return _ogr.Layer_GetLayerDefn(self, *args)

    def GetFeatureCount(self, *args, **kwargs):
        """
        GetFeatureCount(self, int force = 1) -> int

        int
        OGR_L_GetFeatureCount(OGRLayerH hLayer, int bForce)

        Fetch the feature count in this layer.

        Returns the number of features in the layer. For dynamic databases the
        count may not be exact. If bForce is FALSE, and it would be expensive
        to establish the feature count a value of -1 may be returned
        indicating that the count isn't know. If bForce is TRUE some
        implementations will actually scan the entire layer once to count
        objects.

        The returned count takes the spatial filter into account.

        This function is the same as the CPP OGRLayer::GetFeatureCount().

        Parameters:
        -----------

        hLayer:  handle to the layer that owned the features.

        bForce:  Flag indicating whether the count should be computed even if
        it is expensive.

        feature count, -1 if count not known. 
        """
        return _ogr.Layer_GetFeatureCount(self, *args, **kwargs)

    def GetExtent(self, *args, **kwargs):
        """
        GetExtent(self, int force = 1) -> OGRErr

        OGRErr OGR_L_GetExtent(OGRLayerH
        hLayer, OGREnvelope *psExtent, int bForce)

        Fetch the extent of this layer.

        Returns the extent (MBR) of the data in the layer. If bForce is FALSE,
        and it would be expensive to establish the extent then OGRERR_FAILURE
        will be returned indicating that the extent isn't know. If bForce is
        TRUE then some implementations will actually scan the entire layer
        once to compute the MBR of all the features in the layer.

        Depending on the drivers, the returned extent may or may not take the
        spatial filter into account. So it is safer to call OGR_L_GetExtent()
        without setting a spatial filter.

        Layers without any geometry may return OGRERR_FAILURE just indicating
        that no meaningful extents could be collected.

        This function is the same as the C++ method OGRLayer::GetExtent().

        Parameters:
        -----------

        hLayer:  handle to the layer from which to get extent.

        psExtent:  the structure in which the extent value will be returned.

        bForce:  Flag indicating whether the extent should be computed even if
        it is expensive.

        OGRERR_NONE on success, OGRERR_FAILURE if extent not known. 
        """
        return _ogr.Layer_GetExtent(self, *args, **kwargs)

    def TestCapability(self, *args):
        """
        TestCapability(self, char cap) -> bool

        int
        OGR_L_TestCapability(OGRLayerH hLayer, const char *pszCap)

        Test if this layer supported the named capability.

        The capability codes that can be tested are represented as strings,
        but #defined constants exists to ensure correct spelling. Specific
        layer types may implement class specific capabilities, but this can't
        generally be discovered by the caller.

        OLCRandomRead / "RandomRead": TRUE if the GetFeature() method is
        implemented in an optimized way for this layer, as opposed to the
        default implementation using ResetReading() and GetNextFeature() to
        find the requested feature id.

        OLCSequentialWrite / "SequentialWrite": TRUE if the CreateFeature()
        method works for this layer. Note this means that this particular
        layer is writable. The same OGRLayer class may returned FALSE for
        other layer instances that are effectively read-only.

        OLCRandomWrite / "RandomWrite": TRUE if the SetFeature() method is
        operational on this layer. Note this means that this particular layer
        is writable. The same OGRLayer class may returned FALSE for other
        layer instances that are effectively read-only.

        OLCFastSpatialFilter / "FastSpatialFilter": TRUE if this layer
        implements spatial filtering efficiently. Layers that effectively read
        all features, and test them with the OGRFeature intersection methods
        should return FALSE. This can be used as a clue by the application
        whether it should build and maintain its own spatial index for
        features in this layer.

        OLCFastFeatureCount / "FastFeatureCount": TRUE if this layer can
        return a feature count (via OGR_L_GetFeatureCount()) efficiently ...
        ie. without counting the features. In some cases this will return TRUE
        until a spatial filter is installed after which it will return FALSE.

        OLCFastGetExtent / "FastGetExtent": TRUE if this layer can return
        its data extent (via OGR_L_GetExtent()) efficiently ... ie. without
        scanning all the features. In some cases this will return TRUE until a
        spatial filter is installed after which it will return FALSE.

        OLCFastSetNextByIndex / "FastSetNextByIndex": TRUE if this layer can
        perform the SetNextByIndex() call efficiently, otherwise FALSE.

        OLCCreateField / "CreateField": TRUE if this layer can create new
        fields on the current layer using CreateField(), otherwise FALSE.

        OLCDeleteFeature / "DeleteFeature": TRUE if the DeleteFeature()
        method is supported on this layer, otherwise FALSE.

        OLCStringsAsUTF8 / "StringsAsUTF8": TRUE if values of OFTString
        fields are assured to be in UTF-8 format. If FALSE the encoding of
        fields is uncertain, though it might still be UTF-8.

        OLCTransactions / "Transactions": TRUE if the StartTransaction(),
        CommitTransaction() and RollbackTransaction() methods work in a
        meaningful way, otherwise FALSE.

        This function is the same as the C++ method
        OGRLayer::TestCapability().

        Parameters:
        -----------

        hLayer:  handle to the layer to get the capability from.

        pszCap:  the name of the capability to test.

        TRUE if the layer has the requested capability, or FALSE otherwise.
        OGRLayers will return FALSE for any unrecognised capabilities. 
        """
        return _ogr.Layer_TestCapability(self, *args)

    def CreateField(self, *args, **kwargs):
        """
        CreateField(self, FieldDefn field_def, int approx_ok = 1) -> OGRErr

        OGRErr
        OGR_L_CreateField(OGRLayerH hLayer, OGRFieldDefnH hField, int
        bApproxOK)

        Create a new field on a layer.

        You must use this to create new fields on a real layer. Internally the
        OGRFeatureDefn for the layer will be updated to reflect the new field.
        Applications should never modify the OGRFeatureDefn used by a layer
        directly.

        This function is the same as the C++ method OGRLayer::CreateField().

        Parameters:
        -----------

        hLayer:  handle to the layer to write the field definition.

        hField:  handle of the field definition to write to disk.

        bApproxOK:  If TRUE, the field may be created in a slightly different
        form depending on the limitations of the format driver.

        OGRERR_NONE on success. 
        """
        return _ogr.Layer_CreateField(self, *args, **kwargs)

    def StartTransaction(self, *args):
        """
        StartTransaction(self) -> OGRErr

        OGRErr
        OGR_L_StartTransaction(OGRLayerH hLayer)

        For datasources which support transactions, StartTransaction creates a
        transaction.

        If starting the transaction fails, will return OGRERR_FAILURE.
        Datasources which do not support transactions will always return
        OGRERR_NONE.

        This function is the same as the C++ method
        OGRLayer::StartTransaction().

        Parameters:
        -----------

        hLayer:  handle to the layer

        OGRERR_NONE on success. 
        """
        return _ogr.Layer_StartTransaction(self, *args)

    def CommitTransaction(self, *args):
        """
        CommitTransaction(self) -> OGRErr

        OGRErr
        OGR_L_CommitTransaction(OGRLayerH hLayer)

        For datasources which support transactions, CommitTransaction commits
        a transaction.

        If no transaction is active, or the commit fails, will return
        OGRERR_FAILURE. Datasources which do not support transactions will
        always return OGRERR_NONE.

        This function is the same as the C++ method
        OGRLayer::CommitTransaction().

        Parameters:
        -----------

        hLayer:  handle to the layer

        OGRERR_NONE on success. 
        """
        return _ogr.Layer_CommitTransaction(self, *args)

    def RollbackTransaction(self, *args):
        """
        RollbackTransaction(self) -> OGRErr

        OGRErr
        OGR_L_RollbackTransaction(OGRLayerH hLayer)

        For datasources which support transactions, RollbackTransaction will
        roll back a datasource to its state before the start of the current
        transaction. If no transaction is active, or the rollback fails, will
        return OGRERR_FAILURE. Datasources which do not support transactions
        will always return OGRERR_NONE.

        This function is the same as the C++ method
        OGRLayer::RollbackTransaction().

        Parameters:
        -----------

        hLayer:  handle to the layer

        OGRERR_NONE on success. 
        """
        return _ogr.Layer_RollbackTransaction(self, *args)

    def GetSpatialRef(self, *args):
        """
        GetSpatialRef(self) -> SpatialReference

        OGRSpatialReferenceH
        OGR_L_GetSpatialRef(OGRLayerH hLayer)

        Fetch the spatial reference system for this layer.

        The returned object is owned by the OGRLayer and should not be
        modified or freed by the application.

        This function is the same as the C++ method OGRLayer::GetSpatialRef().

        Parameters:
        -----------

        hLayer:  handle to the layer to get the spatial reference from.

        spatial reference, or NULL if there isn't one. 
        """
        return _ogr.Layer_GetSpatialRef(self, *args)

    def GetFeaturesRead(self, *args):
        """
        GetFeaturesRead(self) -> GIntBig

        GIntBig
        OGR_L_GetFeaturesRead(OGRLayerH hLayer) 
        """
        return _ogr.Layer_GetFeaturesRead(self, *args)

    def SetIgnoredFields(self, *args):
        """SetIgnoredFields(self, char options) -> OGRErr"""
        return _ogr.Layer_SetIgnoredFields(self, *args)

    def Reference(self):
      "For backwards compatibility only."
      pass

    def Dereference(self):
      "For backwards compatibility only."
      pass

    def __len__(self):
        """Returns the number of features in the layer"""
        return self.GetFeatureCount()

    def __getitem__(self, value):
        """Support list and slice -like access to the layer.
    r[0] would return the first feature on the layer.
    r[0:4] would return a list of the first four features."""
        import types
        if isinstance(value, slice):
            output = []
            if value.stop == sys.maxint:
                
                
                
                stop = len(self) - 1
            else:
                stop = value.stop
            for i in xrange(value.start,stop,value.step):
                feature = self.GetFeature(i)
                if feature:
                    output.append(feature)
                else:
                    return output
            return output
        if isinstance(value, int):
            if value > len(self)-1:
                raise IndexError
            return self.GetFeature(value)
        else:
            raise TypeError("Input %s is not of IntType or SliceType" % type(value))

    def CreateFields(fields):
        """Create a list of fields on the Layer"""
        for i in fields:
            self.CreateField(i)

    def __iter__(self):
        return self

    def next(self):
        feature = self.GetNextFeature()
        if not feature:
            raise StopIteration
        else:
            return feature

    def schema(self):
        output = []
        defn = self.GetLayerDefn()
        for n in range(defn.GetFieldCount()):
            output.append(defn.GetFieldDefn(n))
        return output
    schema = property(schema)


Layer_swigregister = _ogr.Layer_swigregister
Layer_swigregister(Layer)

class Feature(_object):
    """Proxy of C++ OGRFeatureShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Feature, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Feature, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_Feature
    __del__ = lambda self : None;
    def __init__(self, *args, **kwargs): 
        """__init__(self, FeatureDefn feature_def) -> Feature"""
        this = _ogr.new_Feature(*args, **kwargs)
        try: self.this.append(this)
        except: self.this = this
    def GetDefnRef(self, *args):
        """
        GetDefnRef(self) -> FeatureDefn

        OGRFeatureDefnH
        OGR_F_GetDefnRef(OGRFeatureH hFeat)

        Fetch feature definition.

        This function is the same as the C++ method OGRFeature::GetDefnRef().

        Parameters:
        -----------

        hFeat:  handle to the feature to get the feature definition from.

        an handle to the feature definition object on which feature depends.

        """
        return _ogr.Feature_GetDefnRef(self, *args)

    def SetGeometry(self, *args):
        """
        SetGeometry(self, Geometry geom) -> OGRErr

        OGRErr
        OGR_F_SetGeometry(OGRFeatureH hFeat, OGRGeometryH hGeom)

        Set feature geometry.

        This function updates the features geometry, and operate exactly as
        SetGeometryDirectly(), except that this function does not assume
        ownership of the passed geometry, but instead makes a copy of it.

        This function is the same as the C++ OGRFeature::SetGeometry().

        Parameters:
        -----------

        hFeat:  handle to the feature on which new geometry is applied to.

        hGeom:  handle to the new geometry to apply to feature.

        OGRERR_NONE if successful, or OGR_UNSUPPORTED_GEOMETRY_TYPE if the
        geometry type is illegal for the OGRFeatureDefn (checking not yet
        implemented). 
        """
        return _ogr.Feature_SetGeometry(self, *args)

    def SetGeometryDirectly(self, *args):
        """
        SetGeometryDirectly(self, Geometry geom) -> OGRErr

        OGRErr
        OGR_F_SetGeometryDirectly(OGRFeatureH hFeat, OGRGeometryH hGeom)

        Set feature geometry.

        This function updates the features geometry, and operate exactly as
        SetGeometry(), except that this function assumes ownership of the
        passed geometry.

        This function is the same as the C++ method
        OGRFeature::SetGeometryDirectly.

        Parameters:
        -----------

        hFeat:  handle to the feature on which to apply the geometry.

        hGeom:  handle to the new geometry to apply to feature.

        OGRERR_NONE if successful, or OGR_UNSUPPORTED_GEOMETRY_TYPE if the
        geometry type is illegal for the OGRFeatureDefn (checking not yet
        implemented). 
        """
        return _ogr.Feature_SetGeometryDirectly(self, *args)

    def GetGeometryRef(self, *args):
        """
        GetGeometryRef(self) -> Geometry

        OGRGeometryH
        OGR_F_GetGeometryRef(OGRFeatureH hFeat)

        Fetch an handle to feature geometry.

        This function is the same as the C++ method
        OGRFeature::GetGeometryRef().

        Parameters:
        -----------

        hFeat:  handle to the feature to get geometry from.

        an handle to internal feature geometry. This object should not be
        modified. 
        """
        return _ogr.Feature_GetGeometryRef(self, *args)

    def Clone(self, *args):
        """
        Clone(self) -> Feature

        OGRFeatureH OGR_F_Clone(OGRFeatureH
        hFeat)

        Duplicate feature.

        The newly created feature is owned by the caller, and will have it's
        own reference to the OGRFeatureDefn.

        This function is the same as the C++ method OGRFeature::Clone().

        Parameters:
        -----------

        hFeat:  handle to the feature to clone.

        an handle to the new feature, exactly matching this feature. 
        """
        return _ogr.Feature_Clone(self, *args)

    def Equal(self, *args):
        """
        Equal(self, Feature feature) -> bool

        int OGR_F_Equal(OGRFeatureH hFeat,
        OGRFeatureH hOtherFeat)

        Test if two features are the same.

        Two features are considered equal if the share them (handle equality)
        same OGRFeatureDefn, have the same field values, and the same geometry
        (as tested by OGR_G_Equal()) as well as the same feature id.

        This function is the same as the C++ method OGRFeature::Equal().

        Parameters:
        -----------

        hFeat:  handle to one of the feature.

        hOtherFeat:  handle to the other feature to test this one against.

        TRUE if they are equal, otherwise FALSE. 
        """
        return _ogr.Feature_Equal(self, *args)

    def GetFieldCount(self, *args):
        """
        GetFieldCount(self) -> int

        int
        OGR_F_GetFieldCount(OGRFeatureH hFeat)

        Fetch number of fields on this feature This will always be the same as
        the field count for the OGRFeatureDefn.

        This function is the same as the C++ method
        OGRFeature::GetFieldCount().

        Parameters:
        -----------

        hFeat:  handle to the feature to get the fields count from.

        count of fields. 
        """
        return _ogr.Feature_GetFieldCount(self, *args)

    def GetFieldDefnRef(self, *args):
        """
        GetFieldDefnRef(self, int id) -> FieldDefn
        GetFieldDefnRef(self, char name) -> FieldDefn

        OGRFieldDefnH
        OGR_F_GetFieldDefnRef(OGRFeatureH hFeat, int i)

        Fetch definition for this field.

        This function is the same as the C++ method
        OGRFeature::GetFieldDefnRef().

        Parameters:
        -----------

        hFeat:  handle to the feature on which the field is found.

        i:  the field to fetch, from 0 to GetFieldCount()-1.

        an handle to the field definition (from the OGRFeatureDefn). This is
        an internal reference, and should not be deleted or modified. 
        """
        return _ogr.Feature_GetFieldDefnRef(self, *args)

    def GetFieldAsString(self, *args):
        """
        GetFieldAsString(self, int id) -> char
        GetFieldAsString(self, char name) -> char

        const char*
        OGR_F_GetFieldAsString(OGRFeatureH hFeat, int iField)

        Fetch field value as a string.

        OFTReal and OFTInteger fields will be translated to string using
        sprintf(), but not necessarily using the established formatting rules.
        Other field types, or errors will result in a return value of zero.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsString().

        Parameters:
        -----------

        hFeat:  handle to the feature that owned the field.

        iField:  the field to fetch, from 0 to GetFieldCount()-1.

        the field value. This string is internal, and should not be modified,
        or freed. It's lifetime may be very brief. 
        """
        return _ogr.Feature_GetFieldAsString(self, *args)

    def GetFieldAsInteger(self, *args):
        """
        GetFieldAsInteger(self, int id) -> int
        GetFieldAsInteger(self, char name) -> int

        int
        OGR_F_GetFieldAsInteger(OGRFeatureH hFeat, int iField)

        Fetch field value as integer.

        OFTString features will be translated using atoi(). OFTReal fields
        will be cast to integer. Other field types, or errors will result in a
        return value of zero.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsInteger().

        Parameters:
        -----------

        hFeat:  handle to the feature that owned the field.

        iField:  the field to fetch, from 0 to GetFieldCount()-1.

        the field value. 
        """
        return _ogr.Feature_GetFieldAsInteger(self, *args)

    def GetFieldAsDouble(self, *args):
        """
        GetFieldAsDouble(self, int id) -> double
        GetFieldAsDouble(self, char name) -> double

        double
        OGR_F_GetFieldAsDouble(OGRFeatureH hFeat, int iField)

        Fetch field value as a double.

        OFTString features will be translated using atof(). OFTInteger fields
        will be cast to double. Other field types, or errors will result in a
        return value of zero.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsDouble().

        Parameters:
        -----------

        hFeat:  handle to the feature that owned the field.

        iField:  the field to fetch, from 0 to GetFieldCount()-1.

        the field value. 
        """
        return _ogr.Feature_GetFieldAsDouble(self, *args)

    def GetFieldAsDateTime(self, *args):
        """
        GetFieldAsDateTime(self, int id)

        int
        OGR_F_GetFieldAsDateTime(OGRFeatureH hFeat, int iField, int *pnYear,
        int *pnMonth, int *pnDay, int *pnHour, int *pnMinute, int *pnSecond,
        int *pnTZFlag)

        Fetch field value as date and time.

        Currently this method only works for OFTDate, OFTTime and OFTDateTime
        fields.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsDateTime().

        Parameters:
        -----------

        hFeat:  handle to the feature that owned the field.

        iField:  the field to fetch, from 0 to GetFieldCount()-1.

        pnYear:  (including century)

        pnMonth:  (1-12)

        pnDay:  (1-31)

        pnHour:  (0-23)

        pnMinute:  (0-59)

        pnSecond:  (0-59)

        pnTZFlag:  (0=unknown, 1=localtime, 100=GMT, see data model for
        details)

        TRUE on success or FALSE on failure. 
        """
        return _ogr.Feature_GetFieldAsDateTime(self, *args)

    def GetFieldAsIntegerList(self, *args):
        """
        GetFieldAsIntegerList(self, int id)

        const int*
        OGR_F_GetFieldAsIntegerList(OGRFeatureH hFeat, int iField, int
        *pnCount)

        Fetch field value as a list of integers.

        Currently this function only works for OFTIntegerList fields.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsIntegerList().

        Parameters:
        -----------

        hFeat:  handle to the feature that owned the field.

        iField:  the field to fetch, from 0 to GetFieldCount()-1.

        pnCount:  an integer to put the list count (number of integers) into.

        the field value. This list is internal, and should not be modified, or
        freed. It's lifetime may be very brief. If *pnCount is zero on return
        the returned pointer may be NULL or non-NULL. 
        """
        return _ogr.Feature_GetFieldAsIntegerList(self, *args)

    def GetFieldAsDoubleList(self, *args):
        """
        GetFieldAsDoubleList(self, int id)

        const double*
        OGR_F_GetFieldAsDoubleList(OGRFeatureH hFeat, int iField, int
        *pnCount)

        Fetch field value as a list of doubles.

        Currently this function only works for OFTRealList fields.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsDoubleList().

        Parameters:
        -----------

        hFeat:  handle to the feature that owned the field.

        iField:  the field to fetch, from 0 to GetFieldCount()-1.

        pnCount:  an integer to put the list count (number of doubles) into.

        the field value. This list is internal, and should not be modified, or
        freed. It's lifetime may be very brief. If *pnCount is zero on return
        the returned pointer may be NULL or non-NULL. 
        """
        return _ogr.Feature_GetFieldAsDoubleList(self, *args)

    def GetFieldAsStringList(self, *args):
        """
        GetFieldAsStringList(self, int id) -> char

        char**
        OGR_F_GetFieldAsStringList(OGRFeatureH hFeat, int iField)

        Fetch field value as a list of strings.

        Currently this method only works for OFTStringList fields.

        The returned list is terminated by a NULL pointer. The number of
        elements can also be calculated using CSLCount().

        This function is the same as the C++ method
        OGRFeature::GetFieldAsStringList().

        Parameters:
        -----------

        hFeat:  handle to the feature that owned the field.

        iField:  the field to fetch, from 0 to GetFieldCount()-1.

        the field value. This list is internal, and should not be modified, or
        freed. It's lifetime may be very brief. 
        """
        return _ogr.Feature_GetFieldAsStringList(self, *args)

    def IsFieldSet(self, *args):
        """
        IsFieldSet(self, int id) -> bool
        IsFieldSet(self, char name) -> bool

        int OGR_F_IsFieldSet(OGRFeatureH
        hFeat, int iField)

        Test if a field has ever been assigned a value or not.

        This function is the same as the C++ method OGRFeature::IsFieldSet().

        Parameters:
        -----------

        hFeat:  handle to the feature on which the field is.

        iField:  the field to test.

        TRUE if the field has been set, otherwise false. 
        """
        return _ogr.Feature_IsFieldSet(self, *args)

    def GetFieldIndex(self, *args):
        """
        GetFieldIndex(self, char name) -> int

        int
        OGR_F_GetFieldIndex(OGRFeatureH hFeat, const char *pszName)

        Fetch the field index given field name.

        This is a cover for the OGRFeatureDefn::GetFieldIndex() method.

        This function is the same as the C++ method
        OGRFeature::GetFieldIndex().

        Parameters:
        -----------

        hFeat:  handle to the feature on which the field is found.

        pszName:  the name of the field to search for.

        the field index, or -1 if no matching field is found. 
        """
        return _ogr.Feature_GetFieldIndex(self, *args)

    def GetFID(self, *args):
        """
        GetFID(self) -> int

        long OGR_F_GetFID(OGRFeatureH hFeat)

        Get feature identifier.

        This function is the same as the C++ method OGRFeature::GetFID().

        Parameters:
        -----------

        hFeat:  handle to the feature from which to get the feature
        identifier.

        feature id or OGRNullFID if none has been assigned. 
        """
        return _ogr.Feature_GetFID(self, *args)

    def SetFID(self, *args):
        """
        SetFID(self, int fid) -> OGRErr

        OGRErr OGR_F_SetFID(OGRFeatureH hFeat,
        long nFID)

        Set the feature identifier.

        For specific types of features this operation may fail on illegal
        features ids. Generally it always succeeds. Feature ids should be
        greater than or equal to zero, with the exception of OGRNullFID (-1)
        indicating that the feature id is unknown.

        This function is the same as the C++ method OGRFeature::SetFID().

        Parameters:
        -----------

        hFeat:  handle to the feature to set the feature id to.

        nFID:  the new feature identifier value to assign.

        On success OGRERR_NONE, or on failure some other value. 
        """
        return _ogr.Feature_SetFID(self, *args)

    def DumpReadable(self, *args):
        """
        DumpReadable(self)

        void
        OGR_F_DumpReadable(OGRFeatureH hFeat, FILE *fpOut)

        Dump this feature in a human readable form.

        This dumps the attributes, and geometry; however, it doesn't
        definition information (other than field types and names), nor does it
        report the geometry spatial reference system.

        This function is the same as the C++ method
        OGRFeature::DumpReadable().

        Parameters:
        -----------

        hFeat:  handle to the feature to dump.

        fpOut:  the stream to write to, such as strout. 
        """
        return _ogr.Feature_DumpReadable(self, *args)

    def UnsetField(self, *args):
        """
        UnsetField(self, int id)
        UnsetField(self, char name)

        void OGR_F_UnsetField(OGRFeatureH
        hFeat, int iField)

        Clear a field, marking it as unset.

        This function is the same as the C++ method OGRFeature::UnsetField().

        Parameters:
        -----------

        hFeat:  handle to the feature on which the field is.

        iField:  the field to unset. 
        """
        return _ogr.Feature_UnsetField(self, *args)

    def SetField(self, *args):
        """
        SetField(self, int id, char value)
        SetField(self, char name, char value)
        SetField(self, int id, int value)
        SetField(self, char name, int value)
        SetField(self, int id, double value)
        SetField(self, char name, double value)
        SetField(self, int id, int year, int month, int day, int hour, int minute, 
            int second, int tzflag)
        SetField(self, char name, int year, int month, int day, int hour, 
            int minute, int second, int tzflag)
        """
        return _ogr.Feature_SetField(self, *args)

    def SetFieldIntegerList(self, *args):
        """
        SetFieldIntegerList(self, int id, int nList)

        void
        OGR_F_SetFieldIntegerList(OGRFeatureH hFeat, int iField, int nCount,
        int *panValues)

        Set field to list of integers value.

        This function currently on has an effect of OFTIntegerList fields.

        This function is the same as the C++ method OGRFeature::SetField().

        Parameters:
        -----------

        hFeat:  handle to the feature that owned the field.

        iField:  the field to set, from 0 to GetFieldCount()-1.

        nCount:  the number of values in the list being assigned.

        panValues:  the values to assign. 
        """
        return _ogr.Feature_SetFieldIntegerList(self, *args)

    def SetFieldDoubleList(self, *args):
        """
        SetFieldDoubleList(self, int id, int nList)

        void
        OGR_F_SetFieldDoubleList(OGRFeatureH hFeat, int iField, int nCount,
        double *padfValues)

        Set field to list of doubles value.

        This function currently on has an effect of OFTRealList fields.

        This function is the same as the C++ method OGRFeature::SetField().

        Parameters:
        -----------

        hFeat:  handle to the feature that owned the field.

        iField:  the field to set, from 0 to GetFieldCount()-1.

        nCount:  the number of values in the list being assigned.

        padfValues:  the values to assign. 
        """
        return _ogr.Feature_SetFieldDoubleList(self, *args)

    def SetFieldStringList(self, *args):
        """
        SetFieldStringList(self, int id, char pList)

        void
        OGR_F_SetFieldStringList(OGRFeatureH hFeat, int iField, char
        **papszValues)

        Set field to list of strings value.

        This function currently on has an effect of OFTStringList fields.

        This function is the same as the C++ method OGRFeature::SetField().

        Parameters:
        -----------

        hFeat:  handle to the feature that owned the field.

        iField:  the field to set, from 0 to GetFieldCount()-1.

        papszValues:  the values to assign. 
        """
        return _ogr.Feature_SetFieldStringList(self, *args)

    def SetFrom(self, *args, **kwargs):
        """
        SetFrom(self, Feature other, int forgiving = 1) -> OGRErr

        OGRErr OGR_F_SetFrom(OGRFeatureH
        hFeat, OGRFeatureH hOtherFeat, int bForgiving)

        Set one feature from another.

        Overwrite the contents of this feature from the geometry and
        attributes of another. The hOtherFeature does not need to have the
        same OGRFeatureDefn. Field values are copied by corresponding field
        names. Field types do not have to exactly match. OGR_F_SetField*()
        function conversion rules will be applied as needed.

        This function is the same as the C++ method OGRFeature::SetFrom().

        Parameters:
        -----------

        hFeat:  handle to the feature to set to.

        hOtherFeat:  handle to the feature from which geometry, and field
        values will be copied.

        bForgiving:  TRUE if the operation should continue despite lacking
        output fields matching some of the source fields.

        OGRERR_NONE if the operation succeeds, even if some values are not
        transferred, otherwise an error code. 
        """
        return _ogr.Feature_SetFrom(self, *args, **kwargs)

    def SetFromWithMap(self, *args):
        """
        SetFromWithMap(self, Feature other, int forgiving, int nList) -> OGRErr

        OGRErr
        OGR_F_SetFromWithMap(OGRFeatureH hFeat, OGRFeatureH hOtherFeat, int
        bForgiving, int *panMap)

        Set one feature from another.

        Overwrite the contents of this feature from the geometry and
        attributes of another. The hOtherFeature does not need to have the
        same OGRFeatureDefn. Field values are copied according to the provided
        indices map. Field types do not have to exactly match.
        OGR_F_SetField*() function conversion rules will be applied as needed.
        This is more efficient than OGR_F_SetFrom() in that this doesn't
        lookup the fields by their names. Particularly useful when the field
        names don't match.

        This function is the same as the C++ method OGRFeature::SetFrom().

        Parameters:
        -----------

        hFeat:  handle to the feature to set to.

        hOtherFeat:  handle to the feature from which geometry, and field
        values will be copied.

        panMap:  Array of the indices of the destination feature's fields
        stored at the corresponding index of the source feature's fields. A
        value of -1 should be used to ignore the source's field. The array
        should not be NULL and be as long as the number of fields in the
        source feature.

        bForgiving:  TRUE if the operation should continue despite lacking
        output fields matching some of the source fields.

        OGRERR_NONE if the operation succeeds, even if some values are not
        transferred, otherwise an error code. 
        """
        return _ogr.Feature_SetFromWithMap(self, *args)

    def GetStyleString(self, *args):
        """
        GetStyleString(self) -> char

        const char*
        OGR_F_GetStyleString(OGRFeatureH hFeat)

        Fetch style string for this feature.

        Set the OGR Feature Style Specification for details on the format of
        this string, and ogr_featurestyle.h for services available to parse
        it.

        This function is the same as the C++ method
        OGRFeature::GetStyleString().

        Parameters:
        -----------

        hFeat:  handle to the feature to get the style from.

        a reference to a representation in string format, or NULL if there
        isn't one. 
        """
        return _ogr.Feature_GetStyleString(self, *args)

    def SetStyleString(self, *args):
        """
        SetStyleString(self, char the_string)

        void
        OGR_F_SetStyleString(OGRFeatureH hFeat, const char *pszStyle)

        Set feature style string. This method operate exactly as
        OGR_F_SetStyleStringDirectly() except that it does not assume
        ownership of the passed string, but instead makes a copy of it.

        This function is the same as the C++ method
        OGRFeature::SetStyleString().

        Parameters:
        -----------

        hFeat:  handle to the feature to set style to.

        pszStyle:  the style string to apply to this feature, cannot be NULL.

        """
        return _ogr.Feature_SetStyleString(self, *args)

    def GetFieldType(self, *args):
        """
        GetFieldType(self, int id) -> OGRFieldType
        GetFieldType(self, char name) -> OGRFieldType
        """
        return _ogr.Feature_GetFieldType(self, *args)

    def Reference(self):
      pass

    def Dereference(self):
      pass

    def Destroy(self):
      "Once called, self has effectively been destroyed.  Do not access. For backwards compatiblity only"
      _ogr.delete_Feature( self )
      self.thisown = 0

    def __cmp__(self, other):
        """Compares a feature to another for equality"""
        return self.Equal(other)

    def __copy__(self):
        return self.Clone()

    def __getattr__(self, name):
        """Returns the values of fields by the given name"""
        try:
            return self.GetField(name)
        except:
            raise AttributeError(name)

    def GetField(self, fld_index):
        import types
        if isinstance(fld_index, str):
            fld_index = self.GetFieldIndex(fld_index)
        if (fld_index < 0) or (fld_index > self.GetFieldCount()):
            raise ValueError("Illegal field requested in GetField()")
        if not (self.IsFieldSet(fld_index)):
            return None
        fld_type = self.GetFieldType(fld_index)
        if fld_type == OFTInteger:
            return self.GetFieldAsInteger(fld_index)
        if fld_type == OFTReal:
            return self.GetFieldAsDouble(fld_index)
        
        
        
        return self.GetFieldAsString(fld_index)

    def keys(self):
        names = []
        for i in range(self.GetFieldCount()):
            fieldname = self.GetFieldDefnRef(i).GetName()
            names.append(fieldname)
        return names

    def items(self):
        keys = self.keys()
        output = {}
        for key in keys:
            output[key] = self.GetField(key)
        return output
    def geometry(self):
        return self.GetGeometryRef()

    def ExportToJson(self, as_object = False):
        """Exports a GeoJSON object which represents the Feature. The
           as_object parameter determines whether the returned value 
           should be a Python object instead of a string. Defaults to False."""

        try:
            import simplejson
        except ImportError:
            try:
                import json as simplejson
            except ImportError:
                raise ImportError("Unable to import simplejson or json, needed for ExportToJson.")

        geom = self.GetGeometryRef()
        if geom is not None:
            geom_json_string = geom.ExportToJson()
            geom_json_object = simplejson.loads(geom_json_string)
        else:
            geom_json_object = None

        output = {'type':'Feature',
                   'geometry': geom_json_object,
                   'properties': {}
                  } 
        
        fid = self.GetFID()
        if fid:
            output['id'] = fid
            
        for key in self.keys():
            output['properties'][key] = self.GetField(key)
        
        if not as_object:
            output = simplejson.dumps(output)

        return output



Feature_swigregister = _ogr.Feature_swigregister
Feature_swigregister(Feature)

class FeatureDefn(_object):
    """Proxy of C++ OGRFeatureDefnShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FeatureDefn, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FeatureDefn, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_FeatureDefn
    __del__ = lambda self : None;
    def __init__(self, *args, **kwargs): 
        """__init__(self, char name_null_ok = None) -> FeatureDefn"""
        this = _ogr.new_FeatureDefn(*args, **kwargs)
        try: self.this.append(this)
        except: self.this = this
    def GetName(self, *args):
        """
        GetName(self) -> char

        const char*
        OGR_FD_GetName(OGRFeatureDefnH hDefn)

        Get name of the OGRFeatureDefn passed as an argument.

        This function is the same as the C++ method OGRFeatureDefn::GetName().

        Parameters:
        -----------

        hDefn:  handle to the feature definition to get the name from.

        the name. This name is internal and should not be modified, or freed.

        """
        return _ogr.FeatureDefn_GetName(self, *args)

    def GetFieldCount(self, *args):
        """
        GetFieldCount(self) -> int

        int
        OGR_FD_GetFieldCount(OGRFeatureDefnH hDefn)

        Fetch number of fields on the passed feature definition.

        This function is the same as the C++ OGRFeatureDefn::GetFieldCount().

        Parameters:
        -----------

        hDefn:  handle to the feature definition to get the fields count from.

        count of fields. 
        """
        return _ogr.FeatureDefn_GetFieldCount(self, *args)

    def GetFieldDefn(self, *args):
        """
        GetFieldDefn(self, int i) -> FieldDefn

        OGRFieldDefnH
        OGR_FD_GetFieldDefn(OGRFeatureDefnH hDefn, int iField)

        Fetch field definition of the passed feature definition.

        This function is the same as the C++ method
        OGRFeatureDefn::GetFieldDefn().

        Starting with GDAL 1.7.0, this method will also issue an error if the
        index is not valid.

        Parameters:
        -----------

        hDefn:  handle to the feature definition to get the field definition
        from.

        iField:  the field to fetch, between 0 and GetFieldCount()-1.

        an handle to an internal field definition object or NULL if invalid
        index. This object should not be modified or freed by the application.

        """
        return _ogr.FeatureDefn_GetFieldDefn(self, *args)

    def GetFieldIndex(self, *args):
        """
        GetFieldIndex(self, char name) -> int

        int
        OGR_FD_GetFieldIndex(OGRFeatureDefnH hDefn, const char *pszFieldName)

        Find field by name.

        The field index of the first field matching the passed field name
        (case insensitively) is returned.

        This function is the same as the C++ method
        OGRFeatureDefn::GetFieldIndex.

        Parameters:
        -----------

        hDefn:  handle to the feature definition to get field index from.

        pszFieldName:  the field name to search for.

        the field index, or -1 if no match found. 
        """
        return _ogr.FeatureDefn_GetFieldIndex(self, *args)

    def AddFieldDefn(self, *args):
        """
        AddFieldDefn(self, FieldDefn defn)

        void
        OGR_FD_AddFieldDefn(OGRFeatureDefnH hDefn, OGRFieldDefnH hNewField)

        Add a new field definition to the passed feature definition.

        This function should only be called while there are no OGRFeature
        objects in existance based on this OGRFeatureDefn. The OGRFieldDefn
        passed in is copied, and remains the responsibility of the caller.

        This function is the same as the C++ method
        OGRFeatureDefn::AddFieldDefn.

        Parameters:
        -----------

        hDefn:  handle to the feature definition to add the field definition
        to.

        hNewField:  handle to the new field definition. 
        """
        return _ogr.FeatureDefn_AddFieldDefn(self, *args)

    def GetGeomType(self, *args):
        """
        GetGeomType(self) -> OGRwkbGeometryType

        OGRwkbGeometryType
        OGR_FD_GetGeomType(OGRFeatureDefnH hDefn)

        Fetch the geometry base type of the passed feature definition.

        This function is the same as the C++ method
        OGRFeatureDefn::GetGeomType().

        Parameters:
        -----------

        hDefn:  handle to the feature definition to get the geometry type
        from.

        the base type for all geometry related to this definition. 
        """
        return _ogr.FeatureDefn_GetGeomType(self, *args)

    def SetGeomType(self, *args):
        """
        SetGeomType(self, OGRwkbGeometryType geom_type)

        void
        OGR_FD_SetGeomType(OGRFeatureDefnH hDefn, OGRwkbGeometryType eType)

        Assign the base geometry type for the passed layer (the same as the
        feature definition).

        All geometry objects using this type must be of the defined type or a
        derived type. The default upon creation is wkbUnknown which allows for
        any geometry type. The geometry type should generally not be changed
        after any OGRFeatures have been created against this definition.

        This function is the same as the C++ method
        OGRFeatureDefn::SetGeomType().

        Parameters:
        -----------

        hDefn:  handle to the layer or feature definition to set the geometry
        type to.

        eType:  the new type to assign. 
        """
        return _ogr.FeatureDefn_SetGeomType(self, *args)

    def GetReferenceCount(self, *args):
        """
        GetReferenceCount(self) -> int

        int
        OGR_FD_GetReferenceCount(OGRFeatureDefnH hDefn)

        Fetch current reference count.

        This function is the same as the C++ method
        OGRFeatureDefn::GetReferenceCount().

        Parameters:
        -----------

        hDefn:  hanlde to the feature definition on witch OGRFeature are based
        on.

        the current reference count. 
        """
        return _ogr.FeatureDefn_GetReferenceCount(self, *args)

    def IsGeometryIgnored(self, *args):
        """IsGeometryIgnored(self) -> int"""
        return _ogr.FeatureDefn_IsGeometryIgnored(self, *args)

    def SetGeometryIgnored(self, *args):
        """SetGeometryIgnored(self, int bIgnored)"""
        return _ogr.FeatureDefn_SetGeometryIgnored(self, *args)

    def IsStyleIgnored(self, *args):
        """IsStyleIgnored(self) -> int"""
        return _ogr.FeatureDefn_IsStyleIgnored(self, *args)

    def SetStyleIgnored(self, *args):
        """SetStyleIgnored(self, int bIgnored)"""
        return _ogr.FeatureDefn_SetStyleIgnored(self, *args)

    def Destroy(self):
      "Once called, self has effectively been destroyed.  Do not access. For backwards compatiblity only"
      _ogr.delete_FeatureDefn( self )
      self.thisown = 0


FeatureDefn_swigregister = _ogr.FeatureDefn_swigregister
FeatureDefn_swigregister(FeatureDefn)

class FieldDefn(_object):
    """Proxy of C++ OGRFieldDefnShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FieldDefn, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FieldDefn, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_FieldDefn
    __del__ = lambda self : None;
    def __init__(self, *args, **kwargs): 
        """__init__(self, char name_null_ok = "unnamed", OGRFieldType field_type = OFTString) -> FieldDefn"""
        this = _ogr.new_FieldDefn(*args, **kwargs)
        try: self.this.append(this)
        except: self.this = this
    def GetName(self, *args):
        """GetName(self) -> char"""
        return _ogr.FieldDefn_GetName(self, *args)

    def GetNameRef(self, *args):
        """
        GetNameRef(self) -> char

        const char*
        OGR_Fld_GetNameRef(OGRFieldDefnH hDefn)

        Fetch name of this field.

        This function is the same as the CPP method
        OGRFieldDefn::GetNameRef().

        Parameters:
        -----------

        hDefn:  handle to the field definition.

        the name of the field definition. 
        """
        return _ogr.FieldDefn_GetNameRef(self, *args)

    def SetName(self, *args):
        """
        SetName(self, char name)

        void OGR_Fld_SetName(OGRFieldDefnH
        hDefn, const char *pszName)

        Reset the name of this field.

        This function is the same as the CPP method OGRFieldDefn::SetName().

        Parameters:
        -----------

        hDefn:  handle to the field definition to apply the new name to.

        pszName:  the new name to apply. 
        """
        return _ogr.FieldDefn_SetName(self, *args)

    def GetType(self, *args):
        """
        GetType(self) -> OGRFieldType

        OGRFieldType
        OGR_Fld_GetType(OGRFieldDefnH hDefn)

        Fetch type of this field.

        This function is the same as the CPP method OGRFieldDefn::GetType().

        Parameters:
        -----------

        hDefn:  handle to the field definition to get type from.

        field type. 
        """
        return _ogr.FieldDefn_GetType(self, *args)

    def SetType(self, *args):
        """
        SetType(self, OGRFieldType type)

        void OGR_Fld_SetType(OGRFieldDefnH
        hDefn, OGRFieldType eType)

        Set the type of this field. This should never be done to an
        OGRFieldDefn that is already part of an OGRFeatureDefn.

        This function is the same as the CPP method OGRFieldDefn::SetType().

        Parameters:
        -----------

        hDefn:  handle to the field definition to set type to.

        eType:  the new field type. 
        """
        return _ogr.FieldDefn_SetType(self, *args)

    def GetJustify(self, *args):
        """
        GetJustify(self) -> OGRJustification

        OGRJustification
        OGR_Fld_GetJustify(OGRFieldDefnH hDefn)

        Get the justification for this field.

        This function is the same as the CPP method
        OGRFieldDefn::GetJustify().

        Parameters:
        -----------

        hDefn:  handle to the field definition to get justification from.

        the justification. 
        """
        return _ogr.FieldDefn_GetJustify(self, *args)

    def SetJustify(self, *args):
        """
        SetJustify(self, OGRJustification justify)

        void
        OGR_Fld_SetJustify(OGRFieldDefnH hDefn, OGRJustification eJustify)

        Set the justification for this field.

        This function is the same as the CPP method
        OGRFieldDefn::SetJustify().

        Parameters:
        -----------

        hDefn:  handle to the field definition to set justification to.

        eJustify:  the new justification. 
        """
        return _ogr.FieldDefn_SetJustify(self, *args)

    def GetWidth(self, *args):
        """
        GetWidth(self) -> int

        int OGR_Fld_GetWidth(OGRFieldDefnH
        hDefn)

        Get the formatting width for this field.

        This function is the same as the CPP method OGRFieldDefn::GetWidth().

        Parameters:
        -----------

        hDefn:  handle to the field definition to get width from.

        the width, zero means no specified width. 
        """
        return _ogr.FieldDefn_GetWidth(self, *args)

    def SetWidth(self, *args):
        """
        SetWidth(self, int width)

        void OGR_Fld_SetWidth(OGRFieldDefnH
        hDefn, int nNewWidth)

        Set the formatting width for this field in characters.

        This function is the same as the CPP method OGRFieldDefn::SetWidth().

        Parameters:
        -----------

        hDefn:  handle to the field definition to set width to.

        nNewWidth:  the new width. 
        """
        return _ogr.FieldDefn_SetWidth(self, *args)

    def GetPrecision(self, *args):
        """
        GetPrecision(self) -> int

        int
        OGR_Fld_GetPrecision(OGRFieldDefnH hDefn)

        Get the formatting precision for this field. This should normally be
        zero for fields of types other than OFTReal.

        This function is the same as the CPP method
        OGRFieldDefn::GetPrecision().

        Parameters:
        -----------

        hDefn:  handle to the field definition to get precision from.

        the precision. 
        """
        return _ogr.FieldDefn_GetPrecision(self, *args)

    def SetPrecision(self, *args):
        """
        SetPrecision(self, int precision)

        void
        OGR_Fld_SetPrecision(OGRFieldDefnH hDefn, int nPrecision)

        Set the formatting precision for this field in characters.

        This should normally be zero for fields of types other than OFTReal.

        This function is the same as the CPP method
        OGRFieldDefn::SetPrecision().

        Parameters:
        -----------

        hDefn:  handle to the field definition to set precision to.

        nPrecision:  the new precision. 
        """
        return _ogr.FieldDefn_SetPrecision(self, *args)

    def GetTypeName(self, *args):
        """GetTypeName(self) -> char"""
        return _ogr.FieldDefn_GetTypeName(self, *args)

    def GetFieldTypeName(self, *args):
        """GetFieldTypeName(self, OGRFieldType type) -> char"""
        return _ogr.FieldDefn_GetFieldTypeName(self, *args)

    def IsIgnored(self, *args):
        """IsIgnored(self) -> int"""
        return _ogr.FieldDefn_IsIgnored(self, *args)

    def SetIgnored(self, *args):
        """SetIgnored(self, int bIgnored)"""
        return _ogr.FieldDefn_SetIgnored(self, *args)

    width = property(GetWidth, SetWidth)
    type = property(GetType, SetType)
    precision = property(GetPrecision, SetPrecision)
    name = property(GetName, SetName)
    justify = property(GetJustify, SetJustify)

    def Destroy(self):
      "Once called, self has effectively been destroyed.  Do not access. For backwards compatiblity only"
      _ogr.delete_FieldDefn( self )
      self.thisown = 0

FieldDefn_swigregister = _ogr.FieldDefn_swigregister
FieldDefn_swigregister(FieldDefn)


def CreateGeometryFromWkb(*args, **kwargs):
  """CreateGeometryFromWkb(int len, SpatialReference reference = None) -> Geometry"""
  return _ogr.CreateGeometryFromWkb(*args, **kwargs)

def CreateGeometryFromWkt(*args, **kwargs):
  """CreateGeometryFromWkt(char val, SpatialReference reference = None) -> Geometry"""
  return _ogr.CreateGeometryFromWkt(*args, **kwargs)

def CreateGeometryFromGML(*args):
  """CreateGeometryFromGML(char input_string) -> Geometry"""
  return _ogr.CreateGeometryFromGML(*args)

def CreateGeometryFromJson(*args):
  """CreateGeometryFromJson(char input_string) -> Geometry"""
  return _ogr.CreateGeometryFromJson(*args)

def BuildPolygonFromEdges(*args, **kwargs):
  """
    BuildPolygonFromEdges(Geometry hLineCollection, int bBestEffort = 0, int bAutoClose = 0, 
        double dfTolerance = 0) -> Geometry
    """
  return _ogr.BuildPolygonFromEdges(*args, **kwargs)

def ApproximateArcAngles(*args, **kwargs):
  """
    ApproximateArcAngles(double dfCenterX, double dfCenterY, double dfZ, double dfPrimaryRadius, 
        double dfSecondaryAxis, 
        double dfRotation, double dfStartAngle, double dfEndAngle, 
        double dfMaxAngleStepSizeDegrees) -> Geometry
    """
  return _ogr.ApproximateArcAngles(*args, **kwargs)

def ForceToPolygon(*args):
  """ForceToPolygon(Geometry geom_in) -> Geometry"""
  return _ogr.ForceToPolygon(*args)

def ForceToMultiPolygon(*args):
  """ForceToMultiPolygon(Geometry geom_in) -> Geometry"""
  return _ogr.ForceToMultiPolygon(*args)

def ForceToMultiPoint(*args):
  """ForceToMultiPoint(Geometry geom_in) -> Geometry"""
  return _ogr.ForceToMultiPoint(*args)

def ForceToMultiLineString(*args):
  """ForceToMultiLineString(Geometry geom_in) -> Geometry"""
  return _ogr.ForceToMultiLineString(*args)
class Geometry(_object):
    """Proxy of C++ OGRGeometryShadow class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Geometry, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Geometry, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_Geometry
    __del__ = lambda self : None;
    def __init__(self, *args, **kwargs): 
        """
        __init__(self, OGRwkbGeometryType type = wkbUnknown, char wkt = None, 
            int wkb = 0, char gml = None) -> Geometry
        """
        this = _ogr.new_Geometry(*args, **kwargs)
        try: self.this.append(this)
        except: self.this = this
    def ExportToWkt(self, *args):
        """
        ExportToWkt(self) -> OGRErr

        OGRErr
        OGR_G_ExportToWkt(OGRGeometryH hGeom, char **ppszSrcText)

        Convert a geometry into well known text format.

        This function relates to the SFCOM IWks::ExportToWKT() method.

        This function is the same as the CPP method
        OGRGeometry::exportToWkt().

        Parameters:
        -----------

        hGeom:  handle on the geometry to convert to a text format from.

        ppszSrcText:  a text buffer is allocated by the program, and assigned
        to the passed pointer.

        Currently OGRERR_NONE is always returned. 
        """
        return _ogr.Geometry_ExportToWkt(self, *args)

    def ExportToWkb(self, *args, **kwargs):
        """
        ExportToWkb(self, OGRwkbByteOrder byte_order = wkbXDR) -> OGRErr

        OGRErr
        OGR_G_ExportToWkb(OGRGeometryH hGeom, OGRwkbByteOrder eOrder, unsigned
        char *pabyDstBuffer)

        Convert a geometry into well known binary format.

        This function relates to the SFCOM IWks::ExportToWKB() method.

        This function is the same as the CPP method
        OGRGeometry::exportToWkb().

        Parameters:
        -----------

        hGeom:  handle on the geometry to convert to a well know binary data
        from.

        eOrder:  One of wkbXDR or wkbNDR indicating MSB or LSB byte order
        respectively.

        pabyDstBuffer:  a buffer into which the binary representation is
        written. This buffer must be at least OGR_G_WkbSize() byte in size.

        Currently OGRERR_NONE is always returned. 
        """
        return _ogr.Geometry_ExportToWkb(self, *args, **kwargs)

    def ExportToGML(self, *args, **kwargs):
        """ExportToGML(self, char options = None) -> retStringAndCPLFree"""
        return _ogr.Geometry_ExportToGML(self, *args, **kwargs)

    def ExportToKML(self, *args):
        """ExportToKML(self, char altitude_mode = None) -> retStringAndCPLFree"""
        return _ogr.Geometry_ExportToKML(self, *args)

    def ExportToJson(self, *args):
        """ExportToJson(self) -> retStringAndCPLFree"""
        return _ogr.Geometry_ExportToJson(self, *args)

    def AddPoint(self, *args, **kwargs):
        """AddPoint(self, double x, double y, double z = 0)"""
        return _ogr.Geometry_AddPoint(self, *args, **kwargs)

    def AddPoint_2D(self, *args):
        """AddPoint_2D(self, double x, double y)"""
        return _ogr.Geometry_AddPoint_2D(self, *args)

    def AddGeometryDirectly(self, *args):
        """AddGeometryDirectly(self, Geometry other_disown) -> OGRErr"""
        return _ogr.Geometry_AddGeometryDirectly(self, *args)

    def AddGeometry(self, *args):
        """AddGeometry(self, Geometry other) -> OGRErr"""
        return _ogr.Geometry_AddGeometry(self, *args)

    def Clone(self, *args):
        """
        Clone(self) -> Geometry

        OGRGeometryH OGR_G_Clone(OGRGeometryH
        hGeom)

        Make a copy of this object.

        This function relates to the SFCOM IGeometry::clone() method.

        This function is the same as the CPP method OGRGeometry::clone().

        Parameters:
        -----------

        hGeom:  handle on the geometry to clone from.

        an handle on the copy of the geometry with the spatial reference
        system as the original. 
        """
        return _ogr.Geometry_Clone(self, *args)

    def GetGeometryType(self, *args):
        """
        GetGeometryType(self) -> OGRwkbGeometryType

        OGRwkbGeometryType
        OGR_G_GetGeometryType(OGRGeometryH hGeom)

        Fetch geometry type.

        Note that the geometry type may include the 2.5D flag. To get a 2D
        flattened version of the geometry type apply the wkbFlatten() macro to
        the return result.

        This function is the same as the CPP method
        OGRGeometry::getGeometryType().

        Parameters:
        -----------

        hGeom:  handle on the geometry to get type from.

        the geometry type code. 
        """
        return _ogr.Geometry_GetGeometryType(self, *args)

    def GetGeometryName(self, *args):
        """
        GetGeometryName(self) -> char

        const char*
        OGR_G_GetGeometryName(OGRGeometryH hGeom)

        Fetch WKT name for geometry type.

        There is no SFCOM analog to this function.

        This function is the same as the CPP method
        OGRGeometry::getGeometryName().

        Parameters:
        -----------

        hGeom:  handle on the geometry to get name from.

        name used for this geometry type in well known text format. 
        """
        return _ogr.Geometry_GetGeometryName(self, *args)

    def Length(self, *args):
        """Length(self) -> double"""
        return _ogr.Geometry_Length(self, *args)

    def Area(self, *args):
        """Area(self) -> double"""
        return _ogr.Geometry_Area(self, *args)

    def GetArea(self, *args):
        """GetArea(self) -> double"""
        return _ogr.Geometry_GetArea(self, *args)

    def GetPointCount(self, *args):
        """GetPointCount(self) -> int"""
        return _ogr.Geometry_GetPointCount(self, *args)

    def GetX(self, *args, **kwargs):
        """GetX(self, int point = 0) -> double"""
        return _ogr.Geometry_GetX(self, *args, **kwargs)

    def GetY(self, *args, **kwargs):
        """GetY(self, int point = 0) -> double"""
        return _ogr.Geometry_GetY(self, *args, **kwargs)

    def GetZ(self, *args, **kwargs):
        """GetZ(self, int point = 0) -> double"""
        return _ogr.Geometry_GetZ(self, *args, **kwargs)

    def GetPoint(self, *args):
        """GetPoint(self, int iPoint = 0)"""
        return _ogr.Geometry_GetPoint(self, *args)

    def GetPoint_2D(self, *args):
        """GetPoint_2D(self, int iPoint = 0)"""
        return _ogr.Geometry_GetPoint_2D(self, *args)

    def GetGeometryCount(self, *args):
        """GetGeometryCount(self) -> int"""
        return _ogr.Geometry_GetGeometryCount(self, *args)

    def SetPoint(self, *args, **kwargs):
        """SetPoint(self, int point, double x, double y, double z = 0)"""
        return _ogr.Geometry_SetPoint(self, *args, **kwargs)

    def SetPoint_2D(self, *args, **kwargs):
        """SetPoint_2D(self, int point, double x, double y)"""
        return _ogr.Geometry_SetPoint_2D(self, *args, **kwargs)

    def GetGeometryRef(self, *args):
        """GetGeometryRef(self, int geom) -> Geometry"""
        return _ogr.Geometry_GetGeometryRef(self, *args)

    def Simplify(self, *args):
        """Simplify(self, double tolerance) -> Geometry"""
        return _ogr.Geometry_Simplify(self, *args)

    def Boundary(self, *args):
        """Boundary(self) -> Geometry"""
        return _ogr.Geometry_Boundary(self, *args)

    def GetBoundary(self, *args):
        """
        GetBoundary(self) -> Geometry

        OGRGeometryH
        OGR_G_GetBoundary(OGRGeometryH hTarget)

        Compute boundary.

        A new geometry object is created and returned containing the boundary
        of the geometry on which the method is invoked.

        This function is the same as the C++ method OGR_G_GetBoundary().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hTarget:  The Geometry to calculate the boundary of.

        a handle to a newly allocated geometry now owned by the caller, or
        NULL on failure. 
        """
        return _ogr.Geometry_GetBoundary(self, *args)

    def ConvexHull(self, *args):
        """
        ConvexHull(self) -> Geometry

        OGRGeometryH
        OGR_G_ConvexHull(OGRGeometryH hTarget)

        Compute convex hull.

        A new geometry object is created and returned containing the convex
        hull of the geometry on which the method is invoked.

        This function is the same as the C++ method OGRGeometry::ConvexHull().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hTarget:  The Geometry to calculate the convex hull of.

        a handle to a newly allocated geometry now owned by the caller, or
        NULL on failure. 
        """
        return _ogr.Geometry_ConvexHull(self, *args)

    def Buffer(self, *args, **kwargs):
        """
        Buffer(self, double distance, int quadsecs = 30) -> Geometry

        OGRGeometryH OGR_G_Buffer(OGRGeometryH
        hTarget, double dfDist, int nQuadSegs)

        Compute buffer of geometry.

        Builds a new geometry containing the buffer region around the geometry
        on which it is invoked. The buffer is a polygon containing the region
        within the buffer distance of the original geometry.

        Some buffer sections are properly described as curves, but are
        converted to approximate polygons. The nQuadSegs parameter can be used
        to control how many segements should be used to define a 90 degree
        curve - a quadrant of a circle. A value of 30 is a reasonable default.
        Large values result in large numbers of vertices in the resulting
        buffer geometry while small numbers reduce the accuracy of the result.

        This function is the same as the C++ method OGRGeometry::Buffer().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hTarget:  the geometry.

        dfDist:  the buffer distance to be applied.

        nQuadSegs:  the number of segments used to approximate a 90 degree
        (quadrant) of curvature.

        the newly created geometry, or NULL if an error occurs. 
        """
        return _ogr.Geometry_Buffer(self, *args, **kwargs)

    def Intersection(self, *args):
        """
        Intersection(self, Geometry other) -> Geometry

        OGRGeometryH
        OGR_G_Intersection(OGRGeometryH hThis, OGRGeometryH hOther)

        Compute intersection.

        Generates a new geometry which is the region of intersection of the
        two geometries operated on. The OGR_G_Intersects() function can be
        used to test if two geometries intersect.

        This function is the same as the C++ method
        OGRGeometry::Intersection().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hThis:  the geometry.

        hOther:  the other geometry.

        a new geometry representing the intersection or NULL if there is no
        intersection or an error occurs. 
        """
        return _ogr.Geometry_Intersection(self, *args)

    def Union(self, *args):
        """
        Union(self, Geometry other) -> Geometry

        OGRGeometryH OGR_G_Union(OGRGeometryH
        hThis, OGRGeometryH hOther)

        Compute union.

        Generates a new geometry which is the region of union of the two
        geometries operated on.

        This function is the same as the C++ method OGRGeometry::Union().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hThis:  the geometry.

        hOther:  the other geometry.

        a new geometry representing the union or NULL if an error occurs. 
        """
        return _ogr.Geometry_Union(self, *args)

    def UnionCascaded(self, *args):
        """UnionCascaded(self) -> Geometry"""
        return _ogr.Geometry_UnionCascaded(self, *args)

    def Difference(self, *args):
        """
        Difference(self, Geometry other) -> Geometry

        OGRGeometryH
        OGR_G_Difference(OGRGeometryH hThis, OGRGeometryH hOther)

        Compute difference.

        Generates a new geometry which is the region of this geometry with the
        region of the other geometry removed.

        This function is the same as the C++ method OGRGeometry::Difference().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hThis:  the geometry.

        hOther:  the other geometry.

        a new geometry representing the difference or NULL if the difference
        is empty or an error occurs. 
        """
        return _ogr.Geometry_Difference(self, *args)

    def SymDifference(self, *args):
        """SymDifference(self, Geometry other) -> Geometry"""
        return _ogr.Geometry_SymDifference(self, *args)

    def SymmetricDifference(self, *args):
        """
        SymmetricDifference(self, Geometry other) -> Geometry

        OGRGeometryH
        OGR_G_SymmetricDifference(OGRGeometryH hThis, OGRGeometryH hOther)

        Compute symmetric difference.

        Generates a new geometry which is the symmetric difference of this
        geometry and the other geometry.

        This function is the same as the C++ method
        OGRGeometry::SymmetricDifference().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hThis:  the geometry.

        hOther:  the other geometry.

        a new geometry representing the symmetric difference or NULL if the
        difference is empty or an error occurs. 
        """
        return _ogr.Geometry_SymmetricDifference(self, *args)

    def Distance(self, *args):
        """
        Distance(self, Geometry other) -> double

        double OGR_G_Distance(OGRGeometryH
        hFirst, OGRGeometryH hOther)

        Compute distance between two geometries.

        Returns the shortest distance between the two geometries.

        This function is the same as the C++ method OGRGeometry::Distance().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hFirst:  the first geometry to compare against.

        hOther:  the other geometry to compare against.

        the distance between the geometries or -1 if an error occurs. 
        """
        return _ogr.Geometry_Distance(self, *args)

    def Empty(self, *args):
        """
        Empty(self)

        void OGR_G_Empty(OGRGeometryH hGeom)

        Clear geometry information. This restores the geometry to it's initial
        state after construction, and before assignment of actual geometry.

        This function relates to the SFCOM IGeometry::Empty() method.

        This function is the same as the CPP method OGRGeometry::empty().

        Parameters:
        -----------

        hGeom:  handle on the geometry to empty. 
        """
        return _ogr.Geometry_Empty(self, *args)

    def IsEmpty(self, *args):
        """
        IsEmpty(self) -> bool

        int OGR_G_IsEmpty(OGRGeometryH hGeom)

        Test if the geometry is empty.

        This method is the same as the CPP method OGRGeometry::IsEmpty().

        Parameters:
        -----------

        hGeom:  The Geometry to test.

        TRUE if the geometry has no points, otherwise FALSE. 
        """
        return _ogr.Geometry_IsEmpty(self, *args)

    def IsValid(self, *args):
        """
        IsValid(self) -> bool

        int OGR_G_IsValid(OGRGeometryH hGeom)

        Test if the geometry is valid.

        This function is the same as the C++ method OGRGeometry::IsValid().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always return FALSE.

        Parameters:
        -----------

        hGeom:  The Geometry to test.

        TRUE if the geometry has no points, otherwise FALSE. 
        """
        return _ogr.Geometry_IsValid(self, *args)

    def IsSimple(self, *args):
        """
        IsSimple(self) -> bool

        int OGR_G_IsSimple(OGRGeometryH
        hGeom)

        Returns TRUE if the geometry is simple.

        Returns TRUE if the geometry has no anomalous geometric points, such
        as self intersection or self tangency. The description of each
        instantiable geometric class will include the specific conditions that
        cause an instance of that class to be classified as not simple.

        This function is the same as the c++ method OGRGeometry::IsSimple()
        method.

        If OGR is built without the GEOS library, this function will always
        return FALSE.

        Parameters:
        -----------

        hGeom:  The Geometry to test.

        TRUE if object is simple, otherwise FALSE. 
        """
        return _ogr.Geometry_IsSimple(self, *args)

    def IsRing(self, *args):
        """
        IsRing(self) -> bool

        int OGR_G_IsRing(OGRGeometryH hGeom)

        Test if the geometry is a ring.

        This function is the same as the C++ method OGRGeometry::IsRing().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always return FALSE.

        Parameters:
        -----------

        hGeom:  The Geometry to test.

        TRUE if the geometry has no points, otherwise FALSE. 
        """
        return _ogr.Geometry_IsRing(self, *args)

    def Intersects(self, *args):
        """
        Intersects(self, Geometry other) -> bool

        int OGR_G_Intersects(OGRGeometryH
        hGeom, OGRGeometryH hOtherGeom)

        Do these features intersect?

        Currently this is not implemented in a rigerous fashion, and generally
        just tests whether the envelopes of the two features intersect.
        Eventually this will be made rigerous.

        This function is the same as the CPP method OGRGeometry::Intersects.

        Parameters:
        -----------

        hGeom:  handle on the first geometry.

        hOtherGeom:  handle on the other geometry to test against.

        TRUE if the geometries intersect, otherwise FALSE. 
        """
        return _ogr.Geometry_Intersects(self, *args)

    def Intersect(self, *args):
        """
        Intersect(self, Geometry other) -> bool

        int OGR_G_Intersect(OGRGeometryH
        hGeom, OGRGeometryH hOtherGeom) 
        """
        return _ogr.Geometry_Intersect(self, *args)

    def Equals(self, *args):
        """
        Equals(self, Geometry other) -> bool

        int OGR_G_Equals(OGRGeometryH hGeom,
        OGRGeometryH hOther)

        Returns TRUE if two geometries are equivalent.

        This function is the same as the CPP method OGRGeometry::Equals()
        method.

        Parameters:
        -----------

        hGeom:  handle on the first geometry.

        hOther:  handle on the other geometry to test against.

        TRUE if equivalent or FALSE otherwise. 
        """
        return _ogr.Geometry_Equals(self, *args)

    def Equal(self, *args):
        """
        Equal(self, Geometry other) -> bool

        int OGR_G_Equal(OGRGeometryH hGeom,
        OGRGeometryH hOther) 
        """
        return _ogr.Geometry_Equal(self, *args)

    def Disjoint(self, *args):
        """
        Disjoint(self, Geometry other) -> bool

        int OGR_G_Disjoint(OGRGeometryH
        hThis, OGRGeometryH hOther)

        Test for disjointness.

        Tests if this geometry and the other geometry are disjoint.

        This function is the same as the C++ method OGRGeometry::Disjoint().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hThis:  the geometry to compare.

        hOther:  the other geometry to compare.

        TRUE if they are disjoint, otherwise FALSE. 
        """
        return _ogr.Geometry_Disjoint(self, *args)

    def Touches(self, *args):
        """
        Touches(self, Geometry other) -> bool

        int OGR_G_Touches(OGRGeometryH hThis,
        OGRGeometryH hOther)

        Test for touching.

        Tests if this geometry and the other geometry are touching.

        This function is the same as the C++ method OGRGeometry::Touches().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hThis:  the geometry to compare.

        hOther:  the other geometry to compare.

        TRUE if they are touching, otherwise FALSE. 
        """
        return _ogr.Geometry_Touches(self, *args)

    def Crosses(self, *args):
        """
        Crosses(self, Geometry other) -> bool

        int OGR_G_Crosses(OGRGeometryH hThis,
        OGRGeometryH hOther)

        Test for crossing.

        Tests if this geometry and the other geometry are crossing.

        This function is the same as the C++ method OGRGeometry::Crosses().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hThis:  the geometry to compare.

        hOther:  the other geometry to compare.

        TRUE if they are crossing, otherwise FALSE. 
        """
        return _ogr.Geometry_Crosses(self, *args)

    def Within(self, *args):
        """
        Within(self, Geometry other) -> bool

        int OGR_G_Within(OGRGeometryH hThis,
        OGRGeometryH hOther)

        Test for containment.

        Tests if this geometry is within the other geometry.

        This function is the same as the C++ method OGRGeometry::Within().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hThis:  the geometry to compare.

        hOther:  the other geometry to compare.

        TRUE if hThis is within hOther, otherwise FALSE. 
        """
        return _ogr.Geometry_Within(self, *args)

    def Contains(self, *args):
        """
        Contains(self, Geometry other) -> bool

        int OGR_G_Contains(OGRGeometryH
        hThis, OGRGeometryH hOther)

        Test for containment.

        Tests if this geometry contains the other geometry.

        This function is the same as the C++ method OGRGeometry::Contains().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hThis:  the geometry to compare.

        hOther:  the other geometry to compare.

        TRUE if hThis contains hOther geometry, otherwise FALSE. 
        """
        return _ogr.Geometry_Contains(self, *args)

    def Overlaps(self, *args):
        """
        Overlaps(self, Geometry other) -> bool

        int OGR_G_Overlaps(OGRGeometryH
        hThis, OGRGeometryH hOther)

        Test for overlap.

        Tests if this geometry and the other geometry overlap, that is their
        intersection has a non-zero area.

        This function is the same as the C++ method OGRGeometry::Overlaps().

        This function is built on the GEOS library, check it for the
        definition of the geometry operation. If OGR is built without the GEOS
        library, this function will always fail, issuing a CPLE_NotSupported
        error.

        Parameters:
        -----------

        hThis:  the geometry to compare.

        hOther:  the other geometry to compare.

        TRUE if they are overlapping, otherwise FALSE. 
        """
        return _ogr.Geometry_Overlaps(self, *args)

    def TransformTo(self, *args):
        """
        TransformTo(self, SpatialReference reference) -> OGRErr

        OGRErr
        OGR_G_TransformTo(OGRGeometryH hGeom, OGRSpatialReferenceH hSRS)

        Transform geometry to new spatial reference system.

        This function will transform the coordinates of a geometry from their
        current spatial reference system to a new target spatial reference
        system. Normally this means reprojecting the vectors, but it could
        include datum shifts, and changes of units.

        This function will only work if the geometry already has an assigned
        spatial reference system, and if it is transformable to the target
        coordinate system.

        Because this function requires internal creation and initialization of
        an OGRCoordinateTransformation object it is significantly more
        expensive to use this function to transform many geometries than it is
        to create the OGRCoordinateTransformation in advance, and call
        transform() with that transformation. This function exists primarily
        for convenience when only transforming a single geometry.

        This function is the same as the CPP method OGRGeometry::transformTo.

        Parameters:
        -----------

        hGeom:  handle on the geometry to apply the transform to.

        hSRS:  handle on the spatial reference system to apply.

        OGRERR_NONE on success, or an error code. 
        """
        return _ogr.Geometry_TransformTo(self, *args)

    def Transform(self, *args):
        """
        Transform(self, CoordinateTransformation trans) -> OGRErr

        OGRErr OGR_G_Transform(OGRGeometryH
        hGeom, OGRCoordinateTransformationH hTransform)

        Apply arbitrary coordinate transformation to geometry.

        This function will transform the coordinates of a geometry from their
        current spatial reference system to a new target spatial reference
        system. Normally this means reprojecting the vectors, but it could
        include datum shifts, and changes of units.

        Note that this function does not require that the geometry already
        have a spatial reference system. It will be assumed that they can be
        treated as having the source spatial reference system of the
        OGRCoordinateTransformation object, and the actual SRS of the geometry
        will be ignored. On successful completion the output
        OGRSpatialReference of the OGRCoordinateTransformation will be
        assigned to the geometry.

        This function is the same as the CPP method OGRGeometry::transform.

        Parameters:
        -----------

        hGeom:  handle on the geometry to apply the transform to.

        hTransform:  handle on the transformation to apply.

        OGRERR_NONE on success or an error code. 
        """
        return _ogr.Geometry_Transform(self, *args)

    def GetSpatialReference(self, *args):
        """
        GetSpatialReference(self) -> SpatialReference

        OGRSpatialReferenceH
        OGR_G_GetSpatialReference(OGRGeometryH hGeom)

        Returns spatial reference system for geometry.

        This function relates to the SFCOM IGeometry::get_SpatialReference()
        method.

        This function is the same as the CPP method
        OGRGeometry::getSpatialReference().

        Parameters:
        -----------

        hGeom:  handle on the geometry to get spatial reference from.

        a reference to the spatial reference geometry. 
        """
        return _ogr.Geometry_GetSpatialReference(self, *args)

    def AssignSpatialReference(self, *args):
        """
        AssignSpatialReference(self, SpatialReference reference)

        void
        OGR_G_AssignSpatialReference(OGRGeometryH hGeom, OGRSpatialReferenceH
        hSRS)

        Assign spatial reference to this object.

        Any existing spatial reference is replaced, but under no circumstances
        does this result in the object being reprojected. It is just changing
        the interpretation of the existing geometry. Note that assigning a
        spatial reference increments the reference count on the
        OGRSpatialReference, but does not copy it.

        This is similar to the SFCOM IGeometry::put_SpatialReference() method.

        This function is the same as the CPP method
        OGRGeometry::assignSpatialReference.

        Parameters:
        -----------

        hGeom:  handle on the geometry to apply the new spatial reference
        system.

        hSRS:  handle on the new spatial reference system to apply. 
        """
        return _ogr.Geometry_AssignSpatialReference(self, *args)

    def CloseRings(self, *args):
        """
        CloseRings(self)

        void OGR_G_CloseRings(OGRGeometryH
        hGeom) 
        """
        return _ogr.Geometry_CloseRings(self, *args)

    def FlattenTo2D(self, *args):
        """
        FlattenTo2D(self)

        void
        OGR_G_FlattenTo2D(OGRGeometryH hGeom)

        Convert geometry to strictly 2D. In a sense this converts all Z
        coordinates to 0.0.

        This function is the same as the CPP method
        OGRGeometry::flattenTo2D().

        Parameters:
        -----------

        hGeom:  handle on the geometry to convert. 
        """
        return _ogr.Geometry_FlattenTo2D(self, *args)

    def Segmentize(self, *args):
        """
        Segmentize(self, double dfMaxLength)

        void OGR_G_Segmentize(OGRGeometryH
        hGeom, double dfMaxLength)

        Modify the geometry such it has no segment longer then the given
        distance.

        Interpolated points will have Z and M values (if needed) set to 0.
        Distance computation is performed in 2d only

        This function is the same as the CPP method OGRGeometry::segmentize().

        Parameters:
        -----------

        hGeom:  handle on the geometry to segmentize

        dfMaxLength:  the maximum distance between 2 points after
        segmentization 
        """
        return _ogr.Geometry_Segmentize(self, *args)

    def GetEnvelope(self, *args):
        """
        GetEnvelope(self)

        void
        OGR_G_GetEnvelope(OGRGeometryH hGeom, OGREnvelope *psEnvelope)

        Computes and returns the bounding envelope for this geometry in the
        passed psEnvelope structure.

        This function is the same as the CPP method
        OGRGeometry::getEnvelope().

        Parameters:
        -----------

        hGeom:  handle of the geometry to get envelope from.

        psEnvelope:  the structure in which to place the results. 
        """
        return _ogr.Geometry_GetEnvelope(self, *args)

    def Centroid(self, *args):
        """Centroid(self) -> Geometry"""
        return _ogr.Geometry_Centroid(self, *args)

    def WkbSize(self, *args):
        """
        WkbSize(self) -> int

        int OGR_G_WkbSize(OGRGeometryH hGeom)

        Returns size of related binary representation.

        This function returns the exact number of bytes required to hold the
        well known binary representation of this geometry object. Its
        computation may be slightly expensive for complex geometries.

        This function relates to the SFCOM IWks::WkbSize() method.

        This function is the same as the CPP method OGRGeometry::WkbSize().

        Parameters:
        -----------

        hGeom:  handle on the geometry to get the binary size from.

        size of binary representation in bytes. 
        """
        return _ogr.Geometry_WkbSize(self, *args)

    def GetCoordinateDimension(self, *args):
        """
        GetCoordinateDimension(self) -> int

        int
        OGR_G_GetCoordinateDimension(OGRGeometryH hGeom)

        Get the dimension of the coordinates in this geometry.

        This function corresponds to the SFCOM IGeometry::GetDimension()
        method.

        This function is the same as the CPP method
        OGRGeometry::getCoordinateDimension().

        Parameters:
        -----------

        hGeom:  handle on the geometry to get the dimension of the coordinates
        from.

        in practice this always returns 2 indicating that coordinates are
        specified within a two dimensional space. 
        """
        return _ogr.Geometry_GetCoordinateDimension(self, *args)

    def SetCoordinateDimension(self, *args):
        """
        SetCoordinateDimension(self, int dimension)

        void
        OGR_G_SetCoordinateDimension(OGRGeometryH hGeom, int nNewDimension) 
        """
        return _ogr.Geometry_SetCoordinateDimension(self, *args)

    def GetDimension(self, *args):
        """
        GetDimension(self) -> int

        int
        OGR_G_GetDimension(OGRGeometryH hGeom)

        Get the dimension of this geometry.

        This function corresponds to the SFCOM IGeometry::GetDimension()
        method. It indicates the dimension of the geometry, but does not
        indicate the dimension of the underlying space (as indicated by
        OGR_G_GetCoordinateDimension() function).

        This function is the same as the CPP method
        OGRGeometry::getDimension().

        Parameters:
        -----------

        hGeom:  handle on the geometry to get the dimension from.

        0 for points, 1 for lines and 2 for surfaces. 
        """
        return _ogr.Geometry_GetDimension(self, *args)

    def Destroy(self):
      self.__swig_destroy__(self) 
      self.__del__()
      self.thisown = 0

    def __str__(self):
      return self.ExportToWkt()
      

    def __reduce__(self):
      return (self.__class__, (), self.ExportToWkb())

    def __setstate__(self, state):
        result = CreateGeometryFromWkb(state)
        self.this = result.this
          
    def __iter__(self):
        self.iter_subgeom = 0
        return self
        
    def next(self):
        if self.iter_subgeom < self.GetGeometryCount():
            subgeom = self.GetGeometryRef(self.iter_subgeom)
            self.iter_subgeom += 1
            return subgeom
        else:
            raise StopIteration

Geometry_swigregister = _ogr.Geometry_swigregister
Geometry_swigregister(Geometry)


def GetDriverCount(*args):
  """GetDriverCount() -> int"""
  return _ogr.GetDriverCount(*args)

def GetOpenDSCount(*args):
  """GetOpenDSCount() -> int"""
  return _ogr.GetOpenDSCount(*args)

def SetGenerate_DB2_V72_BYTE_ORDER(*args):
  """SetGenerate_DB2_V72_BYTE_ORDER(int bGenerate_DB2_V72_BYTE_ORDER) -> OGRErr"""
  return _ogr.SetGenerate_DB2_V72_BYTE_ORDER(*args)

def RegisterAll(*args):
  """RegisterAll()"""
  return _ogr.RegisterAll(*args)

def GeometryTypeToName(*args):
  """GeometryTypeToName(OGRwkbGeometryType eType) -> char"""
  return _ogr.GeometryTypeToName(*args)

def GetFieldTypeName(*args):
  """GetFieldTypeName(OGRFieldType type) -> char"""
  return _ogr.GetFieldTypeName(*args)

def GetOpenDS(*args):
  """GetOpenDS(int ds_number) -> DataSource"""
  return _ogr.GetOpenDS(*args)

def Open(*args, **kwargs):
  """Open(char utf8_path, int update = 0) -> DataSource"""
  return _ogr.Open(*args, **kwargs)

def OpenShared(*args, **kwargs):
  """OpenShared(char utf8_path, int update = 0) -> DataSource"""
  return _ogr.OpenShared(*args, **kwargs)

def GetDriverByName(*args):
  """GetDriverByName(char name) -> Driver"""
  return _ogr.GetDriverByName(*args)

def GetDriver(*args):
  """GetDriver(int driver_number) -> Driver"""
  return _ogr.GetDriver(*args)

def GeneralCmdLineProcessor(*args):
  """GeneralCmdLineProcessor(char papszArgv, int nOptions = 0) -> char"""
  return _ogr.GeneralCmdLineProcessor(*args)


