// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_DISCOVERER_H
#define _GSTREAMERMM_DISCOVERER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2011 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gstreamermm/clock.h>
#include <gst/pbutils/pbutils.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstDiscoverer GstDiscoverer;
typedef struct _GstDiscovererClass GstDiscovererClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Discoverer_Class; } // namespace Gst
namespace Gst
{

class DiscovererInfo;

/** Discoverer - Utility for discovering information on URIs.
 * The Discoverer is a utility object which allows to get as much information
 * as possible from one or many URIs.
 *
 * It provides two APIs, allowing usage in blocking or non-blocking mode.
 *
 * The blocking mode just requires calling discover_uri() with the URI one
 * wishes to discover.
 *
 * The non-blocking mode requires a running Glib::MainLoop in the default
 * Glib::MainContext, where one connects to the various signals, appends the
 * URIs to be processed (through discover_uri_async()) and then asks for the
 * discovery to begin (through start()).
 *
 * All the information is returned in a DiscovererInfo structure.
 */

class Discoverer : public Glib::Object 
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Discoverer CppObjectType;
  typedef Discoverer_Class CppClassType;
  typedef GstDiscoverer BaseObjectType;
  typedef GstDiscovererClass BaseClassType;

private:  friend class Discoverer_Class;
  static CppClassType discoverer_class_;

private:
  // noncopyable
  Discoverer(const Discoverer&);
  Discoverer& operator=(const Discoverer&);

protected:
  explicit Discoverer(const Glib::ConstructParams& construct_params);
  explicit Discoverer(GstDiscoverer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Discoverer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstDiscoverer*       gobj()       { return reinterpret_cast<GstDiscoverer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstDiscoverer* gobj() const { return reinterpret_cast<GstDiscoverer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstDiscoverer* gobj_copy();

private:


protected:
  explicit Discoverer(ClockTime timeout);

public:
  
  /** Creates a new Gst::Discoverer with the provided timeout.
   * @param timeout Timeout per file, in nanoseconds. Allowed are values between
   * one second (Gst::SECOND) and one hour (3600 * Gst::SECOND).
   * @param err A pointer to a Error. can be <tt>0</tt>.
   * @return The new Gst::Discoverer.
   * If an error occurred when creating the discoverer, @a err will be set
   * accordingly and <tt>0</tt> will be returned. If @a err is set, the caller must
   * free it when no longer needed using Glib::error_free().
   */

  
  static Glib::RefPtr<Discoverer> create(ClockTime timeout);


  /** Allow asynchronous discovering of URIs to take place.
   * A MainLoop must be available for Gst::Discoverer to properly work in
   * asynchronous mode.
   */
  void start();
  
  /** Stop the discovery of any pending URIs and clears the list of
   * pending URIS (if any).
   */
  void stop();
  
  /** Synchronously discovers the given @a uri.
   * 
   * A copy of @a uri will be made internally, so the caller can safely Glib::free()
   * afterwards.
   * @param uri The URI to run on.
   * @param err If an error occurred, this field will be filled in.
   * @return The result of the scanning. Can be <tt>0</tt> if an
   * error occurred.
   */
  Glib::RefPtr<DiscovererInfo> discover_uri(const Glib::ustring& uri);
  
  /** Appends the given @a uri to the list of URIs to discoverer. The actual
   * discovery of the @a uri will only take place if start() has
   * been called.
   * 
   * A copy of @a uri will be made internally, so the caller can safely Glib::free()
   * afterwards.
   * @param uri The URI to add.
   * @return <tt>true</tt> if the @a uri was succesfully appended to the list of pending
   * uris, else <tt>false</tt>.
   */
  bool discover_uri_async(const Glib::ustring& uri);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Timeout.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< guint64 > property_timeout() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Timeout.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint64 > property_timeout() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  //TODO: Docs?
  
/**
   * @par Slot Prototype:
   * <tt>void on_my_%discovered(const Glib::RefPtr<DiscovererInfo>& info, const Glib::Error& error)</tt>
   *
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<DiscovererInfo>&,const Glib::Error& > signal_discovered();


/**
   * @par Slot Prototype:
   * <tt>void on_my_%finished()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_finished();

  
/**
   * @par Slot Prototype:
   * <tt>void on_my_%starting()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_starting();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_discovered().
  virtual void on_discovered(const Glib::RefPtr<DiscovererInfo>& info, const Glib::Error& error);
  /// This is a default handler for the signal signal_finished().
  virtual void on_finished();
  /// This is a default handler for the signal signal_starting().
  virtual void on_starting();


};

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Discoverer
   */
  Glib::RefPtr<Gst::Discoverer> wrap(GstDiscoverer* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_DISCOVERER_H */

