/* libedataserver-1.2.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "E", gir_namespace = "EDataServer", gir_version = "1.2", lower_case_cprefix = "e_")]
namespace E {
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_id = "e_account_get_type ()")]
	public class Account : GLib.Object {
		public bool always_bcc;
		public bool always_cc;
		public weak string bcc_addrs;
		public weak string cc_addrs;
		public weak string drafts_folder_uri;
		public bool enabled;
		public weak string name;
		public weak string parent_uid;
		public bool pgp_always_sign;
		public bool pgp_always_trust;
		public bool pgp_encrypt_to_self;
		public weak string pgp_hash_algorithm;
		public weak string pgp_key;
		public bool pgp_no_imip_sign;
		public E.AccountReceiptPolicy receipt_policy;
		public weak string sent_folder_uri;
		public bool smime_encrypt_default;
		public weak string smime_encrypt_key;
		public bool smime_encrypt_to_self;
		public weak string smime_hash_algorithm;
		public bool smime_sign_default;
		public weak string smime_sign_key;
		public weak string templates_folder_uri;
		public weak string uid;
		[CCode (has_construct_function = false)]
		public Account ();
		[CCode (has_construct_function = false)]
		public Account.from_xml (string xml);
		public void import (E.Account src);
		public bool set_from_xml (string xml);
		public string to_xml ();
		public static string uid_from_xml (string xml);
		public bool writable_option (string protocol, string option);
		public virtual signal void changed (int field);
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_id = "e_account_list_get_type ()")]
	public class AccountList : E.List {
		[CCode (has_construct_function = false)]
		protected AccountList ();
		public bool account_has_proxies (E.Account account);
		public void add (E.Account account);
		public void change (E.Account account);
		public unowned E.Account get_default ();
		public void prune_proxies ();
		public void remove (E.Account account);
		public void remove_account_proxies (E.Account account);
		public void save ();
		public void set_default (E.Account account);
		public virtual signal void account_added (E.Account account);
		public virtual signal void account_changed (E.Account account);
		public virtual signal void account_removed (E.Account account);
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_id = "e_client_get_type ()")]
	public abstract class Client : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Client ();
		public void cancel_all ();
		public bool check_capability (string capability);
		public bool check_refresh_supported ();
		public static GLib.Error error_create (E.ClientError code, string custom_msg);
		public static GLib.Quark error_quark ();
		public static unowned string error_to_string (E.ClientError code);
		public virtual async bool get_backend_property (string prop_name, GLib.Cancellable? cancellable, out string prop_value) throws GLib.Error;
		public virtual bool get_backend_property_sync (string prop_name, out string prop_value, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned GLib.SList<string> get_capabilities ();
		public unowned E.Source get_source ();
		public unowned string get_uri ();
		[NoWrapper]
		public virtual void handle_authentication (E.Credentials credentials);
		public bool is_online ();
		public bool is_opened ();
		public bool is_readonly ();
		public virtual async bool open (bool only_if_exists, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual bool open_sync (bool only_if_exists, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async bool refresh (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual bool refresh_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async bool remove (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual bool remove_sync (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async bool retrieve_capabilities (GLib.Cancellable? cancellable, out string capabilities) throws GLib.Error;
		public virtual bool retrieve_capabilities_sync (out string capabilities, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async bool set_backend_property (string prop_name, string prop_value, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual bool set_backend_property_sync (string prop_name, string prop_value, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void unwrap_dbus_error (GLib.Error dbus_error) throws GLib.Error;
		public static bool util_unwrap_dbus_error (GLib.Error dbus_error, out GLib.Error client_error, E.ClientErrorsList known_errors, uint known_errors_count, GLib.Quark known_errors_domain, bool fail_when_none_matched);
		public void* capabilities { get; }
		[NoAccessorMethod]
		public bool online { get; set; }
		[NoAccessorMethod]
		public virtual bool opened { get; }
		[NoAccessorMethod]
		public bool readonly { get; }
		public E.Source source { get; construct; }
		public virtual signal bool authenticate (void* credentials);
		public virtual signal void backend_died ();
		public virtual signal void backend_error (string error_msg);
		public virtual signal void backend_property_changed (string prop_name, string prop_value);
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	[Compact]
	public class Flag {
		public void clear ();
		public void free ();
		public bool is_set ();
		public void @set ();
		public bool timed_wait (GLib.TimeVal abs_time);
		public void wait ();
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_id = "e_iterator_get_type ()")]
	public class Iterator : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Iterator ();
		public void @delete ();
		public virtual void* @get ();
		public virtual void insert (void* object, bool before);
		public virtual bool is_valid ();
		public virtual void last ();
		public virtual bool next ();
		public virtual bool prev ();
		[NoWrapper]
		public virtual void remove ();
		public virtual void reset ();
		public virtual void @set (void* object);
		[HasEmitter]
		public virtual signal void invalidate ();
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_id = "e_list_get_type ()")]
	public class List : GLib.Object {
		public void* closure;
		public weak E.ListFreeFunc free;
		public weak GLib.List<void*> iterators;
		public weak GLib.List<void*> list;
		[CCode (has_construct_function = false)]
		protected List ();
		public void append (void* data);
		public E.List duplicate ();
		public unowned E.Iterator get_iterator ();
		public void invalidate_iterators (E.Iterator skip);
		public int length ();
		public void remove (void* data);
		public void remove_iterator (E.Iterator iterator);
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_id = "e_list_iterator_get_type ()")]
	public class ListIterator : E.Iterator {
		public weak GLib.List<void*> iterator;
		public weak E.List list;
		[CCode (has_construct_function = false, type = "EIterator*")]
		public ListIterator (E.List list);
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	[Compact]
	public class MemChunk {
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	[Compact]
	public class OperationPool {
		public void free ();
		public void push (void* opdata);
		public void release_opid (uint32 opid);
		public uint32 reserve_opid ();
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_id = "e_proxy_get_type ()")]
	public class Proxy : GLib.Object {
		[CCode (has_construct_function = false)]
		public Proxy ();
		public bool require_proxy_for_uri (string uri);
		public void setup_proxy ();
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_id = "e_source_get_type ()")]
	public class Source : GLib.Object {
		[CCode (has_construct_function = false)]
		public Source (string name, string relative_uri);
		public string build_absolute_uri ();
		public E.Source copy ();
		public void dump_to_xml_node (Xml.Node parent_node);
		public bool equal (E.Source b);
		public void foreach_property (GLib.HFunc func);
		[CCode (has_construct_function = false)]
		public Source.from_standalone_xml (string xml);
		[CCode (has_construct_function = false)]
		public Source.from_xml_node (Xml.Node node);
		public string get_duped_property (string property_name);
		public unowned string get_property (string property_name);
		public bool get_readonly ();
		public string get_uri ();
		public unowned string peek_absolute_uri ();
		public unowned string peek_color_spec ();
		public void* peek_group ();
		public unowned string peek_name ();
		public unowned string peek_relative_uri ();
		public unowned string peek_uid ();
		public void set_absolute_uri (string absolute_uri);
		public void set_color_spec (string color_spec);
		public void set_group (void* group);
		public void set_name (string name);
		public void set_property (string property_name, string? property_value);
		public void set_readonly (bool readonly);
		public void set_relative_uri (string relative_uri);
		public string to_standalone_xml ();
		public static string uid_from_xml_node (Xml.Node node);
		public bool update_from_xml_node (Xml.Node node, bool changed_return);
		[CCode (has_construct_function = false)]
		public Source.with_absolute_uri (string name, string absolute_uri);
		public static bool xmlstr_equal (string a, string b);
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_id = "e_source_group_get_type ()")]
	public class SourceGroup : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceGroup (string name, string base_uri);
		public bool add_source (E.Source source, int position);
		public bool equal (E.SourceGroup b);
		public void foreach_property (GLib.HFunc func);
		[CCode (has_construct_function = false)]
		public SourceGroup.from_xml (string xml);
		[CCode (has_construct_function = false)]
		public SourceGroup.from_xmldoc (Xml.Doc doc);
		public string get_property (string property);
		public bool get_readonly ();
		public unowned string peek_base_uri ();
		public unowned string peek_name ();
		public unowned E.Source peek_source_by_name (string source_name);
		public unowned E.Source peek_source_by_uid (string source_uid);
		public unowned GLib.SList<E.Source> peek_sources ();
		public unowned string peek_uid ();
		public bool remove_source (E.Source source);
		public bool remove_source_by_uid (string uid);
		public void set_base_uri (string base_uri);
		public void set_name (string name);
		public void set_property (string property, string value);
		public void set_readonly (bool readonly);
		public string to_xml ();
		public static string uid_from_xmldoc (Xml.Doc doc);
		public bool update_from_xml (string xml, bool changed_return);
		public bool update_from_xmldoc (Xml.Doc doc, bool changed_return);
		public static bool xmlstr_equal (string a, string b);
		public virtual signal void changed ();
		public virtual signal void source_added (GLib.Object source);
		public virtual signal void source_removed (GLib.Object source);
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_id = "e_source_list_get_type ()")]
	public class SourceList : GLib.Object {
		[CCode (has_construct_function = false)]
		public SourceList ();
		public bool add_group (E.SourceGroup group, int position);
		public E.SourceGroup ensure_group (string name, string base_uri, bool ret_it);
		[CCode (has_construct_function = false)]
		public SourceList.for_gconf_default (string path);
		public bool is_gconf_updated ();
		public unowned E.Source? peek_default_source ();
		public unowned E.SourceGroup peek_group_by_base_uri (string base_uri);
		public unowned E.SourceGroup peek_group_by_uid (string uid);
		public unowned GLib.SList<E.SourceGroup> peek_groups ();
		public unowned E.Source peek_source_any ();
		public unowned E.Source peek_source_by_uid (string uid);
		public bool remove_group (E.SourceGroup group);
		public bool remove_group_by_base_uri (string base_uri);
		public bool remove_group_by_uid (string uid);
		public bool remove_source_by_uid (string uid);
		public bool sync () throws GLib.Error;
		public virtual signal void changed ();
		public virtual signal void group_added (E.SourceGroup group);
		public virtual signal void group_removed (E.SourceGroup group);
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	[Compact]
	public class XmlHash {
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", type_cname = "EGdbusAsyncOpKeeperInterface", type_id = "e_gdbus_async_op_keeper_get_type ()")]
	public interface GdbusAsyncOpKeeper : GLib.Object {
		public abstract bool cancel_op_sync (uint in_opid, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", has_type_id = false)]
	public struct ClientErrorsList {
		public weak string name;
		public int err_code;
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", has_type_id = false)]
	public struct Credentials {
		public void clear ();
		public void clear_peek ();
		public bool equal (E.Credentials credentials2);
		public void free ();
		public string @get (string key);
		public bool has_key (string key);
		public uint keys_size ();
		public unowned string peek (string key);
		public void @set (string key, string value);
		public static string util_prompt_flags_to_string (uint prompt_flags);
		public static void util_safe_free_string (string str);
		public static uint util_string_to_prompt_flags (string prompt_flags_string);
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", has_type_id = false)]
	public struct Uri {
		public weak string protocol;
		public weak string user;
		public weak string authmech;
		public weak string passwd;
		public weak string host;
		public int port;
		public weak string path;
		public GLib.Datalist @params;
		public weak string query;
		public weak string fragment;
		public void free ();
		public unowned string get_param (string name);
		public string to_string (bool show_password);
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "_EAccountIdentity", has_type_id = false)]
	public struct _AccountIdentity {
		public weak string name;
		public weak string address;
		public weak string reply_to;
		public weak string organization;
		public weak string sig_uid;
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "_EAccountService", has_type_id = false)]
	public struct _AccountService {
		public weak string url;
		public bool keep_on_server;
		public bool auto_check;
		public int auto_check_time;
		public bool save_passwd;
		public bool get_password_canceled;
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cprefix = "E_ACCOUNT_RECEIPT_")]
	public enum AccountReceiptPolicy {
		NEVER,
		ASK,
		ALWAYS
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cprefix = "E_CLIENT_ERROR_")]
	public enum ClientError {
		INVALID_ARG,
		BUSY,
		SOURCE_NOT_LOADED,
		SOURCE_ALREADY_LOADED,
		AUTHENTICATION_FAILED,
		AUTHENTICATION_REQUIRED,
		REPOSITORY_OFFLINE,
		OFFLINE_UNAVAILABLE,
		PERMISSION_DENIED,
		CANCELLED,
		COULD_NOT_CANCEL,
		NOT_SUPPORTED,
		TLS_NOT_AVAILABLE,
		UNSUPPORTED_AUTHENTICATION_METHOD,
		SEARCH_SIZE_LIMIT_EXCEEDED,
		SEARCH_TIME_LIMIT_EXCEEDED,
		INVALID_QUERY,
		QUERY_REFUSED,
		DBUS_ERROR,
		OTHER_ERROR,
		NOT_OPENED
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cprefix = "E_CREDENTIALS_PROMPT_FLAG_")]
	[Flags]
	public enum CredentialsPromptFlags {
		REMEMBER_NEVER,
		REMEMBER_SESSION,
		REMEMBER_FOREVER,
		REMEMBER_MASK,
		SECRET,
		REPROMPT,
		ONLINE,
		DISABLE_REMEMBER,
		PASSPHRASE
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cprefix = "E_TIME_PARSE_")]
	public enum TimeParseStatus {
		OK,
		NONE,
		INVALID
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cprefix = "E_XMLHASH_STATUS_")]
	public enum XmlHashStatus {
		SAME,
		DIFFERENT,
		NOT_FOUND
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cprefix = "E_XML_HASH_TYPE_")]
	public enum XmlHashType {
		OBJECT_UID,
		PROPERTY
	}
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", has_target = false)]
	public delegate bool GdbusCallFinishBoolean (GLib.DBusProxy proxy, GLib.AsyncResult result, bool out_boolean) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", has_target = false)]
	public delegate bool GdbusCallFinishString (GLib.DBusProxy proxy, GLib.AsyncResult result, string out_string) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", has_target = false)]
	public delegate bool GdbusCallFinishStrv (GLib.DBusProxy proxy, GLib.AsyncResult result, string out_strv) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", has_target = false)]
	public delegate bool GdbusCallFinishUint (GLib.DBusProxy proxy, GLib.AsyncResult result, uint out_uint) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", has_target = false)]
	public delegate bool GdbusCallFinishVoid (GLib.DBusProxy proxy, GLib.AsyncResult result) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", instance_pos = 4.9)]
	public delegate void GdbusCallStartBoolean (GLib.DBusProxy proxy, bool in_boolean, GLib.Cancellable? cancellable, [CCode (delegate_target_pos = 0)] GLib.AsyncReadyCallback? callback);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", instance_pos = 4.9)]
	public delegate void GdbusCallStartString (GLib.DBusProxy proxy, string in_string, GLib.Cancellable? cancellable, [CCode (delegate_target_pos = 0)] GLib.AsyncReadyCallback? callback);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", instance_pos = 4.9)]
	public delegate void GdbusCallStartStrv (GLib.DBusProxy proxy, string in_strv, GLib.Cancellable? cancellable, [CCode (delegate_target_pos = 0)] GLib.AsyncReadyCallback? callback);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", instance_pos = 4.9)]
	public delegate void GdbusCallStartUint (GLib.DBusProxy proxy, uint in_uint, GLib.Cancellable? cancellable, [CCode (delegate_target_pos = 0)] GLib.AsyncReadyCallback? callback);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", instance_pos = 3.9)]
	public delegate void GdbusCallStartVoid (GLib.DBusProxy proxy, GLib.Cancellable? cancellable, [CCode (delegate_target_pos = 0)] GLib.AsyncReadyCallback? callback);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", has_target = false)]
	public delegate void ListFreeFunc (void* data, void* closure);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", instance_pos = 2.9)]
	public delegate void XmlHashFunc (string key, string value);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", instance_pos = 2.9)]
	public delegate bool XmlHashRemoveFunc (string key, string value);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_CREDENTIALS_KEY_AUTH_METHOD")]
	public const string CREDENTIALS_KEY_AUTH_METHOD;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_CREDENTIALS_KEY_FOREIGN_REQUEST")]
	public const string CREDENTIALS_KEY_FOREIGN_REQUEST;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_CREDENTIALS_KEY_PASSWORD")]
	public const string CREDENTIALS_KEY_PASSWORD;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_CREDENTIALS_KEY_PROMPT_FLAGS")]
	public const string CREDENTIALS_KEY_PROMPT_FLAGS;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_CREDENTIALS_KEY_PROMPT_KEY")]
	public const string CREDENTIALS_KEY_PROMPT_KEY;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_CREDENTIALS_KEY_PROMPT_REASON")]
	public const string CREDENTIALS_KEY_PROMPT_REASON;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_CREDENTIALS_KEY_PROMPT_TEXT")]
	public const string CREDENTIALS_KEY_PROMPT_TEXT;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_CREDENTIALS_KEY_PROMPT_TITLE")]
	public const string CREDENTIALS_KEY_PROMPT_TITLE;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_CREDENTIALS_KEY_USERNAME")]
	public const string CREDENTIALS_KEY_USERNAME;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_DEBUG_LOG_DOMAIN_CAL_QUERIES")]
	public const string DEBUG_LOG_DOMAIN_CAL_QUERIES;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_DEBUG_LOG_DOMAIN_GLOG")]
	public const string DEBUG_LOG_DOMAIN_GLOG;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h", cname = "E_DEBUG_LOG_DOMAIN_USER")]
	public const string DEBUG_LOG_DOMAIN_USER;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool binding_transform_enum_nick_to_value (GLib.Binding binding, GLib.Value source_value, GLib.Value target_value, void* not_used);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool binding_transform_enum_value_to_nick (GLib.Binding binding, GLib.Value source_value, GLib.Value target_value, void* not_used);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void categories_add (string category, string unused, string icon_file, bool searchable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool categories_exist (string category);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static unowned string categories_get_icon_file_for (string category);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool categories_is_searchable (string category);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void categories_register_change_listener (GLib.Callback listener);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void categories_remove (string category);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void categories_set_icon_file_for (string category, string icon_file);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void categories_unregister_change_listener (GLib.Callback listener);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static int data_server_util_get_dbus_call_timeout ();
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void data_server_util_set_dbus_call_timeout (int timeout_msec);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void debug_log_clear ();
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void debug_log_disable_domains (string domains, int n_domains);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool debug_log_dump (string filename) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool debug_log_dump_to_dated_file () throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void debug_log_enable_domains (string domains, int n_domains);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static int debug_log_get_max_lines ();
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool debug_log_is_domain_enabled (string domain);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool debug_log_load_configuration (string filename) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void debug_log_set_max_lines (int num_lines);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void filename_make_safe (string string);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static string filename_mkdir_encoded (string basepath, string fileprefix, string filename, int fileindex);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_complete_async_method (void* object, GLib.DBusMethodInvocation invocation, uint opid);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_complete_sync_method_boolean (void* object, GLib.DBusMethodInvocation invocation, bool out_boolean, GLib.Error error);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_complete_sync_method_string (void* object, GLib.DBusMethodInvocation invocation, string out_string, GLib.Error error);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_complete_sync_method_strv (void* object, GLib.DBusMethodInvocation invocation, string out_strv, GLib.Error error);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_complete_sync_method_uint (void* object, GLib.DBusMethodInvocation invocation, uint out_uint, GLib.Error error);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_complete_sync_method_void (void* object, GLib.DBusMethodInvocation invocation, GLib.Error error);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_BOOLEAN__OBJECT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_BOOLEAN__OBJECT_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_BOOLEAN__OBJECT_BOXED (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_BOOLEAN__OBJECT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_BOOLEAN__OBJECT_UINT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_BOOLEAN__POINTER (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_VOID__STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_VOID__UINT_BOXED (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_VOID__UINT_BOXED_BOXED (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_VOID__UINT_BOXED_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_marshallers_VOID__UINT_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_proxy_async_method_done_boolean (E.GdbusAsyncOpKeeper proxy, uint arg_opid, GLib.Error error, bool out_boolean);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_proxy_async_method_done_string (E.GdbusAsyncOpKeeper proxy, uint arg_opid, GLib.Error error, string out_string);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_proxy_async_method_done_strv (E.GdbusAsyncOpKeeper proxy, uint arg_opid, GLib.Error error, string out_strv);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_proxy_async_method_done_uint (E.GdbusAsyncOpKeeper proxy, uint arg_opid, GLib.Error error, uint out_uint);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_proxy_async_method_done_void (E.GdbusAsyncOpKeeper proxy, uint arg_opid, GLib.Error error);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static async void gdbus_proxy_call_boolean (string method_name, void* source_tag, E.GdbusAsyncOpKeeper proxy, bool in_boolean, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static async void gdbus_proxy_call_string (string method_name, void* source_tag, E.GdbusAsyncOpKeeper proxy, string in_string, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static async void gdbus_proxy_call_strv (string method_name, void* source_tag, E.GdbusAsyncOpKeeper proxy, string in_strv, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static async void gdbus_proxy_call_uint (string method_name, void* source_tag, E.GdbusAsyncOpKeeper proxy, uint in_uint, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static async void gdbus_proxy_call_void (string method_name, void* source_tag, E.GdbusAsyncOpKeeper proxy, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_proxy_emit_signal (GLib.DBusProxy proxy, GLib.Variant parameters, uint signal_id, uint signal_type);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_finish_call_boolean (E.GdbusAsyncOpKeeper proxy, GLib.AsyncResult result, bool out_boolean, GLib.Error error, void* source_tag);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_finish_call_string (E.GdbusAsyncOpKeeper proxy, GLib.AsyncResult result, string out_string, GLib.Error error, void* source_tag);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_finish_call_strv (E.GdbusAsyncOpKeeper proxy, GLib.AsyncResult result, string out_strv, GLib.Error error, void* source_tag);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_finish_call_uint (E.GdbusAsyncOpKeeper proxy, GLib.AsyncResult result, uint out_uint, GLib.Error error, void* source_tag);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_finish_call_void (E.GdbusAsyncOpKeeper proxy, GLib.AsyncResult result, GLib.Error error, void* source_tag);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static async void gdbus_proxy_method_call_boolean (string method_name, GLib.DBusProxy proxy, bool in_boolean, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_finish_boolean (GLib.DBusProxy proxy, GLib.AsyncResult result, bool out_boolean) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_finish_string (GLib.DBusProxy proxy, GLib.AsyncResult result, string out_string) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_finish_strv (GLib.DBusProxy proxy, GLib.AsyncResult result, string out_strv) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_finish_uint (GLib.DBusProxy proxy, GLib.AsyncResult result, uint out_uint) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_finish_void (GLib.DBusProxy proxy, GLib.AsyncResult result) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static async void gdbus_proxy_method_call_string (string method_name, GLib.DBusProxy proxy, string in_string, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static async void gdbus_proxy_method_call_strv (string method_name, GLib.DBusProxy proxy, string in_strv, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_sync_boolean__void (string method_name, GLib.DBusProxy proxy, bool in_boolean, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_sync_string__string (string method_name, GLib.DBusProxy proxy, string in_string, string out_string, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_sync_string__void (string method_name, GLib.DBusProxy proxy, string in_string, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_sync_strv__string (string method_name, GLib.DBusProxy proxy, string in_strv, string out_string, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_sync_strv__void (string method_name, GLib.DBusProxy proxy, string in_strv, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_sync_uint__void (string method_name, GLib.DBusProxy proxy, uint in_uint, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_proxy_method_call_sync_void__void (string method_name, GLib.DBusProxy proxy, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static async void gdbus_proxy_method_call_uint (string method_name, GLib.DBusProxy proxy, uint in_uint, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static async void gdbus_proxy_method_call_void (string method_name, GLib.DBusProxy proxy, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_async_boolean (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_async_string (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_async_strv (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_async_uint (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_async_void (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_boolean (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_string (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_strv (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_uint (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_uint_string (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_signal_emission_hook_void (GLib.SignalInvocationHint ihint, uint n_param_values, GLib.Value param_values, string signal_name, string iface_name);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_stub_handle_method_call (GLib.Object stub_object, GLib.DBusMethodInvocation invocation, GLib.Variant parameters, string method_name, uint method_id, uint method_type);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_templates_decode_error (string in_strv) throws GLib.Error;
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool gdbus_templates_decode_two_strings (string in_strv, string out_str1, string out_str2);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void gdbus_templates_init_main_thread ();
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static unowned string get_user_cache_dir ();
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static unowned string get_user_config_dir ();
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static unowned string get_user_data_dir ();
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void localtime_with_offset (long tt, void* tm, int offset);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void memchunk_clean (E.MemChunk memchunk);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void memchunk_destroy (E.MemChunk memchunk);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void memchunk_empty (E.MemChunk memchunk);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void memchunk_free (E.MemChunk memchunk, void* mem);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static long mktime_utc (void* tm);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void pointer_tracker_dump ();
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void pointer_tracker_track_with_info (void* ptr, string info);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void pointer_tracker_untrack (void* ptr);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static size_t strftime (string string, size_t max, string fmt, void* tm);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void time_format_date_and_time (void* date_tm, bool use_24_hour_format, bool show_midnight, bool show_zero_seconds, string buffer, int buffer_size);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void time_format_time (void* date_tm, bool use_24_hour_format, bool show_zero_seconds, string buffer, int buffer_size);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static string time_get_d_fmt_with_4digit_year ();
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static E.TimeParseStatus time_parse_date (string value, void* result);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static E.TimeParseStatus time_parse_date_and_time (string value, void* result);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static E.TimeParseStatus time_parse_date_and_time_ex (string value, void* result, bool two_digit_year);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static E.TimeParseStatus time_parse_date_ex (string value, void* result, bool two_digit_year);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static E.TimeParseStatus time_parse_time (string value, void* result);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static string uid_new ();
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static bool url_equal (string url1, string url2);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static string url_shroud (string url);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static size_t utf8_strftime (string string, size_t max, string fmt, void* tm);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static unowned string util_ensure_gdbus_string (string str, string gdbus_str);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static uint64 util_gthread_id (GLib.Thread thread);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static string util_strstrcase (string haystack, string needle);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static string util_unicode_get_utf8 (string text, unichar @out);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static string util_utf8_make_valid (string str);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static string util_utf8_remove_accents (string str);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static int util_utf8_strcasecmp (string s1, string s2);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static unowned string util_utf8_strstrcase (string haystack, string needle);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static unowned string util_utf8_strstrcasedecomp (string haystack, string needle);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void xml_destroy_hash (GLib.HashTable<void*,void*> hash);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static int xml_save_file (string filename, Xml.Doc doc);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static GLib.HashTable<void*,void*> xml_to_hash (Xml.Doc doc, E.XmlHashType type);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void xmlhash_add (E.XmlHash hash, string key, string data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static E.XmlHashStatus xmlhash_compare (E.XmlHash hash, string key, string compare_data);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void xmlhash_destroy (E.XmlHash hash);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void xmlhash_foreach_key (E.XmlHash hash, E.XmlHashFunc func);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void xmlhash_foreach_key_remove (E.XmlHash hash, E.XmlHashRemoveFunc func);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void xmlhash_remove (E.XmlHash hash, string key);
	[CCode (cheader_filename = "libedataserver/e-account.h,libedataserver/e-source.h")]
	public static void xmlhash_write (E.XmlHash hash);
}
