/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.comp;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.xml.comp.CXMLCodeSpace;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.InfosetReader;
import oracle.xml.parser.v2.PageManager;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.TypedAttributes;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.util.ArrayPool;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;

public class CXMLStream
implements CXMLConstants,
InfosetReader {
    PageManager pageMgr;
    PageManager.PageId pageId;
    ArrayList pageIdList;
    int pageStart;
    ObjectOutput oos;
    ObjectInput ois;
    byte[] buf = ArrayPool.allocByteArrDefault();
    int readPos;
    int writePos;
    CXMLContext cxmlContext;
    CXMLCodeSpace nsCodeSpace;
    CXMLCodeSpace elemCodeSpace;
    CXMLCodeSpace prefixCodeSpace;
    CXMLCodeSpace attrCodeSpace;
    byte cxml_version;
    DTD dtd;
    int dtdEnd;
    char[] data;
    int dataLen;
    int eventType;
    QxName qname;
    int elemDepth;
    CXMLOffset curOffset;
    Stack skipOffsets;
    QxName elemtypename;
    QxName attrtypename;
    int elemtypeid;
    int attrtypeid;
    boolean global;
    boolean nillable;
    String version;
    String encoding;
    String standalone;
    SAXAttrList attrs;
    ArrayList typelist;

    public CXMLStream() {
        this.cxmlContext = new CXMLContext();
        this.nsCodeSpace = this.cxmlContext.getNSCodeSpace();
        this.elemCodeSpace = this.cxmlContext.getElemCodeSpace();
        this.attrCodeSpace = this.cxmlContext.getAttrCodeSpace();
        this.prefixCodeSpace = this.cxmlContext.getPrefixCodeSpace();
        this.data = new char[256];
        this.typelist = new ArrayList();
    }

    public CXMLStream(CXMLContext cXMLContext) {
        this.cxmlContext = cXMLContext;
        this.nsCodeSpace = cXMLContext.getNSCodeSpace();
        this.elemCodeSpace = cXMLContext.getElemCodeSpace();
        this.attrCodeSpace = cXMLContext.getAttrCodeSpace();
        this.prefixCodeSpace = cXMLContext.getPrefixCodeSpace();
        this.data = new char[256];
        this.typelist = new ArrayList();
    }

    public void init(XMLDocument xMLDocument) {
        try {
            xMLDocument.readExternal(this, this.cxmlContext);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public boolean isNSResolutionSupported() {
        return false;
    }

    public String getNamespaceURI(String string) {
        return null;
    }

    public String getPrefix(String string) {
        return null;
    }

    public boolean isSeekSupported() {
        return true;
    }

    public InfosetReader.Offset getOffset() {
        CXMLOffset cXMLOffset = this.curOffset;
        this.curOffset = new CXMLOffset(this.curOffset.pageId, this.curOffset.index);
        return cXMLOffset;
    }

    public void seek(InfosetReader.Offset offset) {
        this.elemDepth = 0;
        CXMLOffset cXMLOffset = (CXMLOffset)offset;
        if (this.pageId != null && cXMLOffset.pageId.equals(this.pageId)) {
            if (cXMLOffset.index == this.curOffset.index) {
                return;
            }
            this.readPos = this.pageStart + cXMLOffset.index;
        } else {
            int n = this.pageMgr.pageLength(cXMLOffset.pageId);
            if (n > this.buf.length) {
                int n2 = 2 * this.buf.length;
                if (n2 < n) {
                    n2 = n;
                }
                this.buf = new byte[n2];
            }
            this.pageStart = 0;
            this.writePos = this.pageMgr.readPage(cXMLOffset.pageId, this.buf, 0);
            this.pageId = cXMLOffset.pageId;
            this.readPos = cXMLOffset.index;
        }
        this.next();
    }

    public byte offsetToBytes(InfosetReader.Offset offset, byte[] byArray, int n) {
        CXMLOffset cXMLOffset = (CXMLOffset)offset;
        if (n + 4 > byArray.length) {
            return -1;
        }
        byArray[n++] = (byte)(cXMLOffset.index >>> 24 & 0xFF);
        byArray[n++] = (byte)(cXMLOffset.index >>> 16 & 0xFF);
        byArray[n++] = (byte)(cXMLOffset.index >>> 8 & 0xFF);
        byArray[n++] = (byte)(cXMLOffset.index >>> 0 & 0xFF);
        byte by = this.pageMgr.pageIdToBytes(cXMLOffset.pageId, byArray, n);
        if (by == -1) {
            return -1;
        }
        return (byte)(by + 4);
    }

    public InfosetReader.Offset offsetFromBytes(byte[] byArray, int n) {
        if (n + 4 > byArray.length) {
            return null;
        }
        int n2 = byArray[n++] & 0xFF;
        int n3 = byArray[n++] & 0xFF;
        int n4 = byArray[n++] & 0xFF;
        int n5 = byArray[n++] & 0xFF;
        int n6 = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
        PageManager.PageId pageId = this.pageMgr.pageIdFromBytes(byArray, n);
        if (pageId == null) {
            return null;
        }
        return new CXMLOffset(pageId, n6);
    }

    public int getEventType() {
        return this.eventType;
    }

    public boolean hasNext() {
        return this.eventType != 8;
    }

    public void next() {
        try {
            byte by = this.peekByte();
            this.curOffset.pageId = this.pageId;
            this.curOffset.index = this.readPos;
            switch (by) {
                case 0: {
                    this.eventType = 7;
                    this.readDocument();
                    break;
                }
                case 15: 
                case 28: {
                    ++this.elemDepth;
                    this.eventType = 1;
                    this.qname = this.readQName();
                    this.readAttributes();
                    break;
                }
                case 23: {
                    this.eventType = 4;
                    this.readByte();
                    this.readChars();
                    this.checkNullStr();
                    break;
                }
                case 21: {
                    this.eventType = 12;
                    this.readByte();
                    this.readChars();
                    this.checkNullStr();
                    break;
                }
                case 20: {
                    this.eventType = 3;
                    this.readByte();
                    this.readTagName();
                    this.readChars();
                    this.readBoolean();
                    this.checkNullStr();
                    break;
                }
                case 29: {
                    this.eventType = 5;
                    this.readByte();
                    this.readChars();
                    this.readBoolean();
                    this.checkNullStr();
                    break;
                }
                case 30: {
                    this.eventType = 14;
                    this.readByte();
                    this.readTagName();
                    break;
                }
                case 22: {
                    this.eventType = 8;
                    if (this.elemDepth != 0) {
                        this.eventType = 2;
                        --this.elemDepth;
                    }
                    this.readByte();
                    break;
                }
                case 34: {
                    this.ensureReadCapacity(3);
                    this.readPos += 3;
                    this.next();
                    return;
                }
                default: {
                    throw new RuntimeException("byte " + this.peekByte() + " " + this.readPos);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void skip() {
        if (this.eventType == 1) {
            try {
                this.skip(true);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
            this.eventType = 2;
            --this.elemDepth;
        } else {
            this.next();
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStandalone() {
        return this.standalone;
    }

    public DTD getDoctype() {
        return this.dtd;
    }

    public QName getQName() {
        return this.qname;
    }

    public QName getTypeName() {
        return this.elemtypename;
    }

    public int getPrimitiveTypeId() {
        return this.elemtypeid;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isNilled() {
        return this.nillable;
    }

    public TypedAttributes getAttributes() {
        return this.attrs;
    }

    public char[] getData() {
        return this.data;
    }

    public int getDataStart() {
        return 0;
    }

    public int getDataLength() {
        return this.dataLen;
    }

    public void setObjectOutput(ObjectOutput objectOutput) {
        this.oos = objectOutput;
        this.buf = ArrayPool.allocByteArrDefault();
        this.writePos = 0;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        if (this.oos != null) {
            this.oos.flush();
        }
    }

    void startElementContent() throws IOException {
        if (this.pageMgr != null) {
            this.ensureWriteCapacity(3);
            CXMLOffset cXMLOffset = new CXMLOffset(null, this.writePos);
            this.skipOffsets.push(cXMLOffset);
            this.writeByte(34);
            this.writeShort(0);
        }
    }

    void endElementContent() throws IOException {
        if (this.pageMgr != null && !this.skipOffsets.isEmpty()) {
            CXMLOffset cXMLOffset = (CXMLOffset)this.skipOffsets.pop();
            int n = this.writePos - cXMLOffset.index - 3;
            if (n >= 65535) {
                n = 0;
            }
            this.buf[cXMLOffset.index + 1] = (byte)(n >>> 8 & 0xFF);
            this.buf[cXMLOffset.index + 2] = (byte)(n >>> 0 & 0xFF);
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.ensureWriteCapacity(1);
        this.buf[this.writePos++] = (byte)(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.ensureWriteCapacity(1);
        this.buf[this.writePos++] = (byte)n;
    }

    public void writeShort(int n) throws IOException {
        this.ensureWriteCapacity(2);
        this.buf[this.writePos++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.writePos++] = (byte)(n >>> 0 & 0xFF);
    }

    public void writeChar(int n) throws IOException {
        this.ensureWriteCapacity(2);
        this.buf[this.writePos++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.writePos++] = (byte)(n >>> 0 & 0xFF);
    }

    public void writeInt(int n) throws IOException {
        this.ensureWriteCapacity(4);
        this.buf[this.writePos++] = (byte)(n >>> 24 & 0xFF);
        this.buf[this.writePos++] = (byte)(n >>> 16 & 0xFF);
        this.buf[this.writePos++] = (byte)(n >>> 8 & 0xFF);
        this.buf[this.writePos++] = (byte)(n >>> 0 & 0xFF);
    }

    public void writeUTF(String string) throws IOException {
        int n;
        int n2;
        int n3 = 2;
        if (string == null) {
            string = "null";
        }
        if ((n2 = string.length()) >= 65535) {
            n3 = 6;
        }
        char[] cArray = new char[n2];
        this.ensureWriteCapacity(this.getStrByteSize(cArray) + n3);
        int n4 = this.writePos;
        string.getChars(0, n2, cArray, 0);
        this.writePos += n3;
        for (n = 0; n < n2; ++n) {
            char c = cArray[n];
            if (c >= '\u0001' && c <= '\u007f') {
                this.buf[this.writePos++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.buf[this.writePos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buf[this.writePos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buf[this.writePos++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buf[this.writePos++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buf[this.writePos++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        n = this.writePos - n4 - n3;
        if (n3 == 6) {
            this.buf[n4] = -1;
            this.buf[n4 + 1] = -1;
            this.buf[n4 + 2] = (byte)(n >>> 24 & 0xFF);
            this.buf[n4 + 3] = (byte)(n >>> 16 & 0xFF);
            this.buf[n4 + 4] = (byte)(n >>> 8 & 0xFF);
            this.buf[n4 + 5] = (byte)(n >>> 0 & 0xFF);
        } else {
            this.buf[n4] = (byte)(n >>> 8 & 0xFF);
            this.buf[n4 + 1] = (byte)(n >>> 0 & 0xFF);
        }
    }

    public void setObjectInput(ObjectInput objectInput) {
        this.ois = objectInput;
        this.buf = ArrayPool.allocByteArrDefault();
        this.readPos = 0;
    }

    public void reset() {
        PageManager.PageId pageId = (PageManager.PageId)this.pageIdList.get(0);
        this.seek(new CXMLOffset(pageId, 0));
    }

    public void setPageManager(PageManager pageManager) {
        this.pageMgr = pageManager;
        this.attrs = new SAXAttrList(4);
        this.skipOffsets = new Stack();
        this.curOffset = new CXMLOffset(null, 0);
        this.pageIdList = new ArrayList();
    }

    public int available() throws IOException {
        if (this.readPos < this.writePos) {
            return this.writePos - this.readPos;
        }
        return this.ois.available();
    }

    public boolean readBoolean() throws IOException {
        this.ensureReadCapacity(1);
        int n = this.buf[this.readPos++] & 0xFF;
        return n != 0;
    }

    public byte readByte() throws IOException {
        this.ensureReadCapacity(1);
        return this.buf[this.readPos++];
    }

    public byte peekByte() throws IOException {
        this.ensureReadCapacity(1);
        return this.buf[this.readPos];
    }

    public int readShort() throws IOException {
        this.ensureReadCapacity(2);
        int n = this.buf[this.readPos++] & 0xFF;
        int n2 = this.buf[this.readPos++] & 0xFF;
        return (n << 8) + n2;
    }

    public char readChar() throws IOException {
        this.ensureReadCapacity(2);
        int n = this.buf[this.readPos++] & 0xFF;
        int n2 = this.buf[this.readPos++] & 0xFF;
        return (char)((n << 8) + n2);
    }

    public int readInt() throws IOException {
        this.ensureReadCapacity(4);
        int n = this.buf[this.readPos++] & 0xFF;
        int n2 = this.buf[this.readPos++] & 0xFF;
        int n3 = this.buf[this.readPos++] & 0xFF;
        int n4 = this.buf[this.readPos++] & 0xFF;
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public String readUTF() throws IOException {
        this.readChars();
        String string = null;
        string = new String(this.data, 0, this.dataLen);
        if (string.equals("null")) {
            string = null;
        }
        return string;
    }

    public QxName readQName() throws IOException {
        QxName qxName;
        int n;
        byte by;
        int n2;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n3 = this.readByte();
        if (n3 != 28 && n3 != 15) {
            throw new IOException("Error in serialization of Element node " + n3);
        }
        if (n3 == 28) {
            string2 = this.readUTF();
            if (this.cxml_version == 2) {
                n3 = this.peekByte();
                if (n3 == 27 || n3 == 33) {
                    bl2 = true;
                }
            } else {
                bl2 = this.readBoolean();
                bl3 = this.readBoolean();
            }
            bl = this.elemCodeSpace.addToken(string2);
        } else if (n3 == 15) {
            n3 = this.readByte();
            if ((n3 & 0x80) == 128) {
                bl2 = CXMLCodeSpace.isNamespacePresent((byte)n3);
                if (this.cxml_version == 1) {
                    bl3 = CXMLCodeSpace.isPrefixPresent((byte)n3);
                }
                n2 = n3;
                by = this.readByte();
                n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
            } else if ((n3 & 0xC0) == 192) {
                bl2 = CXMLCodeSpace.isNamespacePresent((byte)n3);
                if (this.cxml_version == 1) {
                    bl3 = CXMLCodeSpace.isPrefixPresent((byte)n3);
                }
                n2 = this.readByte();
                by = this.readByte();
                n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
            } else {
                n = n3;
            }
            string2 = this.elemCodeSpace.getElementFromToken(n);
        }
        if (bl2) {
            n3 = this.readByte();
            if (n3 == 27) {
                string5 = this.readUTF();
                bl = this.nsCodeSpace.addToken(string5);
            } else {
                if (this.cxml_version == 2) {
                    if (n3 != 33) {
                        throw new IOException("Error in reading Namespace associated with the node");
                    }
                    n3 = this.readByte();
                }
                if ((n3 & 0x80) == 128) {
                    n2 = n3;
                    by = this.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                } else if ((n3 & 0xC0) == 192) {
                    n2 = this.readByte();
                    by = this.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                } else {
                    n = n3;
                }
                string5 = this.nsCodeSpace.getElementFromToken(n);
            }
        }
        if (this.cxml_version == 1) {
            this.prefixCodeSpace = this.cxmlContext.getPrefixCodeSpace();
            if (bl3) {
                n3 = this.readByte();
                if (n3 == 26) {
                    string = this.readUTF();
                    bl = this.prefixCodeSpace.addToken(string);
                } else {
                    if ((n3 & 0x80) == 128) {
                        n2 = n3;
                        by = this.readByte();
                        n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                    } else if ((n3 & 0xC0) == 192) {
                        n2 = this.readByte();
                        by = this.readByte();
                        n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                    } else {
                        n = n3;
                    }
                    string = this.prefixCodeSpace.getElementFromToken(n);
                }
            }
        }
        if (this.cxml_version == 2) {
            qxName = QxNameHash.create(string5, string2);
        } else {
            string4 = string2;
            string3 = bl3 ? string + ":" + string4 : string2;
            qxName = QxNameHash.create(string5, string4, string, string3);
        }
        this.global = false;
        this.nillable = false;
        this.elemtypename = null;
        this.elemtypeid = -1;
        n3 = this.peekByte();
        if (n3 == 35 || n3 == 36) {
            this.readByte();
            byte by2 = this.readByte();
            this.nillable = (by2 & 2) == 2;
            boolean bl4 = this.global = (by2 & 1) == 1;
            if ((by2 & 4) == 4) {
                this.elemtypeid = this.readByte();
            }
            int n4 = (by2 & 8) == 8 ? this.readInt() : this.readShort();
            if (n3 == 35) {
                this.elemtypename = QxNameHash.create(this.readUTF(), this.readUTF());
                this.ensureTypeCapacity(n4 + 1);
                this.typelist.set(n4, this.elemtypename);
            } else {
                this.elemtypename = (QxName)this.typelist.get(n4);
            }
        }
        return qxName;
    }

    public QxName readAttrQName() throws IOException {
        QxName qxName;
        int n;
        byte by;
        int n2;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n3 = this.readByte();
        if (n3 != 25 && n3 != 24) {
            throw new IOException("Error in serialization of Attr node " + n3);
        }
        if (n3 == 25) {
            string2 = this.readUTF();
            if (this.cxml_version == 2) {
                n3 = this.peekByte();
                if (n3 == 27 || n3 == 33) {
                    bl2 = true;
                }
            } else {
                bl2 = this.readBoolean();
                bl3 = this.readBoolean();
            }
            bl = this.attrCodeSpace.addToken(string2);
        } else if (n3 == 24) {
            n3 = this.readByte();
            if ((n3 & 0x80) == 128) {
                bl2 = CXMLCodeSpace.isNamespacePresent((byte)n3);
                if (this.cxml_version == 1) {
                    bl3 = CXMLCodeSpace.isPrefixPresent((byte)n3);
                }
                n2 = n3;
                by = this.readByte();
                n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
            } else if ((n3 & 0xC0) == 192) {
                bl2 = CXMLCodeSpace.isNamespacePresent((byte)n3);
                if (this.cxml_version == 1) {
                    bl3 = CXMLCodeSpace.isPrefixPresent((byte)n3);
                }
                n2 = this.readByte();
                by = this.readByte();
                n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
            } else {
                n = n3;
            }
            string2 = this.attrCodeSpace.getElementFromToken(n);
        }
        if (bl2) {
            n3 = this.readByte();
            if (n3 == 27) {
                string5 = this.readUTF();
                bl = this.nsCodeSpace.addToken(string5);
            } else {
                if (this.cxml_version == 2) {
                    if (n3 != 33) {
                        throw new IOException("Error in reading Namespace associated with the node");
                    }
                    n3 = this.readByte();
                }
                if ((n3 & 0x80) == 128) {
                    n2 = n3;
                    by = this.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                } else if ((n3 & 0xC0) == 192) {
                    n2 = this.readByte();
                    by = this.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                } else {
                    n = n3;
                }
                string5 = this.nsCodeSpace.getElementFromToken(n);
            }
        }
        if (this.cxml_version == 1) {
            this.prefixCodeSpace = this.cxmlContext.getPrefixCodeSpace();
            if (bl3) {
                n3 = this.readByte();
                if (n3 == 26) {
                    string = this.readUTF();
                    bl = this.prefixCodeSpace.addToken(string);
                } else {
                    if ((n3 & 0x80) == 128) {
                        n2 = n3;
                        by = this.readByte();
                        n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                    } else if ((n3 & 0xC0) == 192) {
                        n2 = this.readByte();
                        by = this.readByte();
                        n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                    } else {
                        n = n3;
                    }
                    string = this.prefixCodeSpace.getElementFromToken(n);
                }
            }
        }
        if (this.cxml_version == 2) {
            qxName = QxNameHash.create(string5, string2);
        } else {
            string4 = string2;
            string3 = bl3 ? string + ":" + string4 : string2;
            qxName = QxNameHash.create(string5, string4, string, string3);
        }
        this.attrtypename = null;
        this.attrtypeid = -1;
        n3 = this.peekByte();
        if (n3 == 35 || n3 == 36) {
            this.readByte();
            byte by2 = this.readByte();
            if ((by2 & 4) == 4) {
                this.attrtypeid = this.readByte();
            }
            int n4 = (by2 & 8) == 8 ? this.readInt() : this.readShort();
            if (n3 == 35) {
                this.attrtypename = QxNameHash.create(this.readUTF(), this.readUTF());
                this.ensureTypeCapacity(n4 + 1);
                this.typelist.set(n4, this.attrtypename);
            } else {
                this.attrtypename = (QxName)this.typelist.get(n4);
            }
        }
        return qxName;
    }

    public void readDocument() throws IOException {
        byte by;
        char[] cArray = new char[4];
        for (by = 0; by < 4; ++by) {
            cArray[by] = this.readChar();
        }
        if (cArray[0] != 'c' && cArray[1] != 'x' && cArray[2] != 'm' && cArray[3] != 'l') {
            throw new IOException("Error: The binary stream is not a compressed serialized stream");
        }
        this.cxml_version = this.cxmlContext.getVersion();
        by = this.readByte();
        if (by > 2 && by != this.cxml_version) {
            throw new IOException("Error: The binary stream version is not compatible with this release of parser.");
        }
        if (this.cxml_version == 1) {
            this.readUTF();
        }
        if (this.peekByte() == 16) {
            this.readByte();
            this.version = this.readUTF();
            this.encoding = this.readUTF();
            if (this.cxml_version == 2) {
                by = this.readByte();
                if (by == 1) {
                    this.standalone = "yes";
                } else if (by == 16) {
                    this.standalone = "no";
                }
            } else {
                this.standalone = this.readUTF();
            }
        }
    }

    public void readAttributes() throws IOException {
        int n = 0;
        byte by = this.peekByte();
        this.attrs.reset();
        while (by == 25 || by == 24) {
            QxName qxName = this.readAttrQName();
            this.attrs.addAttr(qxName.getPrefix(), qxName.getLocalPart(), qxName.getQName(), this.readUTF(), this.readBoolean(), 0, qxName.getNamespaceURI());
            this.attrs.setTypeInfo(n, this.attrtypeid, this.attrtypename);
            by = this.peekByte();
            ++n;
        }
        if (this.cxml_version == 1 && n > 0) {
            this.readByte();
        }
    }

    public void readChars() throws IOException {
        int n = this.readShort();
        if (n == 65535) {
            n = this.readInt();
        }
        this.ensureReadCapacity(n);
        if (n > this.data.length) {
            this.data = new char[n];
        }
        this.dataLen = 0;
        int n2 = this.readPos + n;
        block5: while (this.readPos < n2) {
            int n3 = this.buf[this.readPos] & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++this.readPos;
                    this.data[this.dataLen++] = (char)n3;
                    continue block5;
                }
                case 12: 
                case 13: {
                    this.readPos += 2;
                    if (this.readPos > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = this.buf[this.readPos - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.data[this.dataLen++] = (char)((n3 & 0x1F) << 6 | by & 0x3F);
                    continue block5;
                }
                case 14: {
                    this.readPos += 3;
                    if (this.readPos > n2) {
                        throw new UTFDataFormatException();
                    }
                    byte by = this.buf[this.readPos - 2];
                    byte by2 = this.buf[this.readPos - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    this.data[this.dataLen++] = (char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
    }

    public void readTagName() throws IOException {
        String string = this.readUTF();
        this.qname = QxNameHash.create("", string, "", string);
    }

    public void close() {
        try {
            if (this.ois != null) {
                this.ois.close();
            }
            this.flushBuffer();
            if (this.oos != null) {
                this.oos.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    private void skip(boolean bl) throws IOException {
        int n = 1;
        block12: do {
            byte by = this.readByte();
            switch (by) {
                case 15: 
                case 28: {
                    ++n;
                    this.skipToken(by);
                    this.skipAttrs();
                    break;
                }
                case 24: 
                case 25: {
                    this.skipToken(by);
                    this.skipString();
                    this.skipByte();
                    break;
                }
                case 21: 
                case 23: {
                    this.skipString();
                    while (this.peekByte() == by) {
                        ++this.readPos;
                        this.skipString();
                    }
                    continue block12;
                }
                case 16: 
                case 20: {
                    this.skipString();
                    this.skipString();
                    this.skipByte();
                    break;
                }
                case 29: {
                    this.skipString();
                    this.skipByte();
                    break;
                }
                case 31: {
                    --this.readPos;
                    if (this.dtd == null) {
                        this.dtd = new DTD();
                        try {
                            this.dtd.readExternal(this, this.cxmlContext);
                            this.dtd.readChildNodes(this, this.cxmlContext);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new IOException(classNotFoundException.getMessage());
                        }
                        this.dtdEnd = this.readPos;
                        break;
                    }
                    this.readPos = this.dtdEnd;
                    break;
                }
                case 22: {
                    --n;
                    break;
                }
                case 34: {
                    this.ensureReadCapacity(2);
                    int n2 = this.readShort();
                    if (!bl) continue block12;
                    this.readPos += n2;
                    break;
                }
                default: {
                    throw new RuntimeException("byte " + this.peekByte() + " " + this.readPos);
                }
            }
        } while (bl && n != 0);
    }

    private void skipAttrs() throws IOException {
        byte by;
        while ((by = this.peekByte()) == 25 || by == 24) {
            ++this.readPos;
            this.skipToken(by);
            this.skipString();
            this.skipByte();
        }
    }

    private void skipByte() throws IOException {
        this.ensureReadCapacity(1);
        ++this.readPos;
    }

    private void skipString() throws IOException {
        int n = this.readShort();
        if (n == 65535) {
            n = this.readInt();
        }
        this.ensureReadCapacity(n);
        this.readPos += n;
    }

    private void skipToken(byte by) throws IOException {
        String string;
        if (by == 28 || by == 25) {
            string = this.readUTF();
            if (by == 28) {
                this.cxmlContext.elemCodeSpace.addToken(string);
            } else if (by == 25) {
                this.cxmlContext.attrCodeSpace.addToken(string);
            }
        } else {
            byte by2 = this.readByte();
            if ((by2 & 0x80) == 128) {
                this.skipByte();
            }
            if ((by2 & 0xC0) == 192) {
                this.skipByte();
            }
        }
        by = this.peekByte();
        if (by == 27) {
            ++this.readPos;
            string = this.readUTF();
            this.cxmlContext.nsCodeSpace.addToken(string);
        } else if (by == 33) {
            ++this.readPos;
            byte by3 = this.readByte();
            if ((by3 & 0x80) == 128) {
                this.skipByte();
            }
            if ((by3 & 0xC0) == 192) {
                this.skipByte();
            }
        }
        by = this.peekByte();
        if (by == 35 || by == 36) {
            this.readByte();
            byte by4 = this.readByte();
            int n = (by4 & 8) == 8 ? this.readInt() : this.readShort();
            if ((by4 & 4) == 4) {
                this.readByte();
            }
            if (by == 35) {
                QxName qxName = QxNameHash.create(this.readUTF(), this.readUTF());
                this.ensureTypeCapacity(n + 1);
                this.typelist.set(n, qxName);
            }
        }
    }

    private void ensureWriteCapacity(int n) throws IOException {
        int n2;
        if (this.writePos + n <= this.buf.length) {
            return;
        }
        if (this.oos != null || this.pageMgr != null) {
            this.flushBuffer();
            n2 = this.buf.length;
        } else {
            n2 = 2 * this.buf.length;
        }
        if (n2 < this.writePos + n) {
            n2 = this.writePos + n;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
        this.buf = byArray;
    }

    private void flushBuffer() throws IOException {
        if (this.oos != null) {
            this.oos.write(this.buf, 0, this.writePos);
        } else if (this.pageMgr != null) {
            this.skipOffsets.clear();
            PageManager.PageId pageId = this.pageMgr.writePage(this.buf, 0, this.writePos);
            this.pageIdList.add(pageId);
        }
        this.writePos = 0;
    }

    private void ensureTypeCapacity(int n) {
        int n2;
        for (int i = n2 = this.typelist.size(); i < n; ++i) {
            this.typelist.add(null);
        }
    }

    private void ensureReadCapacity(int n) throws IOException {
        int n2;
        int n3;
        if (this.readPos + n <= this.writePos) {
            return;
        }
        if (this.readPos < this.writePos) {
            n3 = this.readPos;
            n2 = 0;
            while (n3 < this.writePos) {
                this.buf[n2] = this.buf[n3];
                ++n3;
                ++n2;
            }
        }
        this.writePos -= this.readPos;
        this.readPos = 0;
        n3 = this.buf.length - this.writePos;
        if (this.ois != null) {
            int n4;
            n2 = this.ois.available();
            if (n2 < n3) {
                n3 = n2;
                if (n2 == 0) {
                    n3 = n;
                }
            }
            if (n3 < n) {
                n3 = n;
            }
            while (n3 != 0 && (n4 = this.ois.read(this.buf, this.writePos, n3)) != -1) {
                this.writePos += n4;
                n3 -= n4;
            }
        } else if (this.pageMgr != null) {
            n2 = 0;
            int n5 = this.pageIdList.size();
            for (n2 = 0; n2 < n5 && !this.pageId.equals(this.pageIdList.get(n2)); ++n2) {
            }
            this.pageId = (PageManager.PageId)this.pageIdList.get(n2 + 1);
            int n6 = this.pageMgr.pageLength(this.pageId);
            if (n6 > n3) {
                int n7 = 2 * this.buf.length;
                if (n7 < this.writePos + n6) {
                    n7 = this.writePos + n6;
                }
                byte[] byArray = new byte[n7];
                System.arraycopy(this.buf, 0, byArray, 0, this.writePos);
                this.buf = byArray;
            }
            this.pageStart = this.writePos;
            this.writePos += this.pageMgr.readPage(this.pageId, this.buf, this.writePos);
        }
    }

    private int getStrByteSize(char[] cArray) {
        if (cArray.length * 3 < this.buf.length) {
            return cArray.length * 3;
        }
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++n;
                continue;
            }
            if (c > '\u07ff') {
                n += 3;
                continue;
            }
            n += 2;
        }
        return n;
    }

    private void checkNullStr() {
        if (this.dataLen == 4 && this.data[0] == 'n' && this.data[1] == 'u' && this.data[2] == 'l' && this.data[3] == 'l') {
            this.dataLen = 0;
        }
    }

    class CXMLOffset
    implements InfosetReader.Offset {
        PageManager.PageId pageId;
        int index;

        CXMLOffset(PageManager.PageId pageId, int n) {
            this.pageId = pageId;
            this.index = n;
        }

        public int compareTo(Object object) {
            CXMLOffset cXMLOffset = (CXMLOffset)object;
            int n = this.pageId.compareTo(cXMLOffset.pageId);
            if (n == 0) {
                return this.index - cXMLOffset.index;
            }
            return n;
        }

        public String toString() {
            return this.pageId.toString() + "-" + this.index;
        }

        public boolean equals(Object object) {
            if (object instanceof CXMLOffset) {
                CXMLOffset cXMLOffset = (CXMLOffset)object;
                return cXMLOffset.pageId.equals(this.pageId) && cXMLOffset.index == this.index;
            }
            return false;
        }
    }
}

