/*
 * Decompiled with CFR 0.152.
 */
package org.openamf;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openamf.AMFMessage;

public class RequestContext {
    private static ThreadLocal httpRequestLocal = new ThreadLocal();
    private static ThreadLocal httpResponseLocal = new ThreadLocal();
    private static ThreadLocal requestMsgLocal = new ThreadLocal();

    private RequestContext() {
    }

    public static void setHttpServletRequest(HttpServletRequest req) {
        httpRequestLocal.set(req);
    }

    public static void setHttpServletResponse(HttpServletResponse resp) {
        httpResponseLocal.set(resp);
    }

    public static void clear() {
        httpRequestLocal.set(null);
        httpResponseLocal.set(null);
        requestMsgLocal.set(null);
    }

    public static HttpServletRequest getHttpServletRequest() {
        HttpServletRequest req = (HttpServletRequest)httpRequestLocal.get();
        return req;
    }

    public static HttpServletResponse getHttpServletResponse() {
        HttpServletResponse resp = (HttpServletResponse)httpResponseLocal.get();
        return resp;
    }

    public static HttpSession getHttpSession() {
        return RequestContext.getHttpSession(true);
    }

    public static HttpSession getHttpSession(boolean create) {
        HttpServletRequest req = RequestContext.getHttpServletRequest();
        if (req == null) {
            throw new IllegalStateException("HttpServletRequest is null");
        }
        return req.getSession(create);
    }

    public static AMFMessage getRequestMessage() {
        return (AMFMessage)requestMsgLocal.get();
    }

    public static void setRequestMessage(AMFMessage m) {
        requestMsgLocal.set(m);
    }
}

