#!/bin/bash

args=("$@")
GPATH=${args[0]}
TEXFILE=${args[1]} # example1
INPATH=${args[2]} # papers_info
SPPATH=${args[3]}  #papers_split
PDFPATH=${args[4]}

cd ${GPATH}
SPPATH=${GPATH}/${SPPATH}
PDFFILE=${GPATH}/${TEXFILE}.pdf # PDF proceedings
echo "PDF proc used for individual PDFs extraction:\n  --> $PDFFILE"
echo "saving tmp .ps and .pdf files into\n  --> $SPPATH"
gs -dBATCH -dNOPAUSE -q -sDEVICE=pdfwrite -dFirstPage=7 -dLastPage=12 -sOUTPUTFILE=${SPPATH}/p_001.pdf ${PDFFILE}
gs -dBATCH -dNOPAUSE -q -sDEVICE=pdfwrite -dFirstPage=13 -dLastPage=17 -sOUTPUTFILE=${SPPATH}/p_003.pdf ${PDFFILE}
gs -dBATCH -dNOPAUSE -q -sDEVICE=pdfwrite -dFirstPage=19 -dLastPage=22 -sOUTPUTFILE=${SPPATH}/p_005.pdf ${PDFFILE}
gs -dBATCH -dNOPAUSE -q -sDEVICE=pdfwrite -dFirstPage=23 -dLastPage=28 -sOUTPUTFILE=${SPPATH}/p_007.pdf ${PDFFILE}
gs -dBATCH -dNOPAUSE -q -sDEVICE=pdfwrite -dFirstPage=29 -dLastPage=35 -sOUTPUTFILE=${SPPATH}/p_009.pdf ${PDFFILE}
