/*
 * Decompiled with CFR 0.152.
 */
package org.h2.web;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.web.WebServer;

public class PageParser {
    private WebServer server;
    private String page;
    private int pos;
    private HashMap settings;
    private int len;
    private StringBuffer result;

    public static String parse(WebServer server, String page, HashMap settings) {
        PageParser block = new PageParser(server, page, settings, 0);
        return block.parse();
    }

    private PageParser(WebServer server, String page, HashMap settings, int pos) {
        this.server = server;
        this.page = page;
        this.pos = pos;
        this.len = page.length();
        this.settings = settings;
        this.result = new StringBuffer(this.len);
    }

    private void setError(int i) {
        String s = this.page.substring(0, i) + "####BUG####" + this.page.substring(i);
        s = PageParser.escapeHtml(s);
        this.result = new StringBuffer(s);
    }

    private String parseBlockUntil(String end) throws Exception {
        PageParser block = new PageParser(this.server, this.page, this.settings, this.pos);
        block.parseAll();
        if (!block.readIf(end)) {
            throw new Exception();
        }
        this.pos = block.pos;
        return block.result.toString();
    }

    public String parse() {
        try {
            this.parseAll();
            if (this.pos != this.len) {
                this.setError(this.pos);
            }
        }
        catch (Exception e) {
            this.setError(this.pos);
        }
        return this.result.toString();
    }

    private void parseAll() throws Exception {
        int i;
        StringBuffer buff = this.result;
        String p = this.page;
        block4: for (i = this.pos; i < this.len; ++i) {
            char c = p.charAt(i);
            switch (c) {
                case '<': {
                    if (p.charAt(i + 1) == '%') {
                        if (p.charAt(i + 2) == '@') {
                            this.pos = i += 3;
                            this.read("include");
                            String file = this.readParam("file");
                            this.read("%>");
                            String s = this.server.getTextFile(file);
                            this.append(s);
                            i = this.pos;
                            continue block4;
                        }
                        this.setError(i);
                        return;
                    }
                    if (p.charAt(i + 3) == ':' && p.charAt(i + 1) == '/') {
                        this.pos = i;
                        return;
                    }
                    if (p.charAt(i + 2) == ':') {
                        this.pos = i;
                        if (this.readIf("<c:forEach")) {
                            String var = this.readParam("var");
                            String items = this.readParam("items");
                            this.read(">");
                            int start = this.pos;
                            ArrayList list = (ArrayList)this.get(items);
                            if (list == null) {
                                this.result.append("?items?");
                                list = new ArrayList();
                            }
                            if (list.size() == 0) {
                                this.parseBlockUntil("</c:forEach>");
                            }
                            for (int j = 0; j < list.size(); ++j) {
                                this.settings.put(var, list.get(j));
                                this.pos = start;
                                String block = this.parseBlockUntil("</c:forEach>");
                                this.result.append(block);
                            }
                        } else if (this.readIf("<c:if")) {
                            String test = this.readParam("test");
                            int eq = test.indexOf("=='");
                            if (eq < 0) {
                                this.setError(i);
                                return;
                            }
                            String val = test.substring(eq + 3, test.length() - 1);
                            test = test.substring(0, eq);
                            String value = (String)this.get(test);
                            this.read(">");
                            String block = this.parseBlockUntil("</c:if>");
                            --this.pos;
                            if (value.equals(val)) {
                                this.result.append(block);
                            }
                        } else {
                            this.setError(i);
                            return;
                        }
                        i = this.pos;
                        continue block4;
                    }
                    buff.append(c);
                    continue block4;
                }
                case '$': {
                    if (p.charAt(i + 1) != '{') continue block4;
                    int j = p.indexOf(125, i += 2);
                    if (j < 0) {
                        this.setError(i);
                        return;
                    }
                    String item = p.substring(i, j).trim();
                    i = j;
                    String s = (String)this.get(item);
                    this.append(s);
                    continue block4;
                }
                default: {
                    buff.append(c);
                }
            }
        }
        this.pos = i;
    }

    private Object get(String item) {
        int dot = item.indexOf(46);
        if (dot >= 0) {
            String sub = item.substring(dot + 1);
            HashMap map = (HashMap)this.settings.get(item = item.substring(0, dot));
            if (map == null) {
                return "?" + item + "?";
            }
            return map.get(sub);
        }
        return this.settings.get(item);
    }

    private void append(String s) {
        if (s != null) {
            this.result.append(PageParser.parse(this.server, s, this.settings));
        }
    }

    private String readParam(String name) throws Exception {
        this.read(name);
        this.read("=");
        this.read("\"");
        int start = this.pos;
        while (this.page.charAt(this.pos) != '\"') {
            ++this.pos;
        }
        int end = this.pos;
        this.read("\"");
        String s = this.page.substring(start, end);
        return PageParser.parse(this.server, s, this.settings);
    }

    private void skipSpaces() {
        while (this.page.charAt(this.pos) == ' ') {
            ++this.pos;
        }
    }

    private void read(String s) throws Exception {
        if (!this.readIf(s)) {
            throw new Exception();
        }
    }

    private boolean readIf(String s) {
        this.skipSpaces();
        if (this.page.regionMatches(this.pos, s, 0, s.length())) {
            this.pos += s.length();
            this.skipSpaces();
            return true;
        }
        return false;
    }

    public static String escapeHtmlNoBreak(String s) {
        return PageParser.escapeHtml(s, false);
    }

    public static String escapeHtml(String s) {
        return PageParser.escapeHtml(s, true);
    }

    public static String escapeHtml(String s, boolean convertBreak) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "&nbsp;";
        }
        StringBuffer buff = new StringBuffer(s.length());
        boolean leadingSpace = true;
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (leadingSpace) {
                if (c == ' ') {
                    buff.append("&nbsp;");
                    continue;
                }
                leadingSpace = false;
            }
            switch (c) {
                case '$': {
                    buff.append("&#36;");
                    continue block9;
                }
                case '<': {
                    buff.append("&lt;");
                    continue block9;
                }
                case '>': {
                    buff.append("&gt;");
                    continue block9;
                }
                case '&': {
                    buff.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    buff.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    buff.append("&#39;");
                    continue block9;
                }
                case '\n': {
                    if (convertBreak) {
                        buff.append("<br>");
                        leadingSpace = true;
                        continue block9;
                    }
                    buff.append(c);
                    continue block9;
                }
                default: {
                    if (c >= '\u0080') {
                        buff.append("&#0");
                        buff.append((int)c);
                        buff.append(';');
                        continue block9;
                    }
                    buff.append(c);
                }
            }
        }
        return buff.toString();
    }

    public static String escapeJavaScript(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer(s.length());
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buff.append("\\\\");
                    continue block6;
                }
                case '\n': {
                    buff.append("\\n");
                    continue block6;
                }
                case '\r': {
                    buff.append("\\r");
                    continue block6;
                }
                case '\t': {
                    buff.append("\\t");
                    continue block6;
                }
                default: {
                    buff.append(c);
                }
            }
        }
        return PageParser.escapeHtml(buff.toString());
    }
}

