/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import org.h2.util.Resources;

class ResourceData {
    ResourceData() {
    }

    static {
        Resources.add("/org/h2/res/help.txt", "[* Commands (DML) *]\r\n\r\nSELECT\r\nSELECT [TOP term] [DISTINCT | ALL] \r\nselectExpression [,...]\r\nFROM tableExpression [,...] \r\n[WHERE expression] \r\n[GROUP BY expression [,...]] \r\n[HAVING expression] \r\n[{UNION [ALL] | MINUS | EXCEPT | INTERSECT} select]\r\n[ORDER BY order [,...]] \r\n[LIMIT expression [OFFSET expression] [SAMPLE_SIZE rowCountInt]]\r\n[FOR UPDATE]#\r\nSelects data from a table or multiple tables.\r\nIf a sample size is specified, this limits the number of rows read for aggregate queries.\r\nIf FOR UPDATE is specified, the tables are locked for writing.#\r\nSELECT * FROM TEST\r\n\r\nINSERT\r\nINSERT INTO tableName [(columnName [,...])] \r\n{VALUES {( [{DEFAULT | expression} [,...]] )} [,...] \r\n | select}#\r\nInserts a new row / new rows into a table.#\r\nINSERT INTO TEST VALUES(1, 'Hello')\r\n\r\nUPDATE\r\nUPDATE tableName \r\nSET {columnName=expression} [,...] \r\n[WHERE expression]#\r\nUpdates data in a table.#\r\nUPDATE TEST SET NAME='Hi' WHERE ID=1\r\n\r\nDELETE\r\nDELETE FROM tableName [WHERE expression]#\r\nDeletes rows form a table.#\r\nDELETE FROM TEST WHERE ID=2\r\n\r\nCALL\r\nCALL expression#\r\nCalculates a simple expression.#\r\nCALL 15*25\r\n\r\nEXPLAIN\r\nEXPLAIN [PLAN FOR] {select | insert | update | delete}#\r\nShows the execution plan for a query.#\r\nEXPLAIN SELECT * FROM TEST WHERE ID=1\r\n\r\nMERGE\r\nMERGE INTO tableName [(columnName [,...])] [KEY(columnName [,...])]\r\n{VALUES {( [{DEFAULT | expression} [,...]] )} [,...] \r\n | select}#\r\nUpdates the row if it exists, and if the row does not exist, inserts a new row.\r\nIf the key columns are not specified, the primary key columns are used to find the row.\r\nThis command is sometimes called 'UPSERT' as it UPdates a row if it exists,\r\nor inSERTS the row if it does not yet exist.\r\nIf more than one row per new row is affected, an exception is thrown.#\r\nMERGE INTO TEST KEY(ID) VALUES(2, 'World')\r\n\r\nRUNSCRIPT\r\nRUNSCRIPT FROM fileNameString \r\n[CIPHER cipher PASSWORD string]\r\n[CHARSET charsetString]#\r\nRuns a SQL script from a file. The script is a text file containing SQL statements; each statement must end with ';'.\r\nThis command can be used to restore a database from a backup.\r\nThe password must be in single quotes. It is case sensitive and can contain spaces. \r\nAdmin rights are required to execute this command.#\r\nRUNSCRIPT FROM 'backup'\r\n\r\nSCRIPT\r\nSCRIPT [NODATA] [NOPASSWORDS] [NOSETTINGS] [DROP]\r\n[TO fileNameString [CIPHER cipher PASSWORD string]]#\r\nCreates a SQL script with or without the insert statements. \r\nIf no file name is specified, the script is returned as a result set. \r\nThis command can be used to create a backup of the database.\r\nIf the DROP option is specified, drop statements are created for tables, views, and sequences.\r\nIf a file name is specified, a result set without insert statements is returned.\r\nThe password must be in single quotes. It is case sensitive and can contain spaces.#\r\nSCRIPT NODATA\r\n\r\n[* Commands (DDL) *]\r\n\r\nALTER INDEX RENAME\r\nALTER INDEX indexName RENAME TO newIndexName#\r\nRenames an index.#\r\nALTER INDEX IDXNAME RENAME TO IDX_TEST_NAME\r\n\r\nALTER SEQUENCE\r\nALTER SEQUENCE sequenceName \r\n[RESTART WITH long] \r\n[INCREMENT BY long]#\r\nChanges the next value and / or the increment of a sequence.#\r\nALTER SEQUENCE SEQID RESTART WITH 1000\r\n\r\nALTER TABLE ADD\r\nALTER TABLE tableName ADD newColumnName dataType \r\n[DEFAULT expression]\r\n[[NOT] NULL] [AUTO_INCREMENT | IDENTITY]\r\n[BEFORE columnName]#\r\nAdds a new column to a table.#\r\nALTER TABLE TEST ADD CREATEDATE TIMESTAMP\r\n\r\nALTER TABLE ADD CONSTRAINT\r\nALTER TABLE tableName ADD constraint#\r\nAdds a constraint to a table.#\r\nALTER TABLE TEST ADD CONSTRAINT NAME_UNIQUE UNIQUE(NAME)\r\n\r\nALTER TABLE ALTER COLUMN\r\nALTER TABLE tableName ALTER COLUMN columnName \r\ndataType [DEFAULT expression] [NOT [NULL]] \r\n[AUTO_INCREMENT | IDENTITY]#\r\nChanges the data type of a column.\r\nThe data will be migrated if possible, and if not, the operation fails.#\r\nALTER TABLE TEST ALTER COLUMN NAME CLOB\r\n\r\nALTER TABLE ALTER COLUMN RENAME\r\nALTER TABLE tableName ALTER COLUMN columnName \r\nRENAME TO newColumnName#\r\nRenames a column.#\r\nALTER TABLE TEST ALTER COLUMN NAME RENAME TO TEXT\r\n\r\nALTER TABLE ALTER COLUMN RESTART\r\nALTER TABLE tableName ALTER COLUMN columnName \r\nRESTART WITH long#\r\nChanges the next value of an auto increment column.\r\nThe column must be an auto increment column.#\r\nALTER TABLE TEST ALTER COLUMN ID RESTART WITH 10000\r\n\r\nALTER TABLE ALTER COLUMN SELECTIVITY\r\nALTER TABLE tableName ALTER COLUMN columnName \r\nSELECTIVITY int#\r\nSets the selectivity (1-100) for a column. Setting the selectivity to 0 means setting it to the default value.\r\nSelectivity is used by the cost based optimizer to calculate the estimated cost of an index.\r\nSelectivity 100 means values are unique, 10 means every distinct value appears 10 times on average.#\r\nALTER TABLE TEST ALTER COLUMN NAME SELECTIVITY 100\r\n\r\nALTER TABLE ALTER COLUMN SET DEFAULT\r\nALTER TABLE tableName ALTER COLUMN columnName \r\nSET DEFAULT expression#\r\nChanges the default value of a column.#\r\nALTER TABLE TEST ALTER COLUMN NAME SET DEFAULT ''\r\n\r\nALTER TABLE ALTER COLUMN SET NOT NULL\r\nALTER TABLE tableName ALTER COLUMN columnName \r\nSET NOT NULL#\r\nSets a column to not allow NULL values.\r\nThis is not possible if there are any null values in the table.#\r\nALTER TABLE TEST ALTER COLUMN NAME SET NOT NULL\r\n\r\nALTER TABLE ALTER COLUMN SET NULL\r\nALTER TABLE tableName ALTER COLUMN columnName \r\nSET NULL#\r\nSets a column to allow NULL values.\r\nThis is not possible if the column is part of a primary key or multi-column hash index.\r\nIf there are single column indexes on this column, they are dropped.#\r\nALTER TABLE TEST ALTER COLUMN NAME SET NULL\r\n\r\nALTER TABLE DROP COLUMN\r\nALTER TABLE tableName DROP COLUMN columnName#\r\nRemoves a column from a table.#\r\nALTER TABLE TEST DROP COLUMN NAME\r\n\r\nALTER TABLE DROP CONSTRAINT\r\nALTER TABLE tableName DROP \r\n{CONSTRAINT constraintName | PRIMARY KEY}#\r\nRemoves a constraint or a primary key from a table.#\r\nALTER TABLE TEST DROP CONSTRAINT UNIQUE_NAME\r\n\r\nALTER TABLE RENAME\r\nALTER TABLE tableName RENAME TO newTableName#\r\nRenames a table.#\r\nALTER TABLE TEST RENAME TO MYDATA\r\n\r\nALTER USER ADMIN\r\nALTER USER userName ADMIN {TRUE | FALSE}#\r\nSwitches the admin flag of a user on or off.\r\nThe user name is converted to uppercase if it is not quoted (with double quotes).\r\nAdmin rights are required to execute this command.#\r\nALTER USER TOM ADMIN TRUE\r\n\r\nALTER USER RENAME\r\nALTER USER userName RENAME TO newUserName#\r\nRenames a user.\r\nThe user name is converted to uppercase if it is not quoted (with double quotes).\r\nAdmin rights are required to execute this command.#\r\nALTER USER TOM RENAME TO THOMAS\r\n\r\nALTER USER SET PASSWORD\r\nALTER USER userName SET \r\n{PASSWORD string | SALT bytes HASH bytes}#\r\nChanges the password of a user.\r\nThe user name is converted to uppercase if it is not quoted (with double quotes).\r\nThe password must be in single quotes. It is case sensitive and can contain spaces. \r\nThe salt and hash values are hex strings.\r\nAdmin rights are required to execute this command.#\r\nALTER USER SA SET PASSWORD 'rioyxlgt'\r\n\r\nANALYZE\r\nANALYZE [SAMPLE_SIZE rowCountInt]#\r\nUpdates the selectivity statistics of all tables.\r\nThe selectivity is used by the cost based optimizer to select the best index for a given query.\r\nIf no sample size is set, up to 10000 rows per table are read to calculate the values.\r\nThe value 0 means all rows.\r\nThe selectivity can be set manually with ALTER TABLE ALTER COLUMN SELECTIVITY.\r\nThe manual values are overwritten by this statement.\r\nThe selectivity is available in the INFORMATION_SCHEMA.COLUMNS table.#\r\nANALYZE TOP 1000\r\n\r\nCREATE ALIAS\r\nCREATE ALIAS newFunctionAliasName FOR className#\r\nCreates a new function alias.\r\nAdmin rights are required to execute this command.\r\nIf the first parameter of the Java function is a java.sql.Connection, then\r\nthe current to the database is provided. This connection must not be closed.#\r\nCREATE ALIAS MY_SQRT FOR \"java.lang.Math.sqrt\"\r\n\r\nCREATE INDEX\r\nCREATE {[UNIQUE [HASH]] INDEX [newIndexName] \r\n | PRIMARY KEY [HASH]} ON (columnName [,...])#\r\nCreates a new index.#\r\nCREATE INDEX IDXNAME ON TEST(NAME)\r\n\r\nCREATE LINKED TABLE\r\nCREATE LINKED TABLE [IF NOT EXISTS] \r\nnewTableName(driverString, urlString,\r\nuserString, passwordString, originalTableString)#\r\nCreates a table link to an external table.\r\nThe current user owner must have admin rights.#\r\nCREATE LINKED TABLE LINK('org.h2.Driver', 'jdbc:h2:test', 'sa', '', 'TEST')\r\n\r\nCREATE ROLE\r\nCREATE ROLE [IF NOT EXISTS] newRoleName#\r\nCreates a new role.#\r\nCREATE ROLE READONLY\r\n\r\nCREATE SCHEMA\r\nCREATE SCHEMA [IF NOT EXISTS] newSchemaName \r\nAUTHORIZATION ownerUserName#\r\nCreates a new schema. \r\nThe current user owner must have admin rights.#\r\nCREATE SCHEMA TEST_SCHEMA AUTHORIZATION SA\r\n\r\nCREATE SEQUENCE\r\nCREATE SEQUENCE [IF NOT EXISTS] newSequenceName \r\n[START WITH long] \r\n[INCREMENT BY long]#\r\nCreates a new sequence. The data type of a sequence is BIGINT.#\r\nCREATE SEQUENCE SEQID\r\n\r\nCREATE TABLE\r\nCREATE [CACHED | MEMORY | TEMP | [GLOBAL | LOCAL] TEMPORARY] \r\nTABLE [IF NOT EXISTS] newTableName(\r\n{newColumnName dataType \r\n[{AS computedColumnExpression | DEFAULT expression}]\r\n[[NOT] NULL] \r\n[{AUTO_INCREMENT | IDENTITY}[(startInt [,incrementInt])]]\r\n[SELECTIVITY selectivity]\r\n[PRIMARY KEY [HASH] | UNIQUE] \r\n| constraint} [,...] )#\r\nCreates a new table.\r\nCached tables (the default) are persistent, and the number or rows is not limited by the main memory.\r\nMemory tables are persistent, but the index data is kept in the main memory, so memory tables should not get too large.\r\nTemporary tables are not persistent. Temporary tables can be global (accessible by all connections)\r\nor local (only accessible by the current connection). The default is for temporary tables is global.#\r\nCREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))\r\n\r\nCREATE TRIGGER\r\nCREATE TRIGGER [IF NOT EXISTS] newTriggerName \r\n{BEFORE | AFTER} {INSERT | UPDATE | DELETE} \r\nON tableName \r\n[FOR EACH ROW] [QUEUE int] [NOWAIT] \r\nCALL triggeredClassName#\r\nCreates a new trigger.#\r\nCREATE TRIGGER TRIG_INS BEFORE INSERT ON TEST FOR EACH ROW CALL \"MyTrigger\"\r\n\r\nCREATE USER\r\nCREATE USER [IF NOT EXISTS] newUserName \r\n{PASSWORD string | SALT bytes HASH bytes} \r\n[ADMIN]#\r\nCreates a new user.\r\nAdmin rights are required to execute this command.\r\nThe user name is converted to uppercase if it is not quoted (with double quotes).\r\nThe password must be in single quotes. It is case sensitive and can contain spaces. \r\nThe salt and hash values are hex strings.#\r\nCREATE USER GUEST PASSWORD 'abc'\r\n\r\nCREATE VIEW\r\nCREATE [FORCE] VIEW [IF NOT EXISTS] newViewName \r\nAS select#\r\nCreates a new view. If the force option is used, then the view is created even if the underlying table(s) don't exist.\r\nAdmin rights are required to execute this command.#\r\nCREATE VIEW TEST_VIEW AS SELECT * FROM TEST WHERE ID < 100\r\n\r\nDROP ALIAS\r\nDROP ALIAS functionAliasName#\r\nDrops an existing function alias.\r\nAdmin rights are required to execute this command.#\r\nCREATE ALIAS MY_SQRT\r\n\r\nDROP INDEX\r\nDROP INDEX [IF EXISTS] indexName#\r\nDrops an index.#\r\nDROP INDEX IF EXISTS IDXNAME\r\n\r\nDROP ROLE\r\nDROP ROLE roleName#\r\nDrops a role.#\r\nDROP ROLE READONLY\r\n\r\nDROP SCHEMA\r\nDROP SCHEMA schemaName#\r\nDrops a schema.#\r\nDROP SCHEMA TEST_SCHEMA\r\n\r\nDROP TABLE\r\nDROP TABLE [IF EXISTS] tableName#\r\nDrops an existing table.#\r\nDROP TABLE TEST\r\n\r\nDROP TRIGGER\r\nDROP TRIGGER [IF EXISTS] triggerName#\r\nDrops an existing trigger.#\r\nDROP TRIGGER TRIG_INS\r\n\r\nDROP USER\r\nDROP USER [IF EXISTS] userName#\r\nDrops a user.\r\nAdmin rights are required to execute this command.\r\nThe current user cannot be dropped.\r\nThe user name is converted to uppercase if it is not quoted (with double quotes).#\r\nDROP USER TOM\r\n\r\nDROP VIEW\r\nDROP VIEW [IF EXISTS] viewName#\r\nDrops a view.#\r\nDROP VIEW TEST_VIEW\r\n\r\nTRUNCATE TABLE\r\nTRUNCATE TABLE tableName#\r\nRemoves all rows from a table.\r\nOther than DELETE FROM without where clause, this command can not be rolled back.\r\nThis command is faster than DELETE without where clause.\r\nOnly regular data tables without foreign key constraints can be truncated.#\r\nTRUNCATE TABLE TEST\r\n\r\n[* Commands (Other) *]\r\n\r\nCOMMIT\r\nCOMMIT [WORK]#\r\nCommits a transaction.#\r\nCOMMIT\r\n\r\nCOMMIT TRANSACTION\r\nCOMMIT TRANSACTION transactionName#\r\nSets the resolution of an in-doubt transaction to 'commit'.\r\nAdmin rights are required to execute this command.\r\nThis command is part of the 2-phase-commit protocol.#\r\nCOMMIT TRANSACTION XID_TEST\r\n\r\nCHECKPOINT\r\nCHECKPOINT#\r\nFlushes the log and data files and switches to a new log file.\r\nAdmin rights are required to execute this command.#\r\nCHECKPOINT\r\n\r\nCHECKPOINT SYNC\r\nCHECKPOINT SYNC#\r\nFlushes the log, data and index files and forces all system buffers be written to the underlying device.\r\nAdmin rights are required to execute this command.#\r\nCHECKPOINT SYNC\r\n\r\nGRANT RIGHT\r\nGRANT {SELECT | INSERT | UPDATE | DELETE | ALL} [,...] \r\nON tableName [,...] TO {PUBLIC | userName | roleName}#\r\nGrants rights for a table to a user or role.\r\nAdmin rights are required to execute this command.#\r\nGRANT SELECT ON TEST TO READONLY\r\n\r\nGRANT ROLE\r\nGRANT roleName TO {PUBLIC | userName | roleName}#\r\nGrants a role to a user or role.\r\nAdmin rights are required to execute this command.#\r\nGRANT READONLY TO PUBLIC\r\n\r\nHELP\r\nHELP [anything [...]]#\r\nDisplays the help pages of SQL commands or keywords#\r\nHELP SELECT\r\n\r\nPREPARE COMMIT\r\nPREPARE COMMIT newTransactionName#\r\nPrepares committing a transaction.\r\nThis command is part of the 2-phase-commit protocol.#\r\nPREPARE COMMIT XID_TEST\r\n\r\nREVOKE RIGHT\r\nREVOKE {SELECT | INSERT | UPDATE | DELETE | ALL} [,...] \r\nON tableName [,...] FROM {PUBLIC | userName | roleName}#\r\nRemoves rights for a table from a user or role.\r\nAdmin rights are required to execute this command.#\r\nREVOKE SELECT ON TEST FROM READONLY\r\n\r\nREVOKE ROLE\r\nREVOKE roleName \r\nFROM {PUBLIC | userName | roleName}#\r\nRemoves a role from a user or role.\r\nAdmin rights are required to execute this command.#\r\nREVOKE READONLY FROM TOM\r\n\r\nROLLBACK\r\nROLLBACK [TO SAVEPOINT savepointName]#\r\nRolls back a transaction.\r\nIf a savepoint name is used, the transaction is only rolled back to the specified savepoint.#\r\nROLLBACK\r\n\r\nROLLBACK TRANSACTION\r\nROLLBACK TRANSACTION transactionName#\r\nSets the resolution of an in-doubt transaction to 'rollback'.\r\nAdmin rights are required to execute this command.\r\nThis command is part of the 2-phase-commit protocol.#\r\nROLLBACK TRANSACTION XID_TEST\r\n\r\nSAVEPOINT\r\nSAVEPOINT savepointName#\r\nCreate a new savepoint. See also ROLLBACK. \r\nSavepoints are only valid until the transaction is committed or rolled back.#\r\nSAVEPOINT HALF_DONE\r\n\r\nSET ASSERT\r\nSET ASSERT int#\r\nSets the assertion mode. \r\n0: no assertions (for higher performance) \r\n1: assertions are switched on (default)\r\nThis setting is not persistent.\r\nAdmin rights are required to execute this command.#\r\nSET ASSERT 0\r\n\r\nSET AUTOCOMMIT\r\nSET AUTOCOMMIT {TRUE | ON | FALSE | OFF}#\r\nSwitches autocommit on or off.#\r\nSET AUTOCOMMIT OFF\r\n\r\nSET CACHE_SIZE\r\nSET CACHE_SIZE int#\r\nSets the size of the cache. \r\nA cache entry contains one row.\r\nThe default value is 32768.\r\nThis setting is persistent and affects all connections as there is only one cache per database.\r\nAdmin rights are required to execute this command.#\r\nSET CACHE_SIZE 1000\r\n\r\nSET CLUSTER\r\nSET CLUSTER serverListString#\r\nThis command should not be used directly by an application, \r\nthe statement is executed automatically by the system.\r\nThe behavior may change in future releases.\r\nSets the cluster server list. An empty string switches off the cluster mode.\r\nSwitching on the cluster mode requires admin rights, \r\nbut any user can switch it off \r\n(this is automatically done when the client detects the other server is not responding).\r\nAdmin rights are required to execute this command.#\r\nSET CLUSTER ''\r\n\r\nSET COLLATION\r\nSET [DATABASE] COLLATION \r\n{OFF | collationName \r\n[STRENGTH {PRIMARY | SECONDARY | TERTIARY | IDENTICAL}]}#\r\nSets the collation used for comparing strings.\r\nThis command can only be executed if there are no tables defined.\r\nThis setting is persistent.\r\nAdmin rights are required to execute this command.#\r\nSET COLLATION ENGLISH\r\n\r\nSET DATABASE_EVENT_LISTENER\r\nSET DATABASE_EVENT_LISTENER classNameString#\r\nSets the event listener class. \r\nAn empty string ('') means no listener should be used.\r\nThis setting is not persistent.\r\nAdmin rights are required to execute this command, \r\nexcept if it is set when opening the database \r\n(in this case it is reset just after opening the database)#\r\nSET DATABASE_EVENT_LISTENER 'sample.MyListener'\r\n\r\nSET DB_CLOSE_DELAY\r\nSET DB_CLOSE_DELAY int#\r\nSets the delay for closing a database if all connections are closed. \r\n-1: the database is never closed until the close delay is set to some other value or SHUTDOWN is called.\r\n0: no delay (default; the database is closed if the last connection to it is closed).\r\n1: the database is left open for 1 second after the last connection is closed.\r\nOther values: the number of seconds the database is left open after closing the last connection.\r\nIf application exists normally or System.exit is called, the database is closed immediately, even if a delay is set.\r\nThis setting is persistent.\r\nAdmin rights are required to execute this command.#\r\nSET DB_CLOSE_DELAY -1\r\n\r\nSET DEFAULT_LOCK_TIMEOUT\r\nSET DEFAULT LOCK_TIMEOUT int#\r\nSets the default lock timeout (in milliseconds) in this database that is used for the new sessions.\r\nThis setting is persistent.\r\nThe default value for this setting is 1000 (one second).\r\nAdmin rights are required to execute this command.#\r\nSET DEFAULT_LOCK_TIMEOUT 5000\r\n\r\nSET DEFAULT_TABLE_TYPE\r\nSET DEFAULT_TABLE_TYPE {MEMORY | CACHED}#\r\nSets the default table storage type that is used when creating new tables.\r\nMemory tables are kept fully in the main memory (including indexes),\r\nhowever changes to the data are stored in the log file.\r\nThe size of memory tables is limited by the memory.\r\nThe default is CACHED.\r\nThis setting is persistent.\r\nAdmin rights are required to execute this command.#\r\nSET DEFAULT_TABLE_TYPE MEMORY\r\n\r\nSET LOCK_MODE\r\nSET LOCK_MODE int#\r\nSets the lock mode. \r\n0: no locking (should only be used for testing) \r\n1: table level locking (default)\r\n2: table level locking with garbage collection (if the application does not close all connections).\r\nThis setting is not persistent.\r\nAdmin rights are required to execute this command.#\r\nSET LOCK_MODE 2\r\n\r\nSET LOCK_TIMEOUT\r\nSET LOCK_TIMEOUT int#\r\nSets the lock timeout (in milliseconds) for the current session.\r\nThe default value for this setting is 1000 (one second).#\r\nSET LOCK_TIMEOUT 1000\r\n\r\nSET LOG\r\nSET LOG int#\r\nEnabled or disables writing to the log file. \r\n0: logging is disabled (faster)\r\n1: logging of the data is enabled, but logging of the index changes is disabled (default)\r\n2: logging of both data and index changes are enabled\r\nLogging can be disabled to improve the performance when durability is not important, for example while running tests or when loading the database.\r\nWarning: It may not be possible to recover the database if logging is disabled and the application terminates abnormally.\r\nIf logging of index changes is enabled, opening a database that was crashed becomes faster because the indexes don't need to be rebuilt.\r\nAdmin rights are required to execute this command.#\r\nSET LOG 0\r\n\r\nSET MAX_MEMORY_ROWS\r\nSET MAX_MEMORY_ROWS int#\r\nThe maximum number of rows in a result set that are kept in-memory.\r\nIf more rows are read, then the rows are buffered to disk.\r\nThe default value is 10000.\r\nThis setting is persistent.\r\nAdmin rights are required to execute this command.#\r\nSET MAX_MEMORY_ROWS 1000\r\n\r\nSET MAX_LOG_SIZE\r\nSET MAX_LOG_SIZE int#\r\nSets the maximum file size of a log file, in megabytes. \r\nIf the file exceeds the limit, a new file is created.\r\nOld files (that are not used for recovery) are deleted automatically, \r\nbut multiple log files may exist for some time.\r\nThe default max size is 64 MB.\r\nThis setting is persistent.\r\nAdmin rights are required to execute this command.#\r\nSET MAX_LOG_SIZE 2\r\n\r\nSET MODE\r\nSET MODE {REGULAR | HSQLDB | POSTGRESQL | MYSQL}#\r\nChanges to another database mode.\r\nAdmin rights are required to execute this command.\r\nThis is a global setting, which means it is not possible to open multiple databases \r\nwith different modes at the same time in the same virtual machine.#\r\nSET MODE HSQLDB\r\n\r\nSET PASSWORD\r\nSET PASSWORD string#\r\nChanges the password of the current user.\r\nThe password must be in single quotes. It is case sensitive and can contain spaces.#\r\nSET PASSWORD 'stzri!.5'\r\n\r\nSET SALT HASH\r\nSET SALT bytes HASH bytes#\r\nSets the password salt and hash for the current user.\r\nThe password must be in single quotes. It is case sensitive and can contain spaces.#\r\nSET SALT '00' HASH '1122'\r\n\r\nSET THROTTLE\r\nSET THROTTLE int#\r\nSets the throttle for the current connection. \r\nThe value is the number of milliseconds delay after each 50 ms.\r\nThe default value is 0 (throttling disabled).#\r\nSET THROTTLE 200\r\n\r\nSET TRACE_LEVEL\r\nSET {TRACE_LEVEL_FILE | TRACE_LEVEL_SYSTEM_OUT} int#\r\nSets the trace level for file the file or system out stream.\r\nLevels: 0=off, 1=error, 2=info, 3=debug.\r\nThis setting is persistent.\r\nAdmin rights are required to execute this command.#\r\nSET TRACE_LEVEL_SYSTEM_OUT 3\r\n\r\nSET TRACE_MAX_FILE_SIZE\r\nSET TRACE_MAX_FILE_SIZE int#\r\nSets the maximum trace file size. \r\nIf the file exceeds the limit, the file is renamed to .old and a new file is created. \r\nIf another .old file exists, it is deleted.\r\nThe default max size is 16 MB.\r\nThis setting is persistent.\r\nAdmin rights are required to execute this command.#\r\nSET TRACE_MAX_FILE_SIZE 10\r\n\r\nSET WRITE_DELAY\r\nSET WRITE_DELAY int#\r\nSet the maximum delay between a commit and flushing the log, in milliseconds.\r\nThis setting is persistent.\r\nAdmin rights are required to execute this command.#\r\nSET WRITE_DELAY 2000\r\n\r\nSHUTDOWN\r\nSHUTDOWN [IMMEDIATELY|COMPACT|SCRIPT]#\r\nThis statement is closes all open connections to the database and closes the database.\r\nIf no option is used, then all connections are closed.\r\nIf the IMMEDIATELY option is used, the database files are closed as if the hard drive stops working,\r\nwithout rollback of the open transactions.\r\nCOMPACT and SCRIPT are only supported for compatibility and have no effect.\r\nAny open transaction are rolled back before closing the connection.\r\nThis command should usually not be used, as the database is closed \r\nautomatically when the last connection to it is closed.\r\nAdmin rights are required to execute this command.#\r\nSHUTDOWN\r\n\r\n[* Other Grammar *]\r\n\r\nComment\r\n-- singleLineAnything\r\n| // singleLineAnything\r\n| /* anything */#\r\nComments can be used anywhere in a command and are ignored by the database.\r\nLine comments end with a newline.\r\nBlock comments cannot be nested, but can be multiple lines long.#\r\n// This is a comment\r\n\r\nConstraint\r\nPRIMARY KEY [HASH] (columnName [,...]) \r\n | [CONSTRAINT newConstraintName] {\r\n CHECK expression \r\n | UNIQUE (columnName [,...]) \r\n | referentialConstraint}#\r\nDefines a constraint.#\r\nPRIMARY KEY(ID, NAME)\r\n\r\nReferential Constraint\r\nFOREIGN KEY (columnName [,...]) \r\nREFERENCES [refTableName] [(refColumnName[,...])] \r\n[ON DELETE {CASCADE | RESTRICT | NO ACTION | SET DEFAULT | SET NULL}] \r\n[ON UPDATE {CASCADE | SET DEFAULT | SET NULL}]#\r\nDefines a referential constraint.\r\nIf the table name is not specified, then the same table is referenced.\r\nAs this database does not support deferred checking, \r\nRESTRICT and NO ACTION will both throw an exception if the constraint is violated.\r\nIf the referenced columns are not specified, then the primary key columns are used.#\r\nFOREIGN KEY(ID) REFERENCES TEST(ID)\r\n\r\nTable Expression\r\n{tableName | viewName | (select)} [[AS] newTableAlias] \r\n[{{LEFT | RIGHT} [OUTER] | [INNER] | CROSS | NATURAL} \r\nJOIN {tableName | viewName} [[AS] newTableAlias] [ON expression] ]#\r\nJoins a table. The join expression is not supported for cross and natural joins.\r\nA natural join is an inner join, where the condition is automatically on the columns with the same name.\r\n#\r\nTEST AS T LEFT JOIN TEST AS T1 ON T.ID = T1.ID\r\n\r\nOrder\r\n{int | expression} [ASC | DESC] \r\n[NULLS {FIRST | LAST}]#\r\nGroups the result by the column or expression.#\r\nNAME DESC NULLS LAST\r\n\r\nExpression\r\nandCondition [OR andCondition]#\r\nValue or condition.#\r\nID=1 OR NAME='Hi'\r\n\r\nAnd Condition\r\ncondition [AND condition]#\r\nValue or condition.#\r\nID=1 AND NAME='Hi'\r\n\r\nCondition\r\noperand\r\n| operand compare operand\r\n| operand [NOT] LIKE operand [ESCAPE string]\r\n| operand IS [NOT] NULL \r\n| operand BETWEEN operand AND operand \r\n| [NOT] condition \r\n| EXISTS (select)\r\n| operand IN (expression [,...]) | IN (select)\r\n| operand compare {ALL | ANY | SOME} (select)#\r\nValue or condition.#\r\nID<>2\r\n\r\nCompare\r\n= | <> | <= | >= | !=#\r\nComparison operator. The operator != is the same as <>.#\r\n<>\r\n\r\nOperand\r\nsummand [ || summand]#\r\nA value or a concatenation of values.#\r\n'Hi' || ' Eva'\r\n\r\nSummand\r\nfactor [{+ | -} factor]#\r\nA value or a numeric sum.#\r\nID + 20\r\n\r\nFactor\r\nterm [{* | /} term]#\r\nA value or a numeric factor.#\r\nID * 10\r\n\r\nTerm\r\nvalue\r\n | [tableAlias.]columnName\r\n | [[schemaName.]tableName.]columnName\r\n | ?\r\n | NEXT VALUE FOR sequenceName\r\n | function\r\n | {- | +} term\r\n | (expression)\r\n | select\r\n | case\r\n | caseWhen#\r\nA value.#\r\n'Hello'\r\n\r\nValue\r\nstring | hexNumber | int | long | decimal | double | \r\ndate | time | timestamp | boolean | bytes | null#\r\nA value of any data type, or null#\r\n10\r\n\r\nCase\r\nCASE expression {WHEN expression THEN expression} \r\n[...] [ELSE expression] END#\r\nReturns the first expression where the value is equal to the test expression.\r\nIf no else part is specified, return NULL#\r\nCASE CNT WHEN 0 THEN 'No' WHEN 1 THEN 'One' ELSE 'Some' END\r\n\r\nCase When\r\nCASE {WHEN expression THEN expression} \r\n[...] [ELSE expression] END#\r\nReturns the first expression where the condition is true.\r\nIf no else part is specified, return NULL#\r\nCASE WHEN CNT<10 THEN 'Low' ELSE 'High' END\r\n\r\nCipher\r\n[AES | XTEA]#\r\nTwo algorithms are supported, AES (AES-256) and XTEA (using 32 rounds).\r\nThe AES algorithm is about half as fast as XTEA.#\r\nAES\r\n\r\nSelect Expression\r\n* | tableName.* | expression [[AS] tableAlias]#\r\nAn expression in a SELECT statement.#\r\nID AS VALUE\r\n\r\nData Type\r\nintType | booleanType | tinyintType | smallintType | bigintType | identityType | \r\ndecimalType | doubleType | dateType | timeType | timestampType | \r\nbinaryType | otherType | varcharType | varcharIgnorecaseType |\r\nblobType | clobType#\r\nA data type definition.#\r\nINT\r\n\r\nName\r\n{ { A-Z | _ } { A-Z | 0-9 | _ } [...] } | quotedName#\r\nNames are not case sensitive. \r\nThere is no maximum name length.#\r\nTEST\r\n\r\nAlias\r\nname#\r\nAn alias is a name that is only valid in the context of the statement.#\r\nA\r\n\r\nQuoted Name\r\n\"anything\"#\r\nQuoted names are case sensitive, and can contain spaces.\r\nThere is no maximum name length.#\r\n\"FirstName\"\r\n\r\nString\r\n'anything'#\r\nA string starts and ends with a single quote. \r\nTwo single quotes can be used to create a single quote inside a string.#\r\n'Jon''s car'\r\n\r\nInt\r\n[- | +] digit [...]#\r\nThe maximum integer number is 2147483647, the minimum is -2147483648.#\r\n10\r\n\r\nLong\r\n[- | +] digit [...]#\r\nLong numbers are between -9223372036854775808 and 9223372036854775807.#\r\n100000\r\n\r\nHex Number\r\n[+ | -] 0x hex#\r\nA number written in hexadecimal notation.#\r\n0xff\r\n\r\nDecimal\r\n[- | +] digit [...] [. digit [...] ]#\r\nNumber with fixed precision and scale.#\r\n-1600.05\r\n\r\nDouble\r\n[- | +] digit [...]\r\n[. digit [...] [E [- | +] exponentDigit [...] ]]#\r\nThere is no minimum or maximum number.#\r\n-1.4e-10\r\n\r\nDate\r\nDATE 'yyyy-MM-dd'#\r\nA date constant.#\r\nDATE '2004-12-31'\r\n\r\nTime\r\nTIME 'hh:mm:ss'#\r\nA time constant.#\r\nTIME '23:59:59'\r\n\r\nTimestamp\r\nTIMESTAMP 'yyyy-MM-dd hh:mm:ss[.nnnnnnnnn]'#\r\nA timestamp constant.#\r\nTIMESTAMP '2005-12-31 23:59:59'\r\n\r\nBoolean\r\nTRUE | FALSE#\r\nA boolean value.#\r\nTRUE\r\n\r\nBytes\r\nX'hex'#\r\nA binary value. The hex value is not case sensitive.#\r\nX'01FF'\r\n\r\nNull\r\nNULL#\r\nNULL is a value without data type and means 'unknown value'.#\r\nNULL\r\n\r\nHex\r\n{{ digit | a-f | A-F } {digit | a-f | A-F }} [...]#\r\nThe hexadecimal representation of a number or of bytes.\r\nTwo characters are one byte.#\r\ncafe\r\n\r\nDigit\r\n0-9#\r\nA digit.#\r\n0\r\n\r\n[* Data Types *]\r\n\r\nINT Type\r\nINT | INTEGER | MEDIUMINT | INT4 | SIGNED#\r\nPossible values: -2147483648 to 2147483647#\r\nINT\r\n\r\nBOOLEAN Type\r\nBOOLEAN | BIT | BOOL#\r\nPossible values: TRUE and FALSE#\r\nBOOLEAN\r\n\r\nTINYINT Type\r\nTINYINT#\r\nPossible values are: -128 to 127#\r\nTINYINT\r\n\r\nSMALLINT Type\r\nSMALLINT | INT2 | YEAR#\r\nPossible values: -32768 to 32767#\r\nSMALLINT\r\n\r\nBIGINT Type\r\nBIGINT | INT8#\r\nPossible values: -9223372036854775808 to 9223372036854775807#\r\nBIGINT\r\n\r\nIDENTITY Type\r\nIDENTITY#\r\nAuto-Increment value. \r\nPossible values: -9223372036854775808 to 9223372036854775807#\r\nIDENTITY\r\n\r\nDECIMAL Type\r\n{DECIMAL | NUMBER | DEC | NUMERIC} ( precisionInt [, scaleInt] )#\r\nData type with fixed precision and scale.\r\nThis data type is recommended for storing currency values.#\r\nDECIMAL(20, 2)\r\n\r\nDOUBLE Type\r\n{DOUBLE [PRECISION] | FLOAT | FLOAT4 | FLOAT8}#\r\nFloating point number (java.lang.Double).\r\nShould not be used to represent currency values, because of rounding problems.#\r\nDOUBLE\r\n\r\nREAL Type\r\nREAL#\r\nSingle precision floating point number (java.lang.Float).\r\nShould not be used to represent currency values, because of rounding problems.#\r\nREAL\r\n\r\nTIME Type\r\nTIME#\r\nThe format is hh:mm:ss.#\r\nTIME\r\n\r\nDATE Type\r\nDATE#\r\nThe format is yyyy-MM-dd.#\r\nDATE\r\n\r\nTIMESTAMP Type\r\n{TIMESTAMP | DATETIME | SMALLDATETIME}#\r\nThe format is yyyy-MM-dd hh:mm:ss[.nnnnnn].#\r\nTIMESTAMP\r\n\r\nBINARY Type\r\n{BINARY | VARBINARY | LONGVARBINARY | RAW | BYTEA}\r\n[( precisionInt )]#\r\nRepresents a byte array. For very long arrays, use BLOB.#\r\nBINARY(1000)\r\n\r\nOTHER Type\r\nOTHER#\r\nThis type allows storing serialized Java objects. Internally, a byte array is used. \r\nJava operations cannot be executed due to security reasons. \r\nUse PreparedStatement.setObject to store values.#\r\nOTHER\r\n\r\nVARCHAR Type\r\n{VARCHAR | CHAR | CHARACTER | LONGVARCHAR | \r\nVARCHAR2 | NCHAR | NVARCHAR | NVARCHAR2}\r\n[( precisionInt )]#\r\nUnicode String. Use two single quotes ('') to create a quote.#\r\nVARCHAR(255)\r\n\r\nVARCHAR_IGNORECASE Type\r\nVARCHAR_IGNORECASE [( precisionInt )]#\r\nSame as VARCHAR, but not case sensitive when comparing. Stored in mixed case.#\r\nVARCHAR_IGNORECASE\r\n\r\nBLOB Type\r\n{BLOB | TINYBLOB | MEDIUMBLOB | LONGBLOB | IMAGE | OID}\r\n[( precisionInt )]#\r\nLike BINARY, but intended for very large values. \r\nUse PreparedStatement.setBinaryStream to store values.#\r\nBLOB\r\n\r\nCLOB Type\r\n{CLOB | TINYTEXT | TEXT | MEDIUMTEXT | LONGTEXT | NTEXT | NCLOB}\r\n[( precisionInt )]#\r\nLike VARCHAR, but intended for very large values. \r\nUse PreparedStatement.setCharacterStream to store values.#\r\nCLOB\r\n\r\n[* Functions (Aggregate) *]\r\n\r\nAVG\r\nAVG([DISTINCT] {int | long | decimal | double}): value#\r\nThe average (mean) value.\r\nAggregates are only allowed in select statements.#\r\nAVG(X)\r\n\r\nCOUNT\r\nCOUNT(*) | COUNT([DISTINCT] expression): int#\r\nThe count of all row, or of the non-null values.\r\nAggregates are only allowed in select statements.#\r\nCOUNT(*)\r\n\r\nGROUP_CONCAT\r\nGROUP_CONCAT(string [ORDER BY {expression [ASC|DESC]}[,...]] [SEPARATOR expression]): string#\r\nConcatenates strings with a separator. The default separator is a ',' (without space).\r\nAggregates are only allowed in select statements.#\r\nGROUP_CONCAT(NAME ORDER BY ID SEPARATOR ', ')\r\n\r\nMAX\r\nMAX(value): value#\r\nThe highest value.\r\nAggregates are only allowed in select statements.#\r\nMAX(NAME)\r\n\r\nMIN\r\nMIN(value): value#\r\nThe lowest value.\r\nAggregates are only allowed in select statements.#\r\nMIN(NAME)\r\n\r\nSUM\r\nSUM([DISTINCT] {int | long | decimal | double}): value#\r\nThe sum of all values.\r\nAggregates are only allowed in select statements.#\r\nSUM(X)\r\n\r\nSELECTIVITY\r\nSELECTIVITY(value): int#\r\nEstimates the selectivity (0-100) of a value.\r\nThe value is defined as (100 * distinctCount / rowCount).\r\nThe selecitity of 0 rows is 0 (unknown).\r\nUp to 10000 values are kept in memory.\r\nAggregates are only allowed in select statements.#\r\nSELECT SELECTIVITY(FIRSTNAME), SELECTIVITY(NAME) FROM TEST WHERE ROWNUM()<100000\r\n\r\nSTDDEV_POP\r\nSTDDEV_POP([DISTINCT] double): double#\r\nThe population standard deviation.\r\nAggregates are only allowed in select statements.#\r\nSTDDEV_POP(X)\r\n\r\nSTDDEV_SAMP\r\nSTDDEV_SAMP([DISTINCT] double): double#\r\nThe sample standard deviation.\r\nAggregates are only allowed in select statements.#\r\nSTDDEV(X)\r\n\r\nVAR_POP\r\nVAR_POP([DISTINCT] double): double#\r\nThe population variance (square of the population standard deviation).\r\nAggregates are only allowed in select statements.#\r\nVAR_POP(X)\r\n\r\nVAR_SAMP\r\nVAR_SAMP([DISTINCT] double): double#\r\nThe sample variance (square of the sample standard deviation).\r\nAggregates are only allowed in select statements.#\r\nVAR_SAMP(X)\r\n\r\n[* Functions (Numeric) *]\r\n\r\nABS\r\nABS({int | long | decimal | double}): value#\r\nSee also Java Math.abs.#\r\nABS(ID)\r\n\r\nACOS\r\nACOS(double): double#\r\nSee also Java Math.* functions.#\r\nACOS(D)\r\n\r\nASIN\r\nASIN(double): double#\r\nSee also Java Math.* functions.#\r\nASIN(D)\r\n\r\nATAN\r\nATAN(double): double#\r\nSee also Java Math.* functions.#\r\nATAN(D)\r\n\r\nCOS\r\nCOS(double): double#\r\nSee also Java Math.* functions.#\r\nCOS(ANGLE)\r\n\r\nCOT\r\nCOT(double): double#\r\nSee also Java Math.* functions.#\r\nCOT(ANGLE)\r\n\r\nSIN\r\nSIN(double): double#\r\nSee also Java Math.* functions.#\r\nSIN(ANGLE)\r\n\r\nTAN\r\nTAN(double): double#\r\nSee also Java Math.* functions.#\r\nTAN(ANGLE)\r\n\r\nATAN2\r\nATAN2(double, double): double#\r\nSee also Java Math.atan2.#\r\nATAN2(X, Y)\r\n\r\nBITAND\r\nBITAND(int, int): int#\r\nSee also Java operator &.#\r\nBITAND(A, B)\r\n\r\nBITOR\r\nBITOR(int, int): int#\r\nSee also Java operator |.#\r\nBITOR(A, B)\r\n\r\nBITXOR\r\nBITXOR(int, int): int#\r\nSee also Java operator ^.#\r\nBITXOR(A, B)\r\n\r\nMOD\r\nMOD(int, int): int#\r\nSee also Java operator %.#\r\nMOD(A, B)\r\n\r\nCEILING\r\nCEILING(double): double#\r\nSee also Java Math.ceil.#\r\nLOG(A)\r\n\r\nDEGREES\r\nDEGREES(double): double#\r\nSee also Java Math.toDegrees.#\r\nDEGREES(A)\r\n\r\nEXP\r\nEXP(double): double#\r\nSee also Java Math.exp.#\r\nEXP(A)\r\n\r\nFLOOR\r\nFLOOR(double): double#\r\nSee also Java Math.floor.#\r\nFLOOR(A)\r\n\r\nLOG\r\nLOG(double): double#\r\nSee also Java Math.log.#\r\nLOG(A)\r\n\r\nLOG10\r\nLOG10(double): double#\r\nSee also Java Math.log10 (in Java 5).#\r\nLOG10(A)\r\n\r\nRADIANS\r\nRADIANS(double): double#\r\nSee also Java Math.toRadians.#\r\nRADIANS(A)\r\n\r\nSQRT\r\nSQRT(double): double#\r\nSee also Java Math.sqrt.#\r\nSQRT(A)\r\n\r\nPI\r\nPI(): double#\r\nSee also Java Math.PI.#\r\nPI()\r\n\r\nPOWER\r\nPOWER(double, double): double#\r\nSee also Java Math.pow.#\r\nPOWER(A, B)\r\n\r\nRAND\r\nRAND([int]): double#\r\nCalling the function without parameter returns the next a pseudo random number.\r\nCalling it with an parameter seeds the session's random number generator.#\r\nRAND()\r\n\r\nROUND\r\nROUND(double, digitsInt): double#\r\nRounds to a number of digits.#\r\nROUND(VALUE, 2)\r\n\r\nROUNDMAGIC\r\nROUNDMAGIC(double): double#\r\nThis function rounds numbers in a good way but slow:\r\n- special handling for numbers around 0\r\n- only numbers <= +/-1000000000000\r\n- convert to a string\r\n- check the last 4 characters:\r\n'000x' becomes '0000'\r\n'999x' becomes '999999' (this is rounded automatically).#\r\nROUNDMAGIC(VALUE/3*3)\r\n\r\nSECURE_RAND\r\nSECURE_RAND(int): bytes#\r\nGenerates a number of cryptographically secure random numbers.#\r\nCALL SECURE_RAND(16)\r\n\r\nSIGN\r\nSIGN({int | long | decimal | double}): int#\r\nReturns -1 if the value is smaller 0, 0 if zero, and otherwise 1.#\r\nSIGN(VALUE)\r\n\r\nENCRYPT\r\nENCRYPT(algorithmString, keyBytes, dataBytes): bytes#\r\nEncrypts data using a key. Supported algorithms are XTEA and AES.\r\nThe block size is 16 bytes#\r\nCALL ENCRYPT('AES', '00', STRINGTOUTF8('Test'))\r\n\r\nDECRYPT\r\nDECRYPT(algorithmString, keyBytes, dataBytes): bytes#\r\nDecrypts data using a key. Supported algorithms are XTEA and AES.\r\nThe block size is 16 bytes#\r\nCALL UTF8TOSTRING(DECRYPT('AES', '00', '3fabb4de8f1ee2e97d7793bab2db1116'))\r\n\r\nHASH\r\nHASH(algorithmString, dataBytes, iterationInt): bytes#\r\nCalculate the hash value using an algorithm, and repeat this process for a number of iterations.\r\nCurrently, the only algorithm supported is SHA256.#\r\nCALL HASH('SHA256', STRINGTOUTF8('Password'), 1000)\r\n\r\nTRUNCATE\r\nTRUNCATE(double, digitsInt): double#\r\nTruncates to a number of digits (to the next value closer to 0).#\r\nTRUNCATE(VALUE, 2)\r\n\r\nCOMPRESS\r\nCOMPRESS(dataBytes [, algorithmString]): bytes#\r\nCompresses the data using the specified compression algorithm.\r\nSupported algorithms are: \r\nLZF (fast but lower compression), \r\nDEFLATE (higher compression; default).\r\nCompression only makes reduces the size if the \r\noriginal data contains redundancy and is at least about 30 bytes long.#\r\nCOMPRESS(STRINGTOUTF8('Test'))\r\n\r\nEXPAND\r\nEXPAND(bytes): bytes#\r\nExpands data that was compressed using the COMPRESS function.#\r\nUTF8TOSTRING(EXPAND(COMPRESS(STRINGTOUTF8('Test'))))\r\n\r\n[* Functions (String) *]\r\n\r\nASCII\r\nASCII(string): int#\r\nReturns the ASCII value of the first character in the string.#\r\nASCII('Hi')\r\n\r\nBIT_LENGTH\r\nBIT_LENGTH(string): int#\r\nReturns the number of bits in a string. \r\nEach character needs 16 bits.#\r\nBIT_LENGTH(NAME)\r\n\r\nLENGTH\r\n{LENGTH | CHAR_LENGTH | CHARACTER_LENGTH}(string): int#\r\nReturns the number of characters in a string.#\r\nLENGTH(NAME)\r\n\r\nOCTET_LENGTH\r\nOCTET_LENGTH(string): int#\r\nReturns the number of bytes in a string.\r\nEach character needs 2 bytes.#\r\nOCTET_LENGTH(NAME)\r\n\r\nCHAR\r\nCHAR(int): string#\r\nReturns the character that represents the ASCII value.#\r\nCHAR(65)\r\n\r\nCONCAT\r\nCONCAT(string, string [,...]): string#\r\nCombines strings.#\r\nCONCAT(NAME, '!')\r\n\r\nDIFFERENCE\r\nDIFFERENCE(string, string): int#\r\nReturns the difference between the sounds of two strings.#\r\nDIFFERENCE(T1.NAME, T2.NAME)\r\n\r\nHEXTORAW\r\nHEXTORAW(string): string#\r\nConverts a hex representation of a string to a string.\r\n4 hex characters per string character are used.#\r\nHEXTORAW(DATA)\r\n\r\nRAWTOHEX\r\nRAWTOHEX(string): string#\r\nConverts a string to the hex representation.\r\n4 hex characters per string character are used.#\r\nRAWTOHEX(DATA)\r\n\r\nINSTR\r\nINSTR(string, searchString, [, startInt]): int#\r\nReturns the location of a search string in a string (s).\r\nIf a start position is used, the characters before it are ignored.\r\n0 is returned if the search string is not found.#\r\nINSTR(EMAIL,'@')\r\n\r\nINSERT Function\r\nINSERT(originalString, startInt, lengthInt, addInt): string#\r\nInserts a additional string into the original string at a specified start position. \r\nThe length specifies the number of characters that are removed at the start position\r\nin the original string.#\r\nINSERT(NAME, 1, 1, ' ')\r\n\r\nLOWER\r\n{LOWER | LCASE}(string): string#\r\nConverts a string to lowercase.#\r\nLOWER(NAME)\r\n\r\nUPPER\r\n{UPPER | UCASE}(string): string#\r\nConverts a string to uppercase.#\r\nUPPER(NAME)\r\n\r\nLEFT\r\nLEFT(string, int): string#\r\nReturns the leftmost number of characters.#\r\nLEFT(NAME, 3)\r\n\r\nRIGHT\r\nRIGHT(string, int): string#\r\nReturns the rightmost number of characters.#\r\nRIGHT(NAME, 3)\r\n\r\nLOCATE\r\nLOCATE(searchString, string [, startInt]): int#\r\nReturns the location of a search string in a string (s).\r\nIf a start position is used, the characters before it are ignored.\r\n0 is returned if the search string is not found.#\r\nLOCATE('.', NAME)\r\n\r\nPOSITION\r\nPOSITION(searchString, string): int#\r\nReturns the location of a search string in a string (s).\r\nSee also LOCATE.#\r\nPOSITION('.', NAME)\r\n\r\nLTRIM\r\nLTRIM(string): string#\r\nRemoves all leading spaces from a string.#\r\nLTRIM(NAME)\r\n\r\nRTRIM\r\nRTRIM(string): string#\r\nRemoves all trailing spaces from a string.#\r\nRTRIM(NAME)\r\n\r\nTRIM\r\nTRIM([{LEADING | TRAILING | BOTH} [string] FROM] \r\nstring): string#\r\nRemoves all leading spaces, trailing spaces, or spaces at both ends, from a string.\r\nIt is possible to remove other characters as well.#\r\nTRIM(BOTH '_' FROM NAME)\r\n\r\nREPEAT\r\nREPEAT(string, int): string#\r\nReturns a string repeated some number of times.#\r\nREPEAT(NAME || ' ', 10)\r\n\r\nREPLACE\r\nREPLACE(string, searchString [, replacementString]): string#\r\nReplaces all occurrences of a search string in a text with another string.\r\nIf no replacement is specified, the search string is just removed from the original string.#\r\nREPLACE(NAME, ' ')\r\n\r\nSOUNDEX\r\nSOUNDEX(string): string#\r\nReturns a four character code representing the sound of a string.\r\nSee also http://www.nara.gov/genealogy/coding.html.#\r\nSOUNDEX(NAME)\r\n\r\nSPACE\r\nSPACE(int): string#\r\nReturns a string consisting of a number of spaces.#\r\nSPACE(80)\r\n\r\nSTRINGDECODE\r\nSTRINGDECODE(string): string#\r\nConverts a encoded string using the Java string literal encoding format.\r\nSpecial characters are \\b, \\t, \\n, \\f, \\r, \\\", \\\\, \\<octal>, \\u<unicode>.#\r\nCALL STRINGENCODE(STRINGDECODE('Lines 1\\nLine 2'))\r\n\r\nSTRINGENCODE\r\nSTRINGENCODE(string): string#\r\nEncodes special characters in a string using the Java string literal encoding format.\r\nSpecial characters are \\b, \\t, \\n, \\f, \\r, \\\", \\\\, \\<octal>, \\u<unicode>.#\r\nCALL STRINGENCODE(STRINGDECODE('Lines 1\\nLine 2'))\r\n\r\nSTRINGTOUTF8\r\nSTRINGTOUTF8(string): bytes#\r\nEncodes a string to a byte array using the UTF8 encoding format.#\r\nCALL UTF8TOSTRING(STRINGTOUTF8('This is a test'))\r\n\r\nSUBSTRING \r\n{SUBSTRING | SUBSTR}(string, startInt [, lengthInt]): string#\r\nReturns a substring of a string starting at a position.\r\nThe length is optional.#\r\nSUBSTR(NAME, 1)\r\n\r\nUTF8TOSTRING\r\nUTF8TOSTRING(bytes): string#\r\nDecodes a byte array in the UTF8 format to a string.#\r\nCALL UTF8TOSTRING(STRINGTOUTF8('This is a test'))\r\n\r\nXMLATTR\r\nXMLATTR(nameString, valueString): string#\r\nCreates an XML attribute element of the form name=\"value\".\r\nThe value is encoded as XML text.#\r\nCALL XMLNODE('a', XMLATTR('href', 'http://h2database.com'))\r\n\r\nXMLNODE\r\nXMLNODE(elementString [, attributesString [, contentString]]): string#\r\nCreate an XML node element.#\r\nCALL XMLNODE('a', XMLATTR('href', 'http://h2database.com'), 'H2')\r\n\r\nXMLCOMMENT\r\nXMLCOMMENT(commentString): string#\r\nCreates an XML comment. Two dashes (--) are converted to - -.#\r\nCALL XMLCOMMENT('Test')\r\n\r\nXMLCDATA\r\nXMLCDATA(valueString): string#\r\nCreates an XML CDATA element. If the value contains ']]>', an XML text element is created instead.#\r\nCALL XMLCDATA('data')\r\n\r\nXMLSTARTDOC\r\nXMLSTARTDOC(): string#\r\nThe string '<?xml version=\"1.0\"?>' is returned.#\r\nCALL XMLSTARTDOC()\r\n\r\nXMLTEXT\r\nXMLTEXT(valueString): string#\r\nCreates an XML text element.#\r\nCALL XMLTEXT('test')\r\n\r\n[* Functions (Time and Date) *]\r\n\r\nCURRENT_DATE\r\n{CURRENT_DATE[()] | CURDATE() | SYSDATE | TODAY}: date#\r\nReturns the current date.#\r\nCURRENT_DATE()\r\n\r\nCURRENT_TIME \r\n{CURRENT_TIME[()] | CURTIME()}: time#\r\nReturns the current time.#\r\nCURRENT_TIME()\r\n\r\nCURRENT_TIMESTAMP\r\n{CURRENT_TIMESTAMP[([int])] | NOW([int])}: timestamp#\r\nReturns the current timestamp.\r\nThe precision parameter for nanoseconds precision is optional.#\r\nCURRENT_TIMESTAMP()\r\n\r\nDATEADD\r\nDATEADD(unitString, addInt, timestamp): int#\r\nAdds units to a timestamp. The string indicates the unit. Use negative values to subtract units.\r\nThe following units are supported: \r\nYY, YEAR, MM, MONTH, DD, DAY, HH, HOUR, MI, MINUTE, SS, SECOND, MS, MILLISECOND.#\r\nDATEADD('MONTH', 1, DATE '2001-01-31')\r\n\r\nDATEDIFF\r\nDATEDIFF(unitString, aTimestamp, bTimestamp): int#\r\nReturns the difference between two timestamps. The string indicates the unit.\r\nThe following units are supported: \r\nYY, YEAR, MM, MONTH, DD, DAY, HH, HOUR, MI, MINUTE, SS, SECOND, MS, MILLISECOND.#\r\nDATEDIFF('YEAR', T1.CREATED, T2.CREATED)\r\n\r\nDAYNAME\r\nDAYNAME(date): string#\r\nReturns the name of the day (in English).#\r\nDAYNAME(CREATED)\r\n\r\nDAYOFMONTH\r\nDAYOFMONTH(date): int#\r\nReturns the day of the month (1-31).#\r\nDAYOFMONTH(CREATED)\r\n\r\nDAYOFWEEK\r\nDAYOFWEEK(date): int#\r\nReturns the day of the week (1 means Sunday).#\r\nDAYOFWEEK(CREATED)\r\n\r\nDAYOFYEAR\r\nDAYOFYEAR(date): int#\r\nReturns the day of the year (1-366).#\r\nDAYOFYEAR(CREATED)\r\n\r\nEXTRACT\r\nEXTRACT(\r\n{YY | YEAR | MM | MONTH | DD | DAY | HH | HOUR | \r\nMI | MINUTE | SS | SECOND | MS | MILLISECOND} \r\nFROM timestamp): int#\r\nReturns a specific value from a timestamps.#\r\nEXTRACT(SECOND FROM CURRENT_TIMESTAMP)\r\n\r\nFORMATDATETIME\r\nFORMATDATETIME(timestamp, formatString [, localeString [, timezoneString]]): string#\r\nFormats a date, time or timestamp as a string.\r\nThe most important format characters are: y year, M month, d day, H hour, m minute, s second\r\nFor details of the format, see java.text.SimpleDateFormat.#\r\nCALL FORMATDATETIME(TIMESTAMP '2001-02-03 04:05:06', 'EEE, d MMM yyyy HH:mm:ss z', 'en', 'GMT')\r\n\r\nHOUR\r\nHOUR(timestamp): int#\r\nReturns the hour (0-23) from a timestamp.#\r\nHOUR(CREATED)\r\n\r\nMINUTE\r\nMINUTE(timestamp): int#\r\nReturns the minute (0-59) from a timestamp.#\r\nMINUTE(CREATED)\r\n\r\nMONTH\r\nMONTH(timestamp): int#\r\nReturns the month (1-12) from a timestamp.#\r\nMONTH(CREATED)\r\n\r\nMONTHNAME\r\nMONTHNAME(date): string#\r\nReturns the name of the month (in English).#\r\nMONTHNAME(CREATED)\r\n\r\nPARSEDATETIME\r\nPARSEDATETIME(string, formatString [, localeString [, timezoneString]]): string#\r\nParses a string and returns a timestamp.\r\nThe most important format characters are: y year, M month, d day, H hour, m minute, s second\r\nFor details of the format, see java.text.SimpleDateFormat.#\r\nCALL PARSEDATETIME('Sat, 3 Feb 2001 03:05:06 GMT', 'EEE, d MMM yyyy HH:mm:ss z', 'en', 'GMT')\r\n\r\nQUARTER\r\nQUARTER(timestamp): int#\r\nReturns the quarter (1-4) from a timestamp.#\r\nQUARTER(CREATED)\r\n\r\nSECOND\r\nSECOND(timestamp): int#\r\nReturns the second (0-59) from a timestamp.#\r\nSECOND(CREATED)\r\n\r\nWEEK\r\nWEEK(timestamp): int#\r\nReturns the week (1-53) from a timestamp.#\r\nWEEK(CREATED)\r\n\r\nYEAR\r\nYEAR(timestamp): int#\r\nReturns the year from a timestamp.#\r\nYEAR(CREATED)\r\n\r\n[* Functions (System) *]\r\n\r\nAUTOCOMMIT\r\nAUTOCOMMIT(): boolean#\r\nReturns true if autocommit is switched on for this session.#\r\nAUTOCOMMIT()\r\n\r\nCASEWHEN Function\r\nCASEWHEN(boolean, aValue, bValue): value#\r\nReturns 'a' if the boolean expression is true, otherwise 'b'.#\r\nCASEWHEN(ID=1, 'A', 'B')\r\n\r\nCAST\r\nCAST(value AS dataType): value#\r\nConverts a value to another data type.#\r\nCAST(NAME AS INT)\r\n\r\nCOALESCE\r\nCOALESCE(aValue, bValue [, ...]): value#\r\nReturns the first value that is not null.#\r\nCOALESCE(A, B, C)\r\n\r\nCONVERT\r\nCONVERT(value, dataType): value#\r\nConverts a value to another data type.#\r\nCONVERT(NAME, INT)\r\n\r\nCURRVAL\r\nCURRVAL(sequenceString): long#\r\nReturns the current (last) value of the sequence.#\r\nCURRVAL('TESTSEQ')\r\n\r\nCSVREAD\r\nCSVREAD(fileNameString [, columnNamesString [, charsetString]]): resultSet#\r\nReturns the result set of reading the CSV (comma separated values) file.\r\nIf the column names are specified (a comma separeted list of column names), \r\nthose are used they are read from the file, otherwise (or if they are set to NULL) the first line\r\nof the file is interpreted as the column names.\r\nAdmin rights are required to execute this command.#\r\nSELECT * FROM CSVREAD('test.csv')\r\n\r\nCSVWRITE\r\nCSVWRITE(fileNameString, queryString [, charsetString]): null#\r\nWrites a CSV (comma separated values).\r\nThe file is overwritten if it exists.\r\nAdmin rights are required to execute this command.#\r\nCALL CSVWRITE('test.csv', 'SELECT * FROM TEST')\r\n\r\nDATABASE\r\nDATABASE(): string#\r\nReturns the name of the database.#\r\nDATABASE()\r\n\r\nDATABASE_PATH\r\nDATABASE_PATH(): string#\r\nReturns the directory of the database files and the database name, if it is file based.\r\nReturns NULL otherwise.#\r\nDATABASE_PATH()\r\n\r\nIDENTITY\r\nIDENTITY(): int#\r\nReturns the last inserted identity value for this session.#\r\nIDENTITY()\r\n\r\nIFNULL\r\nIFNULL(aValue, bValue): value#\r\nReturns the value of 'a' if it is not null, otherwise 'b'.#\r\nIFNULL(A, B)\r\n\r\nLOCK_TIMEOUT\r\nLOCK_TIMEOUT(): int#\r\nReturns the lock timeout of the current session (in milliseconds).#\r\nLOCK_TIMEOUT()\r\n\r\nNEXTVAL\r\nNEXTVAL(sequenceString): long#\r\nReturns the next value of the sequence.#\r\nNEXTVAL('TESTSEQ')\r\n\r\nNULLIF\r\nNULLIF(aValue, bValue): value#\r\nReturns NULL if 'a' is equals to 'b', otherwise 'a'.#\r\nNULLIF(A, B)\r\n\r\nREADONLY\r\nREADONLY(): boolean#\r\nReturns true if the database is read-only.#\r\nREADONLY()\r\n\r\nROWNUM\r\nROWNUM(): int#\r\nReturns the number of the current row. This function is supported for SELECT statements, \r\nas well as for DELETE and UPDATE. The first row has the row number 1, and is calculated \r\nbefore ordering and grouping the result set.#\r\nSELECT ROWNUM(), * FROM TEST\r\n\r\nUSER\r\n{USER | CURRENT_USER}(): string#\r\nReturns the name of the current user of this session.#\r\nCURRENT_USER()\r\n\r\n[* System tables *]\r\n\r\nInformation schema\r\nINFORMATION_SCHEMA.tableName#\r\nINFORMATION_SCHEMA.CATALOGS contains the catalogs.\r\nINFORMATION_SCHEMA.COLLATIONS contains the available collations.\r\nINFORMATION_SCHEMA.COLUMNS contains the columns.\r\nINFORMATION_SCHEMA.COLUMN_PRIVILEGES contains column privileges.\r\nINFORMATION_SCHEMA.CONSTRAINTS contains the constraints.\r\nINFORMATION_SCHEMA.CROSS_REFERENCES contains all foreign key constraint data.\r\nINFORMATION_SCHEMA.FUNCTION_ALIASES contains the function aliases.\r\nINFORMATION_SCHEMA.HELP contains the reference help.\r\nINFORMATION_SCHEMA.INDEXES contains the indexes.\r\nINFORMATION_SCHEMA.IN_DOUBT contains all in-doubt transactions.\r\nINFORMATION_SCHEMA.RIGHTS contains the rights.\r\nINFORMATION_SCHEMA.ROLES contains the roles.\r\nINFORMATION_SCHEMA.SCHEMATA contains the schemas.\r\nINFORMATION_SCHEMA.SEQUENCES contains the sequences.\r\nINFORMATION_SCHEMA.SETTINGS contains the settings.\r\nINFORMATION_SCHEMA.TABLES contains the tables.\r\nINFORMATION_SCHEMA.TABLE_PRIVILEGES contains table privileges.\r\nINFORMATION_SCHEMA.TABLE_TYPES contains the table types.\r\nINFORMATION_SCHEMA.TYPE_INFO contains the data types.\r\nINFORMATION_SCHEMA.USERS contains the users.\r\nINFORMATION_SCHEMA.VIEWS contains the views.\r\n#\r\n\r\nRange table\r\nSYSTEM_RANGE(start, end)#\r\nContains all values from start to end (this is a dynamic table).#\r\nSYSTEM_RANGE(0, 100)\r\n");
        Resources.add("/org/h2/res/messages.properties", "02000=No data is available\r\n07001=Invalid parameter count\r\n08000=Error opening database\r\n08004=Wrong user/password\r\n21S02=Column count does not match\r\n22003=Numeric value out of range\r\n22012=Division by zero\r\n22025=Error in LIKE ESCAPE\r\n23000=Check constraint violation: {0}\r\n23001=Unique index or primary key violation: {0}\r\n42000=Syntax error in SQL statement {0}\r\n42001=Syntax error in SQL statement {0}; expected {1}\r\n42S01=Table {0} already exists\r\n42S02=Table {0} not found\r\n42S11=Index {0} already exists\r\n42S12=Index {0} not found\r\n42S21=Duplicate column name {0}\r\n42S22=Column {0} not found\r\n42S32=Setting {0} not found\r\n\r\n90001=Function {0} must return a result set\r\n90002=Method is not allowed for a query\r\n90003=Method is only allowed for a query\r\n90004=Hexadecimal string with odd number of characters: {0}\r\n90005=Hexadecimal string contains non hex character: {0}\r\n90006=Value too long for column {0}\r\n90007=Null value not allowed for column {0}\r\n90008=The object is already closed\r\n90009=Invalid value {0} for parameter {1}\r\n90010=Cannot parse date constant {0}\r\n90011=Cannot parse timestamp constant {0}\r\n90012=Parameter number {0} is not set\r\n90013=Database {0} not found\r\n90014=Error parsing {0}\r\n90015=SUM or AVG on wrong data type\r\n90016=Column {0} must be in group by list\r\n90017=Attempt to define a second primary key\r\n90018=The connection was not closed by the application and is garbage collected\r\n90019=Cannot drop the current user\r\n90020=Database may be already open: {0}\r\n90021=Data conversion error converting {0}\r\n90022=Function {0} not found\r\n90023=Column {0} must not be nullable\r\n90024=Error while renaming file {0} to {1}\r\n90025=Cannot delete file {0}\r\n90026=Serialization failed\r\n90027=Deserialization failed\r\n90028=IO Exception\r\n90029=Currently not on an updatable row\r\n90030=File corrupted while reading record: {0}\r\n90031=The connection was not closed\r\n90032=User {0} not found\r\n90033=User {0} already exists\r\n90034=Log file error: {0}\r\n90035=Sequence {0} already exists\r\n90036=Sequence {0} not found\r\n90037=View {0} not found\r\n90038=View {0} already exists\r\n90039=The value is too large for the precision {0}\r\n90040=Admin rights are required for this operation\r\n90041=Trigger {0} already exists\r\n90042=Trigger {0} not found\r\n90043=Error creating trigger {0} object, class {1}\r\n90044=Error executing trigger {0}, class {1}\r\n90045=Constraint {0} already exists\r\n90046=URL format error; must be {0} but is {1}\r\n90047=Version mismatch, driver version is {0} but server version is {1}\r\n90048=Unsupported database file version or invalid file header in file {0}\r\n90049=Encryption error\r\n90050=Wrong password format, must be: file password <space> user password\r\n90051=Statement was cancelled\r\n90052=Subquery is not a single column query\r\n90053=Scalar subquery contains too many rows\r\n90054=Scalar subquery contains no rows\r\n90055=Unsupported cipher {0}\r\n90056=No default value is set for column {0}\r\n90057=Constraint {0} not found\r\n90058=Duplicate table or table alias {0}\r\n90059=Ambiguous column name {0}\r\n90060=Unsupported file lock method {0}\r\n90061=Exception opening port {0} (port may be in use)\r\n90062=Error while creating file {0}\r\n90063=Savepoint is invalid\r\n90064=Savepoint is unnamed\r\n90065=Savepoint is named\r\n90066=Duplicate property {0}\r\n90067=Connection is broken\r\n90068=Order by expression {0} must be in the result list in this case\r\n90069=Role {0} already exists\r\n90070=Role {0} not found\r\n90071=User or role {0} not found\r\n90072=Roles and rights cannot be mixed\r\n90073=Right not found\r\n90074=Role {0} already granted\r\n90075=Column is part of the multi-column index {0}\r\n90076=Function alias {0} already exists\r\n90077=Function alias {0} not found\r\n90078=Schema {0} already exists\r\n90079=Schema {0} not found\r\n90080=Schema name must match\r\n90081=Column {0} contains null values\r\n90082=Sequence {0} belongs to a table\r\n90083=Column may be referenced by {0}\r\n90084=Cannot drop last column {0}\r\n90085=Index {0} belongs to a constraint\r\n90086=Class {0} not found\r\n90087=Method {0} not found\r\n90088=Unknown mode {0}\r\n90089=Collation cannot be changed because there is a data table {0}\r\n90090=Schema {0} cannot be dropped\r\n90091=Role {0} cannot be dropped\r\n90092=This Java version is not supported (Java 1.4 is required)\r\n90093=Clustering error - database currently runs in standalone mode\r\n90094=Clustering error - database currently runs in cluster mode, server list: {0}\r\n90095=String format error: {0}\r\n90096=Not enought rights for object {0}\r\n90097=The database is read only\r\n90098=The database has been closed\r\n90099=Error setting database event listener {0}\r\n90100=No disk space available\r\n90101=Wrong XID format: {0}\r\n90102=Unsupported compression options: {0}\r\n90103=Unsupported compression algorithm: {0}\r\n90104=Compression error\r\n90105=Exception calling user defined function\r\n90106=Cannot truncate {0}\r\n90107=Cannot drop {0} because {1} depends on it\r\n\r\nHY000=General error: {0}\r\nHY004=Unknown data type {0}\r\nHYC00=Feature not supported\r\nHYT00=Timeout trying to lock table {0}\r\n\r\n\r\n");
        Resources.add("/org/h2/web/res/admin.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n\r\n\t<script type=\"text/javascript\">\r\n\t\t<!--\r\n\t\tif(self != top) {\r\n\t\t    top.location = \"admin.jsp\";\r\n\t\t}\r\n\t\t//-->\r\n\t</script>\r\n\r\n</head>\r\n<body style=\"margin: 20px\">\r\n\t<h1>\r\n\t\t${text.adminTitle}\r\n\t</h1>\r\n\t<p>\r\n\t\t<a href=\"index.do?jsessionid=${sessionId}\">${text.adminLogout}</a> \r\n\t</p>\r\n\t<hr>\r\n\t<form name=\"admin\" method=\"post\" action=\"/adminSave.do?jsessionid=${sessionId}\">\r\n\t<h3>\r\n\t\t${text.adminAllow}\r\n\t</h3>\r\n\t<p>\r\n\t\t<input type=\"radio\" name=\"allowOthers\" value=\"false\" <c:if test=\"allowOthers=='false'\">checked</c:if>> ${text.adminLocal}<br>\r\n\t\t<input type=\"radio\" name=\"allowOthers\" value=\"true\" <c:if test=\"allowOthers=='true'\">checked</c:if>> ${text.adminOthers}<br>\r\n\t</p>\r\n\t<h3>\r\n\t\t${text.adminConnection}\r\n\t</h3>\r\n\t<p>\r\n\t\t<input type=\"radio\" name=\"ssl\" value=\"false\" <c:if test=\"ssl=='false'\">checked</c:if>> ${text.adminHttp}<br>\r\n\t\t<input type=\"radio\" name=\"ssl\" value=\"true\" <c:if test=\"ssl=='true'\">checked</c:if>> ${text.adminHttps}<br>\r\n\t</p>\r\n\t<h3>\r\n\t\tPort number\r\n\t</h3>\r\n\t<p>\r\n\t\t${text.adminPort}: <input type=\"text\" name=\"port\" value=\"${port}\">\r\n\t</p>\r\n\t<hr>\r\n\t<p>\r\n\t\t<input type=\"submit\" class=\"button\" value=\"${text.adminSave}\">\r\n\t</p>\r\n\t<p>\r\n\t\t${text.adminRestart}\r\n\t</p>\r\n\t<hr>\r\n\t<h3>\r\n\t\t${text.adminSessions}\r\n\t</h3>\r\n\t<table>\r\n\t\t<tr>\r\n\t\t\t<th>${text.admin.ip}</th>\r\n\t\t\t<th>${text.admin.url}</th>\r\n\t\t\t<th>${text.a.user}</th>\r\n\t\t\t<th>${text.admin.executing}</th>\r\n\t\t\t<th>${text.admin.lastAccess}</th>\r\n\t\t\t<th>${text.admin.lastQuery}</th>\r\n\t\t</tr>\r\n\t\t<c:forEach var=\"item\" items=\"sessions\">\r\n\t\t\t<tr>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t${item.ip}\r\n\t\t\t\t</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t${item.url}\r\n\t\t\t\t</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t${item.user}\r\n\t\t\t\t</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t${item.executing}\r\n\t\t\t\t</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t${item.lastAccess}\r\n\t\t\t\t</td>\r\n\t\t\t\t<td>\r\n\t\t\t\t\t${item.lastQuery}\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</c:forEach>\r\n\t</table>\r\n\t<p>\r\n\t\t<a href=\"adminShutdown.do?jsessionid=${sessionId}\">${text.adminShutdown}</a> \r\n\t</p>\r\n\t\r\n\t</form>\r\n</body>");
        Resources.add("/org/h2/web/res/adminLogin.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n\r\n\t<script type=\"text/javascript\">\r\n\t\t<!--\r\n\t\tif(self != top) {\r\n\t\t    top.location = \"adminLogin.jsp\";\r\n\t\t}\r\n\t\t//-->\r\n\t</script>\r\n\r\n</head>\r\n<body style=\"margin: 20px\">\r\n\t<form name=\"adminLogin\" method=\"post\" action=\"/admin.do?jsessionid=${sessionId}\">\r\n\t\t<table class=\"login\" cellspacing=0 cellpadding=0>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<th class=\"login\">${text.adminLogin}</th>\r\n\t\t\t\t<th class=\"login\"></th>\r\n\t\t\t</tr>\r\n\t\t\t<tr><td  class=\"login\" colspan=2></td></tr>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<td class=\"login\">${text.a.password}:</td>\r\n\t\t\t\t<td class=\"login\"><input type=\"password\" name=\"password\" value=\"\" style=\"width:200px;\"></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<td class=\"login\"></td>\r\n\t\t\t\t<td class=\"login\">\r\n\t\t\t\t\t<input type=\"submit\" class=\"button\" value=\"${text.adminLoginOk}\">\r\n\t\t\t\t\t&nbsp;\r\n\t\t\t\t\t<input type=\"button\" class=\"button\" value=\"${text.adminLoginCancel}\" onclick=\"javascript:document.adminLogin.action='/index.do?jsessionid=${sessionId}';submit()\">\r\n\t\t\t\t\t<br>\r\n\t\t\t\t\t<br>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</table>\r\n\t\t<br>\r\n\t    <p class=\"error\">${error}</p>\r\n\t</form>\r\n\t<script type=\"text/javascript\">\r\n\t\t<!--\r\n\t\t\tdocument.adminLogin.password.focus();\r\n\t\t//-->\r\n\t</script>\r\n\t\r\n</body>");
        Resources.add("/org/h2/web/res/background.gif", "GIF89a\u0001\u0000\u001b\u0000\u0084\u0017\u00004T\u0087\\\u0088\u00c8^\u008a\u00ca_\u008c\u00cda\u008e\u00cfb\u0091\u00d1d\u0093\u00d4e\u0095\u00d6g\u0097\u00d8h\u0099\u00dbj\u009c\u00ddk\u009d\u00del\u009f\u00e1n\u00a1\u00e3o\u00a4\u00e5p\u00a5\u00e7r\u00a7\u00e9s\u00a9\u00ebt\u00ab\u00edu\u00ad\u00efv\u00ae\u00f0w\u00af\u00f2x\u00b1\u00f3\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00fe\u0015Created with The GIMP\u0000,\u0000\u0000\u0000\u0000\u0001\u0000\u001b\u0000\u0000\u0005\u0015` \fDa\u001cH\u00a2,L\u00e3<P$MTe\u00dd\u0016\u0000\u0084\u0000;");
        Resources.add("/org/h2/web/res/error.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n</head>\r\n<body margin=10>\r\n\t<p class=\"error\">\r\n\t\t${error}\r\n\t</p>\r\n</body>");
        Resources.add("/org/h2/web/res/favicon.ico", "\u0000\u0000\u0001\u0000\u0001\u0000\u0010\u0010\u0000\u0000\u0000\u0000\u0000\u0000h\u0005\u0000\u0000\u0016\u0000\u0000\u0000(\u0000\u0000\u0000\u0010\u0000\u0000\u0000 \u0000\u0000\u0000\u0001\u0000\b\u0000\u0000\u0000\u0000\u0000@\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u00ff\u00ff\u00ff\u0000\f\u00bf\u00c9\u0000\u0080\u0080\u0080\u0000\u00c0\u00c0\u00c0\u0000\u0000\u00ff\u00ff\u0000\t\u008c\u0093\u0000\u0012\u00e7\u00f1\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0003\u0004\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0003\u0004\u0001\u0001\u0001\u0001\u0004\u0004\u0004\u0004\u0004\u0004\u0001\u0001\u0001\u0001\u0003\u0004\u0001\u0001\u0001\u0004\u0007\u0007\u0007\u0007\u0002\u0002\u0004\u0001\u0001\u0001\u0003\u0004\u0001\u0001\u0004\u0007\u0007\u0007\u0007\u0007\u0002\u0002\u0006\u0004\u0001\u0001\u0003\u0004\u0001\u0001\u0004\u0007\u0007\u0007\u0007\u0007\u0002\u0002\u0006\u0004\u0001\u0001\u0003\u0004\u0001\u0001\u0004\u0007\u0007\u0007\u0007\u0007\u0002\u0002\u0006\u0004\u0001\u0001\u0003\u0004\u0001\u0001\u0004\u0007\u0007\u0007\u0007\u0007\u0002\u0002\u0006\u0004\u0001\u0001\u0003\u0004\u0001\u0001\u0004\u0007\u0007\u0007\u0007\u0007\u0002\u0002\u0006\u0004\u0001\u0001\u0003\u0004\u0001\u0001\u0004\u0007\u0007\u0007\u0007\u0007\u0002\u0002\u0006\u0004\u0001\u0001\u0003\u0004\u0001\u0001\u0004\u0007\u0001\u0001\u0001\u0001\u0001\u0001\u0006\u0004\u0001\u0001\u0003\u0004\u0001\u0001\u0004\u0001\u0005\u0005\u0005\u0005\u0005\u0005\u0001\u0004\u0001\u0001\u0003\u0004\u0001\u0001\u0001\u0004\u0005\u0005\u0005\u0005\u0005\u0005\u0004\u0001\u0001\u0001\u0003\u0004\u0001\u0001\u0001\u0001\u0004\u0004\u0004\u0004\u0004\u0004\u0001\u0001\u0001\u0001\u0003\u0004\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0003\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0004\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000");
        Resources.add("/org/h2/web/res/frame.jsp", "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\">\r\n<html>\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n</head>\r\n<frameset cols=\"*\" rows=\"36,*\" frameborder=\"2\" framespacing=\"4\" border=\"4\" >\r\n\t<frame noresize frameborder=\"0\" marginheight=0 marginwidth=0 src=\"header.jsp?jsessionid=${sessionId}\" name=\"header\" scrolling=\"no\">\r\n\t<frameset cols=\"200,*\" rows=\"*\" frameborder=\"2\" framespacing=\"4\" border=\"4\" >\r\n\t\t<frame frameborder=\"0\" marginheight=0 marginwidth=0 src=\"tables.do?jsessionid=${sessionId}\" name=\"h2menu\">\r\n\t\t<frameset  rows=\"180,*\" frameborder=\"2\" framespacing=\"4\" border=\"4\" >\r\n\t\t\t<frame frameborder=\"0\" marginheight=0 marginwidth=0 src=\"query.jsp?jsessionid=${sessionId}\" name=\"h2query\">\r\n\t\t\t<frame frameborder=\"0\" marginheight=0 marginwidth=0 src=\"resultHelp.jsp?jsessionid=${sessionId}\" name=\"h2result\">\r\n\t\t</frameset>\r\n\t</frameset>\r\n</frameset>\r\n<noframes>\r\n<body>\r\n\t${text.a.lynxNotSupported}\r\n</body>\r\n</noframes>\r\n</html>\r\n");
        Resources.add("/org/h2/web/res/header.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<html>\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n</head>\r\n<body  bgcolor=\"#FF00FF\"  class=\"toolbar\">\r\n\t<form name=\"header\" action=\"submit\">\r\n    <table class=\"toolbar\" cellspacing=0 cellpadding=0><tr class=\"toolbar\"><td class=\"toolbar\"\r\n\t><a href=\"logout.do?jsessionid=${sessionId}\" target=\"_top\"\r\n\t><img src=\"icon_disconnect.gif\"\r\n\t\tonmouseover = \"this.className ='icon_hover'\"\r\n\t\tonmouseout = \"this.className ='icon'\"\r\n\t\tclass=\"icon\" alt=\"${text.toolbar.disconnect}\" title=\"${text.toolbar.disconnect}\" border=\"1\"/></a\r\n\t><img src=\"icon_line.gif\" class=\"iconLine\" alt=\"\"\r\n\t/><a href=\"tables.do?jsessionid=${sessionId}\" target=\"h2menu\"\r\n\t><img src=\"icon_refresh.gif\"\r\n\t\tonmouseover = \"this.className ='icon_hover'\"\r\n\t\tonmouseout = \"this.className ='icon'\"\r\n\t\tclass=\"icon\" alt=\"${text.toolbar.refresh}\" title=\"${text.toolbar.refresh}\" border=\"1\"/></a\r\n\t><img src=\"icon_line.gif\" class=\"iconLine\" alt=\"\"\r\n\t/></td><td class=\"toolbar\"><input type=\"checkbox\" name=\"autocommit\" value=\"autocommit\" ${autocommit}\r\n\t  onclick=\"javascript:if(document.header.autocommit.checked)\r\n\t  top.frames['h2result'].document.location='query.do?jsessionid=${sessionId}&amp;sql=@AUTOCOMMIT+TRUE';\r\n\t  else\r\n\t  top.frames['h2result'].document.location='query.do?jsessionid=${sessionId}&amp;sql=@AUTOCOMMIT+FALSE';\r\n\t  \"\r\n\t></td><td class=\"toolbar\">${text.toolbar.autocommit}&nbsp;</td><td class=\"toolbar\"\r\n\t><a href=\"query.do?jsessionid=${sessionId}&amp;sql=ROLLBACK\" target=\"h2result\"\r\n\t><img src=\"icon_rollback.gif\"\r\n\t\tonmouseover = \"this.className ='icon_hover'\"\r\n\t\tonmouseout = \"this.className ='icon'\"\r\n\t\tclass=\"icon\" alt=\"${text.toolbar.rollback}\" title=\"${text.toolbar.rollback}\" border=\"1\"/></a\r\n\t><a href=\"query.do?jsessionid=${sessionId}&amp;sql=COMMIT\" target=\"h2result\"\r\n\t><img src=\"icon_commit.gif\"\r\n\t\tonmouseover = \"this.className ='icon_hover'\"\r\n\t\tonmouseout = \"this.className ='icon'\"\r\n\t\tclass=\"icon\" alt=\"${text.toolbar.commit}\" title=\"${text.toolbar.commit}\" border=\"1\"/></a\r\n\t><img src=\"icon_line.gif\" class=\"iconLine\" alt=\"\"\r\n\t/></td><td class=\"toolbar\">&nbsp;${text.toolbar.maxRows}:&nbsp;</td><td class=\"toolbar\"\r\n\t><select name=\"rowcount\" size=\"1\"\r\n\t  onchange=\"javascript:top.frames['h2result'].document.location='query.do?jsessionid=${sessionId}&amp;sql=@SET+MAXROWS+'+header.rowcount.value;\"\r\n\t><option value=\"0\">${text.toolbar.all}</option><option value=\"10000\">10000</option><option selected value=\"1000\">1000</option><option value=\"100\"\r\n\t>100</option><option value=\"10\">10</option></select\r\n\t>&nbsp;</td><td class=\"toolbar\"><a href=\"javascript:top.frames['h2query'].document.forms['h2query'].submit();\"\r\n\t><img src=\"icon_run.gif\"\r\n\t\tonmouseover = \"this.className ='icon_hover'\"\r\n\t\tonmouseout = \"this.className ='icon'\"\r\n\t\tclass=\"icon\" alt=\"${text.toolbar.run}\" title=\"${text.toolbar.run}\" border=\"1\"/></a\r\n\t></td><td class=\"toolbar\"><a href=\"query.do?jsessionid=${sessionId}&amp;sql=@CANCEL\" target=\"h2result\"\r\n\t><img src=\"icon_stop.gif\"\r\n\t\tonmouseover = \"this.className ='icon_hover'\"\r\n\t\tonmouseout = \"this.className ='icon'\"\r\n\t\tclass=\"icon\" alt=\"${text.toolbar.cancelStatement}\" title=\"${text.toolbar.cancelStatement}\" border=\"1\"/></a\r\n\t><img src=\"icon_line.gif\" class=\"iconLine\" alt=\"\"\r\n\t/><a href=\"query.do?jsessionid=${sessionId}&amp;sql=@HISTORY\" target=\"h2result\"\r\n\t><img src=\"icon_history.gif\"\r\n\t\tonmouseover = \"this.className ='icon_hover'\"\r\n\t\tonmouseout = \"this.className ='icon'\"\r\n\t\tclass=\"icon\" alt=\"${text.toolbar.history}\" title=\"${text.toolbar.history}\" border=\"1\"/></a\r\n\t><img src=\"icon_line.gif\" class=\"iconLine\" alt=\"\"\r\n\t/><a href=\"resultHelp.jsp?jsessionid=${sessionId}\" target=\"h2result\"\r\n\t><img src=\"icon_help.gif\"\r\n\t\tonmouseover = \"this.className ='icon_hover'\"\r\n\t\tonmouseout = \"this.className ='icon'\"\r\n\t\tclass=\"icon\" alt=\"${text.a.help}\" title=\"${text.a.help}\" border=\"1\"/></a\r\n\t></td></tr></table>\r\n\t</form>\r\n</body>\r\n</html>\r\n");
        Resources.add("/org/h2/web/res/help.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n</head>\r\n<body style=\"margin: 10px;\">\r\n<%@ include file=\"help.txt\" %>\r\n</body>\r\n");
        Resources.add("/org/h2/web/res/help.txt", "<script type=\"text/javascript\">\r\n<!--\r\nfunction set(s) {\r\n\ttop.h2query.document.h2query.sql.value = s;\r\n}\r\n//-->\r\n</script>\r\n\r\n<h3>${text.helpImportantCommands}</h3>\r\n<table>\r\n<tr><th>${text.helpIcon}</th><th>${text.helpAction}</th></tr>\r\n<tr>\r\n \t<td style=\"padding:0px\"><img src=\"icon_help.gif\" alt=\"${text.a.help}\"></td>\r\n\t<td style=\"vertical-align: middle;\">\r\n\t\t${text.helpDisplayThis}\r\n\t</td>\r\n</tr>\r\n<tr>\r\n \t<td style=\"padding:0px\"><img src=\"icon_history.gif\" alt=\"${text.toolbar.history}\"></td>\r\n\t<td style=\"vertical-align: middle;\">\r\n\t\t${text.helpCommandHistory}\r\n\t</td>\r\n</tr>\r\n<tr>\r\n \t<td style=\"padding:0px\"><img src=\"icon_run.gif\" alt=\"${text.toolbar.run}\"></td>\r\n\t<td style=\"vertical-align: middle;\">\r\n\t\t${text.helpExecuteCurrent}\r\n\t</td>\r\n</tr>\r\n<tr>\r\n \t<td style=\"padding:0px\"><img src=\"icon_disconnect.gif\" alt=\"${text.toolbar.disconnect}\"></td>\r\n\t<td style=\"vertical-align: middle;\">\r\n\t\t${text.helpDisconnect}\r\n\t</td>\r\n</tr>\r\n</table>\r\n<h3>${text.helpSampleSQL}</h3>\r\n<table><tr><th>${text.helpOperations}</th><th>${text.helpStatements}</th></tr>\r\n<tr><td><a href=\"javascript:set('DROP TABLE IF EXISTS TEST;\\rCREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255));\\rINSERT INTO TEST VALUES(1, \\'Hello\\');\\rINSERT INTO TEST VALUES(2, \\'World\\');\\rSELECT * FROM TEST ORDER BY ID;\\rUPDATE TEST SET NAME=\\'Hi\\' WHERE ID=1;\\rDELETE FROM TEST WHERE ID=2;');\"> \r\n\t${text.helpDropTable}<br>\r\n\t${text.helpCreateTable}<br>\r\n\t&nbsp;&nbsp;${text.helpWithColumnsIdName}<br>\r\n\t${text.helpAddRow}<br>\r\n\t${text.helpAddAnotherRow}<br>\r\n\t${text.helpQuery}<br>\r\n\t${text.helpUpdate}<br>\r\n\t${text.helpDeleteRow}\r\n</a></td><td>\r\n\tDROP TABLE IF EXISTS TEST;<br>\r\n\tCREATE TABLE TEST(ID INT PRIMARY KEY,<br>\r\n\t&nbsp;&nbsp; NAME VARCHAR(255));<br>\r\n\tINSERT INTO TEST VALUES(1, 'Hello');<br>\r\n\tINSERT INTO TEST VALUES(2, 'World');<br>\r\n\tSELECT * FROM TEST ORDER BY ID;<br>\r\n\tUPDATE TEST SET NAME='Hi' WHERE ID=1;<br>\r\n\tDELETE FROM TEST WHERE ID=2;\r\n</td></tr>\r\n</table>\r\n<h3>${text.helpAddDrivers}</h3>\r\n${text.helpAddDriversText}\r\n<p>\r\n${text.helpAddDriversOnlyJava}\r\n\r\n");
        Resources.add("/org/h2/web/res/icon_commit.gif", "GIF89a\u0018\u0000\u0018\u0000\u00a5#\u0000\u0000\u0000\u0000\u007f_?\\w\u00acd~\u00b2h\u0081\u00b6k\u0084\u00b5l\u0085\u00b8o\u0089\u00bcr\u008d\u00bf\u00bf\u007f?u\u008f\u00c0w\u0091\u00c2|\u0092\u00be}\u0092\u00be{\u0094\u00c0\u0081\u0099\u00c4\u0080\u0099\u00cb\u0089\u00a0\u00c8\u009f\u009f\u009f\u0091\u00a6\u00cb\u0092\u00a7\u00cc\u00bf\u009f\u007f\u0095\u00a9\u00cd\u0098\u00ab\u00cf\u0099\u00ac\u00cf\u00df\u009f_\u009c\u00ad\u00cf\u009b\u00ae\u00d0\u00a5\u00b5\u00d4\u00a7\u00b7\u00d5\u00bf\u00bf\u00bf\u00df\u00bf\u009f\u00c6\u00d2\u00e8\u00df\u00df\u00bf\u00e0\u00e5\u00f0\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\n\u0000?\u0000,\u0004\u0000\u0004\u0000\u0010\u0000\u0010\u0000\u0000\u0006`\u00c0\u009fpH,\u0016=\u0089L\u00c0hL&\u0096\u00cc!R\u00e9\u0089\u000e\u009dP\u00eb4P\u00fdY\u0016`\u000b1\u00f1\u00a9@\u0017\u0013\u0011\b\u00f3X\f%\u009f@H\u00a8\u00a0\u00a8\u00d9\u008a!@BD\\\u00ee\u0010\bV\u0007\u007fk\u0010\u0007V\u0006\u0085\u0018\u0010\u0006V\u0004\u008b\u008dV\u0003\u0091\u008eQ\r\u0005\u001d\u001b\u000e\u0010\u001cV?\u0011\u0002\u0002\f\u001a\u009fQA\u0000;");
        Resources.add("/org/h2/web/res/icon_disconnect.gif", "GIF89a\u0018\u0000\u0018\u0000\u00c2\u0007\u0000\u00c8)0\u0080\u001f#\u0080=A\u00f0[g\u00f1?S\u00f6\u0092\u008e\u00f5||\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u0007\u0000,\u0004\u0000\u0004\u0000\u0010\u0000\u0010\u0000\u0000\u00037x\u00ba\u00dc\u00fe\u00f0\r0\u001ap\u00a3\u00e8\u00ba\u00c0e\u0080!~\u00caE\u001e\u0003\u00a1re\u00bbL\u00ac+\u0004B\u00e7\u009c`\u0003/s}f\u009b\u00dc)4\u00b2\u00fcT\u0084\u0098\u00ebE\u00898\u009f\u00d0C\u0002\u0000;");
        Resources.add("/org/h2/web/res/icon_help.gif", "GIF89a\u0018\u0000\u0018\u0000\u00a5&\u0000\u00fe\u00fe\u00ff\u00f1\u00f2\u00f5\u00f2\u00f3\u00f5\u00b5\u00bc\u00c8\u0091\u009d\u00af\u00b4\u00bc\u00c8\u00b3\u00bc\u00c8\u008d\u009c\u00af\u00b4\u00bd\u00c8\u00cc\u00d4\u00de\u00db\u00e4\u00ee\u00fd\u00fe\u00ff(b\u0096Dv\u00a4]\u0089\u00b1_\u008a\u00b1j\u0092\u00b7l\u0094\u00b8y\u009d\u00be\u0095\u00b2\u00cc\u00a2\u00bb\u00d3P\u0080\u00aa\u00f5\u00fb\u00ff\u00fa\u00fd\u00ff\u00e8\u00f0\u00f5\u00f4\u00fb\u00ff\u00f7\u00fc\u00ff\u00ed\u00f2\u00f5\u00f6\u00fc\u00ff\u00ec\u00f2\u00f5\u00f9\u00fd\u00ff\u00fc\u00fe\u00ff\u00f5\u00fc\u00ff\u00f8\u00fd\u00ff\u00f7\u00fd\u00ff\u00fb\u00fe\u00ff\u00f6\u00fd\u00ff\u00a9\u00b0\u00b1\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000?\u0000,\u0004\u0000\u0004\u0000\u0010\u0000\u0010\u0000\u0000\u0006\u0092\u00c0\u009fpH,\u0016\u0015\u0093\n\u0083Q\u0099(\u008c?DS!\b +\u0083\u00a2\u0081\u00a0X\u0088\u00be\"\u0080\u0082P\u0018**]Ec\u00c9H\u00a3\u0085\u0093\u00c9G\u00f4`D&K\u00d1'.D_F\u0014\u0012_J\"#gB\f\u001d\u001e\u001e\u0017_\u000e\f\u000e\u0017\u0017\u001b\f\u0088\u001d!\u0098\"\u008f\u0010\u001e\u0098\u001d\u0095?h\u001a\u001a_y\"\u00a4\t\u0015p\u0013\u00a3\u00a4\u0014\u0014\u001c$\u001c\u001a|?g\n  \"K \u001c \u00b7C%\u0007\n\u0016`\u0016\u0019\n\u0007%E%S\u0018\u0018W\u00cbFWKSP\u00d7EA\u0000;");
        Resources.add("/org/h2/web/res/icon_history.gif", "GIF89a\u0018\u0000\u0018\u0000\u0084\u001d\u0000\u00a7~\u001c\u00a9\u0081\u001d\u00af\u0088 \u00af\u0089 \u00b2\u008d\"\u00b3\u008d\"\u00b6\u0092#\u00b6\u0092$\u00b9\u0096%\u00b9\u0096&\u00bc\u0099'\u00bc\u009a'\u00be\u009c(\u0086\u009f\u00c8\u0098\u00a6\u00c9\u00ab\u00b7\u00cb\u00f9\u00d1m\u00fa\u00d2m\u00fb\u00e1\u009a\u00fb\u00e1\u009b\u00fc\u00e9\u00b4\u00fc\u00ea\u00b4\u00fc\u00f1\u00cd\u00fc\u00f2\u00cc\u00fd\u00f2\u00cc\u00fd\u00f8\u00e1\u00fe\u00f8\u00e0\u00fe\u00f9\u00e0\u00fe\u00fd\u00ef\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\n\u0000\u001f\u0000,\u0000\u0000\u0000\u0000\u0018\u0000\u0018\u0000\u0000\u0005U\u00e0'\u008edi\u009eh\u00aa\u00ael\u00c90-\u00aap\u00dc\u0012\u0097\u0088\u0096mYr\u008b\u0087\u008b\u0005C\u00b4\u0018~\u0084B\u00a1B)$\u007f\"\u00c1D2\u0080\u008e\u0002\u0090H\u00c0:\u0002\u0000\u00b8`\u00d1c\u00fcp\u0098\u001d\u008dt#|#\u0097\u00cf\u00ea5\u00bb\u00e5>;\u00e6\u00d0:\\\u008dg\u00e9\u00cd}\u0081\u0082$!\u0000;");
        Resources.add("/org/h2/web/res/icon_line.gif", "GIF89a\u0006\u0000\u0018\u0000\u00e7\u000f\u0000\u0000\u0000\u0000\u0080\u0000\u0000\u0000\u0080\u0000\u0080\u0080\u0000\u0000\u0000\u0080\u0080\u0000\u0080\u0000\u0080\u0080\u0080\u0080\u0080\u00c0\u00c0\u00c0\u00ff\u0000\u0000\u0000\u00ff\u0000\u00ff\u00ff\u0000\u0000\u0000\u00ff\u00ff\u0000\u00ff\u0000\u00ff\u00ff\u00ff\u00ff\u00ff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u00003\u0000\u0000f\u0000\u0000\u0099\u0000\u0000\u00cc\u0000\u0000\u00ff\u00003\u0000\u000033\u00003f\u00003\u0099\u00003\u00cc\u00003\u00ff\u0000f\u0000\u0000f3\u0000ff\u0000f\u0099\u0000f\u00cc\u0000f\u00ff\u0000\u0099\u0000\u0000\u00993\u0000\u0099f\u0000\u0099\u0099\u0000\u0099\u00cc\u0000\u0099\u00ff\u0000\u00cc\u0000\u0000\u00cc3\u0000\u00ccf\u0000\u00cc\u0099\u0000\u00cc\u00cc\u0000\u00cc\u00ff\u0000\u00ff\u0000\u0000\u00ff3\u0000\u00fff\u0000\u00ff\u0099\u0000\u00ff\u00cc\u0000\u00ff\u00ff3\u0000\u00003\u000033\u0000f3\u0000\u00993\u0000\u00cc3\u0000\u00ff33\u000033333f33\u009933\u00cc33\u00ff3f\u00003f33ff3f\u00993f\u00cc3f\u00ff3\u0099\u00003\u009933\u0099f3\u0099\u00993\u0099\u00cc3\u0099\u00ff3\u00cc\u00003\u00cc33\u00ccf3\u00cc\u00993\u00cc\u00cc3\u00cc\u00ff3\u00ff\u00003\u00ff33\u00fff3\u00ff\u00993\u00ff\u00cc3\u00ff\u00fff\u0000\u0000f\u00003f\u0000ff\u0000\u0099f\u0000\u00ccf\u0000\u00fff3\u0000f33f3ff3\u0099f3\u00ccf3\u00ffff\u0000ff3fffff\u0099ff\u00ccff\u00fff\u0099\u0000f\u00993f\u0099ff\u0099\u0099f\u0099\u00ccf\u0099\u00fff\u00cc\u0000f\u00cc3f\u00ccff\u00cc\u0099f\u00cc\u00ccf\u00cc\u00fff\u00ff\u0000f\u00ff3f\u00ffff\u00ff\u0099f\u00ff\u00ccf\u00ff\u00ff\u0099\u0000\u0000\u0099\u00003\u0099\u0000f\u0099\u0000\u0099\u0099\u0000\u00cc\u0099\u0000\u00ff\u00993\u0000\u009933\u00993f\u00993\u0099\u00993\u00cc\u00993\u00ff\u0099f\u0000\u0099f3\u0099ff\u0099f\u0099\u0099f\u00cc\u0099f\u00ff\u0099\u0099\u0000\u0099\u00993\u0099\u0099f\u0099\u0099\u0099\u0099\u0099\u00cc\u0099\u0099\u00ff\u0099\u00cc\u0000\u0099\u00cc3\u0099\u00ccf\u0099\u00cc\u0099\u0099\u00cc\u00cc\u0099\u00cc\u00ff\u0099\u00ff\u0000\u0099\u00ff3\u0099\u00fff\u0099\u00ff\u0099\u0099\u00ff\u00cc\u0099\u00ff\u00ff\u00cc\u0000\u0000\u00cc\u00003\u00cc\u0000f\u00cc\u0000\u0099\u00cc\u0000\u00cc\u00cc\u0000\u00ff\u00cc3\u0000\u00cc33\u00cc3f\u00cc3\u0099\u00cc3\u00cc\u00cc3\u00ff\u00ccf\u0000\u00ccf3\u00ccff\u00ccf\u0099\u00ccf\u00cc\u00ccf\u00ff\u00cc\u0099\u0000\u00cc\u00993\u00cc\u0099f\u00cc\u0099\u0099\u00cc\u0099\u00cc\u00cc\u0099\u00ff\u00cc\u00cc\u0000\u00cc\u00cc3\u00cc\u00ccf\u00cc\u00cc\u0099\u00cc\u00cc\u00cc\u00cc\u00cc\u00ff\u00cc\u00ff\u0000\u00cc\u00ff3\u00cc\u00fff\u00cc\u00ff\u0099\u00cc\u00ff\u00cc\u00cc\u00ff\u00ff\u00ff\u0000\u0000\u00ff\u00003\u00ff\u0000f\u00ff\u0000\u0099\u00ff\u0000\u00cc\u00ff\u0000\u00ff\u00ff3\u0000\u00ff33\u00ff3f\u00ff3\u0099\u00ff3\u00cc\u00ff3\u00ff\u00fff\u0000\u00fff3\u00ffff\u00fff\u0099\u00fff\u00cc\u00fff\u00ff\u00ff\u0099\u0000\u00ff\u00993\u00ff\u0099f\u00ff\u0099\u0099\u00ff\u0099\u00cc\u00ff\u0099\u00ff\u00ff\u00cc\u0000\u00ff\u00cc3\u00ff\u00ccf\u00ff\u00cc\u0099\u00ff\u00cc\u00cc\u00ff\u00cc\u00ff\u00ff\u00ff\u0000\u00ff\u00ff3\u00ff\u00fff\u00ff\u00ff\u0099\u00ff\u00ff\u00cc\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u00fe\u0000,\u0002\u0000\u0003\u0000\u0002\u0000\u0011\u0000\u0000\b\u000f\u0000\u000f\u00fc\u0013Hp\u00a0\u00c1\u0082\b\u000f*,\u0018\u0010\u0000;");
        Resources.add("/org/h2/web/res/icon_refresh.gif", "GIF89a\u0018\u0000\u0018\u0000\u00a5%\u0000\u00a6k\u0010\u00a8n\u0010\u00a8n\u0011\u00a9n\u0011\u00adr\u0011\u00acr\u0012\u00acs\u0012\u00adr\u0012\u00ads\u0012\u00b1x\u0013\u00b6|\u0014\u00b6}\u0014\u00b6}\u0015\u00ba\u0081\u0015\u00bb\u0081\u0015\u00ba\u0081\u0016\u00bd\u0084\u0016\u00c3\u0096\u001d\u00c2\u0099 \u00f9\u00cd_\u00f8\u00d0`\u00f1\u00d3s\u00f8\u00d8x\u00f9\u00ddz\u00f0\u00d8\u0080\u00f1\u00da\u0083\u00f8\u00d8\u0080\u00fb\u00de\u0085\u00f8\u00e0\u0088\u00f9\u00e8\u0094\u00f8\u00e8\u0098\u00fb\u00e9\u009e\u00f0\u00e0\u00a8\u00f8\u00f0\u00b0\u00fb\u00f0\u00b4\u00f8\u00f8\u00e8\u00fe\u00fd\u00ef\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000?\u0000,\u0004\u0000\u0004\u0000\u0010\u0000\u0010\u0000\u0000\u0006d\u00c0\u009fpH,\u001a\u0089\u0010\u00c8\u00d1\b!)\u0097C\u0007\u0089\u00d4x<\u00a0\u008a\u008eh+\u00ca0\u0096\u0089\u00cbg<\u00aeH\u0096\u0087\u00c9\u00e6\u0090\u00de\u0018\u00a0\u0083\u00c9\u00e0'\u0098\u0004\u0086\u00cf\u00a4\u0010\u0000\u00d8\u00e3\u009d?\u0010#OG\u0082!I# \u0084E\u0010\u001c!\u008f\u008f\u0018\u0011K\u000b\u0016\u001e\u0097\u001e\u0016\nP\b\u0007\u0005\u001a\u0014\u0004PC\u0000\u0014}\u00a3{\u00a7GA\u0000;");
        Resources.add("/org/h2/web/res/icon_rollback.gif", "GIF89a\u0018\u0000\u0018\u0000\u00a5&\u0000\u00a1l\u0015\\w\u00acd~\u00b2h\u0081\u00b6k\u0084\u00b5\u00b0~\u001al\u0085\u00b8o\u0089\u00bc\u00b7\u0084\u001cr\u008d\u00bfu\u008f\u00c0w\u0091\u00c2|\u0092\u00be}\u0092\u00be{\u0094\u00c0\u0081\u0099\u00c4\u0080\u0099\u00cb\u0089\u00a0\u00c8\u0091\u00a6\u00cb\u0092\u00a7\u00cc\u0095\u00a9\u00cd\u0098\u00ab\u00cf\u0099\u00ac\u00cf\u009c\u00ad\u00cf\u009b\u00ae\u00d0\u00a5\u00b5\u00d4\u00a7\u00b7\u00d5\u00f9\u00cba\u00f1\u00d1u\u00c6\u00d2\u00e8\u00f1\u00d7\u0084\u00f9\u00da|\u00fb\u00db\u0086\u00f9\u00e5\u0095\u00fb\u00e6\u009f\u00e0\u00e5\u00f0\u00fb\u00ed\u00b5\u00fe\u00fa\u00ef\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\n\u0000?\u0000,\u0004\u0000\u0004\u0000\u0010\u0000\u0010\u0000\u0000\u0006h\u00c0\u009fpH,\u0012\u0011\b\u00a3\u0012QJ*\u008f\u00a5&\u00f2\u00f9C\u0084HX\u0092\u00c7IYx)\u00bf\u00c2GD&s\n\u000b\u00c9\u00a8cy,~\u0080\r\b\u0010\u009f+&\u00eb\u00b6B\u0018\u0007\u00c07\u0000\t\u0015y\u0010\tCt|?\u0007\u0083l\u0010\u0007T\u0006\u008c\u0016\u0010\u0006T\u0003\u0092\u0094T\u0002\u0098\u0095O\r\u0004\u001a\u0018\u000e\u0010\u0019T?\u0011\u0001\u0001\f\u0017\u00a6\u00ad\u00aeA\u0000;");
        Resources.add("/org/h2/web/res/icon_run.gif", "GIF89a\u0018\u0000\u0018\u0000\u00a5-\u0000 \u0080A&\u0080A&\u0088AA\u0091W^\u009ao:\u0088O3\u0088Hf\u00adw-\u0088AH\u0091WH\u009aW:\u0091HA\u0091Of\u00ado:\u0088A3w:A\u0088HH\u0091OO\u009aWW\u00a4^-\u008033\u0088:A\u009aHH\u009aO:\u0088:A\u0091AW\u00a4WH\u0080Hf\u00a4fw\u00adw\u00ad\u00cb\u00ad\u00ba\u00d2\u00ba\u00d5\u00e0\u00d5^\u009aW\u0088\u00b7\u0080o\u00a4^\u0080\u00ado\u0088\u00b7w\u009a\u00c1\u0088\u0088\u00b7o\u0091\u00b7w\u0091\u00b7o\u00a4\u00c1\u0088\u0080\u00cc&\u00c2\u00e9x\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000?\u0000,\u0004\u0000\u0004\u0000\u0010\u0000\u0010\u0000\u0000\u0006\u0098\u00c0\u009fpH,\u0016A\u0087B P8\u0080\u008c\u00bf\u0083a\u00b52\u00a9D\u009cf\u00f1\u0090(\u00adZ\u00abT\n\u0085J\u001c\u0086 \u0003\u00e9\u00f4i\u0081O\u00f0\u0093\u00e1\u0019\u0095\u008cFm\u00f7\u00ea~?\u00ff\f!\u0081yz\u0081\u001d\u0006B\u0006\u001b\u008a\u001en\u008d,\u001b\u001d\u0001B\u0000\u000f\u0095\u008c\u008d\u001f\u0095\u0004\u0000B\u0001\u0014\u009f\u0097-\u001e\u009f\u0010\u0013\u0092Q\f\u0011\u0011\u0097\u001e\u00aa\u0017\u0012\u0003~ \b\u0012\u0019\u008c\u001e\u000e\u000e\u0019\u0017\u0013\btQ\u000b\u0013\u001e\u001e\u0015\u0018\u0016\u001a\u0013\u000b~C\u0007\b\n\u0013\r\r\u0013\n\b\u00cbDH\u0002K\u0002NP\u00ddEA\u0000;");
        Resources.add("/org/h2/web/res/icon_stop.gif", "GIF89a\u0018\u0000\u0018\u0000\u0084\u0012\u0000\u00e808\u00e88@\u00e8@H\u00e8HP\u00f0hp\u00c0\u0010 \u00e8 0\u00c8(8\u00d0`p\u00c8P@\u00c8XH\u00f8\u00b0\u00a8\u00c8@8\u00b888\u00e8PP\u00f0xx\u00f8\u00a8\u00a8\u00d8\u0098\u0098\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u001f\u0000,\u0004\u0000\u0004\u0000\u0010\u0000\u0010\u0000\u0000\u0005T\u00e0'\u008edi\u009ehjFJ\u00eb\u00baQ\u0099,t]'2\u00e4\u00ec\u00bc\u0003\u00e1$Fd@,\u000e\"\u008c\u0092P\u00c0l\n\u0090\u00a5\u00c6\u0003@\u00ad\u0002\u001eIR\u0083`\u00e8z\r\u0084F\u00e90\u00b5R\u001f\u0087R!\u0012h\u00bb\u0003\u0091\u0082\u001aB\u00af\u00d7\u00e5$Da\u00cf\u00e7#T\u0080\u0081\u001f!\u0000;");
        Resources.add("/org/h2/web/res/ico_add.gif", "GIF89a\u0010\u0000\u0010\u0000\u00d5\u0000\u00005vT8zW8yW;~Z<~Z@\u0085^D\u008bbE\u008ccE\u008bbE\u008bcE\u008cbJ\u0093gJ\u0093hO\u009alP\u009alT\u00a1qU\u00a1qT\u00a1pX\u00a7uU\u00a2q\\\u00acy_\u00b0{]\u00acy\u008d\u00b4S\u008d\u00b4T\u0096\u00b9U\u0096\u00b9V\u00a0\u00c0X\u00a1\u00c0X\u00ac\u00c7Z\u00ac\u00c7[\u00ad\u00c7Z\u00ad\u00c6Z\u00ad\u00c7[\u00c5\u00d6`\u00c6\u00d6`\u00c5\u00d5`\u00c6\u00d5`\u00c5\u00d5a\u00d0\u00dbc\u00da\u00e2e\u00da\u00e1e\u00e0\u00e5f\u00ff\u00ff\u00ff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000!\u00f9\u0004\u0001\u0000\u0000+\u0000,\u0000\u0000\u0000\u0000\u0010\u0000\u0010\u0000\u0000\u0006[\u00c0\u0095pH,\u001a\u008fHaeYI\u000e+*U\u00d3\u00b9\u00a2\u00a4P\u0016\u00eaJr\u0095 '\u0011\u00c8\u00e3D>=\u00ce\u000f\u00a2C$2\u0091\u00da\u00a5\u0011\u00bbAd\u0084B\u00a0\u000e(\u00e4\u00f9\u00f8\u0017D\u0006\t\n\n\u001b\u001c\u001b\u001b\n\b\u0007\u0007H\u0005\u0019\u001a\u0005Z\u0004\u0018\u0017\u0003Z\u0001\u0095\u0002Z\u0000\u009d\u0000Z\u00a0\u00a0A\u0000;");
        Resources.add("/org/h2/web/res/ico_ok.gif", "GIF89a\u0010\u0000\u0010\u0000\u00f7\u0000\u0000\u0000\u0000\u0000\u0080\u0000\u0000\u0000\u0080\u0000\u0080\u0080\u0000\u0000\u0000\u0080\u0080\u0000\u0080\u0000\u0080\u0080\u0080\u0080\u0080\u00c0\u00c0\u00c0\u00ff\u0000\u0000\u0000\u00ff\u0000\u00ff\u00ff\u0000\u0000\u0000\u00ff\u00ff\u0000\u00ff\u0000\u00ff\u00ff\u00ff\u00ff\u00ff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u00003\u0000\u0000f\u0000\u0000\u0099\u0000\u0000\u00cc\u0000\u0000\u00ff\u00003\u0000\u000033\u00003f\u00003\u0099\u00003\u00cc\u00003\u00ff\u0000f\u0000\u0000f3\u0000ff\u0000f\u0099\u0000f\u00cc\u0000f\u00ff\u0000\u0099\u0000\u0000\u00993\u0000\u0099f\u0000\u0099\u0099\u0000\u0099\u00cc\u0000\u0099\u00ff\u0000\u00cc\u0000\u0000\u00cc3\u0000\u00ccf\u0000\u00cc\u0099\u0000\u00cc\u00cc\u0000\u00cc\u00ff\u0000\u00ff\u0000\u0000\u00ff3\u0000\u00fff\u0000\u00ff\u0099\u0000\u00ff\u00cc\u0000\u00ff\u00ff3\u0000\u00003\u000033\u0000f3\u0000\u00993\u0000\u00cc3\u0000\u00ff33\u000033333f33\u009933\u00cc33\u00ff3f\u00003f33ff3f\u00993f\u00cc3f\u00ff3\u0099\u00003\u009933\u0099f3\u0099\u00993\u0099\u00cc3\u0099\u00ff3\u00cc\u00003\u00cc33\u00ccf3\u00cc\u00993\u00cc\u00cc3\u00cc\u00ff3\u00ff\u00003\u00ff33\u00fff3\u00ff\u00993\u00ff\u00cc3\u00ff\u00fff\u0000\u0000f\u00003f\u0000ff\u0000\u0099f\u0000\u00ccf\u0000\u00fff3\u0000f33f3ff3\u0099f3\u00ccf3\u00ffff\u0000ff3fffff\u0099ff\u00ccff\u00fff\u0099\u0000f\u00993f\u0099ff\u0099\u0099f\u0099\u00ccf\u0099\u00fff\u00cc\u0000f\u00cc3f\u00ccff\u00cc\u0099f\u00cc\u00ccf\u00cc\u00fff\u00ff\u0000f\u00ff3f\u00ffff\u00ff\u0099f\u00ff\u00ccf\u00ff\u00ff\u0099\u0000\u0000\u0099\u00003\u0099\u0000f\u0099\u0000\u0099\u0099\u0000\u00cc\u0099\u0000\u00ff\u00993\u0000\u009933\u00993f\u00993\u0099\u00993\u00cc\u00993\u00ff\u0099f\u0000\u0099f3\u0099ff\u0099f\u0099\u0099f\u00cc\u0099f\u00ff\u0099\u0099\u0000\u0099\u00993\u0099\u0099f\u0099\u0099\u0099\u0099\u0099\u00cc\u0099\u0099\u00ff\u0099\u00cc\u0000\u0099\u00cc3\u0099\u00ccf\u0099\u00cc\u0099\u0099\u00cc\u00cc\u0099\u00cc\u00ff\u0099\u00ff\u0000\u0099\u00ff3\u0099\u00fff\u0099\u00ff\u0099\u0099\u00ff\u00cc\u0099\u00ff\u00ff\u00cc\u0000\u0000\u00cc\u00003\u00cc\u0000f\u00cc\u0000\u0099\u00cc\u0000\u00cc\u00cc\u0000\u00ff\u00cc3\u0000\u00cc33\u00cc3f\u00cc3\u0099\u00cc3\u00cc\u00cc3\u00ff\u00ccf\u0000\u00ccf3\u00ccff\u00ccf\u0099\u00ccf\u00cc\u00ccf\u00ff\u00cc\u0099\u0000\u00cc\u00993\u00cc\u0099f\u00cc\u0099\u0099\u00cc\u0099\u00cc\u00cc\u0099\u00ff\u00cc\u00cc\u0000\u00cc\u00cc3\u00cc\u00ccf\u00cc\u00cc\u0099\u00cc\u00cc\u00cc\u00cc\u00cc\u00ff\u00cc\u00ff\u0000\u00cc\u00ff3\u00cc\u00fff\u00cc\u00ff\u0099\u00cc\u00ff\u00cc\u00cc\u00ff\u00ff\u00ff\u0000\u0000\u00ff\u00003\u00ff\u0000f\u00ff\u0000\u0099\u00ff\u0000\u00cc\u00ff\u0000\u00ff\u00ff3\u0000\u00ff33\u00ff3f\u00ff3\u0099\u00ff3\u00cc\u00ff3\u00ff\u00fff\u0000\u00fff3\u00ffff\u00fff\u0099\u00fff\u00cc\u00fff\u00ff\u00ff\u0099\u0000\u00ff\u00993\u00ff\u0099f\u00ff\u0099\u0099\u00ff\u0099\u00cc\u00ff\u0099\u00ff\u00ff\u00cc\u0000\u00ff\u00cc3\u00ff\u00ccf\u00ff\u00cc\u0099\u00ff\u00cc\u00cc\u00ff\u00cc\u00ff\u00ff\u00ff\u0000\u00ff\u00ff3\u00ff\u00fff\u00ff\u00ff\u0099\u00ff\u00ff\u00cc\u00ff\u00ff\u00ff,\u0000\u0000\u0000\u0000\u0010\u0000\u0010\u0000\u0000\b3\u0000\u001f\b\u001cH\u00b0\u00a0\u00c1\u0083\b\u0013*,\b`\u00e1@\u0000\r\u001dB\u008c\u00a8p\u00a2A\u008a\u0002-^\u00a4\u00a8qc\u00c3\u008e\u0007'B\u00948\u00d2\u00e1\u0003\u008c&S\u00aat\u0018\u0010\u0000;");
        Resources.add("/org/h2/web/res/ico_remove.gif", "GIF89a\u0010\u0000\u0010\u0000\u00d5\u0000\u0000\u00deRU\u00e4UX\u00e5WZ\u00e4WZ\u00d6RT\u00c5UV\u00f3y{\u00f3z{\u00f2z{\u00f2z|\u00deRV\u00c4NR\u00c3NR\u00c5RU\u00f3ot\u00f2ot\u00f2pt\u00c3IO\u00f0[e\u00ef[d\u00c4KQ\u00c3KQ\u00f2`i\u00f0`i\u00f2fm\u00d2q{\u00de\u009c\u00a7\u00d3\u008b\u0081\u00c8h^\u00c8i^\u00c7i^\u00c8l`\u00ccwl\u00db\u00a5\u009f\u00c7d]\u00c7_Z\u00c7_[\u00c6_[\u00denj\u00f5\u0085\u0082\u00f3\u0085\u0082\u00e1ec\u00c5ZX\u00c5ZY\u00e1\u00c2\u00c2\u00ff\u00ff\u00ff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000!\u00f9\u0004\u0001\u0000\u0000-\u0000,\u0000\u0000\u0000\u0000\u0010\u0000\u0010\u0000\u0000\u0006{\u00c0\u0096pH,\u001a\u008fG\u00d6gS\u00dc|XDV'\u00d5a\n7\u009e\u0014\u0007*\f\u0089N'\u0011(\u0004\u0012\u00a1\u00c2!\u00e2\u00a6\u00948\u0098F&\u0084\u0081d%fV\u0090\u00c7\u00c3\u00f1Pe\u0090\u0005\u0003\u0018\u0083\u0002\u0005H-\r\u0001\u0017\u0016\u0016\u0001\rH\u0019\u000b\u0012\u0093\u0093\f\u007fE\u0019\u0014\u0093\u0004\u0015\u0004\u0012\u0013\u0015\u0097B\u001a\u0011\u009f\u0011\u0019\u001a\u0019\u00a5\u0013\u0011\u001aC,\u0011\n\u00a7C\u00aa\u0000\u0011\\B\u00b0\u00a2B\u00aa\u00b8\u0087\u00bf\u00c0-A\u0000;");
        Resources.add("/org/h2/web/res/ico_search.gif", "GIF89a\u0010\u0000\u0010\u0000\u00e6\u0000\u0000\u0099\u0096\u0099\u00d9\u00d9\u00da\u00c1\u00c3\u00c8\u00a2\u00a8\u00b3\u00af\u00b4\u00bd~\u0088\u0097\u008d\u0096\u00a4\u0086\u008f\u009b\u00a2\u00aa\u00b5\u00b6\u00bc\u00c4\u00b3\u00b9\u00c1\u0086\u008d\u0094\u00da\u00de\u00e2\u00e3\u00e7\u00eb\u00e9\u00ec\u00ef\u00de\u00e1\u00e4\u00ee\u00f0\u00f2\u00dd\u00df\u00e1\u00d2\u00d4\u00d6\u00f9\u00fa\u00fb\u00e2\u00e3\u00e4\u0092\u009a\u00a1\u00d3\u00d7\u00da\u00c2\u00c6\u00c9\u00e3\u00e7\u00ea\u00dc\u00e0\u00e3\u00ee\u00f1\u00f3\u00e9\u00ec\u00ee\u00e5\u00e8\u00ea\u00dc\u00e1\u00e4\u00da\u00de\u00e0\u00f4\u00f6\u00f7\u00bb\u00bf\u00c0\u00f3\u00f5\u00f5\u00f6\u00f7\u00f7\u0081\u0087\u0086\u00b5\u00b8\u00b4\u00ab\u00ae\u00a9\u0092\u0095\u008e\u00d1\u00d2\u00ce\u00a0\u00a1\u0097\u00ac\u00ac\u00a0\u00d5\u00d5\u00ce\u00bf\u00bf\u00ba\u00b4\u00b2\u009a\u00a5\u00a4\u0095\u009c\u0099|\u00c4\u00c1\u00ad\u00af\u00ad\u009d\u00a6\u009eo\u009f\u0099r\u00bf\u00b8\u0091\u00b2\u00ac\u0089\u00cc\u00c8\u00b2\u00c6\u00c4\u00b7\u00df\u00dd\u00d0\u00ac\u00a2p\u00b1\u00a7u\u00b5\u00ab}\u00d0\u00ca\u00ad\u00b6\u00ac\u007f\u00ef\u00ee\u00eb\u009c\u0098\u0096\u009c\u0088\u007fyO@\u008aqh\u0088qi\u009a\u0087\u0080\u00f7\u00f4\u00f3\u0088qj\u0087pj\u0089tp\u0087sq\u0082nn\u00fe\u00fe\u00fe\u00fb\u00fb\u00fb\u00f4\u00f4\u00f4\u00f2\u00f2\u00f2\u00e8\u00e8\u00e8\u00e6\u00e6\u00e6\u00ff\u00ff\u00ff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000!\u00f9\u0004\u0001\u0000\u0000P\u0000,\u0000\u0000\u0000\u0000\u0010\u0000\u0010\u0000\u0000\u0007~\u0080P\u0082\u0083\u0084\u0085\u0084;8:<93\u0086\u00834/OMLL71\u008e56NJ\u009cJK=2\u0086.\u0001\u0013\u00a5\u00a6\",+\u0085-\u0014\u001f\u00ae\u00af!*0\u0085(\u0011\u001a\u00b7\u00b8\u0010')\u0085&\u0012\u000e\u00c0\u00c1\u001b$\u00aa\u0084% \u001e\r\u00ca\r\u0018\u001c#\u008e\u000b\u0017\u0016\f\u001d\u0019\u000f\u0015>\u008eP\u0007\u0006\n\t\b\u0005\u0000D?\u00da\u0002\u0004\u0003\u0002\u0082C@A\u00da\u0086E@B\u00ee\u0085F@G\u00f3\u0084HI\u00f8\u0086\u0081\u0000;");
        Resources.add("/org/h2/web/res/ico_undo.gif", "GIF89a\u0010\u0000\u0010\u0000\u00f7\u0000\u0000\u0000\u0000\u0000\u0080\u0000\u0000\u0000\u0080\u0000\u0080\u0080\u0000\u0000\u0000\u0080\u0080\u0000\u0080\u0000\u0080\u0080\u0080\u0080\u0080\u00c0\u00c0\u00c0\u00ff\u0000\u0000\u0000\u00ff\u0000\u00ff\u00ff\u0000\u0000\u0000\u00ff\u00ff\u0000\u00ff\u0000\u00ff\u00ff\u00ff\u00ff\u00ff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u00003\u0000\u0000f\u0000\u0000\u0099\u0000\u0000\u00cc\u0000\u0000\u00ff\u00003\u0000\u000033\u00003f\u00003\u0099\u00003\u00cc\u00003\u00ff\u0000f\u0000\u0000f3\u0000ff\u0000f\u0099\u0000f\u00cc\u0000f\u00ff\u0000\u0099\u0000\u0000\u00993\u0000\u0099f\u0000\u0099\u0099\u0000\u0099\u00cc\u0000\u0099\u00ff\u0000\u00cc\u0000\u0000\u00cc3\u0000\u00ccf\u0000\u00cc\u0099\u0000\u00cc\u00cc\u0000\u00cc\u00ff\u0000\u00ff\u0000\u0000\u00ff3\u0000\u00fff\u0000\u00ff\u0099\u0000\u00ff\u00cc\u0000\u00ff\u00ff3\u0000\u00003\u000033\u0000f3\u0000\u00993\u0000\u00cc3\u0000\u00ff33\u000033333f33\u009933\u00cc33\u00ff3f\u00003f33ff3f\u00993f\u00cc3f\u00ff3\u0099\u00003\u009933\u0099f3\u0099\u00993\u0099\u00cc3\u0099\u00ff3\u00cc\u00003\u00cc33\u00ccf3\u00cc\u00993\u00cc\u00cc3\u00cc\u00ff3\u00ff\u00003\u00ff33\u00fff3\u00ff\u00993\u00ff\u00cc3\u00ff\u00fff\u0000\u0000f\u00003f\u0000ff\u0000\u0099f\u0000\u00ccf\u0000\u00fff3\u0000f33f3ff3\u0099f3\u00ccf3\u00ffff\u0000ff3fffff\u0099ff\u00ccff\u00fff\u0099\u0000f\u00993f\u0099ff\u0099\u0099f\u0099\u00ccf\u0099\u00fff\u00cc\u0000f\u00cc3f\u00ccff\u00cc\u0099f\u00cc\u00ccf\u00cc\u00fff\u00ff\u0000f\u00ff3f\u00ffff\u00ff\u0099f\u00ff\u00ccf\u00ff\u00ff\u0099\u0000\u0000\u0099\u00003\u0099\u0000f\u0099\u0000\u0099\u0099\u0000\u00cc\u0099\u0000\u00ff\u00993\u0000\u009933\u00993f\u00993\u0099\u00993\u00cc\u00993\u00ff\u0099f\u0000\u0099f3\u0099ff\u0099f\u0099\u0099f\u00cc\u0099f\u00ff\u0099\u0099\u0000\u0099\u00993\u0099\u0099f\u0099\u0099\u0099\u0099\u0099\u00cc\u0099\u0099\u00ff\u0099\u00cc\u0000\u0099\u00cc3\u0099\u00ccf\u0099\u00cc\u0099\u0099\u00cc\u00cc\u0099\u00cc\u00ff\u0099\u00ff\u0000\u0099\u00ff3\u0099\u00fff\u0099\u00ff\u0099\u0099\u00ff\u00cc\u0099\u00ff\u00ff\u00cc\u0000\u0000\u00cc\u00003\u00cc\u0000f\u00cc\u0000\u0099\u00cc\u0000\u00cc\u00cc\u0000\u00ff\u00cc3\u0000\u00cc33\u00cc3f\u00cc3\u0099\u00cc3\u00cc\u00cc3\u00ff\u00ccf\u0000\u00ccf3\u00ccff\u00ccf\u0099\u00ccf\u00cc\u00ccf\u00ff\u00cc\u0099\u0000\u00cc\u00993\u00cc\u0099f\u00cc\u0099\u0099\u00cc\u0099\u00cc\u00cc\u0099\u00ff\u00cc\u00cc\u0000\u00cc\u00cc3\u00cc\u00ccf\u00cc\u00cc\u0099\u00cc\u00cc\u00cc\u00cc\u00cc\u00ff\u00cc\u00ff\u0000\u00cc\u00ff3\u00cc\u00fff\u00cc\u00ff\u0099\u00cc\u00ff\u00cc\u00cc\u00ff\u00ff\u00ff\u0000\u0000\u00ff\u00003\u00ff\u0000f\u00ff\u0000\u0099\u00ff\u0000\u00cc\u00ff\u0000\u00ff\u00ff3\u0000\u00ff33\u00ff3f\u00ff3\u0099\u00ff3\u00cc\u00ff3\u00ff\u00fff\u0000\u00fff3\u00ffff\u00fff\u0099\u00fff\u00cc\u00fff\u00ff\u00ff\u0099\u0000\u00ff\u00993\u00ff\u0099f\u00ff\u0099\u0099\u00ff\u0099\u00cc\u00ff\u0099\u00ff\u00ff\u00cc\u0000\u00ff\u00cc3\u00ff\u00ccf\u00ff\u00cc\u0099\u00ff\u00cc\u00cc\u00ff\u00cc\u00ff\u00ff\u00ff\u0000\u00ff\u00ff3\u00ff\u00fff\u00ff\u00ff\u0099\u00ff\u00ff\u00cc\u00ff\u00ff\u00ff,\u0000\u0000\u0000\u0000\u0010\u0000\u0010\u0000\u0000\b8\u0000\u001f\b\u001cH\u00b0\u00a0\u00c1\u0083\b\u0013\u001a\u0004\u0000\u00a0 \u00c3\u0083\f\u001b\n\u008c\u0088\u0090\"\u00c5\u0084\u0011\u001f*|pQaF\u0089\u0015\u001fvt\u00a8\u0091cI\u0082'Mn\\\u00c9\u00b2\u00a5\u00cb\u0081\u0001\u0001\u0000;");
        Resources.add("/org/h2/web/res/ico_write.gif", "GIF89a\u0010\u0000\u0010\u0000\u00c4\u0000\u0000\u009e\u008c\u009f\u009c\u008b\u00a4\u0085\u0085\u00b4\u0000%k\u00e4\u00cf\u0094\u00c1\u00aa~\u00fb\u00bcg\u00fd\u00e2\u00bf\u00fb\u00d1\u009b\u0099O\u001b\u0099R\"\u009bZ2\u009ba=\u0098dC\u009bjP\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000!\u00f9\u0004\u0001\u0000\u0000\u0010\u0000,\u0000\u0000\u0000\u0000\u0010\u0000\u0010\u0000\u0000\u0005O $\u008e\u00a4\u00f8<ej6\r\u00aa\u008eOc\u0018\u008c\u00ab\u00c6\u00c6\u0081,v\u0089\u00eb\u0006E\u000f&\u0003:Z\u00a9\u001f\u00c2\u00e0H\f!J\u00a63Y\\6\u009f\u00d1k2\u00e0@\u0010\n\u00dad\u0082\u00f0\r\u00fb\u0000\u0083B!1\u00bd\r\u0012o\u00c7\u00136\u0018\bN/\u00d3iN\n\u0001\u0000;");
        Resources.add("/org/h2/web/res/index.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">  \r\n<script type=\"text/javascript\">\r\n  location.href = 'login.jsp?jsessionid=${sessionId}';\r\n</script>\r\n</head>\r\n<body style=\"margin: 20px;\">\r\n\r\n<h1>Welcome to H2</h1>\r\n<h2>No Javascript</h2>\r\nIf you are not automatically redirected to the login page, then\r\nJavascript is currently disabled or your browser does not support Javascript.\r\nFor this application to work, Javascript is essential.\r\nPlease enable Javascript now, or use another web browser that supports it.\r\n\r\n</body>\r\n");
        Resources.add("/org/h2/web/res/login.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.login.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n\t<script type=\"text/javascript\">\r\n\t\tif(self != top) {\r\n\t\t    top.location = \"login.jsp\";\r\n\t\t}\r\n\t</script>\r\n</head>\r\n<body style=\"margin: 20px\">\r\n\t<form name=\"login\" method=\"post\" action=\"/login.do?jsessionid=${sessionId}\" id=\"login\">\r\n\t<p>\t\t\t\t\t<select name=\"language\" size=\"1\"\r\n\t\t\t\t\t\tonchange=\"javascript:document.location='index.do?jsessionid=${sessionId}&amp;language='+login.language.value;\"\r\n\t\t\t\t\t>\r\n\t\t\t\t\t${languageCombo}\r\n\t\t\t\t\t</select>\r\n\t &nbsp;&nbsp; <a href=\"admin.do?jsessionid=${sessionId}\">${text.login.goAdmin}</a> \r\n\t &nbsp;&nbsp; <a href=\"help.jsp?jsessionid=${sessionId}\">${text.a.help}</a>\r\n\t </p>\t\r\n\t\t<table class=\"login\" cellspacing=0 cellpadding=0>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<th class=\"login\">${text.login.login}</th>\r\n\t\t\t\t<th class=\"login\"></th>\r\n\t\t\t</tr>\r\n\t\t\t<tr><td  class=\"login\" colspan=2></td></tr>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<td class=\"login\">${text.login.savedSetting}:</td>\r\n\t\t\t\t<td class=\"login\">\r\n\t\t\t\t\t<select name=\"setting\" size=\"1\"\r\n\t\t\t\t\t\tstyle=\"width:300px\"\r\n\t\t\t\t\t\tonchange=\"javascript:document.location='index.do?jsessionid=${sessionId}&amp;setting='+login.setting.value;\"\r\n\t\t\t\t\t>\r\n\t\t\t\t\t${settingsList}\r\n\t\t\t\t\t</select>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<td class=\"login\">${text.login.settingName}:</td>\r\n\t\t\t\t<td class=\"login\">\r\n\t\t\t\t\t<input type=\"text\" name=\"name\" value=\"${name}\" style=\"width:200px;\">\r\n\t\t\t\t\t<input type=\"button\" class=\"button\" value=\"${text.login.save}\" onclick=\"javascript:document.login.action='/settingSave.do?jsessionid=${sessionId}';submit()\">\r\n\t\t\t\t\t<input type=\"button\" class=\"button\" value=\"${text.login.remove}\" onclick=\"javascript:document.login.action='/settingRemove.do?jsessionid=${sessionId}';submit()\">\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<td class=\"login\" colspan=2>\r\n\t\t\t\t\t<hr>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<td class=\"login\">${text.login.driverClass}:</td>\r\n\t\t\t\t<td class=\"login\"><input type=\"text\" name=\"driver\" value=\"${driver}\" style=\"width:300px;\"></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<td class=\"login\">${text.login.jdbcUrl}:</td>\r\n\t\t\t\t<td class=\"login\"><input type=\"text\" name=\"url\" value=\"${url}\" style=\"width:300px;\"></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<td class=\"login\">${text.a.user}:</td>\r\n\t\t\t\t<td class=\"login\"><input type=\"text\" name=\"user\" value=\"${user}\" style=\"width:200px;\"></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<td class=\"login\">${text.a.password}:</td>\r\n\t\t\t\t<td class=\"login\"><input type=\"password\" name=\"password\" value=\"\" style=\"width:200px;\"></td>\r\n\t\t\t</tr>\r\n\t\t\t<tr class=\"login\">\r\n\t\t\t\t<td class=\"login\"></td>\r\n\t\t\t\t<td class=\"login\">\r\n\t\t\t\t\t<input type=\"submit\" class=\"button\" value=\"${text.login.connect}\">\r\n\t\t\t\t\t&nbsp;\r\n\t\t\t\t\t<input type=\"button\" class=\"button\" value=\"${text.login.testConnection}\" onclick=\"javascript:document.login.action='/test.do?jsessionid=${sessionId}';submit()\">\r\n\t\t\t\t\t<br>\r\n\t\t\t\t\t<br>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</table>\r\n\t\t<br>\r\n\t    <p class=\"error\">${error}</p>\r\n\t</form>\r\n</body>");
        Resources.add("/org/h2/web/res/main.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n\r\n\t<script type=\"text/javascript\">\r\n\t\t<!--\r\n\t\tif(self != top) {\r\n\t\t    top.location = \"main.jsp\";\r\n\t\t}\r\n\t\t//-->\r\n\t</script>\r\n\r\n</head>\r\n<body margin=10>\r\n\t<h1>Welcome to H2</h1>\r\n\t<h2><a href=\"index.jsp\">Connect</a></h2>\r\n\tLogin to a database.\r\n\t<h2><a href=\"docs.jsp\">Documentation</a></h2>\r\n\tView the online documentation.\r\n\t<h2><a href=\"admin.jsp\">Preferences</a></h2>\r\n\tAllows to you to view and change server settings.\r\n\t\r\n</body>");
        Resources.add("/org/h2/web/res/main_single.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>DbWebInterface</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n</head>\r\n<body>\r\n\t<form name=\"main\" method=\"post\" action=\"/work.do?jsessionid=${sessionId}\">\r\n\t\t<table width=\"100%\" height=\"200px\" cellspacing=0 cellpadding=0 class=\"empty\">\r\n\t\t\t<tr class=\"empty\">\r\n\t\t\t\t<td width=\"150px\"  class=\"empty\">\r\n\t\t\t\t\tTables: <br>\r\n\t\t\t\t\t<div style=\"overflow: auto; width: 150px; height: 400; border: 1px gray solid; padding:0px; margin: 0px\">\r\n\t\t\t\t\t<table cellspacing=0 cellpadding=0 class=\"empty\">\r\n\t\t\t\t\t\t<col width=125>\r\n\t\t\t\t\t\t<tr class=\"empty\">\r\n\t\t\t\t\t\t\t<td width=125 valign=\"top\" nowrap class=\"empty\">\r\n\t\t\t\t\t\t\t\t${tables}\r\n\t\t\t\t\t\t\t</td>\r\n\t\t\t\t\t\t</tr>\r\n\t\t\t\t\t</table>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t\t<td width=\"625px\"  valign=\"top\" class=\"empty\">\r\n\t\t\t\t\tSQL Command: <input type=\"submit\" class=\"button\" value=\"Run\"><br>\r\n\t\t\t\t\t<textarea name=\"sql\" cols=\"80\" rows=\"5\">${query}</textarea>\r\n\t\t\t\t\t<br>\r\n\t\t\t\t\tResult: <br>\r\n\t\t\t\t\t<div style=\"overflow: auto; width: 625px; height: 250; border: 1px gray solid; padding:0px; margin: 0px\">\r\n\t\t\t\t\t<table cellspacing=0 cellpadding=0 class=\"empty\">\r\n\t\t\t\t\t\t<col width=600>\r\n\t\t\t\t\t\t<tr class=\"empty\">\r\n\t\t\t\t\t\t\t<td width=600 valign=\"top\" nowrap class=\"empty\">\r\n\t\t\t\t\t\t\t\t${result}\r\n\t\t\t\t\t\t\t</td>\r\n\t\t\t\t\t\t</tr>\r\n\t\t\t\t\t</table>\r\n\t\t\t\t\t</div>\r\n\t\t\t\t</td>\r\n\t\t\t</tr>\r\n\t\t</table>\r\n\t</form>\r\n\t<form name=\"logout\" method=\"post\" action=\"/logout.do?jsessionid=${sessionId}\">\r\n\t\t<input type=\"submit\" class=\"button\" value=\"Logout\"><br>\r\n\t</form>\r\n</body>\r\n");
        Resources.add("/org/h2/web/res/notAllowed.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n</head>\r\n<body style=\"margin: 20px\">\r\n\t<h1>${text.a.title}</h1>\r\n\t<p>\r\n\t\t${text.a.remoteConnectionsDisabled}\r\n\t</p>\r\n</body>");
        Resources.add("/org/h2/web/res/query.jsp", "<!-- can not use doctype -->\r\n<html>\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n\r\n<script type=\"text/javascript\">\r\n\r\nvar columnsByTable = new Object();\r\nvar tableAliases = new Object();\r\n\r\nfunction refreshTables() {\r\n\tcolumnsByTable = new Object();\r\n\tvar tables = top.frames['h2menu'].tables;\r\n\tfor(var i=0; i<tables.length; i++) {\r\n\t\tcolumnsByTable[tables[i].name] = tables[i].columns;\r\n\t}\r\n}\r\n\r\nfunction sizeTextArea() {\r\n\tvar height=document.body.clientHeight;\r\n\tdocument.h2query.sql.style.height=height-40;\r\n}\r\n\r\nfunction buildTableAliases(input) {\r\n\ttableAliases = new Object();\r\n\tvar list = splitSQL(input);\r\n\tvar last = \"\";\r\n\tfor(var i=0; i<list.length; i++) {\r\n\t\tvar word = list[i].toUpperCase();\r\n\t\tif(word != \"AS\") {\r\n\t\t\tif(columnsByTable[last]) {\r\n\t\t\t\ttableAliases[word] = last;\r\n\t\t\t}\r\n\t\t\tlast = word;\r\n\t\t}\r\n\t}\r\n}\r\n\r\nfunction splitSQL(s) {\r\n\tvar list = new Array();\r\n\ts = s.toUpperCase() + ' ';\r\n\tvar e = s.length;\r\n\tfor(var i=0; i<e; i++) {\r\n\t\tvar ch = s.charAt(i);\r\n\t\tif(ch == '_' || (ch >= 'A' && ch <= 'Z')) {\r\n\t\t\tvar start = i;\r\n\t\t\tdo {\r\n\t\t\t\tch = s.charAt(++i);\r\n\t\t\t} while(ch == '_' || (ch >= '0' && ch <= '9') || (ch >= 'A' && ch <= 'Z'));\r\n\t\t\tlist[list.length] = s.substring(start, i);\r\n\t\t}\r\n\t}\r\n\treturn list;\r\n}\r\n\r\nfunction help(event) {\r\n\tvar unicode=event.keyCode? event.keyCode : event.charCode;\r\n\tif (unicode == 13 && event.ctrlKey) {\r\n\t\tdocument.h2query.submit();\r\n\t} \r\n\tvar input = document.h2query.sql;\r\n\tif(input.selectionStart) {\r\n\t\tvar pos = input.selectionStart;\r\n\t\tif(pos > 0 && input.value.substring(pos-1, pos) == '.') {\r\n\t\t\tvar s = input.value.substring(0, pos-1).toUpperCase();\r\n\t\t\tvar e = pos-2;\r\n\t\t\tfor(; e>=0; e--) {\r\n\t\t\t\tvar ch = s.charAt(e);\r\n\t\t\t\tif(ch != '_' && (ch < '0' || ch > '9') && (ch < 'A' || ch > 'Z')) {\r\n\t\t\t\t\tbreak;\r\n\t\t\t\t}\r\n\t\t\t}\r\n\t\t\ts = s.substring(e+1, s.length);\r\n\t\t\tbuildTableAliases(input.value);\r\n\t\t\tif(!columnsByTable[s]) {\r\n\t\t\t\ts = tableAliases[s];\r\n\t\t\t}\r\n\t\t\tif(columnsByTable[s]) {\r\n\t\t\t\tif(top.h2menu.goToTable(s)) {\r\n\t\t\t\t\ttop.h2menu.document.location='tables.do?jsessionid=${sessionId}#' + s;\r\n\t\t\t\t\t// top.h2menu.window.blur();\r\n\t\t\t\t\tdocument.h2query.sql.focus();\r\n\t\t\t\t}\r\n\t\t\t}\r\n\t\t}\r\n\t}\r\n}\r\n\r\nfunction set(field, combo) {\r\n\tfield.value=combo.value;\r\n\tcombo.value='';\r\n\tfield.focus();\r\n}\r\n\r\nfunction trim(s) {\r\n\twhile(s.charAt(0)==' ' && s.length>0) {\r\n\t\ts=s.substring(1);\r\n\t}\r\n\twhile(s.charAt(s.length-1)==' ' && s.length>0) {\r\n\t\ts=s.substring(0, s.length-1);\r\n\t}\r\n\treturn s;\r\n}\r\n\r\nfunction trimCommas(s) {\r\n\twhile(s.charAt(0)==',' && s.length>0) {\r\n\t\ts=s.substring(1);\r\n\t}\r\n\twhile(s.charAt(s.length-1)==',' && s.length>0) {\r\n\t\ts=s.substring(0, s.length-1);\r\n\t}\r\n\treturn s;\r\n}\r\n\r\nfunction insert(field, combo) {\r\n\tinsertText(combo.value);\r\n\tcombo.value='';\r\n}\r\n\r\nfunction insertText(s, isTable) {\r\n\tvar field = document.h2query.sql;\r\n\ts += ' ';\t\r\n\tif(isTable && trim(field.value)=='') {\r\n\t\tfield.value = 'SELECT * FROM ' + s;\r\n\t} else {\r\n\t\tif (document.selection) {\r\n\t\t\t// IE\r\n\t\t\tfield.focus();\r\n\t\t\tsel = document.selection.createRange();\r\n\t\t\tsel.text = s;\r\n\t\t} else if (field.selectionStart || field.selectionStart == '0') {\r\n\t\t\t// Firefox\r\n\t\t\tvar startPos = field.selectionStart;\r\n\t\t\tvar endPos = field.selectionEnd;\r\n\t\t\tfield.value = field.value.substring(0, startPos) + s + field.value.substring(endPos, field.value.length);\r\n\t\t\tvar pos = endPos + s.length;\r\n\t\t\tfield.selectionStart = pos;\r\n\t\t\tfield.selectionEnd = pos;\r\n\t\t} else {\r\n\t\t\tfield.value += s;\r\n\t\t}\r\n\t}\r\n\tfield.focus();\r\n}\r\n\r\n</script>\r\n\r\n</head>\r\n<body onresize=\"sizeTextArea();\" onload=\"sizeTextArea();\">\r\n\r\n\t<form name=\"h2query\" method=\"post\" action=\"/query.do?jsessionid=${sessionId}\" target=\"h2result\">\r\n\t<input type=\"button\" class=\"button\" value=\"${text.toolbar.run}\" onclick=\"javascript:submit();sql.focus();return true;\">\r\n\t<input type=\"button\" class=\"button\" value=\"${text.toolbar.clear}\" onclick=\"javascript:sql.value='';sql.focus();return true;\">\r\n\t${text.toolbar.sqlStatement}:\r\n\t<br>\r\n\t<textarea name=\"sql\" cols=\"80\" rows=\"5\" onkeyup=\"javascript:help(event);\" onchange=\"javascript:help(event);\">${query}</textarea>\r\n\t</form>\r\n\t\r\n</body></html>");
        Resources.add("/org/h2/web/res/result.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<html>\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n\t<script type=\"text/javascript\" src=\"table.js\"></script>\r\n</head>\r\n<body class=\"result\">\r\n\r\n ${result}\r\n\r\n</body></html>\r\n");
        Resources.add("/org/h2/web/res/resultHelp.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<html>\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n</head>\r\n<body class=\"result\">\r\n\r\n<%@ include file=\"help.txt\" %>\r\n\r\n</body></html>\r\n");
        Resources.add("/org/h2/web/res/sort_down.gif", "GIF89a\u0007\u0000\n\u0000\u00a1\u0002\u0000kkZ\u00b5\u00b5\u00b5\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00fe\u0015Created with The GIMP\u0000!\u00f9\u0004\u0001\n\u0000\u0001\u0000,\u0000\u0000\u0000\u0000\u0007\u0000\n\u0000\u0000\u0002\f\u008c\u008f\u00a9\u000b\u00ed\u0010\u001e4.\u00cd\u0085\u000b\u0000;");
        Resources.add("/org/h2/web/res/sort_up.gif", "GIF89a\u0007\u0000\n\u0000\u00a1\u0002\u0000\u00b5\u00b5\u00b5kkZ\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00fe\u0015Created with The GIMP\u0000!\u00f9\u0004\u0001\n\u0000\u0000\u0000,\u0000\u0000\u0000\u0000\u0007\u0000\n\u0000\u0000\u0002\f\u0084\u008f\u00a9\u0017\u0019\u00cf\u001e\u0094tYU\u0000\u0000;");
        Resources.add("/org/h2/web/res/stylesheet.css", "td, input, select, textarea, body, code, pre {\r\n\tfont-family: Tahoma, helvetica, sans-serif;\r\n\tfont-size: 8pt;\r\n}\r\n\r\nbody {\r\n\tmargin: 4px;\r\n}\r\n\r\nh1 {\r\n\tborder-bottom: 1px solid #CCC;\r\n\tcolor: #800;\r\n\tfont-size: 16pt;\r\n\tline-height: normal;\r\n}\r\n\r\nh2 {\r\n\tborder-bottom: 1px solid #CCC;\r\n\tcolor: #800;\r\n\tfont-size: 13pt;\r\n}\r\n\r\nh3 {\r\n\tcolor: #800;\r\n\tfont-size: 10pt;\r\n}\r\n\r\nul {\r\n\tlist-style-type: circle;\r\n\tlist-style-position: outside;\r\n\tpadding-left: 20px;\r\n}\r\n\r\nli {\r\n\tmargin-top: 6px;\r\n}\r\n\r\n.toolbar {\r\n\tbackground-color: #ece9d8;\r\n}\r\n\r\n.result {\r\n\tbackground-color: #f4f0e0;\r\n\tmargin: 10px;\r\n}\r\n\r\ntable.toolbar {\r\n\tbackground-color: #ffffff;\r\n\tborder-collapse: collapse;\r\n\tborder: 0px;\r\n\tpadding: 0px 0px;\r\n}\r\n\r\nth.toolbar {\r\n\tborder: 0px;\r\n}\r\n\r\ntr.toolbar {\r\n\tborder: 0px;\r\n}\r\n\r\ntd.toolbar {\r\n\tvertical-align: middle;\r\n\tborder: 0px;\r\n\tpadding: 0px 0px;\r\n}\r\n\r\ntable.login {\r\n\tbackground-color: #ece9d8;\r\n\tborder:1px solid #aca899;\r\n}\r\n\r\ntr.login {\r\n\tborder: 0px;\r\n}\r\n\r\nth.login {\r\n\tcolor: #ffffff;\r\n\tfont-size: 10pt;\r\n\ttext-align: left;\r\n\tborder: 0px;\t\r\n\tbackground-color: #ece9d8;\r\n\tpadding: 5px 10px;\r\n\tbackground-image: url(background.gif);\r\n}\r\n\r\ntd.login {\r\n\tbackground-color: #ece9d8;\r\n\tfont-size: 8pt;\r\n\tpadding: 5px 10px;\r\n\ttext-align: left;\r\n\tborder: 0px;\r\n}\r\n\r\n.iconLine {\r\n\tborder-width:0px;\r\n\tborder-style:solid;\r\n}\r\n\r\n.icon {\r\n\tborder-top-color:#ece9d8;\r\n\tborder-left-color:#ece9d8;\r\n\tborder-right-color:#ece9d8;\r\n\tborder-bottom-color:#ece9d8;\r\n\tborder-width:1px;\r\n\tborder-style:solid;\r\n}\r\n\r\n.icon_hover {\r\n\tborder-top-color:#ffffff;\r\n\tborder-left-color:#ffffff;\r\n\tborder-right-color:#aca899;\r\n\tborder-bottom-color:#aca899;\r\n\tborder-width:1px;\r\n\tborder-style:solid;\r\n}\r\n\r\ntable.empty {\r\n\tbackground-color: #ffffff;\r\n\tborder: 0px;\r\n}\r\n\r\ntd.empty {\r\n\tbackground-color: #ffffff;\r\n\tborder: 0px;\r\n\tfont-size: 8pt;\r\n\tpadding: 5px 10px;\r\n\ttext-align: left;\r\n}\r\n\r\n.error {\r\n\tcolor: #ff0000;\r\n}\r\n\r\np.error {\r\n\tcolor: #ff0000;\r\n}\r\n\r\ntable {\r\n\tbackground-color: #ffffff;\r\n\tborder-collapse: collapse;\r\n\tborder: 1px solid #aca899;\r\n}\r\n\r\nth {\r\n\tfont-size: 8pt;\r\n\tfont-weight: normal;\r\n\ttext-align: left;\r\n\tbackground-color: #ece9d8;\r\n\tpadding: 2px;\r\n\tborder: 1px solid #aca899;\r\n}\r\n\r\ntd {\r\n\tbackground-color: #ffffff;\r\n\tfont-size: 8pt;\r\n\tpadding: 2px;\r\n\ttext-align: left;\r\n\tvertical-align:top;\r\n\tborder: 1px solid #aca899;\r\n}\r\n\r\nform {\r\n}\r\n\r\ntextarea {\r\n\twidth: 100%;\r\n\toverflow: auto;\r\n}\r\n\r\ninput.button {\r\n\tpadding: 1px;\r\n}\r\n/*\r\n\tborder-style: solid;\r\n\tborder-width: 1px;\r\n\tbackground-color: #eeeeee;\r\n\tborder-top-color: #aaaaaa;\r\n\tborder-left-color: #aaaaaa;\r\n\tborder-bottom-color: #222222;\r\n\tborder-right-color: #222222;\r\n*/\r\n\r\ntextarea {\r\n}\r\n\r\nselect {\r\n}\r\n\r\nul {\r\n\tlist-style-type: disc;\r\n\tlist-style-position: outside;\r\n}\r\n\r\nli {\r\n}\r\n\r\nol {\r\n\tlist-style-type: upper-roman;\r\n\tlist-style-position: outside;\r\n}\r\n\r\na {\r\n\ttext-decoration: none;\r\n\tcolor: #0000ff;\r\n}\r\n\r\na:hover {\r\n\ttext-decoration: underline;\r\n}\r\n\r\n.tree {\r\n\tborder: 0px;\r\n\tvertical-align: middle;\r\n\twhite-space: nowrap;\r\n}\r\n\r\n.tree img  {\r\n\theight: 18px;\r\n\twidth: 18px;\r\n\tborder: 0px;\r\n\tvertical-align: middle;\r\n}\r\n\r\n.tree a {\r\n\tborder: 0px;\r\n\ttext-decoration: none;\r\n\tvertical-align: middle;\r\n\twhite-space: nowrap;\r\n\tcolor: #000000;\r\n}\r\n\r\n.tree a:hover {\r\n\tcolor: #345373;\r\n}\r\n\r\ntable.content {\r\n\twidth: 100%; \r\n\theight: 100%; \r\n\tborder: 0px;\r\n}\r\n\r\ntr.content {\r\n\tborder:0px; \r\n\tborder-left:1px solid #aca899;\r\n}\r\n\r\ntd.content {\r\n\tborder:0px; \r\n\tborder-left:1px solid #aca899;\r\n}\r\n\r\ntr.contentResult {\r\n\tborder:0px; \r\n\tborder-top:1px solid #aca899;\r\n\tborder-left:1px solid #aca899;\r\n}\r\n\r\ntd.contentResult {\r\n\tborder:0px; \r\n\tborder-top:1px solid #aca899;\r\n\tborder-left:1px solid #aca899;\r\n}\r\n\r\n.contentDiv {\r\n\tmargin:10px;\r\n}\r\n");
        Resources.add("/org/h2/web/res/table.js", "addEvent(window, \"load\", initSort);\r\n\r\nfunction addEvent(elm, evType, fn, useCapture) {\r\n\t// addEvent and removeEvent\r\n\t// cross-browser event handling for IE5+,  NS6 and Mozilla\r\n\t// By Scott Andrew\r\n\tif (elm.addEventListener){\r\n\t    elm.addEventListener(evType, fn, useCapture);\r\n\t    return true;\r\n\t} else if (elm.attachEvent){\r\n\t\tvar r = elm.attachEvent(\"on\"+evType, fn);\r\n\t\treturn r;\r\n\t} else {\r\n    \talert(\"Handler could not be added\");\r\n\t}\r\n}\r\n\r\nfunction initSort() {\r\n    if(document.getElementById('editing') != undefined) {\r\n    \t// don't allow sorting while editing\r\n    \treturn;\r\n   \t}\r\n    var tables = document.getElementsByTagName(\"table\");\r\n    for (var i=0; i<tables.length; i++) {\r\n        table = tables[i];      \r\n\t\tif (table.rows && table.rows.length > 0) {\r\n\t\t\tvar header = table.rows[0];\r\n\t\t\tfor(var j=0;j<header.cells.length;j++) {\r\n\t\t\t\tvar cell = header.cells[j];\r\n\t\t\t\tvar text = cell.innerHTML;\r\n\t\t\t\tcell.innerHTML = '<a href=\"#\" style=\"text-decoration: none;\" class=\"sortheader\" onclick=\"resortTable(this);\">'+text+'<span class=\"sortarrow\">&nbsp;&nbsp;</span></a>';\r\n\t\t\t}\r\n\t\t}\r\n    }\r\n}\r\n\r\nfunction editRow(row, session, write, undo) {\r\n\tvar table = document.getElementById('editTable');\r\n\tvar y = row < 0 ? table.rows.length - 1 : row;\r\n\tvar i;\r\n\tfor(i=1; i<table.rows.length; i++) {\r\n\t    var cell = table.rows[i].cells[0];\r\n\t    if(i == y) {\r\n\t    \tvar edit = '<img width=16 height=16 src=\"ico_ok.gif\" onclick=\"javascript:editing.op.value=\\'1\\';editing.row.value=\\''+row+'\\';editing.submit()\" onmouseover = \"this.className =\\'icon_hover\\'\" onmouseout = \"this.className=\\'icon\\'\" class=\"icon\" alt=\"'+write+'\" title=\"'+write+'\" border=\"1\">';\r\n\t    \tvar undo = '<img width=16 height=16 src=\"ico_undo.gif\" onclick=\"javascript:editing.op.value=\\'3\\';editing.row.value=\\''+row+'\\';editing.submit()\" onmouseover = \"this.className =\\'icon_hover\\'\" onmouseout = \"this.className=\\'icon\\'\" class=\"icon\" alt=\"'+undo+'\" title=\"'+undo+'\" border=\"1\">';\r\n\t\t\tcell.innerHTML = edit + undo;\r\n\t\t} else {\r\n\t\t\tcell.innerHTML = '';\r\n\t\t}\r\n\t}\r\n\tvar cells = table.rows[y].cells;\r\n\tfor(i=1; i<cells.length; i++) {\r\n\t    var cell = cells[i];\r\n\t\tvar text = getInnerText(cell);\r\n\t\tcell.innerHTML = '<input type=\"text\" name=\"r'+row+'c' + i + '\" value=\"'+text+'\" size=\"' + (text.length+5) + '\">';\r\n\t}\r\n}\r\n\r\nfunction getInnerText(el) {\r\n\tif (typeof el == \"string\") return el;\r\n\tif (typeof el == \"undefined\") { return el };\r\n\tif (el.innerText) {\r\n    \t// not needed but it is faster\r\n\t\treturn el.innerText;\r\n\t}\r\n\tvar str = \"\";\r\n\tvar cs = el.childNodes;\r\n\tvar l = cs.length;\r\n\tfor (var i = 0; i < l; i++) {\r\n\t\tswitch (cs[i].nodeType) {\r\n\t\tcase 1: //ELEMENT_NODE\r\n\t\t\tstr += getInnerText(cs[i]);\r\n\t\t\tbreak;\r\n\t\tcase 3:\t//TEXT_NODE\r\n\t\t\tstr += cs[i].nodeValue;\r\n\t\t\tbreak;\r\n\t\t}\r\n\t}\r\n\treturn str;\r\n}\r\n\r\nfunction resortTable(lnk) {\r\n    // get the span\r\n    var span;\r\n    for (var ci=0;ci<lnk.childNodes.length;ci++) {\r\n        if (lnk.childNodes[ci].tagName && lnk.childNodes[ci].tagName.toLowerCase() == 'span') {\r\n        \tspan = lnk.childNodes[ci];\r\n        }\r\n    }\r\n    var spantext = getInnerText(span);\r\n    var td = lnk.parentNode;\r\n    var column = td.cellIndex;\r\n    var table = getParent(td,'TABLE');\r\n\r\n    if (table.rows.length <= 1) return;\r\n\r\n    // detect sort type\r\n    var sortNumeric = false;\r\n    var x = getInnerText(table.rows[1].cells[column]);\r\n    if (x.match(/^[\\d\\.]+$/)) {\r\n\t    sortNumeric = true;\r\n\t}\r\n\r\n//alert(\"start copy\");\r\n\r\n    var newRows = new Array();\r\n    var rows = table.rows;\r\n    for (i=1; i<rows.length; i++) {\r\n    \tvar o = new Object();\r\n    \to.data = rows[i];\r\n    \to.id = i;\r\n    \tif(sortNumeric) {\r\n    \t    o.sort = parseFloat(getInnerText(o.data.cells[column]));\r\n\t\t\tif (isNaN(o.sort)) o.sort = 0;\r\n\t\t} else {\r\n\t\t\to.sort = getInnerText(o.data.cells[column]);\r\n\t\t}\r\n    \tnewRows[i-1] = o;\r\n    }\r\n//alert(\"start sort\");\r\n    newRows.sort(sortCallback);\r\n\r\n    var arrow;\r\n    if (span.getAttribute(\"sortdir\") == 'down') {\r\n        arrow = '&nbsp;<img src=\"sort_up.gif\" with=7 height=10 border=0>';\r\n        newRows.reverse();\r\n        span.setAttribute('sortdir','up');\r\n    } else {\r\n        arrow = '&nbsp;<img src=\"sort_down.gif\" with=7 height=10 border=0>';\r\n        span.setAttribute('sortdir','down');\r\n    }\r\n\r\n//alert(\"start move\");\r\n    // we appendChild rows that already exist to the tbody,\r\n    // so it moves them rather than creating new ones\r\n    var body = table.tBodies[0];\r\n    for (i=0; i<newRows.length; i++) {\r\n\t\tbody.appendChild(newRows[i].data);\r\n    }\r\n//alert(\"end\");\r\n\r\n    // delete any other arrows there may be showing\r\n    var allspans = document.getElementsByTagName(\"span\");\r\n    for (var i=0;i<allspans.length;i++) {\r\n        if (allspans[i].className == 'sortarrow') {\r\n           \t// in the same table as us?\r\n            if (getParent(allspans[i],\"table\") == getParent(lnk,\"table\")) {\r\n                allspans[i].innerHTML = '&nbsp;&nbsp;';\r\n            }\r\n        }\r\n    }\r\n    span.innerHTML = arrow;\r\n}\r\n\r\nfunction getParent(el, pTagName) {\r\n\tif (el == null) return null;\r\n\telse if (el.nodeType == 1 && el.tagName.toLowerCase() == pTagName.toLowerCase())\t{\r\n\t\t// Gecko bug, supposed to be uppercase\r\n\t\treturn el;\r\n\t} else {\r\n\t\treturn getParent(el.parentNode, pTagName);\r\n\t}\r\n}\r\n\r\nfunction sortCallback(ra, rb) {\r\n    return (ra.sort==rb.sort) ? (ra.id-rb.id) : (ra.sort<rb.sort ? -1 : 1);\r\n}\r\n\r\n");
        Resources.add("/org/h2/web/res/tables.jsp", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<html>\r\n<head>\r\n\t<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">\r\n\t<title>${text.a.title}</title>\r\n\t<link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheet.css\">\r\n\t<script type=\"text/javascript\" src=\"tree.js\"></script>\r\n<script type=\"text/javascript\">\r\n<!--\r\n${tree}\r\n//-->\r\n</script>\r\n\r\n</head>\r\n<body>\r\n\r\n<div class=\"tree\">\r\n<script type=\"text/javascript\">\r\n<!--\r\nwriteTree();\r\n//-->\r\n</script>\r\n</div>\r\n\r\n<p class=\"error\">\r\n\t${error}\r\n</p>\r\n\r\n</body>\r\n</html>\r\n");
        Resources.add("/org/h2/web/res/tree.js", "var nodeList = new Array();\r\nvar icons = new Array();\r\nvar tables = new Array();\r\nvar tablesByName = new Object();\r\n\r\nfunction Table(name, columns, i) {\r\n\tthis.name = name;\r\n\tthis.columns = columns;\r\n\tthis.id = i;\r\n}\r\n\r\nfunction addTable(name, columns, i) {\r\n\tvar t = new Table(name, columns, i);\r\n\ttables[tables.length] = t;\r\n\ttablesByName[name] = t;\r\n}\r\n\r\nfunction ins(s, isTable) {\r\n\tif(top.h2query) {\r\n\t\tif(top.h2query.insertText) {\r\n\t\t\ttop.h2query.insertText(s, isTable);\r\n\t\t}\r\n\t}\r\n}\r\n\r\nfunction refreshQueryTables() {\r\n\tif(top.frames['h2query']) {\r\n\t\tif(top.frames['h2query'].refreshTables) {\r\n\t\t\ttop.frames['h2query'].refreshTables();\r\n\t\t}\r\n\t}\r\n}\r\n\r\nfunction goToTable(s) {\r\n\tvar t = tablesByName[s];\r\n\tif(t) {\r\n\t\thitOpen(t.id);\r\n\t\treturn true;\r\n\t}\r\n\treturn false;\r\n}\r\n\r\nfunction loadIcons() {\r\n\ticons[0] = new Image();\r\n\ticons[0].src = \"tree_minus.gif\";\r\n\ticons[1] = new Image();\r\n\ticons[1].src = \"tree_plus.gif\";\r\n}\r\n\r\nfunction Node(level, type, icon, text, link) {\r\n\tthis.level = level;\r\n\tthis.type = type;\r\n\tthis.icon = icon;\r\n\tthis.text = text;\r\n\tthis.link = link;\r\n}\r\n\r\nfunction setNode(id, level, type, icon, text, link) {\r\n\tnodeList[id] = new Node(level, type, icon, text, link);\r\n}\r\n\r\nfunction writeDiv(i, level, dist) {\r\n\tif(dist>0) {\r\n\t\tdocument.write(\"<div id=\\\"div\"+(i-1)+\"\\\" style=\\\"display: none;\\\">\");\r\n\t} else {\r\n\t\twhile(dist++<0) {\r\n\t\t\tdocument.write(\"</div>\");\r\n\t\t}\r\n\t}\r\n}\r\n\r\nfunction writeTree() {\r\n\tloadIcons();\r\n\tvar last=nodeList[0];\r\n\tfor (var i=0; i<nodeList.length; i++) {\r\n\t\tvar node=nodeList[i];\r\n\t\twriteDiv(i, node.level, node.level-last.level);\r\n\t\tlast=node;\r\n\t\tvar j=node.level;\r\n\t\twhile(j-->0) {\r\n\t\t\tdocument.write(\"<img src=\\\"tree_empty.gif\\\"/>\");\r\n\t\t}\r\n\t\tif (node.type==1) {\r\n\t\t\tif( i < nodeList.length-1 && nodeList[i+1].level > node.level) {\r\n\t\t\t\tdocument.write(\"<img onclick=\\\"javascript:hit(\"+i+\");\\\" id=\\\"join\"+i+\"\\\" src=\\\"tree_plus.gif\\\"/>\");\r\n\t\t\t} else {\r\n\t\t\t\tdocument.write(\"<img src=\\\"tree_empty.gif\\\"/>\");\r\n\t\t\t}\r\n\t\t}\r\n\t\tdocument.write(\"<img src=\\\"tree_\"+node.icon+\".gif\\\"/>&nbsp;\");\r\n\t\tif(node.link==null) {\r\n\t\t\tdocument.write(node.text);\r\n\t\t} else {\r\n\t\t\tdocument.write(\"<a name='\"+node.text+\"' href=\\\"\"+node.link+\"\\\" >\"+node.text+\"</a>\");\r\n\t\t}\r\n\t\tdocument.write(\"<br>\");\r\n\t}\r\n\twriteDiv(0, 0, -last.type);\r\n}\r\n\r\nfunction hit(i) {\r\n\tvar theDiv = document.getElementById(\"div\"+i);\r\n\tvar theJoin\t= document.getElementById(\"join\"+i);\r\n\tif (theDiv.style.display == 'none') {\r\n\t\ttheJoin.src = icons[0].src;\r\n\t\ttheDiv.style.display = '';\r\n\t} else {\r\n\t\ttheJoin.src = icons[1].src;\r\n\t\ttheDiv.style.display = 'none';\r\n\t}\r\n}\r\n\r\nfunction hitOpen(i) {\r\n\tvar theDiv = document.getElementById(\"div\"+i);\r\n\tvar theJoin\t= document.getElementById(\"join\"+i);\r\n\ttheJoin.src = icons[0].src;\r\n\ttheDiv.style.display = '';\r\n}");
        Resources.add("/org/h2/web/res/tree_column.gif", "GIF89a\u0012\u0000\u0012\u0000\u00a59\u0000\u0081\u008d\u00a4\u00a8\u00b0\u00c0br\u008f`p\u008chx\u0094\u008a\u0096\u00ab\u00bc\u00c4\u00d3\u00c6\u00cd\u00da[l\u0089^o\u008bk{\u0096l|\u0096w\u0087\u00a0\u0086\u0094\u00aa\u0082\u008f\u00a5\u0084\u0091\u00a6\u0098\u00a4\u00b7\u00aa\u00b4\u00c4\u00bb\u00c4\u00d3\u00c1\u00c9\u00d6ev\u0090o\u0080\u0099s\u0084\u009d\u007f\u008f\u00a6\u0083\u0092\u00a8\u008c\u0099\u00ad\u0092\u009f\u00b2\u008f\u009c\u00af\u0095\u00a2\u00b5\u009c\u00a8\u00b9\u00ad\u00b7\u00c6\u00b6\u00c0\u00cf\u00b9\u00c2\u00d0\u00c0\u00c9\u00d6\u00c4\u00cd\u00da\u00c3\u00cc\u00d9x\u0089\u00a0{\u008c\u00a3\u0080\u0090\u00a6\u0083\u0093\u00a9\u0083\u0093\u00a8\u0087\u0096\u00ab\u008b\u009a\u00ae\u00a4\u00b0\u00c0\u00a6\u00b2\u00c2\u00b4\u00be\u00cc\u00c8\u00d1\u00ddq\u0083\u009a\u0087\u0096\u00a9\u00b0\u00bb\u00c8\u00c4\u00cf\u00dc\u00c6\u00d0\u00dc\u00c6\u00cf\u00da\u00b0\u00bc\u00c9\u00af\u00bb\u00c8\u0090\u00a0\u00b0\u00c4\u00cf\u00da\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00fe\u0015Created with The GIMP\u0000!\u00f9\u0004\u0001\u0000\u0000?\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u0006A\u00c0\u009fpH,\u001a\u008f\u00c8\u001f\"1\u00a8`\u0092\u00c2\u00dbl\u0014BA\u0095\u0000\u00c7\u00e3tU\u00e5\u00be\u00aa\u00ae\u00e8\u0080\u000bCS\u00df\u001c\u00ecj2H\f\u00a6+)M\u00ba\u00beb\u00b5\u00d8\u00eb\u00aaH+\u00ae\b\u0081\u0081W\u0084\u0085\u0086DA\u0000;");
        Resources.add("/org/h2/web/res/tree_database.gif", "GIF89a\u0012\u0000\u0012\u0000\u00c6G\u0000\u00f9\u00f0a\u00f9\u00f0e\u00fc\u00f8\u009c\u00fc\u00f8\u009e\u00fc\u00f8\u00a1\u00fc\u00f8\u00a2\u00fb\u00f0\u0088\u00fb\u00f0\u008a\u00fb\u00ef\u008b\u00fb\u00ef\u008c\u00fb\u00f0\u008c\u00fb\u00f0\u008f\u00f6\u00e0O\u00f9\u00e8o\u00f9\u00e8p\u00f9\u00e9p\u00aa\u00982\u00f6\u00dfM\u00f6\u00e0W\u00f6\u00e0X\u00f6\u00e0Y\u00f6\u00e0Z\u00f6\u00e0^\u00f6\u00e0a\u00f3\u00d34\u00f3\u00d55\u00bf\u00aa=\u00ed\u00c5%\u00ed\u00c5(\u00f0\u00cf<\u00f9\u00d5D\u00f9\u00d8M\u00c7\u00b1O\u00f0\u00c8;\u00f0\u00c8=\u00fb\u00c9,\u00fb\u00cb-\u00f0\u00c8A\u00ef\u00c6B\u00c0\u00a1?\u00cc\u00b0T\u00c6\u00a1=\u00c7\u00a2?\u00e2\u00a6\u0014\u00c2\u00995\u00c5\u009e;\u00c6\u00a1?\u00f2\u00b1\u001f\u00c2\u00952\u00c0\u00954\u00c4\u009b:\u00e2\u009c\u0013\u00bd\u008d/\u00c2\u00957\u00df\u0099\u0015\u00b8\u0081+\u00ba\u0086<\u00b8\u0085<\u00b6\u0084=\u00ba\u0086=\u00b7\u0084<\u00b6\u0083=\u00b5\u0081=\u00c2\u00801\u00c2\u00811\u00e5y\u0006\u00bf}2\u00be|3\u00e5y\u0007\u00b0m&\u00b3f'\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u007f\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u0007~\u0080\u007f\u0082\u0083\u0084\u0085\u0086 0,147 \u0086\u0082\u001a#\u001f\u0004\t\u0015\u001d/\u001a\u008f-$\u001e\u0094\u0096/E\u008f:3\u0019\u0001\u0011\u001b+AC\u008f>!\u000f\u009e\u0097\u00ab\u0086=\u00ae\u0004\b\u0014\u0097B\u008f<!\u000e\u0005\u0007\u0013\u00b9\u008f9\u00bd\u0005\u0006\u0012\u00c2\u00868\"\u000e\u0004\u0007\u009f?\u008f;%\u000e\u0003\n\u0016\u0097@\u00d2&\r\u0002\u000b\u0017\u00d9\u00d26\u0018\u0000\f\u001c+DF\u008f(\u00e3\u00e5\u00e7D\u0010\u008f\u007f .*)25'\u00f2\u00fb\u0083\u0081\u0000;");
        Resources.add("/org/h2/web/res/tree_empty.gif", "GIF89a\u0012\u0000\u0012\u0000\u0091\u0000\u0000\u0000\u0000\u0000\u00ff\u00ff\u00ff\u0080\u0080\u0080\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u0003\u0000,\u0000\u0000\u0000\u0000\u0012\u0000\u0012\u0000\u0000\u0002\u000f\u009c\u008f\u00a9\u00cb\u00ed\u000f\u00a3\u009c\u00b4\u00da\u008b\u00b3\u00de\u009c\u0017\u0000;");
        Resources.add("/org/h2/web/res/tree_folder.gif", "GIF89a\u0012\u0000\u0012\u0000\u00d5\u0000\u0000\u00fb\u00fb\u00fb\u00ef\u00ef\u00ef\u00db\u00b7R\u00cc\u00994\u00e4\u00e4\u00e4\u00c1\u00c1\u00c1\u00a3q\u000b\u00c2\u008f*\u00b7\u00b7\u00b7\u009el\u0006\u00ba\u0087\"\u009cj\u0004\u00c9\u00961\u00bd\u008a%\u00b3\u0081\u001b\u0099g\u0001\u00db\u00b7q\u00b5\u0082\u001d\u00a0n\b\u00cb\u00983\u00ff\u00ff\u00ba\u00b0~\u0018\u00c5\u0092-\u00a7u\u000f\u00c7\u0094/\u00a6\u00a6\u00a6\u00a5s\r\u00b7\u0084\u001f\u00aby\u0013\u00c8\u00950\u00c0\u008d(\u00c6\u00c6\u00c6\u00ae|\u0016\u009ah\u0002\u00a8v\u0010\u00acz\u0014\u00ff\u00d4o\u00ff\u00f8\u0093\u00eb\u00eb\u00eb\u00ff\u00ff\u009c\u00ff\u00dbu\u00ff\u00e4\u007f\u00ff\u00ef\u0089\u00b6\u00b6\u00b6\u00ff\u00ff\u00ff\u00ff\u00ff\u0099\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000!\u00f9\u0004\u0001\u0000\u0000.\u0000,\u0000\u0000\u0000\u0000\u0012\u0000\u0012\u0000\u0000\u0006\u0091@\u0097pH,\u001a\u008f\u00c8\u00a4\u00d25\u0018L\u0018\u009d\u0000@9`Y)\u0094\u0003az\u001c@\u0004`0\u00a4\u00a1\u00d8D\u001c\u0095\u00c0pbm\u00bb\u00db\u00a3\u00cf\u0090\u00d1:\u00d9\u00ef\u00f8\u00d6\u00051\u00c4\u00b4\u00fe\u0080\u0081\u007f\u0006+C\u0016-%\u0089\u008a\u008b-\u0012\u0085B\u0007-*\u0093\u0094\u0095-\t\u008f.\u001e-)\u009d\u009e\u009f-\u000b\u0099\r-(\u00a6\u00a7\u00a8-!\u0099\n-$\u00af\u00b0\u00b1-\u000f|B\u0001g\u0015 \u001c\"\u001a\u0006\u0012\t\u000b\u000f\u0019\u0005C\u0000\u0004\u0005+\u00c9\u00ca\u00cb\u0005\u0004D\u0000\u0001&\u00d2\u00d3\u00d4RKJA\u0000;");
        Resources.add("/org/h2/web/res/tree_index.gif", "GIF89a\u0012\u0000\u0012\u0000\u00e3\f\u0000\u00a4\u007f\u00acov\u0084\u00d1\u00d8\u00e0\u00d8\u00da\u00d7\u00d8\u00d9\u00d7\u00e1\u00dc\u00cb\u00e2\u00dc\u00cb\u00e2\u00db\u00cbsbFcU=zmX\u00cc\u00bf\u00a9\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u000f\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u0004E\u00f0\u00c9\u00f9\u0014R4O%:\u00d6\u00142\u0010\u0004\u0002R\u008aQ\u001c\u00df)Y\u00ad+\u00052E\u00d3\u00f2\u0092,\u008f\u00ce\u009f\tB\u00e2\u0011\u001c\u009e\u0000\t@/y\u00c2=\u009c\u00ceI\u00f4)\u00a5\u00f8&\u00d7\u00ab\u00a48\u00e1r%\u00da%/\\\u009bD\u0000\u0000;");
        Resources.add("/org/h2/web/res/tree_index_az.gif", "GIF89a\u0012\u0000\u0012\u0000\u00e3\u000b\u0000\u008eF\u0094\u00a6y\u00aaov\u0084e}\u0094\\\u0085\u00a5N\u008f\u00bdT\u008b\u00b3MZ]\u001b\u0086{E\u0093\u0088x\u00a9\u00a2\u00ff\u00ff\u00ff\u0083\u001d\u0087\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u000f\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u0004J\u00f0\u00c9I\u00ab}\n\u00a1\u00a4n\u0099H\u00b7]\u00865Z%\u0096lg\u0095\u00aeRK\u00bd\b&O\u00a9\u00b2\u00b2\tz\u00fd\u0084\u000bcH\u0094\f.\u0080\u00c0#\u00c0\u0000H\u0004\u0017%\u00d3)\u00a8V-\u00d3\u00c9Ap\u00c06%\u00caG\u00d7\u0002`\u0080\u009d\u00bf\u0007\u0091\u0018\u0001\u0000;");
        Resources.add("/org/h2/web/res/tree_info.gif", "GIF89a\u0012\u0000\u0012\u0000\u0084\u001a\u0000\u00fe\u00fe\u00ff\u00f1\u00f2\u00f5\u00f2\u00f3\u00f5\u0002F\u008c\u00fd\u00fe\u00ff\bT\u0098\u000b]\u009f\f\\\u009f\u000eb\u00a4U\u0090\u00bf\u00b6\u00d0\u00e4\u00fa\u00fd\u00ff\u00f4\u00fb\u00ff\u00f7\u00fc\u00ff\u00ed\u00f2\u00f5\u00f6\u00fc\u00ff\u00ec\u00f2\u00f5\u00f9\u00fd\u00ff\u00fc\u00fe\u00ff\u0096\u00b6\u00c5\u00f5\u00fc\u00ff\u00f8\u00fd\u00ff\u00f7\u00fd\u00ff\u00fb\u00fe\u00ff\u00f6\u00fd\u00ff\u00c7\u00d4\u00d0\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u001f\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u0005\u0088\u00e0'\u008edYf\t2\fH\u0092\u0099\u00df4$\u008a\u0010(\u00c90\u0095\u0013\u00a2\u0010\u0018\u0004\u0002\u0003P v\u00a2\u00cc\u00e0\u0087\t\u000e1\u0004\u00c5\u00e0\u00f5I$$M\f\u00b6)\u0091XE\u00beES\u00f8\u00bc\\\u008c\u00a2\u0001$\u0012\u0011\u000b\u009b\u008b\u0085c\u0090\u0086T\u00ee\u0098\u0083\u0001\u0013\u00b9C\u00e8\u001f>\r\r\u0016\u0018\u0005\u0005\u0016\u0016\u0084hU\t\u0083\r\u0018+\u0014\u0018\u000f\r_\u001fJ\n\u0014\u0014++\u000f\u0014RT1>\f\u00a5\u00a6FH#24\u00a58:0(*,.0\u00b5%!\u0000;");
        Resources.add("/org/h2/web/res/tree_line.gif", "GIF89a\u0012\u0000\u0012\u0000\u0080\u0001\u0000\u0080\u0080\u0080\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u0001\u0000,\u0000\u0000\u0000\u0000\u0012\u0000\u0012\u0000\u0000\u0002\u0019\u008c\u001f\u0080\u00cb\u00ed\u00ab\u009e\u009c(\u00d2\u00eb,\u00deG\u00f3\u00ed}W(Nd\u00f9\u009ch\u0001\u0000;");
        Resources.add("/org/h2/web/res/tree_minus.gif", "GIF89a\u0012\u0000\u0012\u0000\u00f7\u0003\u0000\u0082\u0082\u0082\u0080\u0080\u0080\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000!\u00f9\u0004\u0001\u0000\u0000\u0003\u0000,\u0000\u0000\u0000\u0000\u0012\u0000\u0012\u0000\u0000\b:\u0000\u0007\b\u001cH\u00b0\u00a0\u00c1\u0083\b\u0013*\\\u00980\u0080\u00c3\u0087\u000f\u001b\u001e\f \u00d1 E\u0084\u0017\u000bf\u00b48\u00e0\u009fG\u008f\u00036j\u009cXq$F\u0092\u0018!Bd\u00c8\u00b2\u00a5\u00cb\u00970\u0013\u0006\u0004\u0000;");
        Resources.add("/org/h2/web/res/tree_page.gif", "GIF89a\u0012\u0000\u0012\u0000\u00e6\u0000\u0000\u00fb\u00fb\u00fb\u00ef\u00ef\u00ef\u00f8\u00fb\u00ff\u00ed\u00f6\u00ff\u00c1\u00c1\u00c1\u00e4\u00e4\u00e4\u00fd\u00fd\u00fd\u00d8\u00eb\u00ff\u00c0\u00df\u00ff\u00fe\u00ff\u00ff\u00f3\u00f9\u00ff\u00c3\u00e1\u00ff\u00f4\u00f4\u00f5\u00f9\u00f9\u00f9\u0081\u0095\u00c3kt\u00a5\u00ce\u00e7\u00ff^a\u0090U\u00a7\u00ed\u0093\u00aa\u00d2z\u0083\u00b0\u00c0\u00c0\u00ff\u00d9\u00e1\u00ed\u0084\u009b\u00ca\u008a\u00a8\u00d9\u00e4\u00f1\u00ff\u0091\u00b8\u00ea\u0092\u00bc\u00efs~\u00b0\u00f5\u00fa\u00ff\u00f7\u00f7\u00f7\u0090\u00a3\u00cb\u00cd\u00e6\u00ff\u00ba\u00dd\u00ff\u00d8\u00e5\u00f6mw\u00a8ej\u009a\u0087\u00a1\u00d2\u007f\u008e\u00bc\u008f\u00b3\u00e5\u008c\u00ae\u00df\u00ce\u00d3\u00ff\u00f6\u00fa\u00ffgm\u009e\u00fc\u00fd\u00ff}\u0089\u00b6\u0094\u00bf\u00f2\u00c6\u00c6\u00c6\u00fe\u00fe\u00fe\u00db\u00e7\u00f7ip\u00a2oz\u00acr|\u00aet\u0080\u00b2\u0087\u00a9\u00dc\u00d1\u00e9\u00ff\u00c9\u00e4\u00ff\u00b7\u00b7\u00b7\u00eb\u00eb\u00eb\u00b6\u00b6\u00b6\u00e9\u00f5\u00ffux\u00a3\u00e1\u00f0\u00ff\u00db\u00ed\u00ff\u00ff\u00ff\u00ff\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000!\u00f9\u0004\u0001\u0000\u0000A\u0000,\u0000\u0000\u0000\u0000\u0012\u0000\u0012\u0000\u0000\u0007\u00a3\u0080A\u0082\u0083\u0084\u0085\u0086\u0087\u0088.6\u008b\u008c65\u0001\u0000\u0087\u001b@\u0006\u0000\r\u001e\f\u00165\u0013\u0090\u0086\u001a0@\u00a1\t\u000215\u0012\u001f\u0001\u0086'\u0006\u00a2\u0002\u001d\"5\u00b1/\u0086(\u00a1\u0002\u0002\u0003<<)\u0015\u001c9\u0086\u0018,\u00b8\u00b9<??\u00074\u00bf\u0085%*\n\u00b9>>\u00c773\u00ca\u0084\u0017\u00ce<\u00d0\u00c67 #\u00d5\u0083\u000e\u00ba\u00da?788\u000f\u00df\u0082&\u00d9\u00d1\u00e4\u00e6\u000b2\u00e9A-\u0019\u00ed7\u00e5\u000b\b+\u00f2\u0014\u00f6\u0010\u00e6\bB\u0090\u0090\u00d7\u00a3\u00a0\u00c1\u0083\u0011\b\u0018*@`\u0087\u00c3\u0087\u000e\t\u00140\u0004 \u0080\u008e\u008b\u0018/vB\u00c4\u00d1P \u0000;");
        Resources.add("/org/h2/web/res/tree_plus.gif", "GIF89a\u0012\u0000\u0012\u0000\u00f7\u0003\u0000\u0082\u0082\u0082\u0080\u0080\u0080\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000!\u00f9\u0004\u0001\u0000\u0000\u0003\u0000,\u0000\u0000\u0000\u0000\u0012\u0000\u0012\u0000\u0000\bC\u0000\u0007\b\u001cH\u00b0\u00a0\u00c1\u0083\b\u0013*\\\u00980\u0080\u00c3\u0087\u000f\u001b\u001e\f Q\u00e0\u00bf\u0081\u0014\u0011f\u001cpQ\u00e0F\u0083\u0014\u00ff\u0089\u00149\u00e0c\u00c1\u008d\u001dKV\u00e4\u0088q%A\u0093/!BdH\u00b3\u00a6\u00cd\u009b8\u0013\u0006\u0004\u0000;");
        Resources.add("/org/h2/web/res/tree_sequence.gif", "GIF89a\u0012\u0000\u0012\u0000\u00c2\u0006\u0000\\z\u00aa\u00ac\u00bb\u00d44f\u0092;v\u00a2\u0089\u00be\u00dbC\u0095\u00c1\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u0007\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u0003 x\u00ba\u00dc\u00fe0\u00caI\u00ab\u0085%\u00af\\\u00b6\u001e\u00c4\u0010\u0000\u0001(\u0092\u00e6!\u00ac\u00cb*\u00b4\u00ec%\u00cft-%\u0000;");
        Resources.add("/org/h2/web/res/tree_sequences.gif", "GIF89a\u0012\u0000\u0012\u0000\u00c2\u0006\u0000\\z\u00aa\u00ac\u00bb\u00d44f\u0092;v\u00a2\u0089\u00be\u00dbC\u0095\u00c1\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u0007\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u00037x\u00ba\u00dc\u00fe0\u00b2B\u0017-\u00b6\u000e2\u0002\b[\u00f7\u0085\u0087`.\u00a6\u0080\u009e\u0092se\u0098\u00f2\u0086\u001e\u00c8\u00d5d\u00ba\u00aa\u008a\u00de6/YE\u0088\u00a1\u008dn\u00c7A\u0089\u00b5\u00e45\u007f\u00d0G\u0002\u0000;");
        Resources.add("/org/h2/web/res/tree_table.gif", "GIF89a\u0012\u0000\u0012\u0000\u00a59\u0000\u0081\u008d\u00a4\u00a8\u00b0\u00c0br\u008f`p\u008chx\u0094\u008a\u0096\u00ab\u00bc\u00c4\u00d3\u00c6\u00cd\u00da[l\u0089^o\u008bk{\u0096l|\u0096w\u0087\u00a0\u0086\u0094\u00aa\u0082\u008f\u00a5\u0084\u0091\u00a6\u0098\u00a4\u00b7\u00aa\u00b4\u00c4\u00bb\u00c4\u00d3\u00c1\u00c9\u00d6ev\u0090o\u0080\u0099s\u0084\u009d\u007f\u008f\u00a6\u0083\u0092\u00a8\u008c\u0099\u00ad\u0092\u009f\u00b2\u008f\u009c\u00af\u0095\u00a2\u00b5\u009c\u00a8\u00b9\u00ad\u00b7\u00c6\u00b6\u00c0\u00cf\u00b9\u00c2\u00d0\u00c0\u00c9\u00d6\u00c4\u00cd\u00da\u00c3\u00cc\u00d9x\u0089\u00a0{\u008c\u00a3\u0080\u0090\u00a6\u0083\u0093\u00a9\u0083\u0093\u00a8\u0087\u0096\u00ab\u008b\u009a\u00ae\u00a4\u00b0\u00c0\u00a6\u00b2\u00c2\u00b4\u00be\u00cc\u00c8\u00d1\u00ddq\u0083\u009a\u0087\u0096\u00a9\u00b0\u00bb\u00c8\u00c4\u00cf\u00dc\u00c6\u00d0\u00dc\u00c6\u00cf\u00da\u00b0\u00bc\u00c9\u00af\u00bb\u00c8\u0090\u00a0\u00b0\u00c4\u00cf\u00da\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000?\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u0006t\u00c0\u009fpH,\u001a\u008fFDb \u00a0\u0010\u0016\u0015\u000b\u00a3t\u00c1\fo\u00b3Q(\u0000j\u00d9<\u0011\u00d6\n5D\u0000\u001c\u008fF!\u00b3\u00d1p \u009d\u00d3P\u0095\u00ab\u00bb\u00ea\u00f8\u00baj.:\u00e0p\"\u007f2\u007f4{B)x\u0013yx0C&\u0006\u0012\u0090\u0006\u0093\u0094\u0006&C$x\u0012\u008bu$C/151\u00121\u00a5\u00a61/C\nx\u001f\u009c9\ne\b\u00b2\u00b3\u00b4\u00b2H\u00b7\u00b8\u00b9\u00b9A\u0000;");
        Resources.add("/org/h2/web/res/tree_type.gif", "GIF89a\u0012\u0000\u0012\u0000\u0084\u0013\u0000\u00ff\u00fc\u00ff.U\u007f&Nr6b\u008bl\u00a5\u00cbk\u009f\u00c3\u0083\u00af\u00cd\u0082\u00ae\u00cc\u0082\u00ac\u00c8\u0098\u00b9\u00d0\u00a9\u00ca\u00e1\u00b4\u00d1\u00e5S\u0095\u00beZ\u009a\u00c2s\u00a9\u00cc\u0090\u00bc\u00d8\u0091\u00bc\u00d7\u0098\u00c1\u00dbY\u009a\u00c0\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u001f\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u0005B\u00e0'\u008edi\u009eh\u009a\u0002,\u00ab\u0002\u00ca \f\n\u0080\u0002O\u0090,I\u00f0\u00d8&\u00c0\u0000\u0011)\"\u0006\u00c0\u0012@@h0$\u0004A\u0092$,8\u00ae\u0005\u00e4\t\u00170@\u000e\u00be)56\u00ab\u00bdZb\u0095z\u00cdn\u0093B\u0000;");
        Resources.add("/org/h2/web/res/tree_types.gif", "GIF89a\u0012\u0000\u0012\u0000\u00a5&\u0000\u00be\u00b7\u00be\u0086y\u00absd\u00a4xk\u00a6\u008c\u0082\u00adVH\u0095i\\\u00a1{p\u00b0e[\u009f~v\u00ac\u00a4\u009e\u00cc@t\u00a8E|\u00b2_\u0093\u00bfC\u009e\u00d8e\u00ae\u00de\u0001~\u00c8\u001e\u008e\u00d0-\u0096\u00d2\u00a7\u00c5\u00c8\u0003g4\u001cwD-\u0087E\u00ac\u00d2\u00b5C\u0095UO\u009c_\u0090\u00c3\u009bA\u0089MG\u0097PG\u0097QH\u0097QH\u0096QO\u009fUO\u009eUz\u00adpz\u00acpz\u00acq\u00a9\u00c8\u008c\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000?\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u0006\u0089\u00c0\u009fpH,\u000e/\u0019K\u00e62\u0004\u0010\u0006\u0004\u0080\u00f0b)Y-L\u00c0@\u00c1\u001dH1#\u0092\u00884\u00c2\u00fc\b\u0087t:\u00f0\u00b3l\u00deo\u00cboP\u00a8\u00d7\u0007\u00bfJ\u0087\u00e3\u00e1|*?\u0002\b\u0083\u0083\u0002?\u001a\u0016!! \u0016\u001a?\u0000\u0005\t\u0092\u0005R\u0087\u0015\u0014\u0015\u008eB\u0000\u0006\u0005\u0006\u0095E\u0013\r\f\r\u0013FD\u0013\f\u000f\u00ab\f\u00a6\u00a7?\r\u0012\u00b2\u00b2\r\u00af?\f\u0010\u00b9\u00b9\f\u00b6\f\u0011\u00bf\u00bf\u00bc\u00af\u0013\u000b\u000e\u00c6\u000b\u00ae\u00c3\f\u000b\u00ad\u00b6\u00ceBA\u0000;");
        Resources.add("/org/h2/web/res/tree_user.gif", "GIF89a\u0012\u0000\u0012\u0000\u00c6g\u0000*A\u007f#6j 1a-D\u0084)?x0I\u0089;X\u009eSg\u0098N_\u008aXh\u0090\u00d6\u00db\u00e7]p\u009c\u001f:r\u001e8o(G\u00861O\u00891M\u00839V\u0091Me\u0096EY\u0083J_\u0088Wn\u009a[r\u009fPc\u0089dy\u00a3ar\u0093\u008b\u009e\u00c4\u009b\u00ad\u00d0\u0091\u00a1\u00c0\u00a3\u00b0\u00c9$@u.K\u00827W\u008f9X\u0090Bb\u009bCc\u009bFf\u009eLl\u00a6Lk\u00a5Xw\u00aed\u0082\u00b6Um\u0098Tj\u0093Th\u008d_u\u009dj\u0083\u00af^s\u0098t\u008c\u00b6s\u008a\u00b2gz\u009c~\u0095\u00bdn\u0082\u00a5iz\u0098w\u0089\u00a9\u008f\u00a3\u00c7\u009a\u00ad\u00d0\u009a\u00ad\u00cf\u009b\u00ad\u00cf\u0099\u00ab\u00cb\u009d\u00ac\u00c8\u00a9\u00b8\u00d2\u00aa\u00b8\u00d2j\u0084\u00b0f\u007f\u00a8g\u007f\u00a8n\u0085\u00abo\u0086\u00ab|\u0093\u00b8o\u0083\u00a5|\u0091\u00b5y\u008e\u00b0o\u0081\u00a0\u0085\u009b\u00bfv\u0089\u00a8\u009d\u00b2\u00d6\u00b1\u00c4\u00e3\u00b2\u00c5\u00e3\u0097\u00a6\u00be\u00ae\u00be\u00d7\u00ab\u00ba\u00d2\u00ac\u00ba\u00d1\u00a9\u00b7\u00ce\u00b2\u00c0\u00d7\u00ae\u00bc\u00d2\u00b0\u00bd\u00d3\u00af\u00bc\u00d2\u00ad\u00ba\u00cf\u00b0\u00bd\u00d2\u0080\u0094\u00b3\u0091\u00a2\u00bc\u00ab\u00ba\u00d1\u00c1\u00ce\u00e1\u00c8\u00d5\u00e8\u00e7\u00eb\u00f1\u00ab\u00b9\u00cc\u00bd\u00cc\u00e1\u00af\u00bc\u00cd\u00c4\u00d0\u00e0\u00c7\u00d2\u00e0\u00cf\u00d9\u00e5\u00d1\u00da\u00e5\u00fd\u00fc\u00fa\u00fd\u00fc\u00fb\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u007f\u0000,\u0000\u0000\u0000\u0000\u0012\u0000\u0012\u0000\u0000\u0007Q\u0080\u007f\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u0087:\u000eE\u008b\u0084%\\\r\u0090\u0083E\r\u008f\u00956 \u0010\u00006\u0095#J\u001b\u001a\u0003\u0095\"K7(\u0006\u0095$L7E\u00ab\u0090\f'\u001a&\u0002\u0095\u007f\u001e9\u0001\u00b8\u007f\u001f8\u0004\u00bd\u000f\u001a\u00c1\u00b8!\\\u0005\u00bd(\u0011&\u00bd\u00ce\u0090\u0081\u0000;");
        Resources.add("/org/h2/web/res/tree_users.gif", "GIF89a\u0012\u0000\u0012\u0000\u00c6g\u0000*A\u007f#6j 1a-D\u0084)?x0I\u0089;X\u009eSg\u0098N_\u008aXh\u0090\u00d6\u00db\u00e7]p\u009c\u001f:r\u001e8o(G\u00861O\u00891M\u00839V\u0091Me\u0096EY\u0083J_\u0088Wn\u009a[r\u009fPc\u0089dy\u00a3ar\u0093\u008b\u009e\u00c4\u009b\u00ad\u00d0\u0091\u00a1\u00c0\u00a3\u00b0\u00c9$@u.K\u00827W\u008f9X\u0090Bb\u009bCc\u009bFf\u009eLl\u00a6Lk\u00a5Xw\u00aed\u0082\u00b6Um\u0098Tj\u0093Th\u008d_u\u009dj\u0083\u00af^s\u0098t\u008c\u00b6s\u008a\u00b2gz\u009c~\u0095\u00bdn\u0082\u00a5iz\u0098w\u0089\u00a9\u008f\u00a3\u00c7\u009a\u00ad\u00d0\u009a\u00ad\u00cf\u009b\u00ad\u00cf\u0099\u00ab\u00cb\u009d\u00ac\u00c8\u00a9\u00b8\u00d2\u00aa\u00b8\u00d2j\u0084\u00b0f\u007f\u00a8g\u007f\u00a8n\u0085\u00abo\u0086\u00ab|\u0093\u00b8o\u0083\u00a5|\u0091\u00b5y\u008e\u00b0o\u0081\u00a0\u0085\u009b\u00bfv\u0089\u00a8\u009d\u00b2\u00d6\u00b1\u00c4\u00e3\u00b2\u00c5\u00e3\u0097\u00a6\u00be\u00ae\u00be\u00d7\u00ab\u00ba\u00d2\u00ac\u00ba\u00d1\u00a9\u00b7\u00ce\u00b2\u00c0\u00d7\u00ae\u00bc\u00d2\u00b0\u00bd\u00d3\u00af\u00bc\u00d2\u00ad\u00ba\u00cf\u00b0\u00bd\u00d2\u0080\u0094\u00b3\u0091\u00a2\u00bc\u00ab\u00ba\u00d1\u00c1\u00ce\u00e1\u00c8\u00d5\u00e8\u00e7\u00eb\u00f1\u00ab\u00b9\u00cc\u00bd\u00cc\u00e1\u00af\u00bc\u00cd\u00c4\u00d0\u00e0\u00c7\u00d2\u00e0\u00cf\u00d9\u00e5\u00d1\u00da\u00e5\u00fd\u00fc\u00fa\u00fd\u00fc\u00fb\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u007f\u0000,\u0000\u0000\u0000\u0000\u0012\u0000\u0012\u0000\u0000\u0007\u00b6\u0080\u007f\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0084Q\u0012Y\u0085M\u0015V\u0087>c\u0013\u007f:\u000eE\u007f\u0017d0\u0087Y\u0013\u008d%\\\r\u007fM\u0017M\u0086^3*\n\u007fE\r\u0099\u001c.I`\u0085@N=]6 \u0010\u00006]URB\u0085?_<]#J\u001b\u001a\u0003]S[A\u0085FaO]\"K7(\u0006]TbX\u0085\u0014/;]$L7E\u00db\u001dC+\u0086\u0019P]\f'\u001a&\u0002]W4\u00871Z]f\u001e9\u0001e\u00ec\u001d9\u0094b\u0007\u00023\u001fp\u0010(\u0093\u00a0\u0003\u008bCD\u00c6\u001c0\u00f3@\u00c3\u00c2\u0005dj\u001c\u0092a\u00a1\u0085\u0099\u0010\\\n\u0094\u0081\u0081\u0001I\"A(\"\u00988\u00c9\u00b2\u00e5\u00c9@\u0000;");
        Resources.add("/org/h2/web/res/tree_view.gif", "GIF89a\u0012\u0000\u0012\u0000\u00e3\b\u0000\u00a9\u00b2\u00c6\u008b\u0096\u00abUl\u00872Nn\u00e4\u00e8\u00ec\u00d5\u00f3\u00ff\u00eb\u00fa\u00ff\u00fc\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff!\u00f9\u0004\u0001\u0000\u0000\u000f\u0000,\u0001\u0000\u0001\u0000\u0010\u0000\u0010\u0000\u0000\u0004J\u00f0\u00c9I\u00ab\u00bd8[$\u0004@\u0014\"\u0082\u000f2|\u0002Y\u0002\u0083\u0010\u0094\u00a78\u0090\b+\u00a6\u00de\u00a8\u00db0;\u009c?\u00df @\u001b\u0014\f\u0086\u0013\u00eb\u0098T\r\f\u0087\u00c3\u00cc\u0004\u0095:\t\u0007\u009b\t\u00cb\u0093\b\u0089\u00b5_l\u00a2\u00a3\u00e94\u00e8\u00b4\u00da\u0012\u0001\u0000;");
        Resources.add("/org/h2/web/res/_text_de.properties", "\r\n\r\n\r\n\r\na.help=Hilfe\r\na.language=Deutsch\r\na.lynxNotSupported=Sorry, this browser does not support frames. Frames (and Javascript) are required.\r\na.password=Passwort\r\na.remoteConnectionsDisabled=Verbindungen von anderen Rechnern sind nicht freigegeben ('webAllowOthers').\r\na.title=H2 Console\r\na.user=Benutzername\r\nadmin.executing=Aktiv\r\nadmin.ip=IP\r\nadmin.lastAccess=Letzter Zugriff\r\nadmin.lastQuery=Letzter Befehl\r\nadmin.url=URL\r\nadminAllow=Zugelassene Verbindungen\r\nadminConnection=Verbindungs-Sicherheit\r\nadminHttp=Unverschl&uuml;sselte HTTP Verbindungen\r\nadminHttps=Verschl&uuml;sselte HTTPS Verbindungen\r\nadminLocal=Nur lokale Verbindungen erlauben\r\nadminLogin=Administration Login\r\nadminLoginCancel=Abbrechen\r\nadminLoginOk=OK\r\nadminLogout=Beenden\r\nadminOthers=Verbindungen von anderen Computern erlauben\r\nadminPort=Web-Server Port\r\nadminRestart=&Auml;nderungen werden nach einem Neustart des Servers aktiv.\r\nadminSave=Speichern\r\nadminSessions=Aktive Verbindungen\r\nadminShutdown=Shutdown\r\nadminTitle=H2 Console Optionen\r\nhelpAction=Aktion\r\nhelpAddAnotherRow=F&uuml;gt einen weiteren Datensatz hinzu\r\nhelpAddDrivers=Datenbank Treiber hinzuf&uuml;gen\r\nhelpAddDriversOnlyJava=Zus&auml;liche Treiber werden nur von der Java Version unterst&uuml;zt (nicht von der Native Version).\r\nhelpAddDriversText=Es ist m&ouml;glich zus&auml;tzliche Datenbank-Treiber zu laden, indem die Pfade der Treiber-Dateien in den Umgebungsvariablen H2DRIVERS oder CLASSPATH eingetragen werden.  Beispiel (Windows): Um den Datenbank-Treiber mit dem Jar-File C:\\\\Programs\\\\hsqldb\\\\lib\\\\hsqldb.jar hinzuzuf&uuml;gen, setzen Sie den die Umgebungvariable H2DRIVERS auf C:\\\\Programs\\\\hsqldb\\\\lib\\\\hsqldb.jar.\r\nhelpAddRow=F&uuml;gt einen Datensatz hinzu\r\nhelpCommandHistory=Zeigt die Befehls-Chronik\r\nhelpCreateTable=Erzeugt eine neue Tabelle\r\nhelpDeleteRow=Entfernt einen Datensatz\r\nhelpDisconnect=Trennt die Verbindung zur Datenbank\r\nhelpDisplayThis=Zeigt diese Hilfe Seite\r\nhelpDropTable=L&ouml;scht die Tabelle falls es sie gibt\r\nhelpExecuteCurrent=F&uuml;hrt den aktuellen SQL Befehl aus\r\nhelpIcon=Schaltfl&auml;che\r\nhelpImportantCommands=Wichtige Befehle\r\nhelpOperations=Operationen\r\nhelpQuery=Fragt die Tabelle ab\r\nhelpSampleSQL=Beispiel SQL Skript\r\nhelpStatements=SQL Befehle\r\nhelpUpdate=&Auml;ndert Daten in einer Zeile\r\nhelpWithColumnsIdName=mit zwei Spalten\r\nlogin.connect=Verbinden\r\nlogin.driverClass=Datenbank-Treiber Klasse\r\nlogin.driverNotFound=Datenbank-Treiber nicht gefunden<br>F&uuml;r Informationen zum Hinzuf&uuml;gen von Treibern siehe Hilfe\r\nlogin.goAdmin=Optionen\r\nlogin.jdbcUrl=JDBC URL\r\nlogin.language=Sprache\r\nlogin.login=Login\r\nlogin.remove=Entfernen\r\nlogin.save=Speichern\r\nlogin.savedSetting=Gespeicherte Einstellung\r\nlogin.settingName=Einstellungs-Name\r\nlogin.testConnection=Verbindung testen\r\nlogin.testSuccessful=Test erfolgreich\r\nlogin.welcome=H2 Console\r\nresult.1row=1 Datensatz\r\nresult.autocommitOff=Auto-Commit ist jetzt ausgeschaltet\r\nresult.autocommitOn=Auto-Commit ist jetzt eingeschaltet\r\nresult.maxrowsSet=Maximale Anzahl Zeilen ist jetzt gesetzt\r\nresult.noRows=keine Datens&auml;tze\r\nresult.noRunningStatement=Im Moment wird kein Befehl ausgef&uuml;hrt\r\nresult.rows=Datens&auml;tze\r\nresult.statementWasCancelled=Der Befehl wurde abgebrochen\r\nresult.updateCount=&Auml;nderungen\r\nresultEdit.add=Hinzuf&uuml;gen\r\nresultEdit.cancel=Abbrechen\r\nresultEdit.delete=L&ouml;schen\r\nresultEdit.edit=Bearbeiten\r\nresultEdit.editResult=Bearbeiten\r\nresultEdit.save=Speichern\r\ntoolbar.all=Alle\r\ntoolbar.autocommit=Auto-Commit\r\ntoolbar.cancelStatement=Laufenden Befehl abbrechen\r\ntoolbar.clear=Leeren\r\ntoolbar.commit=Commit (Abschliessen/Speichern)\r\ntoolbar.disconnect=Verbindung trennen\r\ntoolbar.history=Befehls-Chronik\r\ntoolbar.maxRows=Maximale Anzahl Zeilen\r\ntoolbar.refresh=Aktualisieren\r\ntoolbar.rollback=Rollback (R&uuml;ckg&auml;ngig)\r\ntoolbar.run=Ausf&uuml;hren (Strg+Enter)\r\ntoolbar.sqlStatement=SQL Befehl\r\ntree.admin=Administrator\r\ntree.current=Aktueller Wert\r\ntree.hashed=Hash-basiert\r\ntree.increment=Inkrement\r\ntree.indexes=Indexe\r\ntree.nonUnique=nicht eindeutig\r\ntree.sequences=Sequenzen\r\ntree.unique=eindeutig\r\ntree.users=Benutzer\r\n");
        Resources.add("/org/h2/web/res/_text_en.properties", "a.help=Help\r\na.language=English\r\na.lynxNotSupported=Sorry, Lynx not supported yet\r\na.password=Password\r\na.remoteConnectionsDisabled=Sorry, remote connections ('webAllowOthers') are disabled on this server.\r\na.title=H2 Console\r\na.user=User Name\r\nadmin.executing=Executing\r\nadmin.ip=IP\r\nadmin.lastAccess=Last Access\r\nadmin.lastQuery=Last Query\r\nadmin.url=URL\r\nadminAllow=Allowed clients\r\nadminConnection=Connection security\r\nadminHttp=Use unencrypted HTTP connections\r\nadminHttps=Use encrypted SSL (HTTPS) connections\r\nadminLocal=Only allow local connections\r\nadminLogin=Administration Login\r\nadminLoginCancel=Cancel\r\nadminLoginOk=OK\r\nadminLogout=Logout\r\nadminOthers=Allow connections from other computers\r\nadminPort=Web server port number\r\nadminRestart=Changes take after re-starting the server.\r\nadminSave=Save\r\nadminSessions=Active Sessions\r\nadminShutdown=Shutdown\r\nadminTitle=H2 Console Preferences\r\nhelpAction=Action\r\nhelpAddAnotherRow=Add another row\r\nhelpAddDrivers=Adding Database Drivers\r\nhelpAddDriversOnlyJava=Only the Java version supports additional drivers (this feature is not supported by the Native version).\r\nhelpAddDriversText=Additional database drivers can be registerd by adding the Jar file location of the driver to the the environment variables H2DRIVERS or CLASSPATH. Example (Windows): To add the database driver library  C:\\\\Programs\\\\hsqldb\\\\lib\\\\hsqldb.jar, set the environment variable H2DRIVERS to  C:\\\\Programs\\\\hsqldb\\\\lib\\\\hsqldb.jar.\r\nhelpAddRow=Add a new row\r\nhelpCommandHistory=Shows the Command History\r\nhelpCreateTable=Create a new table\r\nhelpDeleteRow=Remove a row\r\nhelpDisconnect=Disconnects from the database\r\nhelpDisplayThis=Displays this Help Page\r\nhelpDropTable=Delete the table if it exists\r\nhelpExecuteCurrent=Executes the current SQL statement\r\nhelpIcon=Icon\r\nhelpImportantCommands=Important Commands\r\nhelpOperations=Operations\r\nhelpQuery=Query the table\r\nhelpSampleSQL=Sample SQL Script\r\nhelpStatements=SQL statements\r\nhelpUpdate=Change data in a row\r\nhelpWithColumnsIdName=with ID and NAME columns\r\nlogin.connect=Connect\r\nlogin.driverClass=Driver Class\r\nlogin.driverNotFound=Database driver not found<br>See in the Help for how to add drivers\r\nlogin.goAdmin=Preferences\r\nlogin.jdbcUrl=JDBC URL\r\nlogin.language=Language\r\nlogin.login=Login\r\nlogin.remove=Remove\r\nlogin.save=Save\r\nlogin.savedSetting=Saved Settings\r\nlogin.settingName=Setting Name\r\nlogin.testConnection=Test Connection\r\nlogin.testSuccessful=Test successful\r\nlogin.welcome=H2 Console\r\nresult.1row=1 row\r\nresult.autocommitOff=Autocommit is now OFF\r\nresult.autocommitOn=Autocommit is now ON\r\nresult.maxrowsSet=Max rowcount is set\r\nresult.noRows=no rows\r\nresult.noRunningStatement=There is currently no running statement\r\nresult.rows=rows\r\nresult.statementWasCancelled=The statement was cancelled\r\nresult.updateCount=Update Count\r\nresultEdit.add=Add\r\nresultEdit.cancel=Cancel\r\nresultEdit.delete=Delete\r\nresultEdit.edit=Edit\r\nresultEdit.editResult=Edit\r\nresultEdit.save=Save\r\ntoolbar.all=All\r\ntoolbar.autocommit=Autocommit\r\ntoolbar.cancelStatement=Cancel the current statement\r\ntoolbar.clear=Clear\r\ntoolbar.commit=Commit\r\ntoolbar.disconnect=Disconnect\r\ntoolbar.history=Command History\r\ntoolbar.maxRows=Max Rows\r\ntoolbar.refresh=Refresh\r\ntoolbar.rollback=Rollback\r\ntoolbar.run=Run (Ctrl+Enter)\r\ntoolbar.sqlStatement=SQL statement\r\ntree.admin=Admin\r\ntree.current=Current value\r\ntree.hashed=Hashed\r\ntree.increment=Increment\r\ntree.indexes=Indexes\r\ntree.nonUnique=Non-Unique\r\ntree.sequences=Sequences\r\ntree.unique=Unique\r\ntree.users=Users\r\n");
        Resources.add("/org/h2/web/res/_text_es.properties", "a.help=Ayuda\r\na.language=Espa&ntilde;ol\r\na.lynxNotSupported=Sorry, Lynx not supported yet\r\na.password=Contrase&ntilde;a Palabra clave\r\na.remoteConnectionsDisabled=Conexi&oacute;n alejado desactivado ('webAllowOthers')\r\na.title=H2 Console\r\na.user=Nombre de usuario\r\nadmin.executing=#Executing\r\nadmin.ip=#IP\r\nadmin.lastAccess=#Last Access\r\nadmin.lastQuery=#Last Query\r\nadmin.url=#URL\r\nadminAllow=Allowed clients\r\nadminConnection=Connection security\r\nadminHttp=Use unencrypted HTTP connections\r\nadminHttps=Use encrypted SSL (HTTPS) connections\r\nadminLocal=Only allow local connections\r\nadminLogin=Registrar administraci&oacute;n\r\nadminLoginCancel=Cancelar\r\nadminLoginOk=Aceptar\r\nadminLogout=Logout\r\nadminOthers=Allow connections from other computers\r\nadminPort=Web server port number\r\nadminRestart=Changes take after re-starting the server.\r\nadminSave=Guardar\r\nadminSessions=Active Sessions\r\nadminShutdown=Shutdown\r\nadminTitle=H2 Console Preferencias\r\nhelpAction=Action\r\nhelpAddAnotherRow=Add another row\r\nhelpAddDrivers=Adding Database Drivers\r\nhelpAddDriversOnlyJava=Only the Java version supports additional drivers (this feature is not supported by the Native version).\r\nhelpAddDriversText=Additional database drivers can be registerd by adding the Jar file location of the driver to the the environment variables H2DRIVERS or CLASSPATH. Example (Windows): To add the database driver library  C:\\\\Programs\\\\hsqldb\\\\lib\\\\hsqldb.jar, set the environment variable H2DRIVERS to  C:\\\\Programs\\\\hsqldb\\\\lib\\\\hsqldb.jar.\r\nhelpAddRow=Add a new row\r\nhelpCommandHistory=Shows the Command History\r\nhelpCreateTable=Create a new table\r\nhelpDeleteRow=Remove a row\r\nhelpDisconnect=Disconnects from the database\r\nhelpDisplayThis=Displays this Help Page\r\nhelpDropTable=Delete the table if it exists\r\nhelpExecuteCurrent=Executes the current SQL statement\r\nhelpIcon=Icon\r\nhelpImportantCommands=Important Commands\r\nhelpOperations=Operations\r\nhelpQuery=Query the table\r\nhelpSampleSQL=Sample SQL Script\r\nhelpStatements=SQL statements\r\nhelpUpdate=Change data in a row\r\nhelpWithColumnsIdName=with ID and NAME columns\r\nlogin.connect=Conecter\r\nlogin.driverClass=Controlador\r\nlogin.driverNotFound=Controlador no encontrado\r\nlogin.goAdmin=Preferencias\r\nlogin.jdbcUrl=URL JDBC\r\nlogin.language=Idioma\r\nlogin.login=Registrar\r\nlogin.remove=Eliminar\r\nlogin.save=Guardar\r\nlogin.savedSetting=Configuraci&oacute;nes guardados\r\nlogin.settingName=Nombre de la configuraci&oacute;n\r\nlogin.testConnection=Prueba la conexi&oacute;n\r\nlogin.testSuccessful=Pruebe acertado\r\nlogin.welcome=H2 Console\r\nresult.1row=1 fila\r\nresult.autocommitOff=Autocommit no es es activ\r\nresult.autocommitOn=Autocommit es es activ\r\nresult.maxrowsSet=Cuenta m&aacute;xima de las filas cambi&oacute;\r\nresult.noRows=Ningunas filas\r\nresult.noRunningStatement=No hay una instrucci&oacute;n corriente\r\nresult.rows=filas\r\nresult.statementWasCancelled=La instrucci&oacute;n fue cancelada\r\nresult.updateCount=Actualizaci&oacute;nes\r\nresultEdit.add=A&ntilde;adir\r\nresultEdit.cancel=Cancelar\r\nresultEdit.delete=Eliminar\r\nresultEdit.edit=Editar\r\nresultEdit.editResult=Editar\r\nresultEdit.save=Guardar\r\ntoolbar.all=Todos\r\ntoolbar.autocommit=Autocommit\r\ntoolbar.cancelStatement=Cancelar la instrucci&oacute;n actual\r\ntoolbar.clear=Eliminar\r\ntoolbar.commit=Commit\r\ntoolbar.disconnect=Desconectar\r\ntoolbar.history=Historia de los comando\r\ntoolbar.maxRows=Cuenta m&aacute;xima de las filas\r\ntoolbar.refresh=Actualizar\r\ntoolbar.rollback=Rollback\r\ntoolbar.run=Ejecutar (Ctrl+Enter)\r\ntoolbar.sqlStatement=Instrucci&oacute;n SQL\r\ntree.admin=Administrador\r\ntree.current=Valor actual\r\ntree.hashed=Hash\r\ntree.increment=Incremento\r\ntree.indexes=&Iacute;ndices\r\ntree.nonUnique=No &uacute;nico\r\ntree.sequences=Secuencias\r\ntree.unique=&Uacute;nico\r\ntree.users=Usuarios\r\n");
        Resources.add("/org/h2/web/res/_text_fr.properties", "a.help=Aide\r\na.language=Fran&ccedil;ais\r\na.lynxNotSupported=D&eacute;sol&eacute;, Lynx n'est pas encore support&eacute;\r\na.password=Mot de passe\r\na.remoteConnectionsDisabled=D&eacute;sol&eacute;, la gestion des connexions provenant de machines distantes est d&eacute;sactiv&eacute;e sur ce serveur ('webAllowOthers').\r\na.title=Console H2\r\na.user=Nom d'utilisateur\r\nadmin.executing=#Executing\r\nadmin.ip=#IP\r\nadmin.lastAccess=#Last Access\r\nadmin.lastQuery=#Last Query\r\nadmin.url=#URL\r\nadminAllow=Clients autoris&eacute;s\r\nadminConnection=S&eacute;curit&eacute; des connexions\r\nadminHttp=Utiliser des connexions HTTP non s&eacute;curis&eacute;es\r\nadminHttps=Utiliser des connexions s&eacute;curis&eacute;es\r\nadminLocal=Autoriser uniquement les connexions locales\r\nadminLogin=Login administrateur\r\nadminLoginCancel=Annuler\r\nadminLoginOk=OK\r\nadminLogout=D&eacute;connexion\r\nadminOthers=Autoriser les connexions d'ordinateurs distants\r\nadminPort=Num&eacute;ro de port du serveur Web\r\nadminRestart=Modifications effectu&eacute;es apr&eagrave; red&eacute;marrage du serveur.\r\nadminSave=Enregistrer\r\nadminSessions=Sessions actives\r\nadminShutdown=#Shutdown\r\nadminTitle=Console H2 de param&eacute;trage des options\r\nhelpAction=Action\r\nhelpAddAnotherRow=Ajouter un autre enregistrement\r\nhelpAddDrivers=Ajouter de drivers de base de donn&eacute;es\r\nhelpAddDriversOnlyJava=Seule la version Java permet d'ajouter des drivers suppl&eacute;mentaires. (Cette fonctionnalit&eacute; n'est pas support&eacute;e dans la version Native).\r\nhelpAddDriversText=Des drivers additionels peuvent &ecirc;tre configur&eacute;s en d&eacute;clarant l'emplacement du fichier Jar contenant ces drivers dans les variables d'environnement H2DRIVERS ou CLASSPATH. Exemple (Windows): Pour ajouter la librairie C:\\\\Programs\\\\hsqldb\\\\lib\\\\hsqldb.jar, d&eacute;finir la valeur de la variable d'environnement H2DRIVERS en C:\\\\Programs\\\\hsqldb\\\\lib\\\\hsqldb.jar.\r\nhelpAddRow=Ajouter un nouvel enregistrement\r\nhelpCommandHistory=Affiche l'historique des commandes\r\nhelpCreateTable=Cr&eacute;er une nouvelle table\r\nhelpDeleteRow=Effacer un enregistrement\r\nhelpDisconnect=D&eacute;connexion de la base de donn&eacute;es\r\nhelpDisplayThis=Affiche cette page d'aide\r\nhelpDropTable=Effacer une table si elle existe\r\nhelpExecuteCurrent=Ex&eacute;cute la commande courante\r\nhelpIcon=Icone\r\nhelpImportantCommands=Commandes principales\r\nhelpOperations=Op&eacute;rations\r\nhelpQuery=Requ&ecirc;ter une table\r\nhelpSampleSQL=Exemple de script SQL\r\nhelpStatements=Instructions SQL\r\nhelpUpdate=Modifier un enregistrement\r\nhelpWithColumnsIdName=avec les colonnes ID et NAME\r\nlogin.connect=Connecter\r\nlogin.driverClass=Pilote JDBC\r\nlogin.driverNotFound=Driver non trouv&eacute;.<br>Veuillez consulter dans l'aide la proc&eacute;dure d'ajout de drivers.\r\nlogin.goAdmin=Options\r\nlogin.jdbcUrl=URL JDBC\r\nlogin.language=Langue\r\nlogin.login=Connexion\r\nlogin.remove=Supprimer\r\nlogin.save=Enregistrer\r\nlogin.savedSetting=Configuration enregistr&eacute;e\r\nlogin.settingName=Nom de configuration\r\nlogin.testConnection=Test de connexion\r\nlogin.testSuccessful=Succ&egrave;s\r\nlogin.welcome=Console H2\r\nresult.1row=1 enregistrement\r\nresult.autocommitOff=Validation automatique non activ&eacute;e\r\nresult.autocommitOn=Validation automatique activ&eacute;e\r\nresult.maxrowsSet=Nombre max d'enregistrements d&eacute;fini\r\nresult.noRows=Aucun enregistrement\r\nresult.noRunningStatement=Pas d'instruction en cours\r\nresult.rows=enregistrements\r\nresult.statementWasCancelled=L'instruction a &eacute;t&eacute; annul&eacute;e\r\nresult.updateCount=Nombre de modifications\r\nresultEdit.add=Ajouter\r\nresultEdit.cancel=Annuler\r\nresultEdit.delete=Supprimer\r\nresultEdit.edit=Editer\r\nresultEdit.editResult=Editer\r\nresultEdit.save=Enregistrer\r\ntoolbar.all=Tous\r\ntoolbar.autocommit=Validation automatique (autocommit)\r\ntoolbar.cancelStatement=Annuler l'instruction en cours\r\ntoolbar.clear=Effacer\r\ntoolbar.commit=Valider\r\ntoolbar.disconnect=D&eacute;connecter\r\ntoolbar.history=Historique des instructions\r\ntoolbar.maxRows=Max lignes\r\ntoolbar.refresh=Rafra&icirc;chir\r\ntoolbar.rollback=Revenir en arri&egrave;re\r\ntoolbar.run=Ex&eacute;cuter (Ctrl+Enter)\r\ntoolbar.sqlStatement=Instruction SQL\r\ntree.admin=Administrateur\r\ntree.current=Valeur actuelle\r\ntree.hashed=Hach&eacute; (hashed)\r\ntree.increment=Increment\r\ntree.indexes=Indexes\r\ntree.nonUnique=Non unique\r\ntree.sequences=S&eacute;quences\r\ntree.unique=Unique\r\ntree.users=Utilisateurs\r\n");
        Resources.add("/org/h2/web/res/_text_zh_cn.properties", "#Created by JInto - www.guh-software.de\r\n#Mon Apr 10 14:14:45 CST 2006\r\n#Author: junheng.song\r\n#Email sjh21 (at) hot mail (dot) com\r\na.help=\\u5E2E\\u52A9\r\na.language=\\u4E2D\\u6587\r\na.lynxNotSupported=\\u62B1\\u6B49, \\u76EE\\u524D\\u8FD8\\u4E0D\\u652F\\u6301Lynx\r\na.password=\\u5BC6\\u7801\r\na.remoteConnectionsDisabled=\\u62B1\\u6B49, \\u670D\\u52A1\\u5668\\u4E0A\\u7684\\u8FDC\\u7A0B\\u8BA1\\u7B97\\u673A\\u8FDE\\u63A5\\u88AB\\u7981\\u7528.\r\na.title=H2 \\u63A7\\u5236\\u53F0\r\na.user=\\u7528\\u6237\\u540D\r\nadmin.executing=\\u6267\\u884C\r\nadmin.ip=IP\\u5730\\u5740\r\nadmin.lastAccess=\\u6700\\u540E\\u8BBF\\u95EE\r\nadmin.lastQuery=\\u6700\\u540E\\u67E5\\u8BE2\r\nadmin.url=URL\r\nadminAllow=\\u5141\\u8BB8\\u8FDE\\u63A5\\u7684\\u5BA2\\u6237\\u7AEF\r\nadminConnection=\\u8FDE\\u63A5\\u5B89\\u5168\r\nadminHttp=\\u4F7F\\u7528\\u975E\\u52A0\\u5BC6\\u7684 HTTP \\u8FDE\\u63A5\r\nadminHttps=\\u4F7F\\u7528\\u52A0\\u5BC6\\u7684 SSL (HTTPS) \\u8FDE\\u63A5\r\nadminLocal=\\u53EA\\u5141\\u8BB8\\u672C\\u5730\\u8FDE\\u63A5\r\nadminLogin=\\u7BA1\\u7406\\u5458\\u767B\\u5F55\r\nadminLoginCancel=\\u53D6\\u6D88\r\nadminLoginOk=\\u786E\\u8BA4\r\nadminLogout=\\u6CE8\\u9500\r\nadminOthers=\\u5141\\u8BB8\\u6765\\u81EA\\u5176\\u4ED6\\u8FDC\\u7A0B\\u8BA1\\u7B97\\u673A\\u7684\\u8FDE\\u63A5\r\nadminPort=Web server \\u7AEF\\u53E3\\u53F7\r\nadminRestart=\\u91CD\\u542F\\u670D\\u52A1\\u5668\\u540E\\u4FEE\\u6539\\u914D\\u7F6E\\u5C06\\u751F\\u6548.\r\nadminSave=\\u4FDD\\u5B58\r\nadminSessions=\\u6D3B\\u52A8\\u7684\\u4F1A\\u8BDD\r\nadminShutdown=\\u5173\\u95ED\r\nadminTitle=H2 \\u63A7\\u5236\\u53F0\\u914D\\u7F6E\r\nhelpAction=\\u6D3B\\u52A8\r\nhelpAddAnotherRow=\\u589E\\u52A0\\u53E6\\u4E00\\u884C\r\nhelpAddDrivers=\\u589E\\u52A0\\u6570\\u636E\\u5E93\\u9A71\\u52A8\r\nhelpAddDriversOnlyJava=\\u53EA\\u6709Java\\u7248\\u672C\\u652F\\u6301\\u589E\\u52A0\\u9A71\\u52A8\\uFF08\\u672C\\u5730\\u7248\\u672C\\u4E0D\\u652F\\u6301\\u8FD9\\u4E2A\\u7279\\u6027\\uFF09\\u3002\r\nhelpAddDriversText=\\u53EF\\u4EE5\\u901A\\u8FC7\\u6DFB\\u52A0\\u7CFB\\u7EDF\\u73AF\\u5883\\u53D8\\u91CFH2DRIVERS \\u6216\\u8005 CLASSPATH \\u6765\\u589E\\u52A0\\u6570\\u636E\\u5E93\\u9A71\\u52A8\\u6CE8\\u518C\\u3002\\u4F8B\\u5982\\uFF08Windows\\uFF09\\uFF1A\\u8981\\u589E\\u52A0\\u6570\\u636E\\u5E93\\u9A71\\u52A8C\\:\\\\Programs\\\\hsqldb\\\\lib\\\\hsqldb.jar\\uFF0C\\u53EF\\u4EE5\\u589E\\u52A0\\u7CFB\\u7EDF\\u73AF\\u5883\\u53D8\\u91CFH2DRIVERS\\u5E76\\u8BBE\\u7F6E\\u5230C\\:\\\\Programs\\\\hsqldb\\\\lib\\\\hsqldb.jar\\u3002\r\nhelpAddRow=\\u589E\\u52A0\\u65B0\\u7684\\u4E00\\u884C\r\nhelpCommandHistory=\\u663E\\u793A\\u5386\\u53F2SQL\\u547D\\u4EE4\r\nhelpCreateTable=\\u521B\\u5EFA\\u4E00\\u4E2A\\u65B0\\u8868\r\nhelpDeleteRow=\\u5220\\u9664\\u4E00\\u884C\r\nhelpDisconnect=\\u65AD\\u5F00\\u6570\\u636E\\u5E93\\u8FDE\\u63A5\r\nhelpDisplayThis=\\u663E\\u793A\\u5E2E\\u52A9\\u9875\r\nhelpDropTable=\\u5982\\u679C\\u8868\\u5B58\\u5728\\u5220\\u9664\\u5B83\r\nhelpExecuteCurrent=\\u6267\\u884C\\u5F53\\u524DSQL\\u8BED\\u53E5\r\nhelpIcon=\\u56FE\\u6807\r\nhelpImportantCommands=\\u91CD\\u8981\\u7684\\u547D\\u4EE4\r\nhelpOperations=\\u64CD\\u4F5C\r\nhelpQuery=\\u67E5\\u8BE2\\u8868\r\nhelpSampleSQL=\\u6837\\u4F8BSQL\\u811A\\u672C\r\nhelpStatements=SQL \\u8BED\\u53E5\r\nhelpUpdate=\\u6539\\u53D8\\u4E00\\u884C\\u6570\\u636E\r\nhelpWithColumnsIdName=\\u7528ID\\u548CNAME\\u5217\r\nlogin.connect=\\u8FDE\\u63A5\r\nlogin.driverClass=\\u9A71\\u52A8\\u7C7B\r\nlogin.driverNotFound=\\u6570\\u636E\\u5E93\\u9A71\\u52A8\\u6CA1\\u6709\\u53D1\\u73B0<br>\\u8BF7\\u53C2\\u8003\\u5E2E\\u52A9\\u53BB\\u6DFB\\u52A0\\u6570\\u636E\\u5E93\\u9A71\\u52A8\r\nlogin.goAdmin=\\u914D\\u7F6E\r\nlogin.jdbcUrl=JDBC URL\r\nlogin.language=\\u8BED\\u8A00\r\nlogin.login=\\u767B\\u5F55\r\nlogin.remove=\\u5220\\u9664\r\nlogin.save=\\u4FDD\\u5B58\r\nlogin.savedSetting=\\u4FDD\\u5B58\\u7684\\u8FDE\\u63A5\\u8BBE\\u7F6E\r\nlogin.settingName=\\u8FDE\\u63A5\\u8BBE\\u7F6E\\u540D\\u79F0\r\nlogin.testConnection=\\u6D4B\\u8BD5\\u8FDE\\u63A5\r\nlogin.testSuccessful=\\u6D4B\\u8BD5\\u6210\\u529F\r\nlogin.welcome=H2 \\u63A7\\u5236\\u53F0\r\nresult.1row=1 \\u884C\r\nresult.autocommitOff=\\u81EA\\u52A8\\u63D0\\u4EA4\\u73B0\\u5728\\u4E3A\\u5173\\u95ED\r\nresult.autocommitOn=\\u81EA\\u52A8\\u63D0\\u4EA4\\u73B0\\u5728\\u4E3A\\u6253\\u5F00\r\nresult.maxrowsSet=\\u6700\\u5927\\u8FD4\\u56DE\\u884C\\u6570\\u88AB\\u8BBE\\u7F6E\r\nresult.noRows=\\u65E0\\u8FD4\\u56DE\\u884C\r\nresult.noRunningStatement=\\u5F53\\u524D\\u6CA1\\u6709\\u6B63\\u5728\\u6267\\u884C\\u7684SQL\\u8BED\\u53E5\r\nresult.rows=\\u884C\r\nresult.statementWasCancelled=SQL \\u8BED\\u53E5\\u88AB\\u53D6\\u6D88\r\nresult.updateCount=\\u66F4\\u65B0\\u884C\\u6570\r\nresultEdit.add=\\u589E\\u52A0\r\nresultEdit.cancel=\\u53D6\\u6D88\r\nresultEdit.delete=\\u5220\\u9664\r\nresultEdit.edit=\\u7F16\\u8F91\r\nresultEdit.editResult=\\u7F16\\u8F91\\u7ED3\\u679C\\u96C6\r\nresultEdit.save=\\u4FDD\\u5B58\r\ntoolbar.all=\\u5168\\u90E8\r\ntoolbar.autocommit=\\u81EA\\u52A8\\u63D0\\u4EA4\r\ntoolbar.cancelStatement=\\u53D6\\u6D88\\u5F53\\u524D\\u7684\\u6267\\u884C\\u8BED\\u53E5\r\ntoolbar.clear=\\u6E05\\u9664\r\ntoolbar.commit=\\u63D0\\u4EA4\r\ntoolbar.disconnect=\\u65AD\\u5F00\\u8FDE\\u63A5\r\ntoolbar.history=\\u5386\\u53F2SQL\\u547D\\u4EE4\r\ntoolbar.maxRows=\\u6700\\u5927\\u884C\\u6570\r\ntoolbar.refresh=\\u5237\\u65B0\r\ntoolbar.rollback=\\u56DE\\u6EDA\r\ntoolbar.run=\\u6267\\u884C (Ctrl+Enter)\r\ntoolbar.sqlStatement=SQL \\u8BED\\u53E5\r\ntree.admin=\\u7BA1\\u7406\r\ntree.current=\\u5F53\\u524D\\u503C\r\ntree.hashed=\\u6742\\u4E71\\u7684\r\ntree.increment=\\u589E\\u52A0\r\ntree.indexes=\\u7D22\\u5F15\r\ntree.nonUnique=\\u4E0D\\u552F\\u4E00\r\ntree.sequences=\\u5E8F\\u5217\r\ntree.unique=\\u552F\\u4E00\r\ntree.users=\\u7528\\u6237\r\n");
    }
}

