/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.util.Arrays;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.util.IntArray;

public class TestIntArray
extends TestBase {
    public void test() throws Exception {
        IntArray array = new IntArray();
        int[] test = new int[]{};
        Random random = new Random(1L);
        for (int i = 0; i < 10000; ++i) {
            int idx = test.length == 0 ? 0 : random.nextInt(test.length);
            int v = random.nextInt(100);
            int op = random.nextInt(9);
            switch (op) {
                case 0: {
                    array.add(idx, v);
                    test = this.add(test, idx, v);
                    break;
                }
                case 1: {
                    array.add(v);
                    test = this.add(test, v);
                    break;
                }
                case 2: {
                    array.sort();
                    test = this.sort(test);
                    array.addValueSorted(v);
                    test = this.addValueSorted(test, v);
                    break;
                }
                case 3: {
                    int a = array.findNextValueIndex(v);
                    int b = this.findNextValueIndex(test, v);
                    this.check(a, b);
                    break;
                }
                case 4: {
                    if (test.length <= idx) break;
                    this.check(array.get(idx), this.get(test, idx));
                    break;
                }
                case 5: {
                    array.remove(idx);
                    test = this.remove(test, idx);
                    break;
                }
                case 6: {
                    if (test.length <= idx) break;
                    v = test[idx];
                    array.removeValue(v);
                    test = this.removeValue(test, v);
                    break;
                }
                case 7: {
                    array.set(idx, v);
                    test = this.set(test, idx, v);
                    break;
                }
                case 8: {
                    this.check(array.size(), test.length);
                }
            }
            this.check(array.size(), test.length);
            for (int j = 0; j < test.length; ++j) {
                this.check(test[j], array.get(j));
            }
        }
    }

    int[] add(int[] array, int i, int value) {
        int[] a2 = new int[array.length + 1];
        System.arraycopy(array, 0, a2, 0, array.length);
        if (i < array.length) {
            System.arraycopy(a2, i, a2, i + 1, a2.length - i - 1);
        }
        array = a2;
        array[i] = value;
        return array;
    }

    int[] add(int[] array, int value) {
        return this.add(array, array.length, value);
    }

    int[] addValueSorted(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] < value) continue;
            if (array[i] == value) {
                return array;
            }
            return this.add(array, i, value);
        }
        return this.add(array, value);
    }

    int findNextValueIndex(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] < value) continue;
            return i;
        }
        return array.length;
    }

    int get(int[] array, int i) {
        return array[i];
    }

    int[] remove(int[] array, int i) {
        int[] a2 = new int[array.length - 1];
        System.arraycopy(array, 0, a2, 0, i);
        if (i < a2.length) {
            System.arraycopy(array, i + 1, a2, i, array.length - i - 1);
        }
        return a2;
    }

    int[] removeValue(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return this.remove(array, i);
        }
        return array;
    }

    int[] set(int[] array, int i, int value) {
        array[i] = value;
        return array;
    }

    int size(int[] array) {
        return array.length;
    }

    int[] sort(int[] array) {
        Arrays.sort(array);
        return array;
    }
}

