/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.File;
import org.h2.message.TraceSystem;
import org.h2.store.FileLock;
import org.h2.test.TestBase;
import org.h2.util.FileUtils;

public class TestFileLock
extends TestBase
implements Runnable {
    int wait;
    static final int KILL = 10;
    static final String FILE = BASE_DIR + "/test.lock";
    private boolean allowSockets;
    private static volatile int locks = 0;
    private static volatile boolean stop;
    TestBase base;

    public TestFileLock() {
    }

    public void test() throws Exception {
        int i;
        new File(FILE).delete();
        int threadCount = this.getSize(3, 5);
        this.wait = this.getSize(20, 200);
        Thread[] threads = new Thread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            threads[i] = new Thread(new TestFileLock(this, false));
            threads[i].start();
            Thread.sleep(this.wait + (int)(Math.random() * (double)this.wait));
        }
        this.trace("wait");
        Thread.sleep(100L);
        stop = true;
        this.trace("STOP file");
        for (i = 0; i < threadCount; ++i) {
            threads[i].join();
        }
        this.check(locks, 0L);
        FileUtils.delete(FILE);
        stop = false;
        for (i = 0; i < threadCount; ++i) {
            threads[i] = new Thread(new TestFileLock(this, true));
            threads[i].start();
            Thread.sleep(this.wait + (int)(Math.random() * (double)this.wait));
        }
        this.trace("wait");
        Thread.sleep(100L);
        stop = true;
        this.trace("STOP sockets");
        for (i = 0; i < threadCount; ++i) {
            threads[i].join();
        }
        this.check(locks, 0L);
    }

    TestFileLock(TestBase base, boolean allowSockets) {
        this.base = base;
        this.allowSockets = allowSockets;
    }

    public void run() {
        while (!stop) {
            FileLock lock = new FileLock(new TraceSystem(null), 100);
            try {
                lock.lock(FILE, this.allowSockets);
                this.base.trace(lock + " locked");
                if (++locks > 1) {
                    System.err.println("ERROR! LOCKS=" + locks);
                    stop = true;
                }
                Thread.sleep(this.wait + (int)(Math.random() * (double)this.wait));
                --locks;
                if (Math.random() * 50.0 < 10.0) {
                    this.base.trace(lock + " kill");
                    lock = null;
                    System.gc();
                } else {
                    this.base.trace(lock + " unlock");
                    lock.unlock();
                }
                if (locks < 0) {
                    System.err.println("ERROR! LOCKS=" + locks);
                    stop = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Thread.sleep(this.wait + (int)(Math.random() * (double)this.wait));
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

