/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Trace;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public abstract class DbObject {
    public static final int TABLE_OR_VIEW = 0;
    public static final int INDEX = 1;
    public static final int USER = 2;
    public static final int SEQUENCE = 3;
    public static final int TRIGGER = 4;
    public static final int CONSTRAINT = 5;
    public static final int SETTING = 6;
    public static final int ROLE = 7;
    public static final int RIGHT = 8;
    public static final int FUNCTION_ALIAS = 9;
    public static final int SCHEMA = 10;
    private int id;
    protected Database database;
    protected Trace trace;
    private String objectName;
    private int modificationId;
    private boolean temporary;

    protected DbObject(Database database, int id, String name, String traceModule) {
        this.database = database;
        this.trace = database.getTrace(traceModule);
        this.id = id;
        this.objectName = name;
        this.modificationId = database == null ? -1 : database.getModificationId();
    }

    public void setModified() {
        this.modificationId = this.database == null ? -1 : this.database.getNextModificationId();
    }

    public int getModificationId() {
        return this.modificationId;
    }

    protected void setObjectName(String name) {
        this.objectName = name;
    }

    public String getSQL() {
        return Parser.quoteIdentifier(this.objectName);
    }

    public ObjectArray getChildren() {
        return null;
    }

    public Database getDatabase() {
        return this.database;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.objectName;
    }

    public abstract String getCreateSQLForCopy(Table var1, String var2, String var3);

    public abstract String getCreateSQL();

    public abstract int getType();

    public abstract void removeChildrenAndResources(Session var1) throws SQLException;

    public abstract void checkRename() throws SQLException;

    protected void invalidate() {
        this.setModified();
        this.id = -1;
        this.database = null;
        this.trace = null;
        this.objectName = null;
    }

    protected int getHeadPos() {
        return 0;
    }

    public void rename(String newName) throws SQLException {
        this.checkRename();
        this.objectName = newName;
        this.setModified();
    }

    public boolean getTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }
}

