/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util.concurrent;

import com.ibm.websphere.asynchbeans.Work;
import com.ibm.websphere.asynchbeans.WorkEvent;
import com.ibm.websphere.asynchbeans.WorkException;
import com.ibm.websphere.asynchbeans.WorkListener;
import com.ibm.websphere.asynchbeans.WorkManager;
import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;
import flex.messaging.util.concurrent.Executor;
import flex.messaging.util.concurrent.FailedExecutionHandler;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class AsynchBeansWorkManagerExecutor
implements Executor {
    private final Object lock = new Object();
    private final WorkManager workManager;
    private final WorkListener workListener;
    private FailedExecutionHandler failedExecutionHandler;

    public AsynchBeansWorkManagerExecutor(String workManagerJNDIName) {
        try {
            InitialContext ic = new InitialContext();
            this.workManager = (WorkManager)ic.lookup(workManagerJNDIName);
        }
        catch (NamingException ne) {
            ConfigurationException ce = new ConfigurationException();
            ce.setMessage(13600, new Object[]{workManagerJNDIName});
            ce.setRootCause((Throwable)ne);
            throw ce;
        }
        this.workListener = new WorkListener(){

            public void workAccepted(WorkEvent event) {
            }

            public void workCompleted(WorkEvent event) {
                WorkException e = event.getException();
                if (e != null) {
                    if (Log.isDebug()) {
                        Log.getLogger((String)"Executor").error("AsynchBeansWorkManager's WorkListener.workCompleted() callback invoked for failed execution.", (Throwable)e);
                    }
                    AsynchBeansWorkManagerExecutor.this.handleFailedExecution(((WorkCommandWrapper)event.getWork()).command, (Exception)e);
                }
            }

            public void workRejected(WorkEvent event) {
                WorkException e = event.getException();
                if (Log.isDebug()) {
                    Log.getLogger((String)"Executor").error("AsynchBeansWorkManager's WorkListener.workRejected() callback invoked. WorkException? " + e);
                }
                AsynchBeansWorkManagerExecutor.this.handleFailedExecution(((WorkCommandWrapper)event.getWork()).command, (Exception)e);
            }

            public void workStarted(WorkEvent event) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FailedExecutionHandler getFailedExecutionHandler() {
        Object object = this.lock;
        synchronized (object) {
            return this.failedExecutionHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailedExecutionHandler(FailedExecutionHandler value) {
        Object object = this.lock;
        synchronized (object) {
            this.failedExecutionHandler = value;
        }
    }

    public void execute(Runnable command) {
        try {
            this.workManager.startWork((Work)new WorkCommandWrapper(command), Long.MAX_VALUE, this.workListener);
        }
        catch (WorkException e) {
            this.handleFailedExecution(command, (Exception)((Object)e));
        }
    }

    private void handleFailedExecution(Runnable command, Exception e) {
        FailedExecutionHandler handler = this.getFailedExecutionHandler();
        if (handler != null) {
            handler.failedExecution(command, (Executor)this, e);
        } else if (Log.isError()) {
            Log.getLogger((String)"Executor").error("AsynchBeansWorkManager hit an Exception but no FailedExecutionHandler is registered to handle the error.", (Throwable)e);
        }
    }

    class WorkCommandWrapper
    implements Work {
        private final Runnable command;

        public WorkCommandWrapper(Runnable command) {
            this.command = command;
        }

        public void run() {
            this.command.run();
        }

        public void release() {
        }
    }
}

