/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.tablezoning;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;
import org.jpedal.examples.simpleviewer.gui.swing.SwingButton;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.examples.tablezoning.ExtractTextTableFromZones;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.TimeNow;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_String;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableZoner
extends SimpleViewer {
    private Vector_Int itemSelectedX1 = new Vector_Int(10);
    private Vector_Int itemSelectedY1 = new Vector_Int(10);
    private Vector_Int itemSelectedWidth = new Vector_Int(10);
    private Vector_Int itemSelectedHeight = new Vector_Int(10);
    private Vector_Int pageUsed = new Vector_Int(10);
    private Vector_String imagesStored = new Vector_String(10);
    Vector_Object thumbnailsStored = new Vector_Object(10);
    private Map imagesUsed = new HashMap();
    private Vector_String textStored = new Vector_String(10);
    private Vector_String xmlStored = new Vector_String(10);
    private int itemSelectedCount = 1;
    private boolean showExtractedItems;
    GUIButton showItemsExtracted = new SwingButton();
    GUIButton saveItemsExtracted = new SwingButton();
    private static final String type = "TIFF";
    private final JRadioButton xmlButton = new JRadioButton("Xml");
    private final JRadioButton dataButton = new JRadioButton("Data");
    public boolean showSaveFunction = false;
    private String xml_file = "";
    private String pdf_file = "";
    private boolean xmlSaveRequired = false;
    private boolean xmlFileChanged = false;
    private static String OutputDir = System.getProperty("user.home") + System.getProperty("file.separator") + "tables";
    public int[] values = new int[5];
    public String[] key = new String[]{"page", "x1", "x2", "y1", "y2"};
    public DocumentBuilderFactory dbf;
    public DocumentBuilder db;
    public Document doc;
    public Element root;
    public Element count;
    public int coords = 0;

    public TableZoner() {
        JAIHelper.useJAI(true);
        JAIHelper.confirmJAIOnClasspath();
        this.commonValues.setContentExtractor(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " setting look and feel");
        }
        TableZoner tableZoner = new TableZoner();
        tableZoner.setupViewer();
    }

    public void setupViewer() {
        try {
            this.setupOutput();
            this.init(null);
            this.setupExtractorGUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception on initialisation");
        }
    }

    private void setupExtractorGUI() {
        this.currentGUI.first = new SwingButton();
        this.currentGUI.fback = new SwingButton();
        this.currentGUI.back = new SwingButton();
        this.currentGUI.forward = new SwingButton();
        this.currentGUI.fforward = new SwingButton();
        this.currentGUI.end = new SwingButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.xmlButton);
        buttonGroup.add(this.dataButton);
        this.xmlButton.setEnabled(false);
        this.dataButton.setSelected(true);
        this.currentGUI.getTopButtonBar().add(this.xmlButton);
        this.currentGUI.getTopButtonBar().add(this.dataButton);
        ((AbstractButton)((Object)this.currentGUI.first)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.fback)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.back)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.forward)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.fforward)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        ((AbstractButton)((Object)this.currentGUI.end)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        this.currentGUI.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableZoner.this.createOnscreenOutlines();
            }
        });
        this.currentGUI.init(this.scalingValues, this.currentCommands, this.currentPrinter);
        this.currentGUI.setViewerTitle(null);
        if (!this.thumbnails.isShownOnscreen()) {
            this.currentGUI.setPDFOutlineVisible(false);
        }
        this.mouseHandler.setupExtractor();
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarScaling.text"), Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarRotation.text"), Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.currentGUI.addCombo(Messages.getMessage("PdfViewerToolbarImageOp.text"), " ", 250);
        this.currentGUI.initStatus();
        this.createSwingMenu(false);
        this.createExtractorButtons(this.currentGUI.getTopButtonBar());
        this.currentGUI.addCursor();
    }

    private void createExtractorButtons(JToolBar jToolBar) {
        this.openButton(jToolBar);
        jToolBar.add(Box.createHorizontalGlue());
        SwingButton swingButton = new SwingButton();
        swingButton.init("/org/jpedal/examples/contentextractor/snapgrid.gif", -1, "Click to snap onto outlines");
        jToolBar.add(swingButton);
        ((AbstractButton)swingButton).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableZoner.this.mouseHandler.updateRectangle();
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
        SwingButton swingButton2 = new SwingButton();
        swingButton2.init("/org/jpedal/examples/simpleviewer/res/snapshot.gif", -1, "Click to extract selected rectangle");
        jToolBar.add(swingButton2);
        ((AbstractButton)swingButton2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TableZoner.this.commonValues.getSelectedFile() != null && !TableZoner.this.commonValues.isProcessing() && TableZoner.this.currentGUI.getRectangle() != null) {
                    TableZoner.this.extractContent();
                    if (TableZoner.this.currentGUI.isPDFOutlineVisible()) {
                        TableZoner.this.createThumbnails();
                    }
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(Box.createHorizontalGlue());
        String string = "Show extracted items";
        if (this.showExtractedItems) {
            string = "Hide extracted items";
        }
        this.showItemsExtracted.init("/org/jpedal/examples/contentextractor/list.gif", -1, string);
        this.showItemsExtracted.setVisible(false);
        jToolBar.add((AbstractButton)((Object)this.showItemsExtracted));
        ((AbstractButton)((Object)this.showItemsExtracted)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !TableZoner.this.currentGUI.isPDFOutlineVisible();
                TableZoner.this.currentGUI.setPDFOutlineVisible(bl);
                TableZoner.this.showExtractedItems = !TableZoner.this.showExtractedItems;
                if (bl) {
                    TableZoner.this.createThumbnails();
                } else {
                    TableZoner.this.showExtractedItems = false;
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
        this.saveItemsExtracted.init("/org/jpedal/examples/simpleviewer/res/save.gif", -1, "Save extracted items");
        this.saveItemsExtracted.setVisible(false);
        jToolBar.add((AbstractButton)((Object)this.saveItemsExtracted));
        ((AbstractButton)((Object)this.saveItemsExtracted)).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = TableZoner.this.saveThumbnails();
                TableZoner.this.decode_pdf.setFoundTextAreas(null);
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
    }

    private boolean saveThumbnails() {
        boolean bl = false;
        if (this.xml_file.length() == 0 && this.dataButton.isSelected() || this.xmlFileChanged) {
            this.xmlSaveRequired = true;
        }
        if (!this.dataButton.isSelected() || this.xmlSaveRequired) {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            jFileChooser.setFileSelectionMode(0);
            String[] stringArray = new String[]{"xml"};
            jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Xml (*.xml)"));
            int n = jFileChooser.showSaveDialog(jFileChooser);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                String string = file.getAbsolutePath();
                int n2 = 0;
                if (file.exists()) {
                    n2 = this.currentGUI.showConfirmDialog("Are you sure you wish to replace this file?", "Confirm Overwrite", 1);
                }
                if (n2 == 0) {
                    if (!file.getAbsoluteFile().toString().endsWith(".xml")) {
                        file = new File(file.getAbsoluteFile().toString() + ".xml");
                    }
                    try {
                        file.createNewFile();
                        String string2 = this.commonValues.getTarget();
                        String string3 = this.commonValues.getSeparator();
                        if (string2 != null) {
                            File file2 = new File(string2);
                            String[] stringArray2 = file2.list();
                            if (stringArray2 != null) {
                                for (int i = 0; i < stringArray2.length; ++i) {
                                    File file3 = new File(string2 + string3 + stringArray2[i]);
                                    ObjectStore.copy(string2 + string3 + "TablesExtracted.xml", file.getAbsolutePath());
                                    file3.deleteOnExit();
                                    file3.delete();
                                }
                            }
                            this.xml_file = file.getAbsolutePath();
                            bl = true;
                            this.xmlFileChanged = false;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            if (this.xmlSaveRequired) {
                this.xmlSaveRequired = false;
                this.saveThumbnails();
            }
        } else {
            ExtractTextTableFromZones extractTextTableFromZones = new ExtractTextTableFromZones();
            if (this.xml_file.length() != 0) {
                String[] stringArray;
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                jFileChooser.setFileSelectionMode(1);
                int n = jFileChooser.showSaveDialog(jFileChooser);
                if (n == 0) {
                    stringArray = jFileChooser.getSelectedFile();
                    OutputDir = stringArray.getAbsolutePath();
                }
                stringArray = new String[]{this.pdf_file, this.xml_file, OutputDir};
                ExtractTextTableFromZones.main(stringArray);
                JOptionPane.showMessageDialog(new JFrame(), "All Tables Extracted to :: " + OutputDir);
            } else {
                this.xmlSaveRequired = true;
                this.saveThumbnails();
            }
        }
        return bl;
    }

    private void openButton(JToolBar jToolBar) {
        SwingButton swingButton = new SwingButton();
        swingButton.init("/org/jpedal/examples/simpleviewer/res/open.gif", -1, Messages.getMessage("PdfViewerFileMenuTooltip.open"));
        jToolBar.add(swingButton);
        ((AbstractButton)swingButton).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TableZoner.this.dataButton.isSelected()) {
                    TableZoner.this.xmlButton.enable();
                    TableZoner.this.commonValues.setProcessing(false);
                    boolean bl = true;
                    if (TableZoner.this.itemSelectedCount == 1) {
                        bl = false;
                    } else {
                        int n = TableZoner.this.currentGUI.showConfirmDialog("ARE YOU SURE you wish to lose the currently selected items?", "Extracted Content WILL be overwritten", 0);
                        if (n == 0) {
                            bl = false;
                        }
                    }
                    if (!bl) {
                        TableZoner.this.resetToEmpty(false);
                        TableZoner.this.currentGUI.setPDFOutlineVisible(false);
                        TableZoner.this.currentGUI.zoom(false);
                        TableZoner.this.currentCommands.selectFile();
                        TableZoner.this.xmlButton.setEnabled(true);
                        TableZoner.this.xmlButton.setSelected(true);
                        TableZoner.this.pdf_file = TableZoner.this.commonValues.getSelectedFile();
                    }
                } else {
                    boolean bl = false;
                    int[] nArray = new int[1];
                    JFileChooser jFileChooser = new JFileChooser(TableZoner.this.commonValues.getInputDir());
                    if (TableZoner.this.commonValues.getSelectedFile() != null) {
                        jFileChooser.setSelectedFile(new File(TableZoner.this.commonValues.getSelectedFile()));
                    }
                    jFileChooser.setFileSelectionMode(0);
                    String[] stringArray = new String[]{"xml"};
                    jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Xml (*.xml)"));
                    jFileChooser.showOpenDialog(TableZoner.this.currentGUI.getFrame());
                    File file = jFileChooser.getSelectedFile();
                    if (file != null && file.exists()) {
                        Object object;
                        Object object2;
                        TableZoner.this.setupOutput();
                        String string = TableZoner.this.commonValues.getTarget();
                        if (string == null) {
                            try {
                                object2 = File.createTempFile("jpedal", "ads");
                                object = new File(((File)object2).getAbsolutePath() + "-files");
                                ((File)object).mkdirs();
                                ((File)object).deleteOnExit();
                                string = ((File)object).getAbsolutePath();
                                TableZoner.this.commonValues.setTarget(string);
                                ((File)object2).delete();
                            }
                            catch (Exception exception) {
                                LogWriter.writeLog("[PDF] Error deleting file");
                            }
                        }
                        try {
                            object2 = DocumentBuilderFactory.newInstance();
                            object = ((DocumentBuilderFactory)object2).newDocumentBuilder().parse(file);
                            NodeList nodeList = object.getChildNodes();
                            NodeList nodeList2 = object.getElementsByTagName("TablePositions");
                            Element element = (Element)nodeList2.item(0);
                            if (element != null) {
                                NodeList nodeList3 = element.getChildNodes();
                                List list = TableZoner.this.getChildValues(nodeList3);
                                int n = list.size();
                                TableZoner.this.itemSelectedCount = 0;
                                TableZoner.this.itemSelectedX1.clear();
                                TableZoner.this.itemSelectedY1.clear();
                                TableZoner.this.itemSelectedWidth.clear();
                                TableZoner.this.itemSelectedHeight.clear();
                                int n2 = 0;
                                Element element2 = (Element)list.get(n2);
                                String string2 = element2.getNodeName();
                                String string3 = element2.getAttribute("value");
                                if (string2.endsWith("Count")) {
                                    TableZoner.this.itemSelectedCount = Integer.parseInt(string3);
                                    nArray = new int[TableZoner.this.itemSelectedCount];
                                }
                                int n3 = 0;
                                for (n2 = 0; n2 < n; ++n2) {
                                    element2 = (Element)list.get(n2);
                                    string2 = element2.getNodeName();
                                    string3 = element2.getAttribute("value");
                                    if (string2.endsWith("page")) {
                                        nArray[n3] = Integer.parseInt(string3);
                                        ++n3;
                                    }
                                    if (string2.endsWith("x1")) {
                                        TableZoner.this.itemSelectedX1.addElement(Integer.parseInt(string3));
                                    }
                                    if (string2.endsWith("y1")) {
                                        TableZoner.this.itemSelectedY1.addElement(Integer.parseInt(string3));
                                    }
                                    if (string2.endsWith("x2")) {
                                        TableZoner.this.itemSelectedWidth.addElement(Integer.parseInt(string3));
                                    }
                                    if (!string2.endsWith("y2")) continue;
                                    TableZoner.this.itemSelectedHeight.addElement(Integer.parseInt(string3));
                                }
                                int[][] nArray2 = new int[TableZoner.this.itemSelectedCount][5];
                                boolean bl2 = false;
                                int[] nArray3 = TableZoner.this.itemSelectedX1.get();
                                int[] nArray4 = TableZoner.this.itemSelectedWidth.get();
                                int[] nArray5 = TableZoner.this.itemSelectedY1.get();
                                int[] nArray6 = TableZoner.this.itemSelectedHeight.get();
                                for (n2 = 0; n2 < TableZoner.this.itemSelectedCount; ++n2) {
                                    nArray2[n2][0] = nArray[n2];
                                    nArray2[n2][1] = nArray3[n2];
                                    nArray2[n2][2] = nArray4[n2];
                                    nArray2[n2][3] = nArray5[n2];
                                    nArray2[n2][4] = nArray6[n2];
                                    TableZoner.this.values = nArray2[n2];
                                    BufferedImage bufferedImage = TableZoner.this.extractSelectedScreenAsImage();
                                    if (TableZoner.this.commonValues.getTarget() != null) {
                                        if (bufferedImage != null) {
                                            String string4 = "page_" + TableZoner.this.commonValues.getCurrentPage() + "_id_" + n2 + TableZoner.type;
                                            String string5 = TableZoner.this.commonValues.getTarget() + System.getProperty("separator") + string4;
                                            JAI.create((String)"filestore", (RenderedImage)bufferedImage, (Object)string5, (Object)TableZoner.type);
                                            TableZoner.this.imagesStored.addElement(string5);
                                            TableZoner.this.imagesUsed.put(string4, "x");
                                        } else {
                                            TableZoner.this.imagesStored.addElement(null);
                                            TableZoner.this.thumbnailsStored.addElement(null);
                                        }
                                    } else {
                                        TableZoner.this.currentGUI.showInputDialog("Problem accessing drive - unable to save images");
                                    }
                                    TableZoner.this.writeXML(string);
                                }
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (bl) {
                            int n = 0;
                            n = TableZoner.this.commonValues.getCurrentPage();
                            for (int i = 0; i < TableZoner.this.itemSelectedCount; ++i) {
                                TableZoner.this.commonValues.setCurrentPage(nArray[i]);
                                int n4 = TableZoner.this.commonValues.getCurrentPage();
                                if (n4 == 0) {
                                    n4 = 1;
                                }
                                TableZoner.this.pageUsed.addElement(n4);
                            }
                            TableZoner.this.commonValues.setCurrentPage(n);
                            TableZoner.this.showItemsExtracted.setVisible(true);
                            TableZoner.this.saveItemsExtracted.setVisible(true);
                            TableZoner.this.itemSelectedCount++;
                            TableZoner.this.createOnscreenOutlines();
                        } else {
                            object2 = new JOptionPane();
                            JOptionPane.showMessageDialog(new JFrame(), "This file does not contain Table Position Data.");
                        }
                        TableZoner.this.xml_file = file.getAbsolutePath();
                    } else {
                        TableZoner.this.decode_pdf.repaint();
                        TableZoner.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
                    }
                }
            }
        });
        jToolBar.add(Box.createHorizontalGlue());
    }

    protected List getChildValues(NodeList nodeList) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    private void resetToEmpty(boolean bl) {
        int n;
        if (bl && this.itemSelectedCount > 1 && (n = this.currentGUI.showConfirmDialog("Do you wish to save it first?", "Extracted Content WILL be overwritten", 0)) == 0) {
            while (!this.saveThumbnails()) {
            }
        }
        this.showExtractedItems = false;
        this.showItemsExtracted.setVisible(false);
        this.saveItemsExtracted.setVisible(false);
        this.itemSelectedX1 = new Vector_Int(10);
        this.itemSelectedY1 = new Vector_Int(10);
        this.itemSelectedWidth = new Vector_Int(10);
        this.itemSelectedHeight = new Vector_Int(10);
        this.itemSelectedCount = 1;
        this.pageUsed = new Vector_Int(10);
        this.imagesStored = new Vector_String(10);
        this.imagesUsed = new HashMap();
        this.thumbnailsStored = new Vector_Object(10);
        this.textStored = new Vector_String(10);
        this.xmlStored = new Vector_String(10);
        this.currentCommands.flush();
        this.decode_pdf.removeHiglightedObject();
        this.decode_pdf.setHighlightedZones(0, null, null, null, null, null, null, null, null, null, null, null, null, null);
        this.decode_pdf.updateCursorBoxOnScreen(null, null);
        this.thumbnails.generateOtherThumbnails(this.imagesStored.get(), this.thumbnailsStored);
        this.currentGUI.setSplitDividerLocation(0);
        this.decode_pdf.repaint();
    }

    private void extractContent() {
        BufferedImage bufferedImage = null;
        String string = null;
        try {
            PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decode_pdf.getGroupingObject();
            int n = this.commonValues.m_x1;
            int n2 = this.commonValues.m_x2;
            int n3 = this.commonValues.m_y1;
            int n4 = this.commonValues.m_y2;
            if (n3 < n4) {
                n4 = this.commonValues.m_y1;
                n3 = this.commonValues.m_y2;
            }
            if (n > n2) {
                n2 = this.commonValues.m_x1;
                n = this.commonValues.m_x2;
            }
            string = pdfGroupingAlgorithms.extractTextInRectangle(n - 3, n3 + 3, n2 + 6, n4 - 6, this.commonValues.getCurrentPage(), false, true);
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        bufferedImage = this.extractSelectedScreenAsImage();
        this.popupDisplay(bufferedImage, string, this.itemSelectedCount, true, false);
    }

    private void popupDisplay(final BufferedImage bufferedImage, String string, final int n, final boolean bl, boolean bl2) {
        boolean bl3 = true;
        PdfGroupingAlgorithms pdfGroupingAlgorithms = null;
        try {
            pdfGroupingAlgorithms = this.decode_pdf.getGroupingObject();
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        Map map = null;
        int n2 = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerXHTML.message"), Messages.getMessage("PdfViewerOutputFormat.message"), 0);
        try {
            map = n2 != 0 ? pdfGroupingAlgorithms.extractTextAsTable(this.commonValues.m_x1, this.commonValues.m_y1, this.commonValues.m_x2, this.commonValues.m_y2, this.commonValues.getCurrentPage(), true, false, false, false, 0, false) : pdfGroupingAlgorithms.extractTextAsTable(this.commonValues.m_x1, this.commonValues.m_y1, this.commonValues.m_x2, this.commonValues.m_y2, this.commonValues.getCurrentPage(), false, true, true, false, 1, false);
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        string = (String)map.get("content");
        JTabbedPane jTabbedPane = new JTabbedPane();
        final JTextPane jTextPane = new JTextPane();
        final JTextPane jTextPane2 = new JTextPane();
        if (string != null) {
            Object object;
            JScrollPane jScrollPane = new JScrollPane();
            try {
                object = new JTextPane();
                jScrollPane = this.currentGUI.createPane((JTextPane)object, string, true);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setPreferredSize(new Dimension(400, 400));
            final JDialog jDialog = new JDialog((Frame)this.currentGUI.getFrame(), true);
            if (this.commonValues.getModeOfOperation() != 1) {
                object = this.currentGUI.getFrame();
                jDialog.setLocation(((Component)object).getLocationOnScreen().x + 10, ((Component)object).getLocationOnScreen().y + 10);
            }
            jDialog.setSize(450, 450);
            jDialog.setTitle(Messages.getMessage("PdfViewerExtractedText.menu"));
            jDialog.getContentPane().setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)jScrollPane, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)jPanel, "South");
            object = "Extracted Content - would you like to accept?";
            if (bl2) {
                object = "Would you like to save any changes you have made to the current item?";
            }
            JButton jButton = new JButton(Messages.getMessage("PdfMessage.Yes"));
            jButton.setFont(new Font("SansSerif", 0, 12));
            jPanel.add((Component)jButton, "West");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "";
                    String string2 = "";
                    string = jTextPane.getText();
                    string2 = jTextPane2.getText();
                    TableZoner.this.values[0] = TableZoner.this.commonValues.getCurrentPage();
                    TableZoner.this.values[1] = ((TableZoner)TableZoner.this).commonValues.m_x1;
                    TableZoner.this.values[2] = ((TableZoner)TableZoner.this).commonValues.m_x2;
                    TableZoner.this.values[3] = ((TableZoner)TableZoner.this).commonValues.m_y1;
                    TableZoner.this.values[4] = ((TableZoner)TableZoner.this).commonValues.m_y2;
                    if (bl) {
                        TableZoner.this.textStored.addElement(string);
                        TableZoner.this.xmlStored.addElement(string2);
                    } else {
                        TableZoner.this.textStored.setElementAt(string, n - 1);
                        TableZoner.this.xmlStored.setElementAt(string2, n - 1);
                    }
                    TableZoner.this.saveExtractedContent(bufferedImage, string2, n, bl);
                    if (TableZoner.this.itemSelectedCount == 1) {
                        TableZoner.this.showItemsExtracted.setVisible(true);
                        TableZoner.this.saveItemsExtracted.setVisible(true);
                    }
                    if (bl) {
                        TableZoner.this.itemSelectedCount++;
                        TableZoner.this.itemSelectedX1.addElement(((TableZoner)TableZoner.this).commonValues.m_x1);
                        TableZoner.this.itemSelectedWidth.addElement(((TableZoner)TableZoner.this).commonValues.m_x2);
                        TableZoner.this.itemSelectedY1.addElement(((TableZoner)TableZoner.this).commonValues.m_y1);
                        TableZoner.this.itemSelectedHeight.addElement(((TableZoner)TableZoner.this).commonValues.m_y2);
                    }
                    if (bl) {
                        TableZoner.this.createOnscreenOutlines();
                    }
                    TableZoner.this.xmlFileChanged = true;
                    jDialog.dispose();
                }
            });
            JButton jButton2 = new JButton(Messages.getMessage("PdfMessage.No"));
            jButton2.setFont(new Font("SansSerif", 0, 12));
            jPanel.add((Component)jButton2, "East");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            jDialog.setVisible(true);
        }
    }

    private void createOnscreenOutlines() {
        int[] nArray = this.itemSelectedX1.get();
        int[] nArray2 = this.itemSelectedY1.get();
        int[] nArray3 = this.itemSelectedWidth.get();
        int[] nArray4 = this.itemSelectedHeight.get();
        int[] nArray5 = new int[this.itemSelectedCount];
        boolean[] blArray = new boolean[this.itemSelectedCount];
        int[] nArray6 = new int[this.itemSelectedCount];
        Rectangle2D[] rectangle2DArray = new Rectangle2D[this.itemSelectedCount];
        Shape[] shapeArray = new Shape[this.itemSelectedCount];
        Color[] colorArray = new Color[this.itemSelectedCount];
        int[] nArray7 = new int[this.itemSelectedCount];
        int[] nArray8 = new int[this.itemSelectedCount];
        for (int i = 0; i < this.itemSelectedCount; ++i) {
            nArray5[i] = i;
            blArray[i] = true;
            rectangle2DArray[i] = new Rectangle(nArray[i], nArray4[i], nArray3[i] - nArray[i], nArray2[i] - nArray4[i]);
            nArray7[i] = (int)((rectangle2DArray[i].getBounds().getMinX() + rectangle2DArray[i].getBounds().getMaxX()) / 2.0);
            nArray8[i] = (int)((rectangle2DArray[i].getBounds().getMinY() + rectangle2DArray[i].getBounds().getMaxY()) / 2.0) - 12;
            if (this.pageUsed.elementAt(i) == this.commonValues.getCurrentPage()) {
                shapeArray[i] = rectangle2DArray[i];
            }
            colorArray[i] = Color.BLUE;
        }
        this.currentGUI.setRectangle(null);
        this.decode_pdf.setHighlightedZones(1, nArray7, nArray8, shapeArray, null, null, null, null, rectangle2DArray, blArray, null, colorArray, nArray5, nArray6);
        this.decode_pdf.repaint();
    }

    private void saveExtractedContent(BufferedImage bufferedImage, String string, int n, boolean bl) {
        Object object;
        Object object2;
        String string2 = this.commonValues.getTarget();
        String string3 = this.commonValues.getSeparator();
        if (string2 == null) {
            try {
                object2 = File.createTempFile("jpedal", "ads");
                object = new File(((File)object2).getAbsolutePath() + "-files");
                ((File)object).mkdirs();
                ((File)object).deleteOnExit();
                string2 = ((File)object).getAbsolutePath();
                this.commonValues.setTarget(string2);
                ((File)object2).delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (string2 != null) {
            if (bl) {
                if (bufferedImage != null) {
                    object2 = "page_" + this.commonValues.getCurrentPage() + "_id" + n + '.' + type;
                    object = string2 + string3 + (String)object2;
                    JAI.create((String)"filestore", (RenderedImage)bufferedImage, (Object)object, (Object)type);
                    this.imagesStored.addElement((String)object);
                    this.imagesUsed.put(object2, "x");
                    this.thumbnailsStored.addElement(bufferedImage);
                } else {
                    this.imagesStored.addElement(null);
                    this.thumbnailsStored.addElement(null);
                }
            }
        } else {
            this.currentGUI.showInputDialog("Problem accessing drive - unable to save images");
        }
        int n2 = this.commonValues.getCurrentPage();
        if (!bl) {
            n2 = this.pageUsed.elementAt(n - 1);
        } else {
            this.pageUsed.addElement(n2);
        }
        try {
            this.writeXML(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.currentGUI.showMessageDialog("Problem saving xml");
        }
    }

    public void setupOutput() {
        try {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.db = this.dbf.newDocumentBuilder();
            this.doc = this.db.newDocument();
            Comment comment = this.doc.createComment("Created " + TimeNow.getShortTimeNow());
            Comment comment2 = this.doc.createComment("Extracted via JPedal");
            Comment comment3 = this.doc.createComment("SourceFile " + this.decode_pdf.getObjectStore().getCurrentFilename());
            this.doc.appendChild(comment);
            this.doc.appendChild(comment2);
            this.doc.appendChild(comment3);
            this.root = this.doc.createElement("TablePositions");
            this.doc.appendChild(this.root);
            this.count = this.doc.createElement("Count");
            this.count.setAttribute("value", String.valueOf(this.itemSelectedCount));
            this.root.appendChild(this.count);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public void writeXML(String string) throws Exception {
        try {
            Object object;
            Object object2;
            this.count.setAttribute("value", String.valueOf(this.itemSelectedCount));
            for (int i = 0; i < this.values.length; ++i) {
                object2 = this.doc.createElement("loc_" + this.coords + '_' + this.key[i]);
                object2.setAttribute("value", String.valueOf(this.values[i]));
                object = this.doc.importNode((Node)object2, true);
                this.root.appendChild((Node)object);
            }
            ++this.coords;
            object2 = this.decode_pdf.getClass().getResourceAsStream("/org/jpedal/examples/simpleviewer/res/xmlstyle.xslt");
            object = TransformerFactory.newInstance();
            Transformer transformer = ((TransformerFactory)object).newTransformer(new StreamSource((InputStream)object2));
            transformer.transform(new DOMSource(this.doc), new StreamResult(string + this.commonValues.getSeparator() + "TablesExtracted.xml"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private BufferedImage extractSelectedScreenAsImage() {
        int n = this.commonValues.m_x1;
        int n2 = this.commonValues.m_x2;
        int n3 = this.commonValues.m_y1;
        int n4 = this.commonValues.m_y2;
        if (n3 < n4) {
            n4 = this.commonValues.m_y1;
            n3 = this.commonValues.m_y2;
        }
        if (n > n2) {
            n2 = this.commonValues.m_x1;
            n = this.commonValues.m_x2;
        }
        return this.decode_pdf.getSelectedRectangleOnscreen(n, n3, n2, n4, 100.0f);
    }

    private void createThumbnails() {
        this.currentGUI.initThumbnails(this.itemSelectedCount, this.pageUsed);
        this.thumbnails.generateOtherThumbnails(this.imagesStored.get(), this.thumbnailsStored);
        Object[] objectArray = this.thumbnails.getButtons();
        for (int i = 0; i < this.itemSelectedCount - 1; ++i) {
            JButton jButton = (JButton)objectArray[i];
            jButton.addActionListener(new ButtonPopup(i));
        }
    }

    public class ButtonPopup
    implements ActionListener {
        int id;
        JButton[] buttons;

        public ButtonPopup(int n) {
            this.id = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableZoner.this.thumbnails.resetHighlightedThumbnail(this.id);
            TableZoner.this.thumbnails.refreshDisplay();
            BufferedImage bufferedImage = JAI.create((String)"fileload", (Object)TableZoner.this.imagesStored.elementAt(this.id)).getAsBufferedImage();
            TableZoner.this.popupDisplay(bufferedImage, TableZoner.this.xmlStored.elementAt(this.id), this.id + 1, false, true);
        }
    }
}

