/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import org.h2.api.Trigger;
import org.h2.test.TestBase;

public class TestTrigger
extends TestBase
implements Trigger {
    private static boolean mustNotCallTrigger = false;
    private String triggerName;

    public void test() throws Exception {
        mustNotCallTrigger = false;
        this.deleteDb("trigger");
        Connection conn = this.getConnection("trigger");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("CREATE TRIGGER IF NOT EXISTS INS_BEFORE BEFORE INSERT ON TEST FOR EACH ROW NOWAIT CALL \"org.h2.test.db.TestTrigger\"");
        stat.execute("CREATE TRIGGER IF NOT EXISTS INS_BEFORE BEFORE INSERT ON TEST FOR EACH ROW NOWAIT CALL \"org.h2.test.db.TestTrigger\"");
        stat.execute("CREATE TRIGGER INS_AFTER AFTER INSERT ON TEST FOR EACH ROW NOWAIT CALL \"org.h2.test.db.TestTrigger\"");
        stat.execute("CREATE TRIGGER UPD_BEFORE BEFORE UPDATE ON TEST FOR EACH ROW NOWAIT CALL \"org.h2.test.db.TestTrigger\"");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        ResultSet rs = stat.executeQuery("SCRIPT");
        this.checkRows(rs, new String[]{"CREATE TRIGGER INS_BEFORE BEFORE INSERT ON TEST FOR EACH ROW NOWAIT CALL \"org.h2.test.db.TestTrigger\"", "CREATE TRIGGER INS_AFTER AFTER INSERT ON TEST FOR EACH ROW NOWAIT CALL \"org.h2.test.db.TestTrigger\"", "CREATE TRIGGER UPD_BEFORE BEFORE UPDATE ON TEST FOR EACH ROW NOWAIT CALL \"org.h2.test.db.TestTrigger\""});
        while (rs.next()) {
            String sql = rs.getString(1);
            if (!sql.startsWith("CREATE TRIGGER")) continue;
            System.out.println(sql);
        }
        rs = stat.executeQuery("SELECT * FROM TEST");
        rs.next();
        this.check(rs.getString(2), "Hello-updated");
        this.checkFalse(rs.next());
        stat.execute("UPDATE TEST SET NAME=NAME||'-upd'");
        rs = stat.executeQuery("SELECT * FROM TEST");
        rs.next();
        this.check(rs.getString(2), "Hello-updated-upd-updated2");
        this.checkFalse(rs.next());
        mustNotCallTrigger = true;
        stat.execute("DROP TRIGGER IF EXISTS INS_BEFORE");
        stat.execute("DROP TRIGGER IF EXISTS INS_BEFORE");
        try {
            stat.execute("DROP TRIGGER INS_BEFORE");
            this.error("must not work");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        stat.execute("DROP TRIGGER  INS_AFTER");
        stat.execute("DROP TRIGGER  UPD_BEFORE");
        stat.execute("UPDATE TEST SET NAME=NAME||'-upd-notrigger'");
        stat.execute("INSERT INTO TEST VALUES(100, 'Insert-notrigger')");
        conn.close();
        conn = this.getConnection("trigger");
        mustNotCallTrigger = false;
        conn.close();
    }

    private void checkRows(ResultSet rs, String[] expected) throws Exception {
        HashSet<String> set = new HashSet<String>(Arrays.asList(expected));
        while (rs.next()) {
            set.remove(rs.getString(1));
        }
        if (set.size() > 0) {
            this.error("set should be empty: " + set);
        }
    }

    public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        if (mustNotCallTrigger) {
            throw new Error("must not be called now");
        }
        if (conn == null) {
            throw new Error("connection is null");
        }
        if (this.triggerName.startsWith("INS_BEFORE")) {
            newRow[1] = newRow[1] + "-updated";
        } else if (this.triggerName.startsWith("INS_AFTER")) {
            if (!newRow[1].toString().endsWith("-updated")) {
                throw new Error("supposed to be updated");
            }
        } else if (this.triggerName.startsWith("UPD_BEFORE")) {
            newRow[1] = newRow[1] + "-updated2";
        } else if (this.triggerName.startsWith("UPD_AFTER") && !newRow[1].toString().endsWith("-updated2")) {
            throw new Error("supposed to be updated2");
        }
    }

    public void init(String triggerName, String tableName) {
        this.triggerName = triggerName;
        if (!"TEST".equals(tableName)) {
            throw new Error("supposed to be TEST");
        }
    }
}

