/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;

public class TestSpeed
extends TestBase {
    public void test() throws Exception {
        int i;
        this.deleteDb("speed");
        Connection conn = this.getConnection("speed");
        Statement stat = conn.createStatement();
        long time = System.currentTimeMillis();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE CACHED TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        int max = this.getSize(1, 100000);
        for (i = 0; i < max; ++i) {
            prep.setInt(1, i);
            prep.setString(2, "Helloasdfaldsjflajdflajdslfoajlskdfkjasdfadsfasdfadsfadfsalksdjflasjflajsdlkfjaksdjflkskd" + i);
            prep.execute();
        }
        time = System.currentTimeMillis() - time;
        this.trace(time + " insert");
        time = System.currentTimeMillis();
        prep = conn.prepareStatement("UPDATE TEST SET NAME='Another data row which is long' WHERE ID=?");
        for (i = 0; i < max; ++i) {
            prep.setInt(1, i);
            prep.execute();
        }
        time = System.currentTimeMillis() - time;
        this.trace(time + " update");
        conn.close();
        time = System.currentTimeMillis() - time;
        this.trace(time + " close");
    }

    static void testOuterJoin() throws Exception {
        Class.forName("org.h2.jdbc.jdbcDriver");
        Connection conn = DriverManager.getConnection("jdbc:h2:test");
        Statement stat = conn.createStatement();
        int len = 10000;
        long start = System.currentTimeMillis();
        stat.executeUpdate("DROP TABLE IF EXISTS TEST");
        stat.executeUpdate("CREATE TABLE Test(Id INTEGER PRIMARY KEY, FirstName VARCHAR(20), Name VARCHAR(50), ZIP INTEGER)");
        stat.execute("create table a(a1 varchar(1), a2 int)");
        stat.execute("create table b(b1 varchar(1), b2 int)");
        stat.execute("insert into a values(null, 12)");
        stat.execute("insert into a values('a', 22)");
        stat.execute("insert into a values('b', 32)");
        stat.execute("insert into b values(null, 14)");
        stat.execute("insert into b values('a', 14)");
        stat.execute("insert into b values('c', 15)");
        TestSpeed.query(stat, "select * from a left outer join b on ((a.a1=b.b1) or (a.a1 is null and b.b1 is null))");
        TestSpeed.query(stat, "select * from a left outer join b on ((a.a1=b.b1) or (a.a1 is null and b.b1 is null))");
        TestSpeed.query(stat, "select * from a left outer join b on (1=1) where ((a.a1=b.b1) or (a.a1 is null and b.b1 is null))");
        TestSpeed.query(stat, "select * from a left outer join b on (1=1) where a.a1=b.b1");
        TestSpeed.query(stat, "select * from a left outer join b on a.a1=b.b1 where (1=1)");
    }

    private static void query(Statement stat, String sql) throws SQLException {
        System.out.println("--------- " + sql);
        ResultSet rs = stat.executeQuery(sql);
        ResultSetMetaData meta = rs.getMetaData();
        while (rs.next()) {
            for (int i = 0; i < meta.getColumnCount(); ++i) {
                System.out.print("[" + meta.getColumnLabel(i + 1) + "]=" + rs.getString(i + 1) + " ");
            }
            System.out.println();
        }
    }
}

