// I18N constants

// Please translate the following part for your language
// 1. the left  side of fontname, font size and formatblock
// 2. the right side of tooltips

HTMLArea.I18N = {
	fontname: {
		"Arial":           'arial,helvetica,sans-serif',
		"Courier New":     'courier new,courier,monospace',
		"Georgia":         'georgia,times new roman,times,serif',
		"Tahoma":          'tahoma,arial,helvetica,sans-serif',
		"Times New Roman": 'times new roman,times,serif',
		"Verdana":         'verdana,arial,helvetica,sans-serif',
		"impact":          'impact',
		"WingDings":       'wingdings'
	},

	fontsize: {
		"1 (8 点)":  "1",
		"2 (10 点)": "2",
		"3 (12 点)": "3",
		"4 (14 点)": "4",
		"5 (18 点)": "5",
		"6 (24 点)": "6",
		"7 (36 点)": "7"
	},

	formatblock: {
		"标题 1": "h1",
		"标题 2": "h2",
		"标题 3": "h3",
		"标题 4": "h4",
		"标题 5": "h5",
		"标题 6": "h6",
		"段落": "p",
		"位址": "address",
		"已格式化": "pre"
	},

	tooltips: {
		bold:           "粗体",
		italic:         "斜体",
		underline:      "底线",
		strikethrough:  "删除线",
		subscript:      "下标字",
		superscript:    "上标字",
		justifyleft:    "靠左对齐",
		justifycenter:  "置中",
		justifyright:   "靠右对齐",
		justifyfull:    "左右对齐",
		insertorderedlist:    "编号项目",
		insertunorderedlist:  "无编号项目",
		outdent:        "减少缩排",
		indent:         "增加缩排",
		forecolor:      "字型颜色",
		hilitecolor:    "背景颜色",
		inserthorizontalrule: "水平分隔线",
		createlink:     "插入超连结",
		insertimage:    "插入图片",
		insertsound:    "插入声音",
		inserttable:    "插入表格",
		htmlmode:       "切换 HTML 模式",
		popupeditor:    "放大编辑器",
		about:          "关于",
		showhelp:       "求助",
		textindicator:  "目前字型样式",
		undo:           [GB2312?]"_",
		redo:           [GB2312?]"_",
		cut:            [GB2312?]"ŤU",
		copy:           [GB2312?]"ƻs",
		paste:          [GB2312?]"KW"
	},

	buttons: {
		"ok":           "确定",
		"cancel":       "取消"
	},

	msg: {
		"Path":         "路径",
		"TEXT_MODE":    "您现在正在看的是 HTML 信件的原始码. 请按下 [<>] 按钮回到 HTML 编辑模式."
	}
};
