/*
 * Copyright 2005 - 2012  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons. The use of the logo
 * of Zarafa in Legal Notices is allowed for unmodified and modified
 * versions of the software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

/**
 * todayModule extend from the module.
 */
todaymodule.prototype = new Module;
todaymodule.prototype.constructor = todaymodule;
todaymodule.superclass = Module.prototype;

function todaymodule(id, element, title, data)
{
	if(arguments.length > 0) {
		this.init(id, element, title, data);
	}
}

/**
 * Function which intializes the module.
 * @param integer id id
 * @param object element the element for the module
 * @param string title the title of the module
 * @param object data the data (storeid, entryid, ...)  
 */ 
todaymodule.prototype.init = function(id, element, title, data)
{
	todaymodule.superclass.init.call(this, id, element, title);
	
	// Array that contains list of all modules loaded within Today View.
	this.modules = new Object();
	
	this.viewController = new ViewController();
	
	if (data){
		for(var property in data){
			this[property] = data[property];
		}
	}
	
	//for the topmenu (display new and print button).
	webclient.menu.reset();
	this.menuItems = new Array();
	this.menuItems.push(webclient.menu.createMenuItem("print", false, _("Print"), eventListPrintMessage));
	webclient.menu.buildTopMenu(this.id, "createmail", this.menuItems, eventListNewMessage);
	webclient.menu.showMenu();
	
	this.layout = new Object();
	this.layout["calendar"] = new Object();
	this.layout["tasks"] = new Object();
	this.layout["messages"] = new Object();
	
	//get style value from the customize webaccess today settings dialog box.
	this.style = parseInt(webclient.settings.get("today/style/styletype","1"));
	this.setLayoutAsStyle(this.style);
	
	this.initializeView();
}

/**
 * Function which intializes the view.
 */ 
todaymodule.prototype.initializeView = function()
{
	var date = new Date();
	if (this.title!=false){
		this.setTitle(this.title, date.strftime("%A, %B %d, %Y"), true);
	}
	this.customizeTodayViewButton();	

	this.contentElement = dhtml.addElement(this.element, "div", "todayview", "todayview");
	this.viewController.initView(this.id, "today", this.contentElement, false, false);

	this.modules["todayappointmentlistmodule"] = this.addModule(this.storeid, webclient.hierarchy.defaultstore.defaultfolders.calendar, "todayappointmentlistmodule", _("Calendar"), this.layout["calendar"]["position"], this.layout["calendar"]["insert_element_at"]);
    this.modules["todaytasklistmodule"] = this.addModule(this.storeid, webclient.hierarchy.defaultstore.defaultfolders.task, "todaytasklistmodule", _("Tasks"), this.layout["tasks"]["position"], this.layout["tasks"]["insert_element_at"]);
    this.modules["todayfolderlistmodule"] = this.addModule(this.storeid, webclient.hierarchy.defaultstore.defaultfolders.inbox, "todayfolderlistmodule", _("Messages"), this.layout["messages"]["position"], this.layout["messages"]["insert_element_at"]);
    this.resize();
}

/**
 * Function which add the different modules to the todaymodule.
 * @param string name modulename
 * @param string title title of module 
 * @param string storeid storeid
 * @param string entryid entryid
 * @param string position position of module where it should be loaded
 * @param integer insert_element_at
 * @return object module
 */ 
todaymodule.prototype.addModule = function(storeid, entryid, name, title, position, insert_element_at)
{
	var module = webclient.dispatcher.loadModule(name);
	if (module){
		var moduleID = webclient.addModule(module);
		var data = new Object();
		data["storeid"] = storeid; 
		data["entryid"] = entryid;
		data["has_no_menu"] = true;
		
		var element = this.viewController.viewObject.addModule(moduleID, position, insert_element_at);
	
		module.todaymodule = this;
		module.init(moduleID, element, title, data);
		module.list();
	}
	return module;
}

/**
 * As today module has no any request to send, list() is overwritten.
 */ 
todaymodule.prototype.list = function(useTimeOut)
{
}

/**
 * function will create "customize webaccess today" button.
 */ 
todaymodule.prototype.customizeTodayViewButton = function()
{
	var settingButton = dhtml.addElement(false, "span", "button", "button");
	dhtml.addEvent(this, settingButton, "mousedown", eventCustomizedSettingButtonMouseDown);
	var cutomizebutton = dhtml.addElement(settingButton, "a", "buttonborder", false, _("Customize Webaccess Today..."));
	cutomizebutton.href = "#";
	
	//get the subtitle element and append the "customize today view" button.
	var elements = dhtml.getElementsByClassNameInElement(this.element, "subtitle", "div")[0];
	elements.appendChild(settingButton);
}

/**
 * function gives position and place to the module in today view.
 * @param integer style style of the layout.
 */ 
todaymodule.prototype.setLayoutAsStyle = function(style)
{
	switch(style)
	{
		case 2:
			this.layout["calendar"]["position"] = "first";
			this.layout["calendar"]["insert_element_at"] = ""; 
			this.layout["tasks"]["position"] = "third";
			this.layout["tasks"]["insert_element_at"] = ""; 
			this.layout["messages"]["position"] = "third";
			this.layout["messages"]["insert_element_at"] = INSERT_ELEMENT_AT_TOP; 
			break;
		case 3:
			this.layout["calendar"]["position"] = "third";
			this.layout["calendar"]["insert_element_at"] = ""; 
			this.layout["tasks"]["position"] = "third";
			this.layout["tasks"]["insert_element_at"] = ""; 
			this.layout["messages"]["position"] = "third";
			this.layout["messages"]["insert_element_at"] = ""; 
			break;
		case 1:	
		default:
			this.layout["calendar"]["position"] = "first";
			this.layout["calendar"]["insert_element_at"] = "";
			this.layout["tasks"]["position"] = "second"; 
			this.layout["tasks"]["insert_element_at"] = "";
			this.layout["messages"]["position"] = "third";
			this.layout["messages"]["insert_element_at"] = ""; 
			break;
	}
}

/**
 * function call when todayview is resize.
 */ 
todaymodule.prototype.resize = function()
{
	this.viewController.viewObject.resizeView(this.style);
}

// Fuction will call when mousedown on the customize button.
function eventCustomizedSettingButtonMouseDown(moduleObject, element, event) 
{
	//pass the list of task folder to the dialog box for the task settings combo box.
	var data = new Object();
	data = moduleObject;

	webclient.openModalDialog(this, "customizetoday", DIALOG_URL + "task=customizetoday_modal", 400, 400, false, null, data);
}
