<?php
/*********************************************************************************
 * TimeTrex is a Payroll and Time Management program developed by
 * TimeTrex Payroll Services Copyright (C) 2003 - 2012 TimeTrex Payroll Services.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY TIMETREX, TIMETREX DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact TimeTrex headquarters at Unit 22 - 2475 Dobbin Rd. Suite
 * #292 Westbank, BC V4T 2E9, Canada or at email address info@timetrex.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by TimeTrex" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by TimeTrex".
 ********************************************************************************/
/*
 * $Revision: 2286 $
 * $Id: CA.class.php 2286 2008-12-12 23:12:41Z ipso $
 * $Date: 2008-12-12 15:12:41 -0800 (Fri, 12 Dec 2008) $
 */

/**
 * @package GovernmentForms
 */
include_once( 'US.class.php' );
class GovernmentForms_US_W2 extends GovernmentForms_US {
	public $pdf_template = 'w2.pdf';

	public $template_offsets = array( 0, 0 );

	function getOptions( $name ) {
		$retval = NULL;
		switch( $name ) {
			case 'type':
				$retval = array(
								'government' => TTi18n::gettext('Government (Multiple Employees/Page)'),
								'employee' => TTi18n::gettext('Employee (One Employee/Page)'),
								);
				break;
		}

		return $retval;
	}

	//Set the type of form to display/print. Typically this would be:
	// government or employee.
	function getType() {
		if ( isset($this->type) ) {
			return $this->type;
		}

		return FALSE;
	}
	function setType( $value ) {
		$this->type = trim($value);
		return TRUE;
	}

	function getShowInstructionPage() {
		if ( isset($this->show_instruction_page) ) {
			return $this->show_instruction_page;
		}

		return FALSE;
	}
	function setShowInstructionPage( $value ) {
		$this->show_instruction_page = (bool)trim($value);
		return TRUE;
	}

	public function getFilterFunction( $name ) {
		$variable_function_map = array(
										'year' => 'isNumeric',
										'ein' => array( 'stripNonNumeric', 'isNumeric'),
						  );

		if ( isset($variable_function_map[$name]) ) {
			return $variable_function_map[$name];
		}

		return FALSE;
	}

	public function getTemplateSchema( $name = NULL ) {
		$template_schema = array(
								array(
										//'page' => 1,
										//'template_page' => array(
										//						array( 'template_page' => 2, 'x'=> 0, 'y' => 0),
										//						array( 'template_page' => 2, 'x'=> 0, 'y' => 350), //Place two templates on the same page.
										//						),
										'value' => $this->year,
										'on_background' => TRUE,
										'coordinates' => array(
															'x' => 260,
															'y' => 340,
															'h' => 20,
															'w' => 120,
															'halign' => 'C',
															'fill_color' => array( 255, 255, 255 ),
															),
										'font' => array(
																'size' => 18,
																'type' => 'B' )
								),
								//Finish initializing page 1.
								'ssn' => array(
												'coordinates' => array(
																		'x' => 153,
																		'y' => 47,
																		'h' => 15,
																		'w' => 127,
																		'halign' => 'C',
																		),
											),
								'ein' => array(
												'coordinates' => array(
																		'x' => 38,
																		'y' => 70,
																		'h' => 15,
																		'w' => 280,
																		'halign' => 'L',
																		),
											),
								'trade_name' => array(
												'coordinates' => array(
																		'x' => 38,
																		'y' => 92,
																		'h' => 15,
																		'w' => 280,
																		'halign' => 'L',
																		),
											),
								'company_address' => array(
												'function' => array('filterCompanyAddress', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 38,
																		'y' => 107,
																		'h' => 48,
																		'w' => 280,
																		'halign' => 'L',
																		),
												'font' => array(
																		'size' => 8,
																		'type' => '' ),
												'multicell' => TRUE,
											),
								'control_number' => array(
												'function' => array('filterControlNumber', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 38,
																		'y' => 165,
																		'h' => 15,
																		'w' => 127,
																		'halign' => 'L',
																		),
											),


								'first_name' => array(
												'coordinates' => array(
																		'x' => 38,
																		'y' => 189,
																		'h' => 15,
																		'w' => 122,
																		'halign' => 'L',
																		),
											),
								'middle_name' => array(
												'function' => array('filterMiddleName', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 162,
																		'y' => 189,
																		'h' => 15,
																		'w' => 10,
																		'halign' => 'L',
																		),
											),
								'last_name' => array(
												'coordinates' => array(
																		'x' => 175,
																		'y' => 189,
																		'h' => 15,
																		'w' => 127,
																		'halign' => 'L',
																		),
											),
								'address' => array(
												'function' => array('filterAddress', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 38,
																		'y' => 205,
																		'h' => 68,
																		'w' => 280,
																		'halign' => 'L',
																		),
												'font' => array(
																		'size' => 8,
																		'type' => '' ),
												'multicell' => TRUE,
											),
								'l1' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 335,
																		'y' => 70,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),
								'l2' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 459,
																		'y' => 70,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),
								'l3' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 335,
																		'y' => 94,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),
								'l4' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 459,
																		'y' => 94,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),
								'l5' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 335,
																		'y' => 118,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),
								'l6' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 459,
																		'y' => 118,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),
								'l7' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 335,
																		'y' => 142,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),
								'l8' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 459,
																		'y' => 142,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),
								'l9' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 335,
																		'y' => 166,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),
								'l10' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 459,
																		'y' => 166,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),
								'l11' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 335,
																		'y' => 189,
																		'h' => 15,
																		'w' => 115,
																		'halign' => 'R',
																		),
											),


								'l12a_code' => array(
												'coordinates' => array(
																		'x' => 460,
																		'y' => 189,
																		'h' => 15,
																		'w' => 30,
																		'halign' => 'C',
																		),
											),
								'l12a' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 491,
																		'y' => 189,
																		'h' => 15,
																		'w' => 83,
																		'halign' => 'R',
																		),
											),


								'l12b_code' => array(
												'coordinates' => array(
																		'x' => 460,
																		'y' => 214,
																		'h' => 15,
																		'w' => 30,
																		'halign' => 'C',
																		),
											),
								'l12b' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 491,
																		'y' => 214,
																		'h' => 15,
																		'w' => 83,
																		'halign' => 'R',
																		),
											),
								'l12c_code' => array(
												'coordinates' => array(
																		'x' => 460,
																		'y' => 238,
																		'h' => 15,
																		'w' => 30,
																		'halign' => 'C',
																		),
											),
								'l12c' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 491,
																		'y' => 238,
																		'h' => 15,
																		'w' => 83,
																		'halign' => 'R',
																		),
											),
								'l12d_code' => array(
												'coordinates' => array(
																		'x' => 460,
																		'y' => 262,
																		'h' => 15,
																		'w' => 30,
																		'halign' => 'C',
																		),
											),
								'l12d' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 491,
																		'y' => 262,
																		'h' => 15,
																		'w' => 83,
																		'halign' => 'R',
																		),
											),

								'l13a' => array(
										'function' => 'drawCheckBox',
										'coordinates' => array(
																array(
																	'x' => 348,
																	'y' => 216,
																	'h' => 11,
																	'w' => 10,
																	'halign' => 'C',
																)
															),
									),
								'l13b' => array(
										'function' => 'drawCheckBox',
										'coordinates' => array(
																array(
																	'x' => 384,
																	'y' => 216,
																	'h' => 11,
																	'w' => 10,
																	'halign' => 'C',
																)
															),
									),
								'l13c' => array(
										'function' => 'drawCheckBox',
										'coordinates' => array(
																array(
																	'x' => 420,
																	'y' => 216,
																	'h' => 11,
																	'w' => 10,
																	'halign' => 'C',
																)
															),
									),

								'l14a_name' => array(
												'coordinates' => array(
																		'x' => 331,
																		'y' => 238,
																		'h' => 12,
																		'w' => 40,
																		'halign' => 'L',
																		),
											),
								'l14a' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 371,
																		'y' => 238,
																		'h' => 12,
																		'w' => 82,
																		'halign' => 'R',
																		),
											),
								'l14b_name' => array(
												'coordinates' => array(
																		'x' => 331,
																		'y' => 250,
																		'h' => 12,
																		'w' => 40,
																		'halign' => 'L',
																		),
											),
								'l14b' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 371,
																		'y' => 250,
																		'h' => 12,
																		'w' => 82,
																		'halign' => 'R',
																		),
											),
								'l14c_name' => array(
												'coordinates' => array(
																		'x' => 331,
																		'y' => 262,
																		'h' => 12,
																		'w' => 40,
																		'halign' => 'L',
																		),
											),
								'l14c' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 371,
																		'y' => 262,
																		'h' => 12,
																		'w' => 82,
																		'halign' => 'R',
																		),
											),
								'l14d_name' => array(
												'coordinates' => array(
																		'x' => 331,
																		'y' => 274,
																		'h' => 12,
																		'w' => 40,
																		'halign' => 'L',
																		),
											),
								'l14d' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 371,
																		'y' => 274,
																		'h' => 12,
																		'w' => 82,
																		'halign' => 'R',
																		),
											),


								//State (Line 1)
								'l15a_state' => array(
												'coordinates' => array(
																		'x' => 38,
																		'y' => 300,
																		'h' => 12,
																		'w' => 27,
																		'halign' => 'C',
																		),
											),
								'l15a_state_id' => array(
												'coordinates' => array(
																		'x' => 65,
																		'y' => 300,
																		'h' => 12,
																		'w' => 130,
																		'halign' => 'C',
																		),
											),
								'l16a' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 196,
																		'y' => 300,
																		'h' => 12,
																		'w' => 85,
																		'halign' => 'R',
																		),
											),
								'l17a' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 281,
																		'y' => 300,
																		'h' => 12,
																		'w' => 79,
																		'halign' => 'R',
																		),
											),
								'l18a' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 360,
																		'y' => 300,
																		'h' => 12,
																		'w' => 86,
																		'halign' => 'R',
																		),
											),
								'l19a' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 446,
																		'y' => 300,
																		'h' => 12,
																		'w' => 80,
																		'halign' => 'R',
																		),
											),
								'l20a' => array(
												'coordinates' => array(
																		'x' => 526,
																		'y' => 300,
																		'h' => 12,
																		'w' => 50,
																		'halign' => 'R',
																		),
											),

								//State (Line 2)
								'l15b_state' => array(
												'coordinates' => array(
																		'x' => 38,
																		'y' => 325,
																		'h' => 12,
																		'w' => 27,
																		'halign' => 'C',
																		),
											),
								'l15b_state_id' => array(
												'coordinates' => array(
																		'x' => 65,
																		'y' => 325,
																		'h' => 12,
																		'w' => 130,
																		'halign' => 'C',
																		),
											),
								'l16b' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 196,
																		'y' => 325,
																		'h' => 12,
																		'w' => 85,
																		'halign' => 'R',
																		),
											),
								'l17b' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 281,
																		'y' => 325,
																		'h' => 12,
																		'w' => 79,
																		'halign' => 'R',
																		),
											),
								'l18b' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 360,
																		'y' => 325,
																		'h' => 12,
																		'w' => 86,
																		'halign' => 'R',
																		),
											),
								'l19b' => array(
												'function' => array( 'MoneyFormat', 'drawNormal' ),
												'coordinates' => array(
																		'x' => 446,
																		'y' => 325,
																		'h' => 12,
																		'w' => 80,
																		'halign' => 'R',
																		),
											),
								'l20b' => array(
												'coordinates' => array(
																		'x' => 526,
																		'y' => 325,
																		'h' => 12,
																		'w' => 50,
																		'halign' => 'R',
																		),
											),
							  );

		if ( isset($template_schema[$name]) ) {
			return $name;
		} else {
			return $template_schema;
		}
	}

	function filterMiddleName( $value ) {
		//Return just initial
		$value = substr( $value, 0, 1);
		return $value;
	}
	function filterCompanyAddress( $value ) {
		Debug::Text('Filtering company address: '. $value, __FILE__, __LINE__, __METHOD__,10);

		//Combine company address for multicell display.
		$retarr[] = $this->company_address1;
		if ( $this->company_address2 != '' ) {
			$retarr[] = $this->company_address2;
		}
		$retarr[] = $this->company_city. ', '.$this->company_state . ' ' . $this->company_zip_code;

		return implode("\n", $retarr );
	}
	function filterAddress( $value ) {
		//Combine company address for multicell display.
		$retarr[] = $this->address1;
		if ( $this->address2 != '' ) {
			$retarr[] = $this->address2;
		}
		$retarr[] = $this->city. ', '.$this->state . ' ' . $this->zip_code;

		return implode("\n", $retarr );
	}

	function filterControlNumber( $value ) {
		$value = str_pad( $value, 4, 0, STR_PAD_LEFT );
		return $value;
	}

	function _outputPDF() {
		//Initialize PDF with template.
		$pdf = $this->getPDFObject();

		if ( $this->getShowBackground() == TRUE ) {
			$pdf->setSourceFile( $this->getTemplateDirectory() . DIRECTORY_SEPARATOR . $this->pdf_template );

			for ( $tp=1; $tp <= 11; $tp++ ) {
				$this->template_index[$tp] = $pdf->ImportPage($tp);
			}
		}

		if ( $this->year == ''  ) {
			$this->year = $this->getYear();
		}

		if ( $this->getType() == 'government') {
			$employees_per_page = 2;
			$n=2; //Don't loop the same employee.
			$form_template_pages = array(2,3,10); //Template pages to use.
		} else {
			$employees_per_page = 1;
			$n=1; //Loop the same employee twice.
			$form_template_pages = array(4,6,8); //Template pages to use.
		}

		//Get location map, start looping over each variable and drawing
		$records = $this->getRecords();
		if ( is_array($records) AND count($records) > 0 ) {

			$template_schema = $this->getTemplateSchema();

			foreach( $form_template_pages as $form_template_page ) {
				//Set the template used.
				$template_schema[0]['template_page'] = $form_template_page;

				if ( $this->getShowBackground() == TRUE AND $this->getType() == 'government' AND count($records) > 1 ) {
					$template_schema[0]['combine_templates'] = array(
																	array( 'template_page' => $form_template_page, 'x'=> 0, 'y' => 0),
																	array( 'template_page' => $form_template_page, 'x'=> 0, 'y' => 400) //Place two templates on the same page.
																);
				}

				$e=0;
				foreach( $records as $employee_data ) {
					//Debug::Arr($employee_data, 'Employee Data: ', __FILE__, __LINE__, __METHOD__,10);
					$employee_data['control_number'] = $e+1;
					$this->arrayToObject( $employee_data ); //Convert record array to object

					for( $i=0; $i < $n; $i++ ) {
						$this->page_offsets = array(0,0);

						if ( ( $employees_per_page == 1 AND $i > 0 )
								OR ( $employees_per_page == 2 AND $e % 2 != 0 )
								) {
							$this->page_offsets = array(0,400);
						}

						foreach( $template_schema as $field => $schema ) {
							$this->Draw( $this->$field, $schema );
						}
					}

					if ( $employees_per_page == 1 OR ( $employees_per_page == 2 AND  $e % $employees_per_page != 0 ) ) {
						$this->resetTemplatePage();
						//if ( $this->getShowInstructionPage() == TRUE ) {
						//	$this->addPage( array('template_page' => 2) );
						//}
					}

					$e++;
				}
			}
		}

		$this->clearRecords();

		return TRUE;
	}
}
?>