/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfKeyPairsIterator;

public class PdfObject
implements Cloneable {
    protected int colorspace = -1;
    protected int subtype = -1;
    protected int type = -1;
    private int BitsPerComponent = -1;
    private int Count = 0;
    private int FormType = -1;
    private int Length = -1;
    private int Length1 = -1;
    private int Length2 = -1;
    private int Length3 = -1;
    private int Rotate = -1;
    private float[] ArtBox;
    private float[] BBox;
    private float[] BleedBox;
    private float[] CropBox;
    private float[] Decode;
    private float[] Domain;
    private float[] Matrix;
    private float[] MediaBox;
    private float[] Range;
    private float[] TrimBox;
    protected PdfObject ColorSpace = null;
    protected PdfObject DecodeParms = null;
    protected PdfObject Encoding = null;
    protected PdfObject Function = null;
    protected PdfObject Resources = null;
    protected PdfObject Shading = null;
    protected PdfObject SMask = null;
    private boolean ignoreRecursion = false;
    protected boolean isZapfDingbats = false;
    protected boolean isSymbol = false;
    private boolean isCompressedStream = false;
    protected int generalType = -1;
    private String generalTypeAsString = null;
    private String Parent = null;
    private String Name = null;
    private byte[] rawParent;
    private byte[] rawName = null;
    public static boolean debug = false;
    public static final int NO = 0;
    public static final int PARTIAL = 1;
    public static final int FULL = 2;
    String ref = null;
    int intRef;
    int gen;
    protected boolean hasStream = false;
    public byte[] stream = null;
    public byte[] DecodedStream = null;
    public int startStreamOnDisk = -1;
    public int endStreamOnDisk = -1;
    public String CachedStream = null;
    private byte[][] Filter = null;
    private byte[][] TR = null;
    private byte[][] keys;
    private byte[][] values;
    private PdfObject[] objs;

    private PdfObject() {
    }

    public PdfObject(byte[] byArray) {
    }

    public PdfObject(int n, int n2) {
        this.setRef(n, n2);
    }

    public void setRef(int n, int n2) {
        this.intRef = n;
        this.gen = n2;
        this.ref = null;
    }

    public PdfObject(String string) {
        this.ref = string;
    }

    public PdfObject(int n) {
        this.generalType = n;
    }

    protected boolean[] deepCopy(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        int n = blArray.length;
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, n);
        return blArray2;
    }

    protected float[] deepCopy(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        int n = fArray.length;
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, n);
        return fArray2;
    }

    protected double[] deepCopy(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    protected int[] deepCopy(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    protected byte[][] deepCopy(byte[][] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[][] byArrayArray = new byte[n][];
        System.arraycopy(byArray, 0, byArrayArray, 0, n);
        return byArrayArray;
    }

    public int isImplemented() {
        return 0;
    }

    public PdfObject getDictionary(int n) {
        switch (n) {
            case 2087749783: {
                return this.ColorSpace;
            }
            case 1888135062: {
                return this.DecodeParms;
            }
            case 1518239089: {
                return this.Function;
            }
            case 2004251818: {
                return this.Resources;
            }
            case 878474856: {
                return this.Shading;
            }
            case 489767774: {
                return this.SMask;
            }
        }
        return null;
    }

    public int getGeneralType(int n) {
        if (n == 1232564598 && this.isZapfDingbats) {
            return 5;
        }
        if (n == 1232564598 && this.isSymbol) {
            return 4;
        }
        return this.generalType;
    }

    public String getGeneralStringValue() {
        return this.generalTypeAsString;
    }

    public void setGeneralStringValue(String string) {
        this.generalTypeAsString = string;
    }

    public void setIntNumber(int n, int n2) {
        switch (n) {
            case -1344207655: {
                this.BitsPerComponent = n2;
                break;
            }
            case 1061502551: {
                this.Count = n2;
                break;
            }
            case 982024818: {
                this.FormType = n2;
                break;
            }
            case 1043816557: {
                this.Length = n2;
                break;
            }
            case 929066303: {
                this.Length1 = n2;
                break;
            }
            case 929066304: {
                this.Length2 = n2;
                break;
            }
            case 929066305: {
                this.Length3 = n2;
                break;
            }
            case 1144088180: {
                this.Rotate = n2;
                break;
            }
        }
    }

    public void setFloatNumber(int n, float f) {
        switch (n) {
            default: 
        }
    }

    public int getInt(int n) {
        switch (n) {
            case -1344207655: {
                return this.BitsPerComponent;
            }
            case 1061502551: {
                return this.Count;
            }
            case 982024818: {
                return this.FormType;
            }
            case 1043816557: {
                return this.Length;
            }
            case 929066303: {
                return this.Length1;
            }
            case 929066304: {
                return this.Length2;
            }
            case 929066305: {
                return this.Length3;
            }
            case 1144088180: {
                return this.Rotate;
            }
        }
        return -1;
    }

    public float getFloatNumber(int n) {
        switch (n) {
            default: 
        }
        return -1.0f;
    }

    public boolean getBoolean(int n) {
        switch (n) {
            default: 
        }
        return false;
    }

    public void setBoolean(int n, boolean bl) {
        switch (n) {
            default: 
        }
    }

    public void setDictionary(int n, PdfObject pdfObject) {
        switch (n) {
            case 2087749783: {
                this.ColorSpace = pdfObject;
                break;
            }
            case 1888135062: {
                this.DecodeParms = pdfObject;
                break;
            }
            case 1518239089: {
                this.Function = pdfObject;
                break;
            }
            case 2004251818: {
                this.Resources = pdfObject;
                break;
            }
            case 878474856: {
                this.Shading = pdfObject;
                break;
            }
            case 489767774: {
                this.SMask = pdfObject;
                break;
            }
        }
    }

    public boolean hasStream() {
        return this.hasStream;
    }

    public int setConstant(int n, int n2, int n3, byte[] byArray) {
        return -1;
    }

    public int getParameterConstant(int n) {
        int n2 = -1;
        switch (n) {
            case 2087749783: {
                return this.colorspace;
            }
            case 1147962727: {
                return this.subtype;
            }
            case 608780341: {
                return this.type;
            }
        }
        return n2;
    }

    public int setConstant(int n, int n2) {
        int n3 = n2;
        switch (n2) {
            case -1044665361: {
                n3 = 373243460;
            }
        }
        switch (n) {
            case 2087749783: {
                this.colorspace = n3;
                break;
            }
            case 1147962727: {
                this.subtype = n3;
                break;
            }
            case 608780341: {
                this.type = n3;
            }
        }
        return n3;
    }

    public float[] getFloatArray(int n) {
        float[] fArray = null;
        switch (n) {
            case 1142050954: {
                return this.deepCopy(this.ArtBox);
            }
            case 303185736: {
                return this.deepCopy(this.BBox);
            }
            case 1179546749: {
                return this.deepCopy(this.BleedBox);
            }
            case 1076199815: {
                return this.deepCopy(this.CropBox);
            }
            case 859785322: {
                return this.deepCopy(this.Decode);
            }
            case 1026641277: {
                return this.deepCopy(this.Domain);
            }
            case 1145198201: {
                return this.deepCopy(this.Matrix);
            }
            case 1313305473: {
                return this.deepCopy(this.MediaBox);
            }
            case 826160983: {
                return this.deepCopy(this.Range);
            }
            case 1026982273: {
                return this.deepCopy(this.TrimBox);
            }
        }
        return this.deepCopy(fArray);
    }

    public byte[][] getKeyArray(int n) {
        switch (n) {
            default: 
        }
        return null;
    }

    public double[] getDoubleArray(int n) {
        double[] dArray = null;
        switch (n) {
            default: 
        }
        return this.deepCopy(dArray);
    }

    public boolean[] getBooleanArray(int n) {
        boolean[] blArray = null;
        switch (n) {
            default: 
        }
        return this.deepCopy(blArray);
    }

    public int[] getIntArray(int n) {
        int[] nArray = null;
        switch (n) {
            default: 
        }
        return this.deepCopy(nArray);
    }

    public void setFloatArray(int n, float[] fArray) {
        switch (n) {
            case 1142050954: {
                this.ArtBox = fArray;
                break;
            }
            case 303185736: {
                this.BBox = fArray;
                break;
            }
            case 1179546749: {
                this.BleedBox = fArray;
                break;
            }
            case 1076199815: {
                this.CropBox = fArray;
                break;
            }
            case 859785322: {
                this.Decode = this.ignoreIdentity(fArray);
                break;
            }
            case 1026641277: {
                this.Domain = fArray;
                break;
            }
            case 1145198201: {
                this.Matrix = fArray;
                break;
            }
            case 1313305473: {
                this.MediaBox = fArray;
                break;
            }
            case 826160983: {
                this.Range = fArray;
                break;
            }
            case 1026982273: {
                this.TrimBox = fArray;
                break;
            }
        }
    }

    private float[] ignoreIdentity(float[] fArray) {
        boolean bl = true;
        if (fArray != null) {
            int n = fArray.length;
            for (int i = 0; i < n; i += 2) {
                if (fArray[i] == 0.0f && fArray[i + 1] == 1.0f) continue;
                bl = false;
                i = n;
            }
        }
        if (bl) {
            return null;
        }
        return fArray;
    }

    public void setIntArray(int n, int[] nArray) {
        switch (n) {
            default: 
        }
    }

    public void setBooleanArray(int n, boolean[] blArray) {
        switch (n) {
            default: 
        }
    }

    public void setDoubleArray(int n, double[] dArray) {
        switch (n) {
            default: 
        }
    }

    public void setMixedArray(int n, byte[][] byArray) {
        switch (n) {
            case 1011108731: {
                this.Filter = byArray;
                break;
            }
        }
    }

    public String getStringValue(int n, int n2) {
        byte[] byArray = null;
        switch (n) {
            case 506543413: {
                byArray = this.rawName;
            }
        }
        switch (n2) {
            case 0: {
                if (byArray != null) {
                    return new String(byArray);
                }
                return null;
            }
            case 1: {
                if (byArray != null) {
                    return new String(byArray);
                }
                return null;
            }
            case 2: {
                if (byArray != null) {
                    int n3 = byArray.length;
                    if (n3 > 6 && byArray[6] == 43) {
                        int n4 = n3 - 7;
                        byte[] byArray2 = new byte[n4];
                        System.arraycopy(byArray, 7, byArray2, 0, n4);
                        return new String(byArray2);
                    }
                    return new String(byArray);
                }
                return null;
            }
        }
        throw new RuntimeException("Value not defined in getStringValue(int,mode)");
    }

    public String getStringValue(int n) {
        String string = null;
        switch (n) {
            case 506543413: {
                if (this.Name == null && this.rawName != null) {
                    this.Name = new String(this.rawName);
                }
                return this.Name;
            }
        }
        return string;
    }

    public String getStringKey(int n) {
        String string = null;
        switch (n) {
            case 1110793845: {
                if (this.Filter == null && this.rawParent != null) {
                    this.Parent = new String(this.rawParent);
                }
                return this.Parent;
            }
        }
        return string;
    }

    public String getTextStreamValue(int n) {
        String string = null;
        switch (n) {
            default: 
        }
        return string;
    }

    public void setStringValue(int n, byte[] byArray) {
        switch (n) {
            case 506543413: {
                this.rawName = byArray;
                break;
            }
        }
    }

    public void setStringKey(int n, byte[] byArray) {
        switch (n) {
            case 1110793845: {
                this.rawParent = byArray;
                break;
            }
        }
    }

    public void setTextStreamValue(int n, byte[] byArray) {
        switch (n) {
            default: 
        }
    }

    public byte[] getStream() {
        if (this.DecodedStream == null) {
            return null;
        }
        int n = this.DecodedStream.length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.DecodedStream, 0, byArray, 0, n);
        return byArray;
    }

    public void setStream(byte[] byArray) {
        this.stream = byArray;
    }

    public String getObjectRefAsString() {
        if (this.ref == null) {
            this.ref = this.intRef + " " + this.gen + " R";
        }
        return this.ref;
    }

    public int getObjectRefID() {
        return this.intRef;
    }

    public int getObjectRefGeneration() {
        return this.gen;
    }

    public PdfArrayIterator getArrayIterator(int n) {
        switch (n) {
            case 1011108731: {
                return new PdfArrayIterator(this.Filter);
            }
        }
        return null;
    }

    public void setDictionaryPairs(byte[][] byArray, byte[][] byArray2, PdfObject[] pdfObjectArray) {
        this.keys = byArray;
        this.values = byArray2;
        this.objs = pdfObjectArray;
    }

    public PdfKeyPairsIterator getKeyPairsIterator() {
        return new PdfKeyPairsIterator(this.keys, this.values, this.objs);
    }

    public boolean getDebugMode() {
        debug = false;
        return debug;
    }

    public void setKeyArray(int n, byte[][] byArray) {
        switch (n) {
            default: 
        }
    }

    public void setStringArray(int n, byte[][] byArray) {
        switch (n) {
            case 9250: {
                this.TR = byArray;
                break;
            }
        }
    }

    public byte[][] getStringArray(int n) {
        switch (n) {
            case 9250: {
                return this.deepCopy(this.TR);
            }
        }
        return null;
    }

    public final Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public boolean decompressStreamWhenRead() {
        return false;
    }

    public int getObjectType() {
        return -1;
    }

    public byte[] getStringValueAsByte(int n) {
        return null;
    }

    public boolean isCompressedStream() {
        return this.isCompressedStream;
    }

    public void setCompressedStream(boolean bl) {
        this.isCompressedStream = bl;
    }

    public boolean ignoreRecursion() {
        return this.ignoreRecursion;
    }

    public void ignoreRecursion(boolean bl) {
        this.ignoreRecursion = bl;
    }
}

