/*
 * Decompiled with CFR 0.152.
 */
package org.h2.web;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.h2.message.TraceSystem;
import org.h2.util.StringUtils;
import org.h2.web.PageParser;
import org.h2.web.WebServer;
import org.h2.web.WebServerSession;

abstract class WebServerThread
extends Thread {
    protected WebServer server;
    protected WebServerSession session;
    protected Properties attributes;
    protected Socket socket;
    private InputStream input;
    private String ifModifiedSince;

    WebServerThread(Socket socket, WebServer server) {
        this.server = server;
        this.socket = socket;
    }

    abstract String process(String var1);

    protected String getCombobox(String[] elements, String selected) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            String value = elements[i];
            buff.append("<option value=\"");
            buff.append(PageParser.escapeHtml(value));
            buff.append("\"");
            if (value.equals(selected)) {
                buff.append(" selected");
            }
            buff.append(">");
            buff.append(PageParser.escapeHtml(value));
            buff.append("</option>");
        }
        return buff.toString();
    }

    protected String getCombobox(String[][] elements, String selected) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            String[] n = elements[i];
            buff.append("<option value=\"");
            buff.append(PageParser.escapeHtml(n[0]));
            buff.append("\"");
            if (n[0].equals(selected)) {
                buff.append(" selected");
            }
            buff.append(">");
            buff.append(PageParser.escapeHtml(n[1]));
            buff.append("</option>");
        }
        return buff.toString();
    }

    public void run() {
        try {
            this.input = this.socket.getInputStream();
            String head = this.readHeaderLine();
            if (head.startsWith("GET ") || head.startsWith("POST ")) {
                String message;
                byte[] bytes;
                boolean cache;
                String mimeType;
                int end;
                int begin = head.indexOf(47);
                String file = head.substring(begin + 1, end = head.lastIndexOf(32)).trim();
                if (file.length() == 0) {
                    file = "index.do";
                }
                if (!this.allow()) {
                    file = "notAllowed.jsp";
                }
                this.server.trace(head + " :" + file);
                this.attributes = new Properties();
                int paramIndex = file.indexOf("?");
                this.session = null;
                if (paramIndex >= 0) {
                    String attrib = file.substring(paramIndex + 1);
                    this.parseAttributes(attrib);
                    String sessionId = this.attributes.getProperty("jsessionid");
                    file = file.substring(0, paramIndex);
                    this.session = this.server.getSession(sessionId);
                }
                if (file.endsWith(".ico")) {
                    mimeType = "image/x-icon";
                    cache = true;
                } else if (file.endsWith(".gif")) {
                    mimeType = "image/gif";
                    cache = true;
                } else if (file.endsWith(".css")) {
                    cache = true;
                    mimeType = "text/css";
                } else if (file.endsWith(".html") || file.endsWith(".do") || file.endsWith(".jsp")) {
                    cache = false;
                    mimeType = "text/html";
                    if (this.session == null) {
                        this.session = this.server.createNewSession(this.socket);
                        if (!file.equals("notAllowed.jsp")) {
                            file = "index.do";
                        }
                    }
                } else if (file.endsWith(".js")) {
                    cache = true;
                    mimeType = "text/javascript";
                } else {
                    cache = false;
                    mimeType = "text/html";
                    file = "error.jsp";
                    this.server.trace("unknown mime type, file " + file);
                }
                this.server.trace("mimeType=" + mimeType);
                this.parseHeader();
                this.server.trace(file);
                if (file.endsWith(".do")) {
                    file = this.process(file);
                }
                if (cache && this.ifModifiedSince != null && this.ifModifiedSince.equals(this.server.getStartDateTime())) {
                    bytes = null;
                    message = "HTTP/1.1 304 Not Modified\n";
                } else {
                    bytes = this.server.getFile(file);
                    if (bytes == null) {
                        message = "HTTP/1.0 404 Not Found\n";
                        bytes = StringUtils.utf8Encode("File not found: " + file);
                    } else {
                        if (this.session != null && file.endsWith(".jsp")) {
                            bytes = StringUtils.utf8Encode(this.fill(StringUtils.utf8Decode(bytes)));
                        }
                        message = "HTTP/1.1 200 OK\n";
                        message = message + "Content-Type: " + mimeType + "\n";
                        if (!cache) {
                            message = message + "Cache-Control: no-cache\n";
                        } else {
                            message = message + "Cache-Control: max-age=10\n";
                            message = message + "Last-Modified: " + this.server.getStartDateTime() + "\n";
                        }
                    }
                }
                message = message + "\n";
                this.server.trace(message);
                DataOutputStream output = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                output.write(message.getBytes());
                if (bytes != null) {
                    output.write(bytes);
                }
                output.flush();
                output.close();
                output.close();
                this.socket.close();
                return;
            }
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
        }
    }

    abstract boolean allow();

    private String readHeaderLine() throws IOException {
        StringBuffer buff = new StringBuffer();
        while (true) {
            int i;
            if ((i = this.input.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (i == 13 && this.input.read() == 10) {
                return buff.length() > 0 ? buff.toString() : null;
            }
            buff.append((char)i);
        }
    }

    private void parseAttributes(String s) throws Exception {
        int idx;
        this.server.trace("data=" + s);
        while (s != null && (idx = s.indexOf(61)) >= 0) {
            String value;
            String property = s.substring(0, idx);
            if ((idx = (s = s.substring(idx + 1)).indexOf(38)) >= 0) {
                value = s.substring(0, idx);
                s = s.substring(idx + 1);
            } else {
                value = s;
            }
            String attr = StringUtils.urlDecode(value);
            this.attributes.put(property, attr);
        }
        this.server.trace(this.attributes.toString());
    }

    private void parseHeader() throws Exception {
        String line;
        this.server.trace("parseHeader");
        int len = 0;
        this.ifModifiedSince = null;
        block0: while ((line = this.readHeaderLine()) != null) {
            this.server.trace(" " + line);
            String lower = line.toLowerCase();
            if (lower.startsWith("if-modified-since")) {
                this.ifModifiedSince = line.substring(line.indexOf(58) + 1).trim();
                continue;
            }
            if (lower.startsWith("content-length")) {
                len = Integer.parseInt(line.substring(line.indexOf(58) + 1).trim());
                this.server.trace("len=" + len);
                continue;
            }
            if (lower.startsWith("accept-language")) {
                Locale locale;
                if (this.session == null || (locale = this.session.locale) != null) continue;
                String languages = line.substring(line.indexOf(58) + 1).trim();
                StringTokenizer tokenizer = new StringTokenizer(languages, ",;");
                while (tokenizer.hasMoreTokens()) {
                    String language;
                    String token = tokenizer.nextToken();
                    if (token.startsWith("q=") || !this.server.supportsLanguage(token)) continue;
                    int dash = token.indexOf(45);
                    if (dash >= 0) {
                        language = token.substring(0, dash);
                        String country = token.substring(dash + 1);
                        locale = new Locale(language, country);
                    } else {
                        locale = new Locale(token, "");
                    }
                    this.session.locale = locale;
                    language = locale.getLanguage();
                    this.session.put("language", language);
                    this.server.readTranslations(this.session, language);
                    continue block0;
                }
                continue;
            }
            if (line.trim().length() != 0) continue;
            break;
        }
        if (this.session != null && len > 0) {
            byte[] bytes = new byte[len];
            for (int pos = 0; pos < len; pos += this.input.read(bytes, pos, len - pos)) {
            }
            String s = new String(bytes);
            this.parseAttributes(s);
        }
    }

    private String fill(String page) {
        return PageParser.parse(this.server, page, this.session.map);
    }
}

