/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.MessageException;
import flex.messaging.io.AbstractProxy;
import flex.messaging.io.ArrayList;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;

public class StatusInfoProxy
extends AbstractProxy {
    static final long serialVersionUID = 8860353096401173320L;
    public static final String DESCRIPTION = "description";
    public static final String DETAILS = "details";
    public static final String CLASS = "type";
    public static final String CODE = "code";
    public static final String ROOTCAUSE = "rootcause";
    public static final List propertyNameCache = new ArrayList();
    protected boolean showStacktraces;

    public StatusInfoProxy() {
        super(null);
    }

    public StatusInfoProxy(Throwable defaultInstance) {
        super(defaultInstance);
    }

    public void setShowStacktraces(boolean value) {
        this.showStacktraces = value;
    }

    public String getAlias(Object instance) {
        return null;
    }

    public List getPropertyNames(Object instance) {
        return propertyNameCache;
    }

    public Class getType(Object instance, String propertyName) {
        Class type = null;
        if (CODE.equals(propertyName)) {
            type = String.class;
        } else if (CLASS.equals(propertyName)) {
            type = String.class;
        } else if (DESCRIPTION.equals(propertyName)) {
            type = String.class;
        } else if (DETAILS.equals(propertyName)) {
            type = String.class;
        } else if (ROOTCAUSE.equals(propertyName)) {
            type = Map.class;
        }
        return type;
    }

    public Object getValue(Object instance, String propertyName) {
        Object value = null;
        if (CODE.equals(propertyName)) {
            value = this.getCode(instance);
        } else if (CLASS.equals(propertyName)) {
            value = this.getType(instance);
        } else if (DESCRIPTION.equals(propertyName)) {
            value = this.getDescription(instance);
        } else if (DETAILS.equals(propertyName)) {
            value = this.getDetails(instance);
        } else if (ROOTCAUSE.equals(propertyName)) {
            value = this.getRootCause(instance);
        }
        return value;
    }

    public void setValue(Object instance, String propertyName, Object value) {
    }

    private String getCode(Object ex) {
        String code = null;
        if (ex instanceof MessageException) {
            code = ((MessageException)((Object)ex)).getCode();
        }
        if (code == null) {
            code = "Server.Processing";
        }
        return code;
    }

    private String getType(Object ex) {
        String type = "";
        if (ex != null && this.showStacktraces) {
            type = ex.getClass().getName();
        }
        return type;
    }

    private String getDescription(Object ex) {
        String desc = null;
        if (ex instanceof Throwable) {
            desc = ((Throwable)ex).getMessage();
        }
        return desc;
    }

    private String getDetails(Object ex) {
        MessageException e;
        StringBuffer details = new StringBuffer();
        if (ex instanceof MessageException && (e = (MessageException)((Object)ex)).getDetails() != null) {
            details.append(e.getDetails());
        }
        if (this.showStacktraces && ex instanceof Throwable) {
            details.append(StatusInfoProxy.getTraceback((Throwable)ex));
        }
        return details.toString();
    }

    private Map getRootCause(Object ex) {
        if (ex == null) {
            return null;
        }
        if (ex instanceof ServletException) {
            ex = ((ServletException)ex).getRootCause();
        }
        if (ex instanceof Throwable) {
            return this.getExceptionInfo((Throwable)ex);
        }
        return null;
    }

    private Map getExceptionInfo(Throwable t) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put(CODE, this.getCode(t));
        info.put(CLASS, this.getType(t));
        info.put(DESCRIPTION, this.getDescription(t));
        info.put(DETAILS, this.getDetails(t));
        info.put(ROOTCAUSE, this.getRootCause(t));
        return info;
    }

    private static String getTraceback(Throwable e) {
        String trace = "";
        if (e != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintWriter pr = new PrintWriter(outputStream);
            pr.println();
            e.printStackTrace(pr);
            pr.flush();
            trace = outputStream.toString();
        }
        return trace;
    }

    public Object clone() {
        StatusInfoProxy proxy = new StatusInfoProxy();
        proxy.setCloneFieldsFrom(this);
        return proxy;
    }

    static {
        propertyNameCache.add(CODE);
        propertyNameCache.add(CLASS);
        propertyNameCache.add(DESCRIPTION);
        propertyNameCache.add(DETAILS);
        propertyNameCache.add(ROOTCAUSE);
    }
}

