/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.transaction.SystemException;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.CMTTransaction;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class CMTTransactionFactory
implements TransactionFactory {
    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    public void configure(Properties props) throws HibernateException {
    }

    public Transaction createTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) throws HibernateException {
        return new CMTTransaction(jdbcContext, transactionContext);
    }

    public boolean isTransactionManagerRequired() {
        return true;
    }

    public boolean areCallbacksLocalToHibernateTransactions() {
        return false;
    }

    public boolean isTransactionInProgress(JDBCContext jdbcContext, TransactionFactory.Context transactionContext, Transaction transaction) {
        try {
            return JTAHelper.isTransactionInProgress(transactionContext.getFactory().getTransactionManager().getTransaction());
        }
        catch (SystemException se) {
            throw new TransactionException("Unable to check transaction status", se);
        }
    }
}

