/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.Tuple;
import org.python.pydev.navigator.elements.ProjectConfigError;
import org.python.pydev.navigator.elements.PythonSourceFolder;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectInfoForPackageExplorer {
    public final Set<PythonSourceFolder> sourceFolders = new HashSet<PythonSourceFolder>();
    public final List<ProjectConfigError> configErrors = new ArrayList<ProjectConfigError>();
    public IInterpreterInfo interpreterInfo;

    public ProjectInfoForPackageExplorer(IProject project) {
        this.recreateInfo(project);
    }

    public void recreateInfo(IProject project) {
        this.configErrors.clear();
        Tuple<List<ProjectConfigError>, IInterpreterInfo> configErrorsAndInfo = this.getConfigErrorsAndInfo(project);
        this.configErrors.addAll((Collection)configErrorsAndInfo.o1);
        this.interpreterInfo = (IInterpreterInfo)configErrorsAndInfo.o2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<List<ProjectConfigError>, IInterpreterInfo> getConfigErrorsAndInfo(IProject project) {
        if (project == null || !project.isOpen()) {
            return new Tuple(new ArrayList(), null);
        }
        PythonNature nature = PythonNature.getPythonNature(project);
        if (nature == null) {
            return new Tuple(new ArrayList(), null);
        }
        Tuple<List<ProjectConfigError>, IInterpreterInfo> configErrorsAndInfo = null;
        boolean goodToGo = false;
        int i = 0;
        while (i < 10 && !goodToGo) {
            try {
                configErrorsAndInfo = nature.getConfigErrorsAndInfo(project);
                goodToGo = true;
            }
            catch (PythonNatureWithoutProjectException pythonNatureWithoutProjectException) {
                goodToGo = false;
                ProjectInfoForPackageExplorer projectInfoForPackageExplorer = this;
                synchronized (projectInfoForPackageExplorer) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ++i;
        }
        if (configErrorsAndInfo == null) {
            return new Tuple(new ArrayList(), null);
        }
        if (nature != null) {
            try {
                project.deleteMarkers("org.python.pydev.PydevProjectErrorMarkers", true, 0);
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
            List errors = (List)configErrorsAndInfo.o1;
            for (ProjectConfigError error : errors) {
                try {
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("message", error.getLabel());
                    attributes.put("severity", Autobox.valueOf((int)2));
                    MarkerUtilities.createMarker((IResource)project, attributes, (String)"org.python.pydev.PydevProjectErrorMarkers");
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
            }
        }
        return configErrorsAndInfo;
    }
}

